/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.image.ColorModel;
import java.lang.reflect.Field;

public class FloatProcessorT2
extends FloatProcessor {
    private static Field fmin;
    private static Field fmax;
    private static Field ffixedScale;

    public final void setMinMax(double min, double max) {
        try {
            fmin.set((Object)this, Float.valueOf((float)min));
            fmax.set((Object)this, Float.valueOf((float)max));
            ffixedScale.set((Object)this, true);
            this.minMaxSet = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setPixels(int width, int height, float[] pixels) {
        this.width = width;
        this.height = height;
        this.roiX = 0;
        this.roiY = 0;
        this.roiWidth = width;
        this.roiHeight = height;
        super.setPixels((Object)pixels);
    }

    public final void resizeInPlace(int w, int h) {
        double min = this.getMin();
        double max = this.getMax();
        this.setPixels(w, h, (float[])super.resize(w, h).getPixels());
        this.setMinMax(min, max);
    }

    public final void halfSizeInPlace() {
        double min = this.getMin();
        double max = this.getMax();
        int width2 = this.width + this.width;
        int wb = (this.width + 1) / 2;
        int hb = (this.height + 1) / 2;
        int nb = hb * wb;
        float[] aPixels = (float[])this.getPixels();
        float[] bPixels = new float[nb];
        int ya = 0;
        for (int yb = 0; yb < nb; yb += wb) {
            int xa = 0;
            for (int xb = 0; xb < wb; ++xb) {
                bPixels[yb + xb] = aPixels[ya + xa];
                xa += 2;
            }
            ya += width2;
        }
        this.setPixels(wb, hb, bPixels);
        this.setMinMax(min, max);
    }

    public FloatProcessorT2(int width, int height, float[] pixels, ColorModel cm) {
        super(width, height, null, cm);
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = width;
        this.height = height;
        this.setPixels(pixels);
        this.cm = cm;
        this.resetRoi();
    }

    public FloatProcessorT2(int width, int height, float[] pixels, ColorModel cm, double min, double max) {
        this(width, height, pixels, cm);
        this.setMinMax(min, max);
    }

    public FloatProcessorT2(int width, int height, double min, double max) {
        this(width, height, new float[width * height], null);
        this.setMinMax(min, max);
    }

    public FloatProcessorT2(int width, int height) {
        this(width, height, 0.0, 0.0);
    }

    public FloatProcessorT2(int width, int height, byte[] pix, double min, double max) {
        this(width, height, new float[width * height], null, min, max);
        float[] pixels = (float[])this.getPixels();
        for (int i = 0; i < pix.length; ++i) {
            pixels[i] = pix[i] & 0xFF;
        }
    }

    public FloatProcessorT2(ColorProcessor cp, int channel) {
        this(cp.getWidth(), cp.getHeight(), 0.0, 255.0);
        int[] c = (int[])cp.getPixels();
        int bitmask = 0;
        int shift = 0;
        switch (channel) {
            case 0: {
                bitmask = 0xFF0000;
                shift = 16;
                break;
            }
            case 1: {
                bitmask = 65280;
                shift = 8;
                break;
            }
            case 2: {
                bitmask = 255;
            }
        }
        float[] pixels = (float[])this.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (c[i] & bitmask) >> shift;
        }
        super.setMinAndMax(0.0, 255.0);
    }

    public FloatProcessorT2(FloatProcessor fp) {
        this(fp.getWidth(), fp.getHeight(), (float[])fp.getPixels(), fp.getColorModel(), fp.getMin(), fp.getMax());
    }

    public FloatProcessorT2(ByteProcessor bp) {
        this((FloatProcessor)bp.convertToFloat());
        super.setMinAndMax(0.0, 255.0);
    }

    public ImageProcessor createProcessor(int width, int height) {
        FloatProcessorT2 ip2 = new FloatProcessorT2(width, height, new float[width * height], this.getColorModel());
        return ip2;
    }

    public void findMinAndMax() {
        Utils.printCaller((Object)this, 15);
        Utils.log2("FPT2.findMinAndMax called");
        super.findMinAndMax();
    }

    public final float[] getFloatPixels() {
        return (float[])this.getPixels();
    }

    public final byte[] getBytePixels() {
        float[] f = this.getFloatPixels();
        byte[] b = new byte[f.length];
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            int val = (int)(f[i] + 0.5f);
            if (val < 0) {
                val = 0;
            }
            if (val > 255) {
                val = 255;
            }
            b[i] = (byte)val;
        }
        return b;
    }

    public final byte[] getScaledBytePixels() {
        float[] f = this.getFloatPixels();
        byte[] b = new byte[f.length];
        int size = this.width * this.height;
        double min = this.getMin();
        double scale = 255.0 / (this.getMax() - min + 1.0);
        for (int i = 0; i < size; ++i) {
            int val = (int)(((double)f[i] - min) * scale + 0.5);
            if (val < 0) {
                val = 0;
            }
            if (val > 255) {
                val = 255;
            }
            b[i] = (byte)val;
        }
        return b;
    }

    public final int[] getRGBPixels() {
        float[] f = this.getFloatPixels();
        int[] rgb = new int[f.length];
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            int val = (int)(f[i] + 0.5f);
            if (val < 0) {
                val = 0;
            }
            if (val > 255) {
                val = 255;
            }
            rgb[i] = 0xFF000000 | val << 16 | val << 8 | val;
        }
        return rgb;
    }

    public final int[] getARGBPixels(byte[] alpha) {
        float[] f = this.getFloatPixels();
        int[] rgb = new int[f.length];
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            int val = (int)(f[i] + 0.5f);
            if (val < 0) {
                val = 0;
            }
            if (val > 255) {
                val = 255;
            }
            rgb[i] = (alpha[i] & 0xFF) << 24 | val << 16 | val << 8 | val;
        }
        return rgb;
    }

    public final int[] getARGBPixels(byte[] alpha, byte[] outside) {
        float[] f = this.getFloatPixels();
        int[] rgb = new int[f.length];
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            int val = (int)(f[i] + 0.5f);
            if (val < 0) {
                val = 0;
            }
            if (val > 255) {
                val = 255;
            }
            rgb[i] = ((outside[i] & 0xFF) != 255 ? 0 : (alpha[i] & 0xFF) << 24) | val << 16 | val << 8 | val;
        }
        return rgb;
    }

    public final void debugMinMax(String msg) {
        try {
            Utils.log(msg + "\n\tmin, max: " + fmin.get((Object)this) + ", " + fmax.get((Object)this) + " minMaxSet: " + this.minMaxSet);
        }
        catch (Throwable t) {
            IJError.print(t);
        }
    }

    public final int[] getARGBPixels(float[] alpha) {
        float[] f = this.getFloatPixels();
        int[] rgb = new int[f.length];
        int size = this.width * this.height;
        float min = (float)this.getMin();
        float max = (float)this.getMax();
        float scale = 256.0f / (max - min + 1.0f);
        for (int i = 0; i < size; ++i) {
            int val = (int)(f[i] - min);
            if (val < 0) {
                val = 0;
            }
            if ((val = (int)((float)val * scale + 0.5f)) > 255) {
                val = 255;
            }
            rgb[i] = ((int)(alpha[i] + 0.5f) << 24) + (val << 16) + (val << 8) + val;
        }
        return rgb;
    }

    public final int[] getARGBPixels(float[] alpha, float[] outside) {
        float[] f = this.getFloatPixels();
        int[] rgb = new int[f.length];
        int size = this.width * this.height;
        float min = (float)this.getMin();
        float max = (float)this.getMax();
        float scale = 256.0f / (max - min + 1.0f);
        for (int i = 0; i < size; ++i) {
            int val = (int)(f[i] - min);
            if (val < 0) {
                val = 0;
            }
            if ((val = (int)((float)val * scale + 0.5f)) > 255) {
                val = 255;
            }
            rgb[i] = ((int)(outside[i] + 0.5f) == 255 ? (int)(alpha[i] + 0.5f) << 24 : 0) + (val << 16) + (val << 8) + val;
        }
        return rgb;
    }

    static {
        try {
            fmin = FloatProcessor.class.getDeclaredField("min");
            fmin.setAccessible(true);
            fmax = FloatProcessor.class.getDeclaredField("max");
            fmax.setAccessible(true);
            ffixedScale = FloatProcessor.class.getDeclaredField("fixedScale");
            ffixedScale.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

