/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Patch;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Dispatcher;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class FilePathRepair {
    private final Project project;
    private final PathTableModel data = new PathTableModel();
    private final JTable table = new JTable(this.data);
    private final JFrame frame;
    private static final Hashtable<Project, FilePathRepair> projects = new Hashtable();
    private static final Dispatcher dispatcher = new Dispatcher("File path fixer");
    private static MouseAdapter listener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent me) {
            final JTable table = (JTable)me.getSource();
            final PathTableModel data = (PathTableModel)table.getModel();
            final int row = table.rowAtPoint(me.getPoint());
            if (-1 == row) {
                return;
            }
            if (2 == me.getClickCount()) {
                dispatcher.exec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            table.setEnabled(false);
                            GenericDialog gd = new GenericDialog("Fix paths");
                            gd.addCheckbox("Fix other listed image files with identical parent directory", true);
                            gd.addCheckbox("Fix all image files in the project with identical parent directory", true);
                            gd.addCheckbox("Update mipmaps for each fixed path", false);
                            gd.showDialog();
                            if (!gd.wasCanceled()) {
                                FilePathRepair.fixPath(table, data, row, gd.getNextBoolean(), gd.getNextBoolean(), gd.getNextBoolean());
                            }
                        }
                        catch (Exception e) {
                            IJError.print(e);
                        }
                        finally {
                            table.setEnabled(true);
                        }
                    }
                });
            }
        }
    };

    private FilePathRepair(Project project) {
        this.project = project;
        this.frame = ControlWindow.createJFrame("Repair: " + project);
    }

    private final Runnable makeGUI() {
        return new Runnable(){

            @Override
            public void run() {
                JScrollPane jsp = new JScrollPane(FilePathRepair.this.table);
                jsp.setPreferredSize(new Dimension(500, 500));
                FilePathRepair.this.table.addMouseListener(listener);
                JLabel label = new JLabel("Double-click any to repair file path:");
                JLabel label2 = new JLabel("(Any listed with identical parent folder will be fixed as well.)");
                JPanel plabel = new JPanel();
                BoxLayout pbl = new BoxLayout(plabel, 1);
                plabel.setLayout(pbl);
                plabel.setMinimumSize(new Dimension(400, 40));
                plabel.add(label);
                plabel.add(label2);
                JPanel all = new JPanel();
                BoxLayout bl = new BoxLayout(all, 1);
                all.setLayout(bl);
                all.add(plabel);
                all.add(jsp);
                FilePathRepair.this.frame.getContentPane().add(all);
                FilePathRepair.this.frame.setDefaultCloseOperation(2);
                FilePathRepair.this.frame.addWindowListener(new WindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void windowClosing(WindowEvent we) {
                        Hashtable hashtable = projects;
                        synchronized (hashtable) {
                            if (((FilePathRepair)FilePathRepair.this).data.vpath.size() > 0) {
                                Utils.logAll("WARNING: Some images remain associated to inexistent file paths.");
                            }
                            projects.remove(FilePathRepair.this.project);
                        }
                    }
                });
                FilePathRepair.this.frame.pack();
                GUI.center((Window)FilePathRepair.this.frame);
                FilePathRepair.this.frame.setVisible(true);
            }
        };
    }

    public static void add(final Patch patch) {
        dispatcher.exec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Project project = patch.getProject();
                FilePathRepair fpr = null;
                Hashtable hashtable = projects;
                synchronized (hashtable) {
                    fpr = (FilePathRepair)projects.get(project);
                    if (null == fpr) {
                        fpr = new FilePathRepair(project);
                        projects.put(project, fpr);
                        SwingUtilities.invokeLater(fpr.makeGUI());
                    }
                    fpr.data.add(patch);
                    if (!fpr.frame.isVisible()) {
                        fpr.frame.setVisible(true);
                    } else {
                        SwingUtilities.invokeLater(new Repainter(fpr));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixPath(JTable table, PathTableModel data, int row, boolean fix_similar, boolean fix_all, boolean update_mipmaps) throws Exception {
        Hashtable<Project, FilePathRepair> hashtable = projects;
        synchronized (hashtable) {
            Patch p;
            Patch patch = data.vp.get(row);
            if (null == patch) {
                return;
            }
            String old_path = patch.getImageFilePath();
            File f = new File(old_path);
            if (f.exists()) {
                Utils.log("File exists for " + patch + " at " + f.getAbsolutePath() + "\n  --> not updating path.");
                data.remove(row);
                return;
            }
            OpenDialog od = new OpenDialog("Select image file", OpenDialog.getDefaultDirectory(), null);
            String dir = od.getDirectory();
            String filename = od.getFileName();
            if (null == dir) {
                return;
            }
            if (IJ.isWindows()) {
                dir = dir.replace('\\', '/');
            }
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            if (!filename.equals(f.getName())) {
                YesNoDialog yn = new YesNoDialog((Frame)FilePathRepair.projects.get((Object)patch.getProject()).frame, "WARNING", "Different file names!\n  old: " + f.getName() + "\n  new: " + filename + "\nSet to new file name?");
                if (!yn.yesPressed()) {
                    return;
                }
                if (!f.getName().equals(new File(old_path).getName())) {
                    patch.getProject().getLoader().removeMipMaps(patch);
                }
            }
            String wrong_parent_path = new File(data.vpath.get(row)).getParent();
            if (!(wrong_parent_path = wrong_parent_path.replace('\\', '/')).endsWith("/")) {
                wrong_parent_path = wrong_parent_path + '/';
            }
            String path = dir + filename;
            HashSet<Patch> fixed = new HashSet<Patch>();
            int n_fixed = 0;
            if (-1 == patch.getFilePath().lastIndexOf("-----#slice=")) {
                if (!FilePathRepair.fixPatchPath(patch, path, update_mipmaps)) {
                    return;
                }
                data.remove(patch);
                fixed.add(patch);
                ++n_fixed;
            } else {
                int n = FilePathRepair.fixStack(data, fixed, patch.getStackPatches(), old_path, path, update_mipmaps);
                if (0 == n) {
                    return;
                }
                n_fixed += n;
            }
            String good_parent_path = dir;
            if (!dir.endsWith("/")) {
                good_parent_path = good_parent_path + '/';
            }
            if (fix_similar) {
                for (int i = data.vp.size() - 1; i > -1; --i) {
                    File file;
                    String wrong_path = data.vpath.get(i);
                    p = data.vp.get(i);
                    if (!wrong_path.startsWith(wrong_parent_path) || !(file = new File(good_parent_path + wrong_path.substring(wrong_parent_path.length()))).exists()) continue;
                    if (-1 == p.getFilePath().lastIndexOf("-----#slice=")) {
                        if (fixed.contains(p) || !FilePathRepair.fixPatchPath(p, file.getAbsolutePath(), update_mipmaps)) continue;
                        data.remove(p);
                        ++n_fixed;
                        fixed.add(p);
                        continue;
                    }
                    if (fixed.contains(p)) continue;
                    n_fixed += FilePathRepair.fixStack(data, fixed, p.getStackPatches(), wrong_path, file.getAbsolutePath(), update_mipmaps);
                }
            }
            if (fix_all) {
                for (Displayable d : patch.getLayerSet().getDisplayables(Patch.class)) {
                    File file;
                    p = (Patch)d;
                    String wrong_path = p.getImageFilePath();
                    if (!wrong_path.startsWith(wrong_parent_path) || !(file = new File(good_parent_path + wrong_path.substring(wrong_parent_path.length()))).exists()) continue;
                    if (-1 == p.getFilePath().lastIndexOf("-----#slice=")) {
                        if (fixed.contains(p) || !FilePathRepair.fixPatchPath(p, file.getAbsolutePath(), update_mipmaps)) continue;
                        data.remove(p);
                        ++n_fixed;
                        fixed.add(p);
                        continue;
                    }
                    if (fixed.contains(p)) continue;
                    n_fixed += FilePathRepair.fixStack(data, fixed, p.getStackPatches(), wrong_path, file.getAbsolutePath(), update_mipmaps);
                }
            }
            if (0 == data.vp.size()) {
                FilePathRepair fpr = projects.remove(patch.getProject());
                fpr.frame.dispose();
            }
            Utils.logAll("Fixed " + n_fixed + " image file path" + (n_fixed > 1 ? "s" : ""));
        }
    }

    private static int fixStack(PathTableModel data, Set<Patch> fixed, Collection<Patch> slices, String wrong_path, String new_path, boolean update_mipmaps) {
        int n_fixed = 0;
        Dimension dim = null;
        Loader loader = null;
        for (Patch ps : slices) {
            if (fixed.contains(ps)) continue;
            String slicepath = ps.getFilePath();
            int isl = slicepath.lastIndexOf("-----#slice=");
            if (-1 == isl) {
                Utils.log2("Not a stack path: " + slicepath);
                continue;
            }
            String ps_path = slicepath.substring(0, isl);
            if (!ps_path.substring(0, isl).equals(wrong_path)) {
                Utils.log2("Not the same stack path:\n  i=" + ps_path + "\n  ref=" + wrong_path);
                continue;
            }
            if (null == dim) {
                loader = ps.getProject().getLoader();
                loader.releaseToFit(Math.max(Loader.MIN_FREE_BYTES, (long)(ps.getOWidth() * ps.getOHeight() * 10)));
                dim = Loader.getDimensions(new_path);
                if (null == dim) {
                    Utils.log("ERROR: could not open image at " + new_path);
                    return n_fixed;
                }
                if (dim.width != ps.getOWidth() || dim.height != ps.getOHeight()) {
                    Utils.log("ERROR different o_width,o_height for patch " + ps + "\n  at new path " + new_path + "\nold o_width,o_height: " + ps.getOWidth() + "," + ps.getOHeight() + "\nnew o_width,o_height: " + dim.width + "," + dim.height);
                    return n_fixed;
                }
            }
            fixed.add(ps);
            loader.removeFromUnloadable(ps);
            loader.addedPatchFrom(new_path + slicepath.substring(isl), ps);
            if (update_mipmaps) {
                loader.regenerateMipMaps(ps);
            }
            data.remove(ps);
            ++n_fixed;
        }
        return n_fixed;
    }

    private static boolean fixPatchPath(Patch patch, String new_path, boolean update_mipmaps) {
        try {
            Loader loader = patch.getProject().getLoader();
            loader.releaseToFit(Math.max(Loader.MIN_FREE_BYTES, (long)(patch.getOWidth() * patch.getOHeight() * 10)));
            Dimension dim = Loader.getDimensions(new_path);
            if (null == dim) {
                Utils.log("ERROR: could not open image at " + new_path);
                return false;
            }
            if (dim.width != patch.getOWidth() || dim.height != patch.getOHeight()) {
                Utils.log("ERROR different o_width,o_height for patch " + patch + "\n  at new path " + new_path + "\nold o_width,o_height: " + patch.getOWidth() + "," + patch.getOHeight() + "\nnew o_width,o_height: " + dim.width + "," + dim.height);
                return false;
            }
            loader.removeFromUnloadable(patch);
            loader.addedPatchFrom(new_path, patch);
            if (update_mipmaps) {
                loader.regenerateMipMaps(patch);
            }
            return true;
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    private static class Repainter
    implements Runnable {
        FilePathRepair fpr;

        Repainter(FilePathRepair fpr) {
            this.fpr = fpr;
        }

        @Override
        public void run() {
            try {
                this.fpr.table.updateUI();
                this.fpr.table.repaint();
                this.fpr.frame.pack();
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }

    private static class PathTableModel
    extends AbstractTableModel {
        final Vector<Patch> vp = new Vector();
        final Vector<String> vpath = new Vector();
        final HashSet<Patch> set = new HashSet();

        PathTableModel() {
        }

        @Override
        public final String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Image";
                }
                case 1: {
                    return "Nonexistent file path";
                }
            }
            return "";
        }

        @Override
        public final int getRowCount() {
            return this.vp.size();
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.vp.get(row);
                }
                case 1: {
                    return this.vpath.get(row);
                }
            }
            return null;
        }

        @Override
        public final boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public final void setValueAt(Object value, int row, int col) {
        }

        public final synchronized void add(Patch patch) {
            if (this.set.contains(patch)) {
                return;
            }
            this.vp.add(patch);
            this.vpath.add(patch.getImageFilePath());
            this.set.add(patch);
        }

        public final synchronized String remove(int row) {
            this.set.remove(this.vp.remove(row));
            return this.vpath.remove(row);
        }

        public final synchronized String remove(Patch p) {
            int i = this.vp.indexOf(p);
            if (-1 == i) {
                return null;
            }
            this.set.remove(this.vp.remove(i));
            return this.vpath.remove(i);
        }
    }
}

