/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.text.TextWindow;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Connector;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.VectorData;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.tree.DNDTree;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.RenameThingStep;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpicbg.trakem2.align.AlignTask;

public final class ProjectTree
extends DNDTree
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultMutableTreeNode selected_node = null;
    protected static final Color ACTIVE_DISPL_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.5f);

    public ProjectTree(Project project, ProjectThing project_thing) {
        super(project, DNDTree.makeNode(project_thing), new Color(240, 230, 255));
        this.setEditable(false);
        this.addMouseListener(this);
        this.addTreeExpansionListener(this);
    }

    private JPopupMenu getPopupMenu(DefaultMutableTreeNode node) {
        Object ob = node.getUserObject();
        ProjectThing thing = null;
        if (!(ob instanceof ProjectThing)) {
            return null;
        }
        thing = (ProjectThing)ob;
        JMenuItem[] items = thing.getPopupItems(this);
        if (0 == items.length) {
            return null;
        }
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < items.length; ++i) {
            popup.add(items[i]);
        }
        JMenu node_menu = new JMenu("Node");
        JMenuItem item = new JMenuItem("Move up");
        item.addActionListener(this);
        item.setAccelerator(KeyStroke.getKeyStroke(33, 0, true));
        node_menu.add(item);
        item = new JMenuItem("Move down");
        item.addActionListener(this);
        item.setAccelerator(KeyStroke.getKeyStroke(34, 0, true));
        node_menu.add(item);
        item = new JMenuItem("Collapse nodes of children nodes");
        item.addActionListener(this);
        node_menu.add(item);
        popup.add(node_menu);
        JMenu send_menu = new JMenu("Send to");
        item = new JMenuItem("Sibling project");
        item.addActionListener(this);
        send_menu.add(item);
        popup.add(send_menu);
        return popup;
    }

    @Override
    public void mousePressed(final MouseEvent me) {
        this.dispatcher.execSwing(new Runnable(){

            @Override
            public void run() {
                int y;
                if (!me.getSource().equals(ProjectTree.this) || !ProjectTree.this.project.isInputEnabled()) {
                    return;
                }
                int x = me.getX();
                TreePath path = ProjectTree.this.getPathForLocation(x, y = me.getY());
                if (null == path) {
                    return;
                }
                ProjectTree.this.setSelectionPath(path);
                ProjectTree.this.selected_node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (2 == me.getClickCount() && !me.isPopupTrigger() && 1 == me.getButton()) {
                    if (null == ProjectTree.this.selected_node) {
                        return;
                    }
                    Object obt = ProjectTree.this.selected_node.getUserObject();
                    if (!(obt instanceof ProjectThing)) {
                        return;
                    }
                    ProjectThing thing = (ProjectThing)obt;
                    thing.setVisible(true);
                    Object obd = thing.getObject();
                    if (obd instanceof Displayable) {
                        Displayable displ = (Displayable)obd;
                        Display.showCentered(displ.getLayer(), displ, true, me.isShiftDown());
                    }
                    return;
                }
                if (me.isPopupTrigger() || IJ.isMacOSX() && me.isControlDown() || 2 == me.getButton() || 0 != (me.getModifiers() & 4)) {
                    JPopupMenu popup = ProjectTree.this.getPopupMenu(ProjectTree.this.selected_node);
                    if (null == popup) {
                        return;
                    }
                    popup.show(ProjectTree.this, x, y);
                    return;
                }
            }
        });
    }

    public void rename(ProjectThing thing) {
        Object ob = thing.getObject();
        String old_title = null == ob ? thing.getType() : (ob instanceof DBObject ? ((DBObject)ob).getTitle() : ob.toString());
        GenericDialog gd = ControlWindow.makeGenericDialog("New name");
        gd.addMessage("Old name: " + old_title);
        gd.addStringField("New name: ", old_title, 40);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String title = gd.getNextString();
        if (null == title) {
            Utils.log("WARNING: avoided setting the title to null for " + thing);
            return;
        }
        title = title.replace('\"', '\'').trim();
        this.project.getRootLayerSet().addUndoStep(new RenameThingStep(thing));
        if (title.length() == 0) {
            thing.setTitle(thing.getTemplate().getType());
            return;
        }
        thing.setTitle(title);
        this.updateUILater();
        this.project.getRootLayerSet().addUndoStep(new RenameThingStep(thing));
    }

    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void actionPerformed(final ActionEvent ae) {
        if (!this.project.isInputEnabled()) {
            return;
        }
        this.dispatcher.exec(new Runnable(){

            @Override
            public void run() {
                block36: {
                    try {
                        if (null == ProjectTree.this.selected_node) {
                            return;
                        }
                        Object ob = ProjectTree.this.selected_node.getUserObject();
                        if (!(ob instanceof ProjectThing)) {
                            return;
                        }
                        final ProjectThing thing = (ProjectThing)ob;
                        int i_position = 0;
                        String command = ae.getActionCommand();
                        Object obd = thing.getObject();
                        if (command.startsWith("new ") || command.equals("Duplicate")) {
                            ProjectThing new_thing = null;
                            if (command.startsWith("new ")) {
                                new_thing = thing.createChild(command.substring(4));
                            } else if (command.equals("Duplicate")) {
                                if (Project.isBasicType(thing.getType()) && null != thing.getParent()) {
                                    new_thing = ((ProjectThing)thing.getParent()).createClonedChild(thing);
                                }
                                ProjectTree.this.selected_node = (DefaultMutableTreeNode)ProjectTree.this.selected_node.getParent();
                            }
                            if (null != new_thing) {
                                DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new_thing);
                                ((DefaultTreeModel)ProjectTree.this.getModel()).insertNodeInto(new_node, ProjectTree.this.selected_node, i_position);
                                TreePath treePath = new TreePath(new_node.getPath());
                                ProjectTree.this.scrollPathToVisible(treePath);
                                ProjectTree.this.setSelectionPath(treePath);
                            }
                            if (new_thing.getObject() instanceof Displayable) {
                                Display.getFront().getFrame().toFront();
                            }
                            break block36;
                        }
                        if (command.equals("many...")) {
                            ArrayList<TemplateThing> children = thing.getTemplate().getChildren();
                            if (null == children || 0 == children.size()) {
                                return;
                            }
                            String[] cn = new String[children.size()];
                            int i = 0;
                            for (TemplateThing child : children) {
                                cn[i] = child.getType();
                                ++i;
                            }
                            GenericDialog gd = new GenericDialog("Add many children");
                            gd.addNumericField("Amount: ", 1.0, 0);
                            gd.addChoice("New child: ", cn, cn[0]);
                            gd.addCheckbox("Recursive", true);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            int amount = (int)gd.getNextNumber();
                            if (amount < 1) {
                                Utils.showMessage("Makes no sense to create less than 1 child!");
                                return;
                            }
                            ProjectTree.this.project.getRootLayerSet().addChangeTreesStep();
                            ArrayList<ProjectThing> nc = thing.createChildren(cn[gd.getNextChoiceIndex()], amount, gd.getNextBoolean());
                            ProjectTree.this.addLeafs(nc, new Runnable(){

                                @Override
                                public void run() {
                                    ProjectTree.this.project.getRootLayerSet().addChangeTreesStep();
                                }
                            });
                            break block36;
                        }
                        if (command.equals("Unhide")) {
                            thing.setVisible(true);
                            break block36;
                        }
                        if (command.equals("Select in display")) {
                            boolean shift_down = 0 != (ae.getModifiers() & 1);
                            ProjectTree.this.selectInDisplay(thing, shift_down);
                            break block36;
                        }
                        if (command.equals("Show centered in Display")) {
                            if (obd instanceof Displayable) {
                                Displayable displ = (Displayable)obd;
                                Display.showCentered(displ.getLayer(), displ, true, 0 != (ae.getModifiers() & 1));
                            }
                            break block36;
                        }
                        if (command.equals("Show tabular view")) {
                            ((Tree)obd).createMultiTableView();
                            break block36;
                        }
                        if (command.equals("Show in 3D")) {
                            Display3D.showAndResetView(thing);
                            break block36;
                        }
                        if (command.equals("Remove from 3D view")) {
                            Display3D.removeFrom3D(thing);
                            break block36;
                        }
                        if (command.equals("Hide")) {
                            thing.setVisible(false);
                            break block36;
                        }
                        if (command.equals("Delete...")) {
                            ProjectTree.this.project.getRootLayerSet().addChangeTreesStep();
                            ProjectTree.this.remove(true, thing, ProjectTree.this.selected_node);
                            ProjectTree.this.project.getRootLayerSet().addChangeTreesStep();
                            return;
                        }
                        if (command.equals("Rename...")) {
                            ProjectTree.this.rename(thing);
                            break block36;
                        }
                        if (command.equals("Measure")) {
                            Bureaucrat.createAndStart(new Worker("Measuring"){

                                @Override
                                public void run() {
                                    this.startedWorking();
                                    try {
                                        thing.measure();
                                    }
                                    catch (Throwable e) {
                                        IJError.print(e);
                                    }
                                    finally {
                                        this.finishedWorking();
                                    }
                                }
                            }, thing.getProject());
                            break block36;
                        }
                        if (command.equals("Export project...") || command.equals("Save as...")) {
                            Utils.log2("Calling export project at " + System.currentTimeMillis());
                            thing.getProject().getLoader().saveTask(thing.getProject(), "Save as...");
                            break block36;
                        }
                        if (command.equals("Save")) {
                            thing.getProject().getLoader().saveTask(thing.getProject(), "Save");
                            break block36;
                        }
                        if (command.equals("Info")) {
                            ProjectTree.this.showInfo(thing);
                            return;
                        }
                        if (command.equals("Move up")) {
                            ProjectTree.this.move(ProjectTree.this.selected_node, -1);
                            break block36;
                        }
                        if (command.equals("Move down")) {
                            ProjectTree.this.move(ProjectTree.this.selected_node, 1);
                            break block36;
                        }
                        if (command.equals("Collapse nodes of children nodes")) {
                            if (null == ProjectTree.this.selected_node) {
                                return;
                            }
                            Enumeration<TreeNode> c = ProjectTree.this.selected_node.children();
                            while (c.hasMoreElements()) {
                                DefaultMutableTreeNode child = (DefaultMutableTreeNode)c.nextElement();
                                if (child.isLeaf()) continue;
                                ProjectTree.this.collapsePath(new TreePath(child.getPath()));
                            }
                            break block36;
                        }
                        if (command.equals("Sibling project")) {
                            ProjectTree.this.sendToSiblingProjectTask(ProjectTree.this.selected_node);
                            break block36;
                        }
                        Utils.log("ProjectTree.actionPerformed: don't know what to do with the command: " + command);
                        return;
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
            }
        });
    }

    public void remove(DefaultMutableTreeNode node, boolean check, boolean remove_empty_parents, int levels) {
        Object uob = node.getUserObject();
        if (!(uob instanceof ProjectThing)) {
            return;
        }
        ProjectThing thing = (ProjectThing)uob;
        Display3D.remove(thing);
        ProjectThing parent = (ProjectThing)thing.getParent();
        if (!thing.remove(check)) {
            return;
        }
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
        if (remove_empty_parents) {
            this.removeProjectThingLadder(parent, levels);
        }
        this.updateUILater();
    }

    public void removeProjectThingLadder(ProjectThing lowest, int levels) {
        if (0 == levels) {
            return;
        }
        if (lowest.getType().toLowerCase().equals("project")) {
            return;
        }
        if (null == lowest.getChildren() || 0 == lowest.getChildren().size()) {
            ProjectThing parent = (ProjectThing)lowest.getParent();
            if (!lowest.remove(false)) {
                Utils.log("Failed to remove parent in the ladder: " + lowest);
                return;
            }
            DefaultMutableTreeNode node = DNDTree.findNode(lowest, this);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
            this.removeProjectThingLadder(parent, levels--);
        }
    }

    public Profile duplicateChild(Profile original, int position, Layer layer) {
        Utils.log2("ProjectTree: Called duplicateChild " + System.currentTimeMillis() + " for original id = " + original.getId() + " at position " + position);
        ProjectThing child = this.project.findProjectThing(original);
        if (null == child) {
            Utils.log("ProjectTree.duplicateChild: node not found for original " + original);
            return null;
        }
        Profile copy = (Profile)original.clone();
        copy.setLayer(layer);
        ProjectThing new_thing = null;
        try {
            new_thing = new ProjectThing(((ProjectThing)child.getParent()).getChildTemplate(child.getType()), original.getProject(), copy);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        DefaultMutableTreeNode child_node = ProjectTree.findNode(child, this);
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)child_node.getParent();
        ProjectThing parent_thing = (ProjectThing)parent_node.getUserObject();
        if (position < 0) {
            position = 0;
        } else if (position > 1) {
            position = 1;
        }
        int index = parent_node.getIndex(child_node) + position;
        if (index < 0) {
            index = 0;
        }
        if (index > parent_node.getChildCount()) {
            index = parent_node.getChildCount() - 1;
        }
        if (!parent_thing.addChild(new_thing, index)) {
            return null;
        }
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new_thing);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(new_node, parent_node, index);
        this.updateList(parent_node);
        TreePath treePath = new TreePath(new_node.getPath());
        this.scrollPathToVisible(treePath);
        this.setSelectionPath(treePath);
        return copy;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.selected_node = null;
    }

    public void insertSegmentations(Collection<? extends Displayable> al) {
        TemplateThing tt_root = (TemplateThing)this.project.getTemplateTree().getRoot().getUserObject();
        String imported_labels = "imported_labels";
        if (!this.project.typeExists("imported_labels")) {
            TemplateThing tet = new TemplateThing("imported_labels", this.project);
            this.project.addUniqueType(tet);
            DefaultMutableTreeNode root = this.project.getTemplateTree().getRoot();
            tt_root.addChild(tet);
            DefaultMutableTreeNode child_node = this.addChild(tet, root);
            DNDTree.expandNode(this.project.getTemplateTree(), child_node);
        }
        TemplateThing tt_is = this.project.getTemplateThing("imported_labels");
        final DefaultMutableTreeNode project_node = this.project.getProjectTree().getRoot();
        ProjectThing project_pt = (ProjectThing)project_node.getUserObject();
        final ProjectThing ct = project_pt.createChild(tt_root.getType());
        ProjectThing pt_is = ct.createChild("imported_labels");
        final DefaultMutableTreeNode node_pt_is = new DefaultMutableTreeNode(pt_is);
        HashMap<Class<Connector>, String> types = new HashMap<Class<Connector>, String>();
        types.put(AreaList.class, "area_list");
        types.put(Pipe.class, "pipe");
        types.put(Polyline.class, "polyline");
        types.put(Ball.class, "ball");
        types.put(Treeline.class, "treeline");
        types.put(AreaTree.class, "areatree");
        types.put(Connector.class, "connector");
        for (Displayable displayable : al) {
            String type = (String)types.get(displayable.getClass());
            if (null == type) {
                Utils.log("insertSegmentations: ignoring " + displayable);
                continue;
            }
            try {
                TemplateThing tt = this.getOrCreateChildTemplateThing(tt_is, type);
                ProjectThing one = new ProjectThing(tt, this.project, displayable);
                pt_is.addChild(one);
                node_pt_is.add(new DefaultMutableTreeNode(one));
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode ctn = ProjectTree.this.addChild(ct, project_node);
                ctn.add(node_pt_is);
                try {
                    ProjectTree.this.scrollPathToVisible(new TreePath(node_pt_is.getPath()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DNDTree.expandNode(this, node_pt_is);
    }

    private final TemplateThing getOrCreateChildTemplateThing(TemplateThing parent, String type) {
        TemplateThing tt = parent.getChildTemplate(type);
        if (null == tt) {
            tt = new TemplateThing(type, parent.getProject());
            tt.getProject().addUniqueType(tt);
            parent.addChild(tt);
        }
        return tt;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        super.keyPressed(ke);
        if (ke.isConsumed()) {
            return;
        }
        if (!ke.getSource().equals(this) || !this.project.isInputEnabled()) {
            return;
        }
        TreePath path = this.getSelectionPath();
        if (null == path) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (null == node) {
            return;
        }
        ProjectThing pt = (ProjectThing)node.getUserObject();
        if (null == pt) {
            return;
        }
        int flags = ke.getModifiers();
        switch (ke.getKeyCode()) {
            case 33: {
                this.move(node, -1);
                ke.consume();
                break;
            }
            case 34: {
                this.move(node, 1);
                ke.consume();
                break;
            }
            case 113: {
                this.rename(pt);
                ke.consume();
                break;
            }
            case 72: {
                if (0 == (flags ^ 8)) {
                    pt.setVisible(true);
                    ke.consume();
                    break;
                }
                if (0 != flags) break;
                pt.setVisible(false);
                ke.consume();
                break;
            }
            case 65: {
                if (0 != flags && 0 != (flags ^ 1)) break;
                this.selectInDisplay(pt, 0 == (flags ^ 1));
                ke.consume();
                break;
            }
            case 51: {
                if (0 == flags) {
                    Display3D.showAndResetView(pt);
                    ke.consume();
                    break;
                }
            }
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (!(pt.getObject() instanceof Displayable) || null == Utils.launchTPlugIn(ke, "Project Tree", this.project, (Displayable)pt.getObject())) break;
                ke.consume();
            }
        }
        ke.consume();
    }

    private void move(DefaultMutableTreeNode node, int direction) {
        ProjectThing pt = (ProjectThing)node.getUserObject();
        if (null == pt) {
            return;
        }
        if (!pt.move(direction)) {
            return;
        }
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int index = parent_node.getChildCount() - 1;
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
        index = pt.getParent().getChildren().indexOf(pt);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(node, parent_node, index);
        TreePath trp = new TreePath(node.getPath());
        this.scrollPathToVisible(trp);
        this.setSelectionPath(trp);
        this.updateUILater();
    }

    public boolean remove(boolean check, ProjectThing thing, DefaultMutableTreeNode node) {
        Object obd = thing.getObject();
        if (obd.getClass() == Project.class) {
            return ((Project)obd).remove(check);
        }
        boolean b = thing.remove(check) && this.removeNode(null != node ? node : ProjectTree.findNode(thing, this));
        Display.repaint();
        return b;
    }

    public final Set<Displayable> remove(Set<? extends Displayable> displayables, DefaultMutableTreeNode top) {
        Enumeration<TreeNode> en = (null == top ? (DefaultMutableTreeNode)this.getModel().getRoot() : top).depthFirstEnumeration();
        HashSet<DefaultMutableTreeNode> to_remove = new HashSet<DefaultMutableTreeNode>();
        HashSet<Displayable> remaining = new HashSet<Displayable>(displayables);
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            ProjectThing pt = (ProjectThing)node.getUserObject();
            if (!remaining.remove(pt.getObject())) continue;
            pt.remove(false, false);
            ((Displayable)pt.getObject()).softRemove();
            to_remove.add(node);
        }
        for (DefaultMutableTreeNode node : to_remove) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
        }
        if (!remaining.isEmpty()) {
            Utils.log("Could not remove:", remaining);
        }
        return remaining;
    }

    public void showInfo(ProjectThing thing) {
        if (null == thing) {
            return;
        }
        HashMap<String, ArrayList<ProjectThing>> ht = thing.getByType();
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(ht.keySet());
        Collections.sort(types);
        StringBuilder sb = new StringBuilder(thing.getNodeInfo());
        sb.append("\nCounts:\n");
        for (String type : types) {
            sb.append(type).append(": ").append(ht.get(type).size()).append('\n');
        }
        sb.append('\n');
        sb.append(thing.getInfo().replaceAll("\t", "    "));
        new TextWindow("Info", sb.toString(), 500, 500);
    }

    public void selectInDisplay(ProjectThing thing, boolean shift_down) {
        Object obd = thing.getObject();
        if (obd instanceof Displayable) {
            Display display;
            Displayable d = (Displayable)obd;
            if (!d.isVisible()) {
                d.setVisible(true);
            }
            if (null == (display = Display.getFront(d.getProject()))) {
                return;
            }
            display.select(d, shift_down);
        } else {
            ArrayList<Displayable> ds = thing.findChildrenOfType(Displayable.class);
            Display display = null;
            Iterator it = ds.iterator();
            while (it.hasNext()) {
                Displayable d = (Displayable)it.next();
                if (null == display && null == (display = Display.getFront(d.getProject()))) {
                    return;
                }
                if (d.isVisible()) continue;
                Utils.log("Skipping non-visible object " + d);
                it.remove();
            }
            if (null == display) {
                return;
            }
            if (!shift_down) {
                display.getSelection().clear();
            }
            display.getSelection().selectAll(ds);
        }
    }

    public DefaultMutableTreeNode addSibling(Displayable elder, Displayable sibling) {
        ProjectThing pt;
        if (null == elder || null == sibling) {
            return null;
        }
        if (elder.getProject() != sibling.getProject()) {
            Utils.log2("Can't mix projects!");
            return null;
        }
        DefaultMutableTreeNode enode = DNDTree.findNode2(elder, this);
        if (null == enode) {
            Utils.log2("Could not find a tree node for elder " + elder);
            return null;
        }
        ProjectThing parent = (ProjectThing)((ProjectThing)enode.getUserObject()).getParent();
        if (null == parent) {
            Utils.log2("No parent for elder " + elder);
            return null;
        }
        TemplateThing tt = elder.getProject().getTemplateThing(Project.getType(sibling.getClass()));
        if (null == tt) {
            Utils.log2("Could not find a template for class " + sibling.getClass());
            return null;
        }
        if (!parent.getTemplate().canHaveAsChild(tt)) {
            if (null == parent.getProject().getTemplateTree().addNewChildType(parent, tt.getType())) {
                return null;
            }
            Utils.log2("Added template " + tt.getType() + " as child of " + parent.getTemplate().getType());
        }
        try {
            pt = new ProjectThing(tt, sibling.getProject(), sibling);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        if (!parent.addChild(pt)) {
            Utils.log2("Could not add sibling!");
            return null;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(pt);
        int index = enode.getParent().getIndex(enode);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(node, (DefaultMutableTreeNode)enode.getParent(), index + 1);
        return node;
    }

    public DefaultMutableTreeNode addChild(ProjectThing parent, String childType, Displayable d) {
        ProjectThing pt;
        if (!parent.canHaveAsChild(childType)) {
            Utils.log("The type '" + parent.getType() + "' cannot have as child the type '" + childType + "'");
            return null;
        }
        try {
            pt = new ProjectThing(this.project.getTemplateThing(childType), this.project, d);
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
        if (!parent.addChild(pt)) {
            Utils.log("Could not add child to " + parent);
            return null;
        }
        DefaultMutableTreeNode parentNode = DNDTree.findNode(parent, this);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(pt);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(node, parentNode, parentNode.getChildCount());
        return node;
    }

    @Override
    protected DNDTree.NodeRenderer createNodeRenderer() {
        return new ProjectThingNodeRenderer();
    }

    public Bureaucrat sendToSiblingProjectTask(final DefaultMutableTreeNode node) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Send to sibling"){

            @Override
            public void exec() {
                ProjectTree.this.sendToSiblingProject(node);
            }
        }, this.project);
    }

    public boolean sendToSiblingProject(DefaultMutableTreeNode node) {
        ArrayList<Project> ps = Project.getProjects();
        if (1 == ps.size()) {
            Utils.log("There aren't any other projects open!");
            return false;
        }
        ProjectThing pt = (ProjectThing)node.getUserObject();
        if (pt.getTemplate().getType().equals("project")) {
            Utils.log("Cannot transfer the project node.");
            return false;
        }
        final ArrayList<Project> psother = new ArrayList<Project>(ps);
        psother.remove(this.project);
        ps = null;
        final String parent_type = ((ProjectThing)pt.getParent()).getTemplate().getType();
        final ArrayList<ProjectThing> landing_pt = new ArrayList<ProjectThing>(psother.get(0).getRootProjectThing().findChildrenOfTypeR(parent_type));
        final Comparator<ProjectThing> comparator = new Comparator<ProjectThing>(){

            @Override
            public int compare(ProjectThing t1, ProjectThing t2) {
                return t1.toString().compareTo(t2.toString());
            }

            @Override
            public boolean equals(Object o) {
                return this == o;
            }
        };
        Collections.sort(landing_pt, comparator);
        String[] landing = new String[landing_pt.size()];
        int next = 0;
        if (landing_pt.isEmpty()) {
            landing = new String[]{"-- NONE --"};
        } else {
            for (ProjectThing t : landing_pt) {
                landing[next++] = t.toString();
            }
        }
        String parentTitle = pt.getParent().toString();
        int k = 0;
        boolean matched = false;
        for (String candidate : landing) {
            if (candidate.equals(parentTitle)) {
                matched = true;
                break;
            }
            ++k;
        }
        if (!matched) {
            k = 0;
            for (String candidate : landing) {
                if (-1 != candidate.indexOf(parentTitle)) {
                    matched = true;
                    break;
                }
                ++k;
            }
        }
        if (!matched) {
            k = 0;
        }
        GenericDialog gd = new GenericDialog("Send to sibling project");
        gd.addMessage("Transfering node: " + pt);
        String[] trmode = new String[]{"As is", "Transformed as the images"};
        gd.addChoice("Transfer:", trmode, trmode[0]);
        String[] ptitles = new String[psother.size()];
        for (int i = 0; i < ptitles.length; ++i) {
            ptitles[i] = psother.get(i).toString();
        }
        gd.addChoice("Target project:", ptitles, ptitles[0]);
        gd.addChoice("Landing node:", landing, landing[k]);
        Vector vc = gd.getChoices();
        final Choice choice_project = (Choice)vc.get(vc.size() - 2);
        final Choice choice_landing = (Choice)vc.get(vc.size() - 1);
        choice_project.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                landing_pt.clear();
                landing_pt.addAll(((Project)psother.get(choice_project.getSelectedIndex())).getRootProjectThing().findChildrenOfTypeR(parent_type));
                Collections.sort(landing_pt, comparator);
                choice_landing.removeAll();
                if (landing_pt.isEmpty()) {
                    choice_landing.add("-- NONE --");
                } else {
                    for (ProjectThing t : landing_pt) {
                        choice_landing.add(t.toString());
                    }
                }
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (choice_landing.getSelectedItem().equals("-- NONE --")) {
            Utils.log("No valid landing nodes!");
            return false;
        }
        int transfer_mode = gd.getNextChoiceIndex();
        Project target_project = psother.get(gd.getNextChoiceIndex());
        ProjectThing landing_parent = (ProjectThing)landing_pt.get(gd.getNextChoiceIndex());
        return this.rawSendToSiblingProject(pt, transfer_mode, target_project, landing_parent);
    }

    /*
     * WARNING - void declaration
     */
    public boolean rawSendToSiblingProject(ProjectThing source_pt, int transfer_mode, final Project target_project, ProjectThing landing_parent) {
        try {
            ProjectThing copy;
            HashSet<Long> lids = new HashSet<Long>();
            for (Layer layer : this.project.getRootLayerSet().getLayers()) {
                lids.add(layer.getId());
            }
            HashSet<Long> tgt_lids = new HashSet<Long>(lids);
            for (Layer layer : target_project.getRootLayerSet().getLayers()) {
                lids.remove(layer.getId());
                tgt_lids.add(layer.getId());
            }
            Object var7_10 = null;
            HashSet<Long> lids_to_operate = new HashSet<Long>();
            if (0 != lids.size()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (ProjectThing child : source_pt.findChildrenOfTypeR(Displayable.class)) {
                    Displayable d = (Displayable)child.getObject();
                    if (!tgt_lids.containsAll(d.getLayerIds())) {
                        Utils.log("CANNOT transfer: not all required layers are present in the target project!\n  First object that couldn't be transfered: \n    " + d);
                        return false;
                    }
                    if (!(d instanceof VectorData)) continue;
                    arrayList.add(d);
                    lids_to_operate.addAll(d.getLayerIds());
                }
            }
            try {
                copy = source_pt.deepClone(target_project, false);
            }
            catch (Exception ee) {
                Utils.logAll("Can't send: " + ee.getMessage());
                IJError.print(ee);
                return false;
            }
            if (null == landing_parent.getChildTemplate(copy.getTemplate().getType())) {
                landing_parent.getTemplate().addChild(copy.getTemplate().shallowCopy());
            }
            if (!landing_parent.addChild(copy)) {
                Utils.log("Could NOT transfer the node!");
                return false;
            }
            ArrayList<Profile> srcProfiles = new ArrayList<Profile>();
            for (ProjectThing profile_pt : source_pt.findChildrenOfTypeR(Profile.class)) {
                srcProfiles.add((Profile)profile_pt.getObject());
            }
            List<ProjectThing> copies = copy.findChildrenOfTypeR(Displayable.class);
            ArrayList<Profile> newProfiles = new ArrayList<Profile>();
            ArrayList<Displayable> vdata = new ArrayList<Displayable>();
            ArrayList<ZDisplayable> zd = new ArrayList<ZDisplayable>();
            for (ProjectThing projectThing : copies) {
                Displayable d = (Displayable)projectThing.getObject();
                if (d instanceof VectorData) {
                    vdata.add(d);
                }
                if (d instanceof ZDisplayable) {
                    zd.add((ZDisplayable)d);
                    continue;
                }
                newProfiles.add((Profile)d);
            }
            int profileIndex = 0;
            for (Profile newProfile : newProfiles) {
                Profile srcProfile = (Profile)srcProfiles.get(profileIndex++);
                Layer newLayer = target_project.getRootLayerSet().getLayer(srcProfile.getLayer().getId());
                newLayer.add(newProfile);
                for (Displayable srcLinkedProfile : srcProfile.getLinked(Profile.class)) {
                    newProfile.link((Displayable)newProfiles.get(srcProfiles.indexOf(srcLinkedProfile)));
                }
            }
            target_project.getRootLayerSet().addAll(zd);
            target_project.getTemplateTree().rebuild();
            target_project.getProjectTree().rebuild();
            final TreePath treePath = new TreePath(DNDTree.findNode(landing_parent, target_project.getProjectTree()).getPath());
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    target_project.getProjectTree().scrollPathToVisible(treePath);
                    target_project.getProjectTree().setSelectionPath(treePath);
                }
            });
            if (1 == transfer_mode) {
                void var7_14;
                void var7_12;
                if (null == var7_12) {
                    ArrayList<Displayable> arrayList = new ArrayList<Displayable>();
                    for (ProjectThing child : source_pt.findChildrenOfTypeR(Displayable.class)) {
                        Displayable d = (Displayable)child.getObject();
                        if (!(d instanceof VectorData)) continue;
                        arrayList.add(d);
                        lids_to_operate.addAll(d.getLayerIds());
                    }
                }
                AlignTask.transformVectorData(AlignTask.createTransformPropertiesTable((List<Displayable>)var7_14, vdata, lids_to_operate), vdata, target_project.getRootLayerSet());
            }
            return true;
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    @Override
    protected Thing getRootThing() {
        return this.project.getRootProjectThing();
    }

    public Connector tryAddNewConnector(Displayable d, boolean selectNode) {
        ProjectThing pt = this.project.findProjectThing(d);
        ProjectThing parent = (ProjectThing)pt.getParent();
        TemplateThing connectorType = this.project.getTemplateThing("connector");
        boolean add = false;
        if (parent.canHaveAsChild(connectorType)) {
            add = true;
        } else {
            for (ProjectThing child : parent.getChildren()) {
                if (!child.canHaveAsChild(connectorType)) continue;
                parent = child;
                add = true;
                break;
            }
        }
        Connector c = null;
        DefaultMutableTreeNode node = null;
        if (add) {
            c = new Connector(this.project, connectorType.getType());
            node = this.addChild(parent, connectorType.getType(), c);
        }
        if (null != node) {
            d.getLayerSet().add(c);
            if (selectNode) {
                this.setSelectionPath(new TreePath(node.getPath()));
            }
            return c;
        }
        Utils.logAll("Could not add a new Connector related to " + d);
        return null;
    }

    protected final class ProjectThingNodeRenderer
    extends DNDTree.NodeRenderer {
        private static final long serialVersionUID = 1L;

        protected ProjectThingNodeRenderer() {
            super(ProjectTree.this);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            label.setText(label.getText().replace('_', ' '));
            if (value.getClass() == DefaultMutableTreeNode.class) {
                Object obb = ((DefaultMutableTreeNode)value).getUserObject();
                Object ob = ((ProjectThing)obb).getObject();
                if (ob.getClass().getSuperclass() == Displayable.class) {
                    Displayable displ = (Displayable)ob;
                    Layer layer = Display.getFrontLayer();
                    if (null != layer && (displ == Display.getFront().getActive() || layer.contains(displ))) {
                        label.setOpaque(true);
                        label.setBackground(ACTIVE_DISPL_COLOR);
                    } else {
                        label.setOpaque(false);
                        label.setBackground(ProjectTree.this.background);
                    }
                } else {
                    label.setOpaque(false);
                    label.setBackground(ProjectTree.this.background);
                }
            } else {
                label.setOpaque(false);
                label.setBackground(ProjectTree.this.background);
            }
            return label;
        }
    }
}

