/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FieldMapView
implements Map<String, String> {
    @Override
    public int size() {
        return this.getClass().getDeclaredFields().length;
    }

    @Override
    public boolean isEmpty() {
        return 0 != this.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (null == value) {
            return false;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (!field.get(this).equals(value)) continue;
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public String get(Object key) {
        if (null == key) {
            return null;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getName().equals(key)) continue;
            field.setAccessible(true);
            try {
                return field.get(this).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hs = new HashSet<String>(this.size());
        for (Field field : this.getClass().getDeclaredFields()) {
            hs.add(field.getName());
        }
        return Collections.unmodifiableSet(hs);
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> vals = new ArrayList<String>(this.size());
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                vals.add(field.get(this).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Collections.unmodifiableList(vals);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<1> entries = new HashSet<1>(this.size());
        for (final Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            entries.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return field.getName();
                }

                @Override
                public String getValue() {
                    try {
                        return field.get(FieldMapView.this).toString();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String setValue(String value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return Collections.unmodifiableSet(entries);
    }
}

