/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public final class IntegerField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private final int maxDigits;

    public IntegerField(int initial, int maxDigits) {
        this.maxDigits = maxDigits;
        String text = Integer.toString(initial);
        if (text.length() > maxDigits) {
            text = text.substring(0, maxDigits);
        }
        this.setText(text);
    }

    @Override
    protected void processKeyEvent(KeyEvent ke) {
        if (0 != ke.getModifiers()) {
            return;
        }
        if (ke.getID() != 401) {
            return;
        }
        switch (ke.getKeyCode()) {
            case 8: 
            case 10: 
            case 37: 
            case 39: 
            case 127: {
                super.processKeyEvent(ke);
                for (KeyListener kl : this.getKeyListeners()) {
                    kl.keyPressed(ke);
                }
                return;
            }
        }
        if (Character.isDigit(ke.getKeyChar()) && this.getText().length() < this.maxDigits) {
            this.setText(this.getText() + ke.getKeyChar());
            for (KeyListener kl : this.getKeyListeners()) {
                kl.keyPressed(ke);
            }
        }
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (0 == text.length()) {
            return "0";
        }
        return text;
    }
}

