/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.process.ByteProcessor;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.models.Affine2D;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;

public abstract class AbstractAffineTile2D<A extends Model<A> & Affine2D<A>>
extends Tile<A> {
    private static final long serialVersionUID = -2229469138975635535L;
    protected final Patch patch;
    protected final Set<PointMatch> virtualMatches = new HashSet<PointMatch>();

    public final Patch getPatch() {
        return this.patch;
    }

    public final double getWidth() {
        return this.patch.getWidth();
    }

    public final double getHeight() {
        return this.patch.getHeight();
    }

    public final Set<PointMatch> getVirtualMatches() {
        return this.virtualMatches;
    }

    public final boolean addVirtualMatch(PointMatch match) {
        if (this.virtualMatches.add(match)) {
            return this.matches.add(match);
        }
        return false;
    }

    public final boolean removeVirtualMatch(PointMatch match) {
        if (this.virtualMatches.remove(match)) {
            return this.matches.remove(match);
        }
        return false;
    }

    public final void clearVirtualMatches() {
        for (PointMatch m : this.virtualMatches) {
            this.matches.remove(m);
        }
        this.virtualMatches.clear();
    }

    protected abstract void initModel();

    public AbstractAffineTile2D(A model, Patch patch) {
        super(model);
        this.patch = patch;
        this.initModel();
    }

    public final AffineTransform createAffine() {
        return ((Affine2D)this.model).createAffine();
    }

    public final void updatePatch() {
        this.patch.setAffineTransform(this.createAffine());
        this.patch.updateMipMaps();
    }

    public final ByteProcessor createMaskedByteImage() {
        ByteProcessor target;
        block7: {
            int i;
            Patch.PatchImage pai = this.patch.createTransformedImage();
            ByteProcessor mask = pai.mask == null ? pai.outside : pai.mask;
            pai.target.setMinAndMax(this.patch.getMin(), this.patch.getMax());
            target = (ByteProcessor)pai.target.convertToByte(true);
            if (ByteProcessor.class.isInstance(pai.target)) {
                float s = 255.0f / (float)(this.patch.getMax() - this.patch.getMin());
                int m = (int)this.patch.getMin();
                byte[] targetBytes = (byte[])target.getPixels();
                for (i = 0; i < targetBytes.length; ++i) {
                    targetBytes[i] = (byte)Math.max(0.0f, Math.min(255.0f, (float)((targetBytes[i] & 0xFF) - m) * s));
                }
                target.setMinAndMax(0.0, 255.0);
            }
            if (mask == null) break block7;
            byte[] targetBytes = (byte[])target.getPixels();
            byte[] maskBytes = (byte[])mask.getPixels();
            if (pai.outside != null) {
                byte[] outsideBytes = (byte[])pai.outside.getPixels();
                for (i = 0; i < outsideBytes.length; ++i) {
                    if ((outsideBytes[i] & 0xFF) != 255) {
                        maskBytes[i] = 0;
                    }
                    float a = (float)(maskBytes[i] & 0xFF) / 255.0f;
                    int t = targetBytes[i] & 0xFF;
                    targetBytes[i] = (byte)((float)t * a + 127.0f * (1.0f - a));
                }
            } else {
                for (int i2 = 0; i2 < targetBytes.length; ++i2) {
                    float a = (float)(maskBytes[i2] & 0xFF) / 255.0f;
                    int t = targetBytes[i2] & 0xFF;
                    targetBytes[i2] = (byte)((float)t * a + 127.0f * (1.0f - a));
                }
            }
        }
        return target;
    }

    public final boolean intersects(AbstractAffineTile2D<?> t, boolean sloppy) {
        return this.patch.intersects(t.patch, sloppy);
    }

    public final boolean intersects(AbstractAffineTile2D<?> t) {
        return this.intersects(t, false);
    }

    public final void makeVirtualConnection(AbstractAffineTile2D<?> t) {
        Area a = new Area(this.patch.getPerimeter());
        Area b = new Area(t.patch.getPerimeter());
        a.intersect(b);
        double[] fa = new double[2];
        int i = 0;
        double[] coords = new double[6];
        PathIterator p = a.getPathIterator(null);
        while (!p.isDone()) {
            p.currentSegment(coords);
            fa[0] = fa[0] + coords[0];
            fa[1] = fa[1] + coords[1];
            ++i;
            p.next();
        }
        if (i > 0) {
            fa[0] = fa[0] / (double)i;
            fa[1] = fa[1] / (double)i;
            double[] fb = (double[])fa.clone();
            try {
                ((InverseCoordinateTransform)this.model).applyInverseInPlace(fa);
                ((InverseCoordinateTransform)t.model).applyInverseInPlace(fb);
            }
            catch (NoninvertibleModelException e) {
                return;
            }
            Point pa = new Point(fa);
            Point pb = new Point(fb);
            PointMatch ma = new PointMatch(pa, pb, (double)0.1f);
            PointMatch mb = new PointMatch(pb, pa, (double)0.1f);
            this.addVirtualMatch(ma);
            this.addConnectedTile(t);
            t.addVirtualMatch(mb);
            t.addConnectedTile(this);
        }
    }

    public static final void pairTiles(List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>[]> tilePairs) {
        for (int a = 0; a < tiles.size(); ++a) {
            for (int b = a + 1; b < tiles.size(); ++b) {
                AbstractAffineTile2D<?> ta = tiles.get(a);
                AbstractAffineTile2D<?> tb = tiles.get(b);
                tilePairs.add(new AbstractAffineTile2D[]{ta, tb});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <AAT extends AbstractAffineTile2D<?>> void pairOverlappingTiles(List<AAT> tiles, final List<AbstractAffineTile2D<?>[]> tilePairs, boolean sloppyOverlapTest) {
        HashSet<Patch> visited = new HashSet<Patch>();
        ArrayList<AbstractAffineTile2D[]> tilePairCandidates = new ArrayList<AbstractAffineTile2D[]>();
        Hashtable<Patch, AbstractAffineTile2D> lut = new Hashtable<Patch, AbstractAffineTile2D>();
        for (AbstractAffineTile2D tile : tiles) {
            lut.put(tile.patch, tile);
        }
        for (int a = 0; a < tiles.size(); ++a) {
            AbstractAffineTile2D ta = (AbstractAffineTile2D)((Object)tiles.get(a));
            Iterator pa = ta.patch;
            visited.add((Patch)((Object)pa));
            Layer layer = ((Displayable)((Object)pa)).getLayer();
            for (Displayable d : layer.getDisplayables(Patch.class, ((Displayable)((Object)pa)).getBoundingBox())) {
                AbstractAffineTile2D tb;
                Patch pb = (Patch)d;
                if (visited.contains(pb) || (tb = (AbstractAffineTile2D)((Object)lut.get(pb))) == null) continue;
                tilePairCandidates.add(new AbstractAffineTile2D[]{ta, tb});
            }
        }
        if (sloppyOverlapTest) {
            tilePairs.addAll(tilePairCandidates);
        } else {
            ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            ArrayList futures = new ArrayList();
            for (final AbstractAffineTile2D[] abstractAffineTile2DArray : tilePairCandidates) {
                futures.add(exec.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (abstractAffineTile2DArray[0].intersects(abstractAffineTile2DArray[1])) {
                            List list = tilePairs;
                            synchronized (list) {
                                tilePairs.add(abstractAffineTile2DArray);
                            }
                        }
                    }
                }));
            }
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            finally {
                exec.shutdown();
            }
        }
    }

    public static final <AAT extends AbstractAffineTile2D<?>> void pairOverlappingTiles(List<AAT> tiles, List<AbstractAffineTile2D<?>[]> tilePairs) {
        AbstractAffineTile2D.pairOverlappingTiles(tiles, tilePairs, false);
    }

    public static final void pairTiles(List<AbstractAffineTile2D<?>> tilesA, List<AbstractAffineTile2D<?>> tilesB, List<AbstractAffineTile2D<?>[]> tilePairs) {
        for (int a = 0; a < tilesA.size(); ++a) {
            for (int b = 0; b < tilesB.size(); ++b) {
                AbstractAffineTile2D<?> ta = tilesA.get(a);
                AbstractAffineTile2D<?> tb = tilesB.get(b);
                tilePairs.add(new AbstractAffineTile2D[]{ta, tb});
            }
        }
    }

    public static final void pairOverlappingTiles(List<AbstractAffineTile2D<?>> tilesA, List<AbstractAffineTile2D<?>> tilesB, List<AbstractAffineTile2D<?>[]> tilePairs, boolean sloppyOverlapTest) {
        for (int a = 0; a < tilesA.size(); ++a) {
            for (int b = 0; b < tilesB.size(); ++b) {
                AbstractAffineTile2D<?> tb;
                AbstractAffineTile2D<?> ta = tilesA.get(a);
                if (!ta.intersects(tb = tilesB.get(b), sloppyOverlapTest)) continue;
                tilePairs.add(new AbstractAffineTile2D[]{ta, tb});
            }
        }
    }

    public static final void pairOverlappingTiles(List<AbstractAffineTile2D<?>> tilesA, List<AbstractAffineTile2D<?>> tilesB, List<AbstractAffineTile2D<?>[]> tilePairs) {
        AbstractAffineTile2D.pairOverlappingTiles(tilesA, tilesB, tilePairs, false);
    }

    public final void commonPointMatches(Tile<?> other, Collection<PointMatch> commonMatches) {
        block0: for (PointMatch pm : this.matches) {
            for (PointMatch otherPm : other.getMatches()) {
                if (pm.getP1() != otherPm.getP2()) continue;
                commonMatches.add(pm);
                continue block0;
            }
        }
    }
}

