/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.IJ;
import ij.gui.GenericDialog;
import ini.trakem2.Project;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.VectorData;
import ini.trakem2.parallel.ExecutorProvider;
import ini.trakem2.utils.AreaUtils;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Spring;
import mpicbg.models.SpringMesh;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.models.Transforms;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.Vertex;
import mpicbg.trakem2.align.AbstractLayerAlignmentParam;
import mpicbg.trakem2.align.AlignmentUtils;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.align.concurrent.BlockMatchPairCallable;
import mpicbg.trakem2.transform.MovingLeastSquaresTransform2;
import mpicbg.trakem2.transform.ThinPlateSplineTransform;
import mpicbg.trakem2.util.Triple;

public class ElasticLayerAlignment {
    static final Param p = new Param();

    private static final String layerName(Layer layer) {
        return new StringBuffer("layer z=").append(String.format("%.3f", layer.getZ())).append(" `").append(layer.getTitle()).append("'").toString();
    }

    public final void exec(Param param, Project project, List<Layer> layerRange, Set<Layer> fixedLayers, Set<Layer> emptyLayers, Rectangle box, boolean propagateTransformBefore, boolean propagateTransformAfter, Filter<Patch> filter) throws Exception {
        int lastLayerIndex;
        ExecutorService service = ExecutorProvider.getExecutorService(1.0f);
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        block9: for (int i = 0; i < layerRange.size(); ++i) {
            switch (param.desiredModelIndex) {
                case 0: {
                    tiles.add(new Tile((Model)new TranslationModel2D()));
                    continue block9;
                }
                case 1: {
                    tiles.add(new Tile((Model)new RigidModel2D()));
                    continue block9;
                }
                case 2: {
                    tiles.add(new Tile((Model)new SimilarityModel2D()));
                    continue block9;
                }
                case 3: {
                    tiles.add(new Tile((Model)new AffineModel2D()));
                    continue block9;
                }
                case 4: {
                    tiles.add(new Tile((Model)new HomographyModel2D()));
                    continue block9;
                }
                default: {
                    return;
                }
            }
        }
        ArrayList pairs = new ArrayList();
        if (!param.isAligned) {
            this.preAlignStack(param, project, layerRange, box, filter, pairs);
        } else {
            for (int i = 0; i < layerRange.size(); ++i) {
                int range = Math.min(layerRange.size(), i + param.maxNumNeighbors + 1);
                for (int j = i + 1; j < range; ++j) {
                    pairs.add(new Triple((Object)i, (Object)j, (Object)new TranslationModel2D()));
                }
            }
        }
        TileConfiguration initMeshes = new TileConfiguration();
        int meshWidth = (int)Math.ceil((double)box.width * param.layerScale);
        int meshHeight = (int)Math.ceil((double)box.height * param.layerScale);
        ArrayList<SpringMesh> meshes = new ArrayList<SpringMesh>(layerRange.size());
        for (int i = 0; i < layerRange.size(); ++i) {
            meshes.add(new SpringMesh(param.resolutionSpringMesh, (double)meshWidth, (double)meshHeight, param.stiffnessSpringMesh, param.maxStretchSpringMesh * param.layerScale, param.dampSpringMesh));
        }
        int blockRadius = Math.max(16, mpicbg.util.Util.roundPos((double)(param.layerScale * (double)param.blockRadius)));
        Utils.log("effective block radius = " + blockRadius);
        ArrayList<Future<BlockMatchPairCallable.BlockMatchResults>> futures = new ArrayList<Future<BlockMatchPairCallable.BlockMatchResults>>(pairs.size());
        for (Triple<Integer, Integer, AbstractModel<?>> triple : pairs) {
            project.getLoader().releaseAll();
            SpringMesh m1 = (SpringMesh)meshes.get((Integer)triple.a);
            SpringMesh m2 = (SpringMesh)meshes.get((Integer)triple.b);
            ArrayList v1 = m1.getVertices();
            ArrayList v2 = m2.getVertices();
            Layer layer1 = layerRange.get((Integer)triple.a);
            Layer layer2 = layerRange.get((Integer)triple.b);
            boolean layer1Fixed = fixedLayers.contains(layer1);
            boolean layer2Fixed = fixedLayers.contains(layer2);
            if (layer1Fixed && layer2Fixed) continue;
            BlockMatchPairCallable bmpc = new BlockMatchPairCallable(triple, layerRange, layer1Fixed, layer2Fixed, filter, param, v1, v2, box);
            futures.add(service.submit(bmpc));
        }
        for (Future future : futures) {
            Vertex p2;
            Vertex p1;
            BlockMatchPairCallable.BlockMatchResults results = (BlockMatchPairCallable.BlockMatchResults)future.get();
            Collection<PointMatch> pm12 = results.pm12;
            Collection<PointMatch> pm21 = results.pm21;
            Triple<Integer, Integer, AbstractModel<?>> pair = results.pair;
            Tile t1 = (Tile)tiles.get((Integer)pair.a);
            Tile t2 = (Tile)tiles.get((Integer)pair.b);
            SpringMesh m1 = (SpringMesh)meshes.get((Integer)pair.a);
            SpringMesh m2 = (SpringMesh)meshes.get((Integer)pair.b);
            double springConstant = 1.0 / (double)((Integer)pair.b - (Integer)pair.a);
            boolean layer1Fixed = results.layer1Fixed;
            boolean layer2Fixed = results.layer2Fixed;
            if (layer1Fixed) {
                initMeshes.fixTile(t1);
            } else {
                if (param.useLocalSmoothnessFilter) {
                    Utils.log(pair.a + " > " + pair.b + ": " + pm12.size() + " candidates passed local smoothness filter.");
                } else {
                    Utils.log(pair.a + " > " + pair.b + ": found " + pm12.size() + " correspondences.");
                }
                for (PointMatch pm : pm12) {
                    p1 = (Vertex)pm.getP1();
                    p2 = new Vertex(pm.getP2());
                    p1.addSpring(p2, new Spring(0.0, springConstant));
                    m2.addPassiveVertex(p2);
                }
                if (pm12.size() > ((AbstractModel)pair.c).getMinNumMatches()) {
                    initMeshes.addTile(t1);
                    initMeshes.addTile(t2);
                    t1.connect(t2, pm12);
                }
            }
            if (layer2Fixed) {
                initMeshes.fixTile(t2);
            } else {
                if (param.useLocalSmoothnessFilter) {
                    Utils.log(pair.a + " < " + pair.b + ": " + pm21.size() + " candidates passed local smoothness filter.");
                } else {
                    Utils.log(pair.a + " < " + pair.b + ": found " + pm21.size() + " correspondences.");
                }
                for (PointMatch pm : pm21) {
                    p1 = (Vertex)pm.getP1();
                    p2 = new Vertex(pm.getP2());
                    p1.addSpring(p2, new Spring(0.0, springConstant));
                    m1.addPassiveVertex(p2);
                }
                if (pm21.size() > ((AbstractModel)pair.c).getMinNumMatches()) {
                    initMeshes.addTile(t1);
                    initMeshes.addTile(t2);
                    t2.connect(t1, pm21);
                }
            }
            Utils.log(pair.a + " <> " + pair.b + " spring constant = " + springConstant);
        }
        initMeshes.optimize((double)param.maxEpsilon * param.layerScale, param.maxIterationsSpringMesh, param.maxPlateauwidthSpringMesh);
        for (int i = 0; i < layerRange.size(); ++i) {
            ((SpringMesh)meshes.get(i)).init((CoordinateTransform)((Tile)tiles.get(i)).getModel());
        }
        try {
            long t0 = System.currentTimeMillis();
            Utils.log("Optimizing spring meshes...");
            if (param.useLegacyOptimizer) {
                Utils.log("  ...using legacy optimizer...");
                SpringMesh.optimizeMeshes2(meshes, (double)((double)param.maxEpsilon * param.layerScale), (int)param.maxIterationsSpringMesh, (int)param.maxPlateauwidthSpringMesh, (boolean)param.visualize);
            } else {
                SpringMesh.optimizeMeshes(meshes, (double)((double)param.maxEpsilon * param.layerScale), (int)param.maxIterationsSpringMesh, (int)param.maxPlateauwidthSpringMesh, (boolean)param.visualize);
            }
            Utils.log("Done optimizing spring meshes. Took " + (System.currentTimeMillis() - t0) + " ms");
        }
        catch (NotEnoughDataPointsException e) {
            Utils.log("There were not enough data points to get the spring mesh optimizing.");
            e.printStackTrace();
            return;
        }
        for (SpringMesh springMesh : meshes) {
            for (PointMatch pm : springMesh.getVA().keySet()) {
                Point p1 = pm.getP1();
                Point p2 = pm.getP2();
                double[] l = p1.getL();
                double[] w = p2.getW();
                l[0] = l[0] / param.layerScale + (double)box.x;
                l[1] = l[1] / param.layerScale + (double)box.y;
                w[0] = w[0] / param.layerScale + (double)box.x;
                w[1] = w[1] / param.layerScale + (double)box.y;
            }
        }
        project.getLoader().releaseAll();
        Layer first = layerRange.get(0);
        ArrayList<Layer> arrayList = first.getParent().getLayers();
        LayerSet ls = first.getParent();
        Area infArea = AreaUtils.infiniteArea();
        ArrayList<VectorData> vectorData = new ArrayList<VectorData>();
        for (Layer layer : ls.getLayers()) {
            vectorData.addAll(Utils.castCollection(layer.getDisplayables(VectorData.class, false, true), VectorData.class, true));
        }
        vectorData.addAll(Utils.castCollection(ls.getZDisplayables(VectorData.class, true), VectorData.class, true));
        if (propagateTransformBefore || propagateTransformAfter) {
            if (propagateTransformBefore) {
                ThinPlateSplineTransform tps = ElasticLayerAlignment.makeTPS(((SpringMesh)meshes.get(0)).getVA().keySet());
                int firstLayerIndex = first.getParent().getLayerIndex(first.getId());
                for (int i = 0; i < firstLayerIndex; ++i) {
                    ElasticLayerAlignment.applyTransformToLayer((Layer)arrayList.get(i), (mpicbg.trakem2.transform.CoordinateTransform)tps, filter);
                    for (VectorData vd : vectorData) {
                        vd.apply((Layer)arrayList.get(i), infArea, (CoordinateTransform)tps);
                    }
                }
            }
            if (propagateTransformAfter) {
                ThinPlateSplineTransform ct;
                Layer last = layerRange.get(layerRange.size() - 1);
                if (param.useTps) {
                    ct = ElasticLayerAlignment.makeTPS(((SpringMesh)meshes.get(meshes.size() - 1)).getVA().keySet());
                } else {
                    MovingLeastSquaresTransform2 mls = new MovingLeastSquaresTransform2();
                    mls.setMatches(((SpringMesh)meshes.get(meshes.size() - 1)).getVA().keySet());
                    ct = mls;
                }
                int lastLayerIndex2 = last.getParent().getLayerIndex(last.getId());
                for (int i = lastLayerIndex2 + 1; i < arrayList.size(); ++i) {
                    ElasticLayerAlignment.applyTransformToLayer((Layer)arrayList.get(i), (mpicbg.trakem2.transform.CoordinateTransform)ct, filter);
                    for (VectorData vd : vectorData) {
                        vd.apply((Layer)arrayList.get(i), infArea, (CoordinateTransform)ct);
                    }
                }
            }
        }
        for (int l = 0; l < layerRange.size(); ++l) {
            IJ.showStatus((String)"Applying transformation to patches ...");
            IJ.showProgress((int)0, (int)layerRange.size());
            Layer layer = layerRange.get(l);
            ThinPlateSplineTransform tps = ElasticLayerAlignment.makeTPS(((SpringMesh)meshes.get(l)).getVA().keySet());
            ElasticLayerAlignment.applyTransformToLayer(layer, (mpicbg.trakem2.transform.CoordinateTransform)tps, filter);
            for (VectorData vd : vectorData) {
                vd.apply(layer, infArea, (CoordinateTransform)tps);
            }
            if (Thread.interrupted()) {
                Utils.log("Interrupted during applying transformations to patches.  No all patches have been updated.  Re-generate mipmaps manually.");
            }
            IJ.showProgress((int)(l + 1), (int)layerRange.size());
        }
        int firstLayerIndex = propagateTransformBefore ? 0 : first.getParent().getLayerIndex(first.getId());
        if (propagateTransformAfter) {
            lastLayerIndex = arrayList.size() - 1;
        } else {
            Layer last = layerRange.get(layerRange.size() - 1);
            lastLayerIndex = last.getParent().getLayerIndex(last.getId());
        }
        for (int i = firstLayerIndex; i <= lastLayerIndex; ++i) {
            Layer layer = (Layer)arrayList.get(i);
            if (emptyLayers.contains(layer) || fixedLayers.contains(layer)) continue;
            for (Patch patch : AlignmentUtils.filterPatches(layer, filter)) {
                patch.updateMipMaps();
            }
        }
        Utils.log("Done.");
    }

    protected static final ThinPlateSplineTransform makeTPS(Set<PointMatch> matches) throws Exception {
        double[][] srcPts = new double[2][matches.size()];
        double[][] tgtPts = new double[2][matches.size()];
        int i = 0;
        for (PointMatch match : matches) {
            double[] srcPt = match.getP1().getL();
            double[] tgtPt = match.getP2().getW();
            srcPts[0][i] = srcPt[0];
            srcPts[1][i] = srcPt[1];
            tgtPts[0][i] = tgtPt[0];
            tgtPts[1][i] = tgtPt[1];
            ++i;
        }
        ThinPlateR2LogRSplineKernelTransform tps = new ThinPlateR2LogRSplineKernelTransform(2, srcPts, tgtPts);
        return new ThinPlateSplineTransform(tps);
    }

    protected static final void applyTransformToLayer(Layer layer, final mpicbg.trakem2.transform.CoordinateTransform mlt, Filter<Patch> filter) throws InterruptedException {
        final List<Patch> patches = AlignmentUtils.filterPatches(layer, filter);
        ArrayList<Thread> applyThreads = new ArrayList<Thread>(ElasticLayerAlignment.p.maxNumThreads);
        final AtomicInteger ai = new AtomicInteger(0);
        for (int t = 0; t < ElasticLayerAlignment.p.maxNumThreads; ++t) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public final void run() {
                    try {
                        int i = ai.getAndIncrement();
                        while (i < patches.size() && !Thread.interrupted()) {
                            Util.applyLayerTransformToPatch((Patch)patches.get(i), mlt.copy());
                            i = ai.getAndIncrement();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            applyThreads.add(thread);
            thread.start();
        }
        for (Thread thread : applyThreads) {
            thread.join();
        }
    }

    public final void exec(Project project, List<Layer> layerRange, Set<Layer> fixedLayers, boolean propagateTransformBefore, boolean propagateTransformAfter, Rectangle fov, Filter<Patch> filter) throws Exception {
        Rectangle box = null;
        HashSet<Layer> emptyLayers = new HashSet<Layer>();
        for (Layer la : layerRange) {
            if (!la.contains(Patch.class, true)) {
                emptyLayers.add(la);
                continue;
            }
            if (null == box) {
                box = la.getMinimalBoundingBox(Patch.class, true);
                continue;
            }
            box = box.union(la.getMinimalBoundingBox(Patch.class, true));
        }
        if (box == null) {
            box = new Rectangle();
        }
        if (fov != null) {
            box = box.intersection(fov);
        }
        if (box.width <= 0 || box.height <= 0) {
            Utils.log("Bounding box empty.");
            return;
        }
        if (layerRange.size() == emptyLayers.size()) {
            Utils.log("All layers in range are empty!");
            return;
        }
        if (layerRange.size() - emptyLayers.size() < 2) {
            Utils.log("All except one layer in range are empty!");
            return;
        }
        if (!p.setup(box)) {
            return;
        }
        this.exec(p.clone(), project, layerRange, fixedLayers, emptyLayers, box, propagateTransformBefore, propagateTransformAfter, filter);
    }

    private void preAlignStack(final Param param, final Project project, final List<Layer> layerRange, Rectangle box, Filter<Patch> filter, ArrayList<Triple<Integer, Integer, AbstractModel<?>>> pairs) {
        double scale = Math.min(1.0, Math.min((double)param.ppm.sift.maxOctaveSize / (double)box.width, (double)param.ppm.sift.maxOctaveSize / (double)box.height));
        try {
            AlignmentUtils.extractAndSaveLayerFeatures(layerRange, box, scale, filter, param.ppm.sift, param.ppm.clearCache, param.ppm.maxNumThreadsSift);
        }
        catch (Exception e) {
            return;
        }
        int numFailures = 0;
        final double pointMatchScale = param.layerScale / scale;
        for (int i = 0; i < layerRange.size(); ++i) {
            ArrayList<2> threads = new ArrayList<2>(param.maxNumThreads);
            final int sliceA = i;
            final Layer layerA = layerRange.get(i);
            int range = Math.min(layerRange.size(), i + param.maxNumNeighbors + 1);
            final String layerNameA = ElasticLayerAlignment.layerName(layerA);
            int j = i + 1;
            block7: while (j < range) {
                int numThreads = Math.min(param.maxNumThreads, range - j);
                final ArrayList models = new ArrayList(numThreads);
                for (int k = 0; k < numThreads; ++k) {
                    models.add(null);
                }
                int t = 0;
                while (t < numThreads && j < range) {
                    final int n = t++;
                    final int n2 = j;
                    final Layer layerB = layerRange.get(j);
                    final String layerNameB = ElasticLayerAlignment.layerName(layerB);
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            boolean modelFound;
                            TranslationModel2D model;
                            IJ.showProgress((int)sliceA, (int)(layerRange.size() - 1));
                            Utils.log("matching " + layerNameB + " -> " + layerNameA + "...");
                            ArrayList<Object> candidates = null;
                            if (!param.ppm.clearCache) {
                                candidates = Util.deserializePointMatches(project, param.ppm, "layer", layerB.getId(), layerA.getId());
                            }
                            if (null == candidates) {
                                ArrayList<Feature> fs1 = Util.deserializeFeatures(project, param.ppm.sift, "layer", layerA.getId());
                                ArrayList<Feature> fs2 = Util.deserializeFeatures(project, param.ppm.sift, "layer", layerB.getId());
                                candidates = new ArrayList(FloatArray2DSIFT.createMatches(fs2, fs1, (float)param.ppm.rod));
                                for (PointMatch pointMatch : candidates) {
                                    Point p1 = pointMatch.getP1();
                                    Point p2 = pointMatch.getP2();
                                    double[] l1 = p1.getL();
                                    double[] w1 = p1.getW();
                                    double[] l2 = p2.getL();
                                    double[] w2 = p2.getW();
                                    l1[0] = l1[0] * pointMatchScale;
                                    l1[1] = l1[1] * pointMatchScale;
                                    w1[0] = w1[0] * pointMatchScale;
                                    w1[1] = w1[1] * pointMatchScale;
                                    l2[0] = l2[0] * pointMatchScale;
                                    l2[1] = l2[1] * pointMatchScale;
                                    w2[0] = w2[0] * pointMatchScale;
                                    w2[1] = w2[1] * pointMatchScale;
                                }
                                if (!Util.serializePointMatches(project, param.ppm, "layer", layerB.getId(), layerA.getId(), candidates)) {
                                    Utils.log("Could not store point match candidates for layers " + layerNameB + " and " + layerNameA + ".");
                                }
                            }
                            switch (param.expectedModelIndex) {
                                case 0: {
                                    model = new TranslationModel2D();
                                    break;
                                }
                                case 1: {
                                    model = new RigidModel2D();
                                    break;
                                }
                                case 2: {
                                    model = new SimilarityModel2D();
                                    break;
                                }
                                case 3: {
                                    model = new AffineModel2D();
                                    break;
                                }
                                case 4: {
                                    model = new HomographyModel2D();
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            ArrayList inliers = new ArrayList();
                            boolean bl = false;
                            try {
                                boolean bl2;
                                do {
                                    bl2 = false;
                                    modelFound = model.filterRansac(candidates, inliers, 1000, (double)param.maxEpsilon * param.layerScale, (double)param.minInlierRatio, param.minNumInliers, 3.0);
                                    if (!modelFound || !param.rejectIdentity) continue;
                                    ArrayList points = new ArrayList();
                                    PointMatch.sourcePoints(inliers, points);
                                    if (!Transforms.isIdentity((CoordinateTransform)model, points, (double)((double)param.identityTolerance * param.layerScale))) continue;
                                    IJ.log((String)("Identity transform for " + inliers.size() + " matches rejected."));
                                    candidates.removeAll(inliers);
                                    inliers.clear();
                                    bl2 = true;
                                } while (bl2);
                            }
                            catch (NotEnoughDataPointsException e) {
                                modelFound = false;
                            }
                            if (!modelFound) {
                                Utils.log(layerNameB + " -> " + layerNameA + ": no correspondences found.");
                                return;
                            }
                            Utils.log(layerNameB + " -> " + layerNameA + ": " + inliers.size() + " corresponding features with an average displacement of " + PointMatch.meanDistance(inliers) / param.layerScale + "px identified.");
                            Utils.log("Estimated transformation model: " + model);
                            models.set(n, new Triple((Object)sliceA, (Object)n2, (Object)model));
                        }
                    };
                    threads.add(thread);
                    thread.start();
                    ++j;
                }
                try {
                    for (Thread thread : threads) {
                        thread.join();
                    }
                }
                catch (InterruptedException e) {
                    Utils.log("Establishing feature correspondences interrupted.");
                    for (Thread thread : threads) {
                        thread.interrupt();
                    }
                    try {
                        for (Thread thread : threads) {
                            thread.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                threads.clear();
                for (t = 0; t < models.size(); ++t) {
                    Triple triple = (Triple)models.get(t);
                    if (triple == null) {
                        if (++numFailures <= param.maxNumFailures) continue;
                        continue block7;
                    }
                    numFailures = 0;
                    pairs.add(triple);
                }
            }
        }
    }

    public final void exec(LayerSet layerSet, int firstIn, int lastIn, int ref, boolean propagateTransformBefore, boolean propagateTransformAfter, Rectangle fov, Filter<Patch> filter) throws Exception {
        int first = Math.min(firstIn, lastIn);
        int last = Math.max(firstIn, lastIn);
        List<Layer> layerRange = layerSet.getLayers(first, last);
        HashSet<Layer> fixedLayers = new HashSet<Layer>();
        if (ref - firstIn >= 0) {
            fixedLayers.add(layerRange.get(ref - firstIn));
        }
        Utils.log(layerRange.size() + "");
        this.exec(layerSet.getProject(), layerRange, fixedLayers, propagateTransformBefore, propagateTransformAfter, fov, filter);
    }

    public final void exec(LayerSet layerSet, int firstIn, int lastIn, int ref, boolean propagateTransform, Rectangle fov, Filter<Patch> filter) throws Exception {
        if (firstIn < lastIn) {
            this.exec(layerSet, firstIn, lastIn, ref, false, propagateTransform, fov, filter);
        } else {
            this.exec(layerSet, firstIn, lastIn, ref, propagateTransform, false, fov, filter);
        }
    }

    public final void exec(LayerSet layerSet, int firstIn, int lastIn, int ref1, int ref2, boolean propagateTransformBefore, boolean propagateTransformAfter, Rectangle fov, Filter<Patch> filter) throws Exception {
        int first = Math.min(firstIn, lastIn);
        int last = Math.max(firstIn, lastIn);
        List<Layer> layerRange = layerSet.getLayers(first, last);
        HashSet<Layer> fixedLayers = new HashSet<Layer>();
        if (ref1 - first >= 0) {
            fixedLayers.add(layerRange.get(ref1 - first));
        }
        if (ref2 - first >= 0) {
            fixedLayers.add(layerRange.get(ref2 - first));
        }
        Utils.log(layerRange.size() + "");
        this.exec(layerSet.getProject(), layerRange, fixedLayers, propagateTransformBefore, propagateTransformAfter, fov, filter);
    }

    public static final class Param
    extends AbstractLayerAlignmentParam
    implements Serializable {
        private static final long serialVersionUID = 208742614581106404L;
        public boolean isAligned = false;
        public double layerScale = 0.1;
        public float minR = 0.6f;
        public float maxCurvatureR = 10.0f;
        public float rodR = 0.9f;
        public int searchRadius = 200;
        public int blockRadius = -1;
        public boolean useLocalSmoothnessFilter = true;
        public int localModelIndex = 1;
        public float localRegionSigma = this.searchRadius;
        public float maxLocalEpsilon = this.searchRadius / 2;
        public float maxLocalTrust = 3.0f;
        public int resolutionSpringMesh = 16;
        public double stiffnessSpringMesh = 0.1;
        public double dampSpringMesh = 0.9;
        public double maxStretchSpringMesh = 2000.0;
        public int maxIterationsSpringMesh = 1000;
        public int maxPlateauwidthSpringMesh = 200;
        public boolean useLegacyOptimizer = true;
        public boolean useTps = true;

        public boolean setup(Rectangle box) {
            if (this.blockRadius < 0) {
                this.blockRadius = box.width / this.resolutionSpringMesh / 2;
            }
            GenericDialog gdBlockMatching = new GenericDialog("Elastically align layers: Block Matching parameters");
            gdBlockMatching.addMessage("Block Matching:");
            gdBlockMatching.addNumericField("layer_scale :", this.layerScale, 2);
            gdBlockMatching.addNumericField("search_radius :", (double)this.searchRadius, 0, 6, "px");
            gdBlockMatching.addNumericField("block_radius :", (double)this.blockRadius, 0, 6, "px");
            gdBlockMatching.addNumericField("resolution :", (double)this.resolutionSpringMesh, 0);
            gdBlockMatching.addMessage("Correlation Filters:");
            gdBlockMatching.addNumericField("minimal_PMCC_r :", (double)this.minR, 2);
            gdBlockMatching.addNumericField("maximal_curvature_ratio :", (double)this.maxCurvatureR, 2);
            gdBlockMatching.addNumericField("maximal_second_best_r/best_r :", (double)this.rodR, 2);
            gdBlockMatching.addMessage("Local Smoothness Filter:");
            gdBlockMatching.addCheckbox("use_local_smoothness_filter", this.useLocalSmoothnessFilter);
            gdBlockMatching.addChoice("approximate_local_transformation :", modelStrings, modelStrings[this.localModelIndex]);
            gdBlockMatching.addNumericField("local_region_sigma:", (double)this.localRegionSigma, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (absolute):", (double)this.maxLocalEpsilon, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (relative):", (double)this.maxLocalTrust, 2);
            gdBlockMatching.addMessage("Miscellaneous:");
            gdBlockMatching.addCheckbox("layers_are_pre-aligned", this.isAligned);
            gdBlockMatching.addNumericField("test_maximally :", (double)this.maxNumNeighbors, 0, 6, "layers");
            gdBlockMatching.addChoice("elastic_transformation :", new String[]{"thin plate spline", "moving least squares"}, "thin plate spline");
            gdBlockMatching.showDialog();
            if (gdBlockMatching.wasCanceled()) {
                return false;
            }
            this.layerScale = gdBlockMatching.getNextNumber();
            this.searchRadius = (int)gdBlockMatching.getNextNumber();
            this.blockRadius = (int)gdBlockMatching.getNextNumber();
            this.resolutionSpringMesh = (int)gdBlockMatching.getNextNumber();
            this.minR = (float)gdBlockMatching.getNextNumber();
            this.maxCurvatureR = (float)gdBlockMatching.getNextNumber();
            this.rodR = (float)gdBlockMatching.getNextNumber();
            this.useLocalSmoothnessFilter = gdBlockMatching.getNextBoolean();
            this.localModelIndex = gdBlockMatching.getNextChoiceIndex();
            this.localRegionSigma = (float)gdBlockMatching.getNextNumber();
            this.maxLocalEpsilon = (float)gdBlockMatching.getNextNumber();
            this.maxLocalTrust = (float)gdBlockMatching.getNextNumber();
            this.isAligned = gdBlockMatching.getNextBoolean();
            this.maxNumNeighbors = (int)gdBlockMatching.getNextNumber();
            boolean bl = this.useTps = gdBlockMatching.getNextChoiceIndex() == 0;
            if (!this.isAligned) {
                if (!this.setupSIFT("Elastically align layers: ")) {
                    return false;
                }
                GenericDialog gd = new GenericDialog("Elastically align layers: Geometric filters");
                gd.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
                gd.addNumericField("minimal_inlier_ratio :", (double)this.minInlierRatio, 2);
                gd.addNumericField("minimal_number_of_inliers :", (double)this.minNumInliers, 0);
                gd.addChoice("approximate_transformation :", modelStrings, modelStrings[this.expectedModelIndex]);
                gd.addCheckbox("ignore constant background", this.rejectIdentity);
                gd.addNumericField("tolerance :", (double)this.identityTolerance, 2, 6, "px");
                gd.addNumericField("give_up_after :", (double)this.maxNumFailures, 0, 6, "failures");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return false;
                }
                this.maxEpsilon = (float)gd.getNextNumber();
                this.minInlierRatio = (float)gd.getNextNumber();
                this.minNumInliers = (int)gd.getNextNumber();
                this.expectedModelIndex = gd.getNextChoiceIndex();
                this.rejectIdentity = gd.getNextBoolean();
                this.identityTolerance = (float)gd.getNextNumber();
                this.maxNumFailures = (int)gd.getNextNumber();
            }
            GenericDialog gdOptimize = new GenericDialog("Elastically align layers: Optimization");
            gdOptimize.addMessage("Approximate Optimizer:");
            gdOptimize.addChoice("approximate_transformation :", modelStrings, modelStrings[this.desiredModelIndex]);
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsOptimize, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthOptimize, 0);
            gdOptimize.addMessage("Spring Mesh:");
            gdOptimize.addNumericField("stiffness :", this.stiffnessSpringMesh, 2);
            gdOptimize.addNumericField("maximal_stretch :", this.maxStretchSpringMesh, 2, 6, "px");
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsSpringMesh, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthSpringMesh, 0);
            gdOptimize.addCheckbox("use_legacy_optimizer :", this.useLegacyOptimizer);
            gdOptimize.showDialog();
            if (gdOptimize.wasCanceled()) {
                return false;
            }
            this.desiredModelIndex = gdOptimize.getNextChoiceIndex();
            this.maxIterationsOptimize = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthOptimize = (int)gdOptimize.getNextNumber();
            this.stiffnessSpringMesh = gdOptimize.getNextNumber();
            this.maxStretchSpringMesh = gdOptimize.getNextNumber();
            this.maxIterationsSpringMesh = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthSpringMesh = (int)gdOptimize.getNextNumber();
            this.useLegacyOptimizer = gdOptimize.getNextBoolean();
            return true;
        }

        public Param() {
        }

        public Param(int SIFTfdBins, int SIFTfdSize, float SIFTinitialSigma, int SIFTmaxOctaveSize, int SIFTminOctaveSize, int SIFTsteps, boolean clearCache, int maxNumThreadsSift, float rod, int desiredModelIndex, int expectedModelIndex, float identityTolerance, boolean isAligned, float maxEpsilon, int maxIterationsOptimize, int maxNumFailures, int maxNumNeighbors, int maxNumThreads, int maxPlateauwidthOptimize, float minInlierRatio, int minNumInliers, boolean multipleHypotheses, boolean widestSetOnly, boolean rejectIdentity, boolean visualize, int blockRadius, double dampSpringMesh, double layerScale, int localModelIndex, float localRegionSigma, float maxCurvatureR, int maxIterationsSpringMesh, float maxLocalEpsilon, float maxLocalTrust, int maxPlateauwidthSpringMesh, boolean useLegacyOptimizer, double maxStretchSpringMesh, float minR, int resolutionSpringMesh, float rodR, int searchRadius, double stiffnessSpringMesh, boolean useLocalSmoothnessFilter, boolean useTps) {
            super(SIFTfdBins, SIFTfdSize, SIFTinitialSigma, SIFTmaxOctaveSize, SIFTminOctaveSize, SIFTsteps, clearCache, maxNumThreadsSift, rod, desiredModelIndex, expectedModelIndex, identityTolerance, maxEpsilon, maxIterationsOptimize, maxNumFailures, maxNumNeighbors, maxNumThreads, maxPlateauwidthOptimize, minInlierRatio, minNumInliers, multipleHypotheses, widestSetOnly, rejectIdentity, visualize);
            this.isAligned = isAligned;
            this.blockRadius = blockRadius;
            this.dampSpringMesh = dampSpringMesh;
            this.layerScale = layerScale;
            this.localModelIndex = localModelIndex;
            this.localRegionSigma = localRegionSigma;
            this.maxCurvatureR = maxCurvatureR;
            this.maxIterationsSpringMesh = maxIterationsSpringMesh;
            this.maxLocalEpsilon = maxLocalEpsilon;
            this.maxLocalTrust = maxLocalTrust;
            this.maxPlateauwidthSpringMesh = maxPlateauwidthSpringMesh;
            this.useLegacyOptimizer = useLegacyOptimizer;
            this.maxStretchSpringMesh = maxStretchSpringMesh;
            this.minR = minR;
            this.resolutionSpringMesh = resolutionSpringMesh;
            this.rodR = rodR;
            this.searchRadius = searchRadius;
            this.stiffnessSpringMesh = stiffnessSpringMesh;
            this.useLocalSmoothnessFilter = useLocalSmoothnessFilter;
            this.useTps = useTps;
        }

        @Override
        public Param clone() {
            return new Param(this.ppm.sift.fdBins, this.ppm.sift.fdSize, this.ppm.sift.initialSigma, this.ppm.sift.maxOctaveSize, this.ppm.sift.minOctaveSize, this.ppm.sift.steps, this.ppm.clearCache, this.ppm.maxNumThreadsSift, this.ppm.rod, this.desiredModelIndex, this.expectedModelIndex, this.identityTolerance, this.isAligned, this.maxEpsilon, this.maxIterationsOptimize, this.maxNumFailures, this.maxNumNeighbors, this.maxNumThreads, this.maxPlateauwidthOptimize, this.minInlierRatio, this.minNumInliers, this.multipleHypotheses, this.widestSetOnly, this.rejectIdentity, this.visualize, this.blockRadius, this.dampSpringMesh, this.layerScale, this.localModelIndex, this.localRegionSigma, this.maxCurvatureR, this.maxIterationsSpringMesh, this.maxLocalEpsilon, this.maxLocalTrust, this.maxPlateauwidthSpringMesh, this.useLegacyOptimizer, this.maxStretchSpringMesh, this.minR, this.resolutionSpringMesh, this.rodR, this.searchRadius, this.stiffnessSpringMesh, this.useLocalSmoothnessFilter, this.useTps);
        }
    }
}

