/*
 * Decompiled with CFR 0.152.
 */
package volumeCalculator;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import ij3d.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import sc.fiji.analyzeSkeleton.AnalyzeSkeleton_;
import sc.fiji.analyzeSkeleton.Edge;
import sc.fiji.analyzeSkeleton.Graph;
import sc.fiji.analyzeSkeleton.Point;
import sc.fiji.analyzeSkeleton.SkeletonResult;
import sc.fiji.analyzeSkeleton.Vertex;
import sc.fiji.skeletonize3D.Skeletonize3D_;
import volumeCalculator.GraphContentNode;
import volumeCalculator.UserData;

class AnalyzedGraph {
    private static float INITIAL_SCALE = 1.5f;
    private static Color3f EDGE_POINT_COLOR = Utils.toColor3f(Color.yellow);
    private static Color3f TREE_POINT_COLOR = Utils.toColor3f(Color.MAGENTA);
    private static float TREE_POINT_THICKNESS = 1.0f;
    private static final Color EDGE_COLOR = Color.white;
    private static Color3f EDGE_COLOR_3f = Utils.toColor3f(EDGE_COLOR);
    private static float EDGE_THICKNESS = 2.0f;
    private static float VERTEX_THICKNESS = 2.0f;
    private static String STATUS_BEGIN_CREATE_GRAPHIC = "Begin creating 3D graphic.";
    private ImageProcessor ip;
    private Skeletonize3D_ skeletonizer;
    private AnalyzeSkeleton_ analyzeSkeleton;
    SkeletonResult skeletonResult;
    private Graph[] forest;
    private GraphContentNode sceneGraph;
    private BranchGroup treeBG;
    private Map<Integer, Set<Edge>> sliceGuide = new HashMap<Integer, Set<Edge>>();
    private float width;
    private float height;
    private float depth;
    private static Map<Point, Set<Edge>> edgeGuide = new HashMap<Point, Set<Edge>>();

    public SkeletonResult getSkeletonResult() {
        return this.skeletonResult;
    }

    public Map<Integer, Set<Edge>> getSliceGuide() {
        return this.sliceGuide;
    }

    public GraphContentNode getSceneGraph() {
        return this.sceneGraph;
    }

    void init(ImagePlus imagePlus) {
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
        this.skeletonizer = new Skeletonize3D_();
        this.skeletonizer.setup("none", imagePlus);
        this.skeletonizer.run(this.ip);
        this.analyzeSkeleton = new AnalyzeSkeleton_();
        this.analyzeSkeleton.setup("none", imagePlus);
        this.skeletonResult = this.analyzeSkeleton.run(0, false, false, imagePlus, true, false);
        this.forest = this.skeletonResult.getGraph();
        IJ.showStatus((String)STATUS_BEGIN_CREATE_GRAPHIC);
        this.construct(this.forest);
        this.constructSliceGuide(this.forest);
        IJ.showStatus((String)"");
    }

    void construct(Graph[] forest) {
        this.sceneGraph = new GraphContentNode();
        this.sceneGraph.setCapability(1);
        int graphCount = 0;
        for (Graph tree : forest) {
            if (tree.getEdges().size() < 1) continue;
            ++graphCount;
            int vcount = 0;
            int ecount = 0;
            Stack<Vertex> stack = new Stack<Vertex>();
            Stack<Object> groupStack = new Stack<Object>();
            for (Vertex v : tree.getVertices()) {
                v.setVisited(false);
            }
            stack.push(((Edge)tree.getEdges().get(0)).getV1());
            this.treeBG = new BranchGroup();
            this.treeBG.setCapability(1);
            this.sceneGraph.addChild((Node)this.treeBG);
            groupStack.push(this.treeBG);
            int visitOrder = 0;
            while (!stack.empty()) {
                Vertex vertex = (Vertex)stack.pop();
                Group vertexGroup = (Group)groupStack.pop();
                if (vertex.isVisited()) continue;
                UserData ud = new UserData(vertex);
                vertexGroup.setUserData((Object)ud);
                PointAttributes attr = new PointAttributes();
                attr.setPointSize(VERTEX_THICKNESS);
                PointAttributes treePointAttr = new PointAttributes();
                treePointAttr.setPointSize(TREE_POINT_THICKNESS);
                Appearance appear = new Appearance();
                appear.setPointAttributes(attr);
                if (vertex.getPredecessor() != null) {
                    vertex.getPredecessor().setType(0);
                }
                vertex.setVisited(true, visitOrder++);
                ++vcount;
                ArrayList<Edge> previousEdges = new ArrayList<Edge>();
                block3: for (Edge edge : vertex.getBranches()) {
                    for (Edge previousEdge : previousEdges) {
                        if (!edge.equals(previousEdge) && (!edge.getV1().equals(previousEdge.getV1()) || !edge.getV2().equals(previousEdge.getV2()))) continue;
                        continue block3;
                    }
                    previousEdges.add(edge);
                    if (edge.getType() == 1) continue;
                    Vertex oppVertex = edge.getOppositeVertex(vertex);
                    if (!oppVertex.isVisited()) {
                        ++ecount;
                        Vertex v1 = edge.getV1();
                        Vertex v2 = edge.getV2();
                        Group edgeGroup = new Group();
                        edgeGroup.setCapability(1);
                        vertexGroup.addChild((Node)edgeGroup);
                        int numberOfEdges = 1 + edge.getSlabs().size();
                        int numberOfPoints = 2 * numberOfEdges;
                        LineArray la = new LineArray(numberOfPoints, 1);
                        la.setCoordinate(0, this.point2point3f((Point)v1.getPoints().get(0)));
                        for (int edgePoint = 0; edgePoint < edge.getSlabs().size(); ++edgePoint) {
                            Point point = (Point)edge.getSlabs().get(edgePoint);
                            la.setCoordinate(2 * edgePoint + 1, this.point2point3f(point));
                            la.setCoordinate(2 * edgePoint + 2, this.point2point3f(point));
                        }
                        la.setCoordinate(numberOfPoints - 1, this.point2point3f((Point)v2.getPoints().get(0)));
                        la.setCapability(2);
                        la.setCapability(3);
                        Appearance appearance = new Appearance();
                        appearance.setCapability(8);
                        appearance.setCapability(9);
                        LineAttributes lineAttributes = new LineAttributes();
                        lineAttributes.setLineWidth(EDGE_THICKNESS);
                        appearance.setLineAttributes(lineAttributes);
                        ColoringAttributes colorAttributes = new ColoringAttributes();
                        colorAttributes.setCapability(0);
                        colorAttributes.setCapability(1);
                        colorAttributes.setColor(EDGE_COLOR_3f);
                        appearance.setColoringAttributes(colorAttributes);
                        Shape3D edgeShape = new Shape3D((Geometry)la, appearance);
                        edgeShape.setCapability(14);
                        edgeShape.setCapability(15);
                        ud = new UserData(edge);
                        edgeShape.setUserData((Object)ud);
                        edgeGroup.addChild((Node)edgeShape);
                        groupStack.push(edgeGroup);
                        stack.push(oppVertex);
                        oppVertex.setPredecessor(edge);
                        continue;
                    }
                    edge.setType(1);
                }
            }
        }
    }

    private Point3f point2point3f(Point point) {
        float x = (float)point.x / this.width;
        float y = (float)point.y / this.height;
        float z = (float)point.z / this.height;
        Point3f point3f = new Point3f(x, y, z);
        point3f.scale(INITIAL_SCALE);
        return point3f;
    }

    void resetColorAtGroup(Group startGroup, Color3f edgeColor) {
        Color3f currentColor = new Color3f();
        Color3f resetColor = Utils.toColor3f(EDGE_COLOR);
        Iterator children = startGroup.getAllChildren();
        while (children.hasNext()) {
            Node node = (Node)children.next();
            if (node instanceof Shape3D) {
                Shape3D shape = (Shape3D)node;
                if (!(shape.getGeometry() instanceof LineArray)) continue;
                Appearance appearance = shape.getAppearance();
                ColoringAttributes ca = appearance.getColoringAttributes();
                ca.getColor(currentColor);
                if (!currentColor.equals((Tuple3f)edgeColor)) continue;
                ca.setColor(resetColor);
                appearance.setColoringAttributes(ca);
                LineArray segments = (LineArray)shape.getGeometry();
                int nSegs = segments.getVertexCount();
                for (int i = 0; i < nSegs; ++i) {
                    UserData ud = (UserData)shape.getUserData();
                    ud.setColorIndex(99);
                }
                continue;
            }
            this.resetColorAtGroup((Group)node, edgeColor);
        }
    }

    void resetColor(Color3f edgeColor) {
        this.resetColorAtGroup((Group)this.sceneGraph, edgeColor);
    }

    private void constructSliceGuide(Graph[] forest) {
        for (Graph tree : forest) {
            for (Edge edge : tree.getEdges()) {
                this.saveSliceInfo(((Point)edge.getV1().getPoints().get((int)0)).z, edge);
                this.saveSliceInfo(((Point)edge.getV2().getPoints().get((int)0)).z, edge);
                for (Point point : edge.getSlabs()) {
                    this.saveSliceInfo(point.z, edge);
                }
            }
        }
    }

    private void saveSliceInfo(Integer slice, Edge edge) {
        if (this.sliceGuide.containsKey(slice)) {
            this.sliceGuide.get(slice).add(edge);
        } else {
            HashSet<Edge> newSet = new HashSet<Edge>();
            newSet.add(edge);
            this.sliceGuide.put(slice, newSet);
        }
    }

    private void constructEdgeGuide(Graph[] forest) {
        for (Graph tree : forest) {
            for (Edge edge : tree.getEdges()) {
                this.saveEdgeInfo((Point)edge.getV1().getPoints().get(0), edge);
                this.saveEdgeInfo((Point)edge.getV2().getPoints().get(0), edge);
            }
        }
    }

    public Map<Point, Set<Edge>> getEdgeGuide() {
        return edgeGuide;
    }

    private void saveEdgeInfo(Point point, Edge edge) {
        if (edgeGuide.containsKey(point)) {
            edgeGuide.get(point).add(edge);
        } else {
            HashSet<Edge> newSet = new HashSet<Edge>();
            newSet.add(edge);
            edgeGuide.put(point, newSet);
        }
    }
}

