/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation.structure;

import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.Polygon;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import sc.fiji.balloonSegmentation.structure.Balloon;

public class BalloonPopulation {
    public ArrayList<Balloon> BallList = new ArrayList();
    int channel = 1;
    public ImageProcessor ipb;
    ImageProcessor ip_gradx_p;
    ImageProcessor ip_grady_p;
    ImageProcessor ip_gradx_m;
    ImageProcessor ip_grady_m;
    public int N = 0;
    public int id = 0;
    int n_envelop = 351;
    public boolean[][] topo;
    public int[][][] IMB;
    public int[][] contacts;
    public Matrix ref_topo;
    public int area;
    public int[] XXi;
    public int[] YYi;
    public int max_n0 = 0;
    public int max_length = 15;
    double wmin;
    double hmin;
    double wmax;
    double hmax;
    int optimisation_cycles = 10;
    int n_random_points = 500;
    int use_delaunay = 1;
    double triangle_size_factor = 3.5;
    double min_triangle_angle = 0.2;
    double crit_inclusion = 0.6;
    int use_knn = 0;
    int KN = 7;
    boolean is_contact_all = false;
    boolean do_contact = true;
    int period_contact_check = 2;
    double fine_contact_check = 0.8;
    boolean is_growing = true;

    public BalloonPopulation(ImageProcessor ip, int index, int rgbchannel) {
        this.ipb = ip;
        ImageProcessor ipEdge = this.ipb.duplicate();
        ipEdge.findEdges();
        this.channel = rgbchannel;
        float s = 2.0f;
        float[] kernelYp = new float[]{1.0f / s, 2.0f / s, 1.0f / s, 0.0f, 0.0f, 0.0f, -1.0f / s, -2.0f / s, -1.0f / s};
        float[] kernelXp = new float[]{1.0f / s, 0.0f, -1.0f / s, 2.0f / s, 0.0f, -2.0f / s, 1.0f / s, 0.0f, -1.0f / s};
        float[] kernelYm = new float[]{-1.0f / s, -2.0f / s, -1.0f / s, 0.0f, 0.0f, 0.0f, 1.0f / s, 2.0f / s, 1.0f / s};
        float[] kernelXm = new float[]{-1.0f / s, 0.0f, 1.0f / s, -2.0f / s, 0.0f, 2.0f / s, -1.0f / s, 0.0f, 1.0f / s};
        this.ip_gradx_p = ipEdge.duplicate();
        this.ip_gradx_p.convolve(kernelXp, 3, 3);
        this.ip_gradx_m = ipEdge.duplicate();
        this.ip_gradx_m.convolve(kernelXm, 3, 3);
        this.ip_grady_p = ipEdge.duplicate();
        this.ip_grady_p.convolve(kernelYp, 3, 3);
        this.ip_grady_m = ipEdge.duplicate();
        this.ip_grady_m.convolve(kernelYm, 3, 3);
        this.id = index;
        this.loadProperties();
    }

    public void AddNewBalloon(int[] X, int[] Y) {
        Balloon bal1 = new Balloon(X, Y, this.N, this.ipb, this, this.channel);
        this.BallList.add(bal1);
        if (this.max_n0 < bal1.n0) {
            this.max_n0 = bal1.n0;
        }
        ++this.N;
    }

    public void AddNewBalloon(int x, int y) {
        Balloon ball = new Balloon(x, y, this.N, this.ipb, this, this.channel);
        this.BallList.add(ball);
        if (this.max_n0 < ball.n0) {
            this.max_n0 = ball.n0;
        }
        ++this.N;
    }

    public void importSeeds(String directory, String file_name) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(directory + file_name));
            String line = null;
            boolean i = false;
            while ((line = input.readLine()) != null) {
                String[] parts = line.split("\t");
                double x = Double.parseDouble(parts[0].trim());
                double y = Double.parseDouble(parts[1].trim());
                this.AddNewBalloon((int)x, (int)y);
            }
        }
        catch (IOException e) {
            IJ.error((String)"Could not load the data from file: setStructureFromFile");
            return;
        }
    }

    public void remove(int i) {
        if (i < this.N) {
            this.BallList.remove(i);
            --this.N;
            int k = 0;
            while (k < this.N) {
                Balloon B = this.BallList.get(k);
                B.id = k++;
            }
        }
    }

    public void clear() {
        if (this.BallList != null) {
            this.BallList.clear();
        }
        this.is_growing = true;
        this.N = 0;
    }

    private void loadProperties() {
        Properties tempProp = new Properties();
        try {
            InputStream propsFile = this.getClass().getResourceAsStream("/BalloonSegmentation.properties");
            tempProp.load(propsFile);
            propsFile.close();
        }
        catch (IOException ioe) {
            IJ.log((String)"I/O Exception: cannot read .properties file");
        }
        this.triangle_size_factor = Double.parseDouble(tempProp.getProperty("triangle_size_factor"));
        this.min_triangle_angle = Double.parseDouble(tempProp.getProperty("min_triangle_angle"));
        this.crit_inclusion = Double.parseDouble(tempProp.getProperty("crit_inclusion"));
        this.is_contact_all = Boolean.parseBoolean(tempProp.getProperty("is_contact_all"));
        this.fine_contact_check = Double.parseDouble(tempProp.getProperty("fine_contact_check"));
        this.period_contact_check = Integer.parseInt(tempProp.getProperty("period_contact_check"));
        this.do_contact = Boolean.parseBoolean(tempProp.getProperty("do_contact"));
        this.optimisation_cycles = Integer.parseInt(tempProp.getProperty("optimisation_cycles"));
        this.n_random_points = Integer.parseInt(tempProp.getProperty("n_random_points"));
        this.n_envelop = Integer.parseInt(tempProp.getProperty("n_envelop"));
        this.use_delaunay = Integer.parseInt(tempProp.getProperty("use_delaunay"));
        this.use_knn = Integer.parseInt(tempProp.getProperty("use_knn"));
        this.KN = Integer.parseInt(tempProp.getProperty("KN"));
        this.max_length = Integer.parseInt(tempProp.getProperty("max_length"));
        this.max_length = Math.max(this.max_length, 15);
    }

    public void ConnectExistingBalloons() {
        int j;
        int i;
        this.mass_Geometry();
        if (this.BallList.size() > 0) {
            Balloon B = this.BallList.get(0);
            this.contacts = new int[this.N][this.max_n0];
            for (int i2 = 0; i2 < this.N; ++i2) {
                for (int j2 = 0; j2 < B.n0; ++j2) {
                    this.contacts[i2][j2] = -10;
                }
            }
        } else {
            IJ.log((String)("Cannot initialize the contact detection in population: " + this.id));
        }
        this.topo = new boolean[this.N][this.N];
        for (i = 0; i < this.N; ++i) {
            for (j = 0; j < i; ++j) {
                this.topo[i][j] = false;
                if (!(this.N < 4 & i != j)) continue;
                this.topo[i][j] = true;
            }
        }
        if (this.N < 4) {
            for (i = 0; i < this.N; ++i) {
                for (j = 0; j < this.N; ++j) {
                    this.topo[i][j] = true;
                }
            }
        }
    }

    public void ConnectRefinedBalloons() {
        this.mass_Geometry();
        if (this.BallList.size() > 0) {
            Balloon B = this.BallList.get(0);
            int[][] NewContacts = new int[this.N][this.max_n0];
            for (int i = 0; i < this.N; ++i) {
                for (int j = 0; j < B.n0 / 2; ++j) {
                    NewContacts[i][2 * j % B.n0] = this.contacts[i][j];
                    NewContacts[i][(2 * j + 1) % B.n0] = this.contacts[i][j];
                }
            }
            this.contacts = NewContacts;
        } else {
            IJ.log((String)("Cannot initialize the contact detection in population: " + this.id));
        }
    }

    public void sample(float HL) {
        for (int rep = 0; rep < this.optimisation_cycles; ++rep) {
            IJ.showStatus((String)("Sampling point: " + (int)((double)rep / (double)this.optimisation_cycles * 100.0) + "%"));
            for (int i = 0; i < this.n_random_points; ++i) {
                int xc = (int)(this.wmin + Math.random() * (this.wmax - this.wmin));
                int yc = (int)(this.hmin + Math.random() * (this.hmax - this.hmin));
                int add = 1;
                int n = this.N;
                if (250 < this.IMB[xc][yc][2]) {
                    add = 0;
                } else {
                    for (int j = 0; j < n; ++j) {
                        float crit = this.couple(j, xc, yc);
                        if (!(crit < HL)) continue;
                        add = 0;
                        break;
                    }
                }
                if (add <= 0) continue;
                this.AddNewBalloon(xc, yc);
            }
            this.optimize(HL);
        }
        IJ.showStatus((String)"");
    }

    private float couple(int j, int x, int y) {
        float zmax;
        float zmean;
        int xj = this.BallList.get((int)j).x0;
        int yj = this.BallList.get((int)j).y0;
        int xk = x;
        int yk = y;
        float ux = xk - xj;
        float uy = yk - yj;
        float length = (float)Math.sqrt(ux * ux + uy * uy);
        ux /= length;
        uy /= length;
        int sub = 2;
        int[] Pix_max = new int[]{xj, yj, this.ipb.get(xj, yj)};
        int[][] line = new int[(int)length / sub][3];
        int nsub = (int)(length / (float)sub);
        for (int i = 0; i < nsub; ++i) {
            int yi;
            int xi;
            int xii = (int)((float)xk - (float)(sub * i) * ux);
            int yii = (int)((float)yk - (float)(sub * i) * uy);
            if (i < nsub - 1) {
                xi = (int)((float)xj + (float)(sub * i) * ux);
                yi = (int)((float)yj + (float)(sub * i) * uy);
            } else {
                xi = xk;
                yi = yk;
            }
            line[i][0] = xi;
            line[i][1] = yi;
            line[i][2] = this.ipb.get(xi, yi);
            if (Pix_max[2] < line[i][2]) {
                Pix_max[0] = xi;
                Pix_max[1] = yi;
                Pix_max[2] = line[i][2];
            }
            if (Pix_max[2] >= this.ipb.get(xii, yii)) continue;
            Pix_max[0] = xii;
            Pix_max[1] = yii;
            Pix_max[2] = this.ipb.get(xii, yii);
        }
        if (length < 4.0f) {
            zmean = 0.0f;
            zmax = 0.0f;
            length = 0.0f;
        } else {
            zmean = line[line.length - 1][2];
            zmax = (float)Pix_max[2] - zmean;
        }
        float[] features = new float[]{zmean, zmax, length};
        return features[1] * features[2] * features[2];
    }

    private void optimize(float HL) {
        int i;
        this.MakeTopo();
        boolean[] deletion = new boolean[this.N];
        block0: for (i = this.N - 1; i > -1; --i) {
            boolean rem = false;
            double xi = this.BallList.get((int)i).x0;
            double yi = this.BallList.get((int)i).y0;
            deletion[i] = false;
            for (int j = 0; j < this.N; ++j) {
                if (this.topo[i][j] & i != j) {
                    for (int k = 0; k < 8; ++k) {
                        double angle = (double)k * 360.0 / 8.0 * 3.14159 / 180.0;
                        int xx = (int)(xi + 4.5 * Math.cos(angle));
                        int yy = (int)(yi + 4.5 * Math.sin(angle));
                        float crit = this.couple(j, xx = (int)Math.max(Math.min((double)xx, this.wmax), this.wmin), yy = (int)Math.max(Math.min((double)yy, this.hmax), this.hmin));
                        if (!((crit < HL && !deletion[j]) | this.IMB[xx][yy][2] > 50)) continue;
                        deletion[i] = true;
                        rem = true;
                        break;
                    }
                }
                if (rem) continue block0;
            }
        }
        for (i = this.N - 1; i > -1; --i) {
            if (!deletion[i]) continue;
            this.remove(i);
        }
    }

    public void EnvelopBoundaries() {
        int m = 0;
        double xc = 0.0;
        double yc = 0.0;
        int w = this.ipb.getWidth();
        int h = this.ipb.getHeight();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                if (this.IMB[i][j][2] >= 50) continue;
                ++m;
                xc += (double)i;
                yc += (double)j;
            }
        }
        xc /= (double)m;
        yc /= (double)m;
        int n = this.n_envelop;
        this.XXi = new int[n];
        this.YYi = new int[n];
        this.wmin = this.ipb.getWidth() / 2;
        this.wmax = this.ipb.getWidth() / 2;
        this.hmin = this.ipb.getHeight() / 2;
        this.hmax = this.ipb.getHeight() / 2;
        block2: for (int i = 0; i < n; ++i) {
            double angle = (double)(i % n) * 360.0 / (double)n;
            double xr = xc;
            double yr = yc;
            for (int r = 1; r < 8 * w; ++r) {
                xr = xc + (double)r * Math.cos(angle * 3.14159 / 180.0) / 8.0;
                if (!(xr < 2.0 | (double)(w - 2) < xr | (yr = yc + (double)r * Math.sin(angle * 3.14159 / 180.0) / 8.0) < 2.0 | (double)(h - 2) < yr | 50 < this.IMB[(int)xr][(int)yr][2])) continue;
                this.XXi[i] = (int)xr;
                this.YYi[i] = (int)yr;
                this.wmin = Math.min(this.wmin, xr);
                this.wmax = Math.max(this.wmax, xr);
                this.hmin = Math.min(this.hmin, yr);
                this.hmax = Math.max(this.hmax, yr);
                continue block2;
            }
        }
    }

    public void refineStructure() {
        for (int i = 0; i < this.N; ++i) {
            Balloon B1 = this.BallList.get(i);
            B1.refineStructure();
        }
        this.ConnectRefinedBalloons();
    }

    public void InitiateGrowingRegion() {
        for (int i = 0; i < this.N; ++i) {
            Balloon B1 = this.BallList.get(i);
            B1.loadProperties();
            B1.init();
            B1.InitiateGrowingRegion();
        }
    }

    public void MakeTopo() {
        int j;
        int i;
        if (this.BallList.size() > 0) {
            Balloon B = this.BallList.get(0);
            this.contacts = new int[this.N][this.max_n0];
            for (int i2 = 0; i2 < this.N; ++i2) {
                for (int j2 = 0; j2 < this.max_n0; ++j2) {
                    this.contacts[i2][j2] = -10;
                }
                B = this.BallList.get(i2);
            }
        } else {
            IJ.log((String)("Could not initialize the contact detection in population: " + this.id));
        }
        this.topo = new boolean[this.N][this.N];
        for (i = 0; i < this.N; ++i) {
            for (j = 0; j < i; ++j) {
                this.topo[i][j] = false;
                if (!(this.N < 4 & i != j)) continue;
                this.topo[i][j] = true;
            }
        }
        if (this.N < 4) {
            for (i = 0; i < this.N; ++i) {
                for (j = 0; j < this.N; ++j) {
                    this.topo[i][j] = true;
                }
            }
        }
        if (this.use_delaunay == 1) {
            for (i = 0; i < this.N; ++i) {
                for (j = i + 1; j < this.N; ++j) {
                    for (int k = j + 1; k < this.N; ++k) {
                        boolean isTriangle = true;
                        for (int a = 0; a < this.N; ++a) {
                            if (a == i || a == j || a == k) continue;
                            Point Pi = this.BallList.get(i).getPoint();
                            Point Pj = this.BallList.get(j).getPoint();
                            Point Pk = this.BallList.get(k).getPoint();
                            Point Pa = this.BallList.get(a).getPoint();
                            Polygon triangle = new Polygon();
                            if (!this.contains(Pi, Pj, Pk, Pa)) continue;
                            isTriangle = false;
                            break;
                        }
                        if (!isTriangle) continue;
                        this.topo[i][j] = true;
                        this.topo[j][i] = true;
                        this.topo[i][k] = true;
                        this.topo[k][i] = true;
                        this.topo[j][k] = true;
                        this.topo[k][j] = true;
                    }
                }
            }
        } else {
            int[][] BUF = new int[this.N][2];
            ArrayList<double[]> KNLIST = new ArrayList<double[]>();
            for (int i3 = 0; i3 < this.N; ++i3) {
                for (int j3 = 0; j3 < this.N; ++j3) {
                    Point Pi = this.BallList.get(i3).getPoint();
                    Point Pj = this.BallList.get(j3).getPoint();
                    double xi = Pi.getX();
                    double yi = Pi.getY();
                    double xj = Pj.getX();
                    double yj = Pj.getY();
                    double d = (xi - xj) * (xi - xj) + (yi - yj) * (yi - yj);
                    for (int k = 0; k < this.KN; ++k) {
                        double[] ins;
                        if (k >= KNLIST.size()) {
                            if (i3 == j3) break;
                            ins = new double[]{j3, d};
                            KNLIST.add(ins);
                            break;
                        }
                        if (!(d < ((double[])KNLIST.get(k))[1] & i3 != j3)) continue;
                        ins = new double[]{j3, d};
                        KNLIST.add(k, ins);
                        if (KNLIST.size() <= this.KN) break;
                        KNLIST.remove(this.KN);
                        break;
                    }
                    if (!(KNLIST.size() == 0 & i3 != j3)) continue;
                    double[] ins0 = new double[]{j3, d};
                    KNLIST.add(ins0);
                }
                for (int jj = 0; jj < KNLIST.size(); ++jj) {
                    int n = (int)((double[])KNLIST.get(jj))[0];
                    this.topo[i3][n] = true;
                    this.topo[n][i3] = true;
                }
                KNLIST.clear();
            }
        }
    }

    public void Tick_inflate(int PixLevel, int t) {
        for (int i = 0; i < this.N; ++i) {
            Balloon B = this.BallList.get(i);
            if (!B.docontact & t % this.period_contact_check == 0) {
                this.Tick_contact(B);
            } else if (B.docontact) {
                this.Tick_contact(B);
            }
            B.PixLevel = PixLevel - 1;
            B.Inflate_inc();
        }
    }

    public void Tick_inflate(int PixLevel) {
        int t = 0;
        for (int i = 0; i < this.N; ++i) {
            Balloon B = this.BallList.get(i);
            B.init_opt();
        }
        for (int k = 1; k < 150; ++k) {
            ++t;
            this.is_growing = true;
            for (int i = 0; i < this.N; ++i) {
                Balloon B = this.BallList.get(i);
                if (!B.docontact & t % this.period_contact_check == 0) {
                    this.Tick_contact(B);
                } else if (B.docontact & t % 1 == 0) {
                    this.Tick_contact(B);
                }
                B.Optimize_inc();
                Double r_ini = B.history_radius.get(0);
                Double r_end = B.history_radius.get(B.length_history - 1);
                if (2.0 * (r_end - r_ini) / (r_end + r_ini) < 1.0E-4) {
                    B.is_growing = false;
                }
                if (!B.is_growing) continue;
                this.is_growing = true;
            }
            if (!this.is_growing) break;
        }
    }

    public void Tick_contact(Balloon B) {
        int i = B.id;
        block0: for (int k = 0; k < B.n0; ++k) {
            boolean contactb = this.isEdge((int)B.XX[k], (int)B.YY[k]);
            if (contactb | B.FIX[k] == 10) {
                B.encastre(k);
                if (!contactb) continue;
                this.contacts[i][k] = -1;
                continue;
            }
            if (!this.do_contact) continue;
            for (int j = 0; j < this.N; ++j) {
                Balloon Bj = this.BallList.get(j);
                double dx = B.x0 - Bj.x0;
                double dy = B.y0 - Bj.y0;
                if (!this.topo[i][j] || i == j || !(B.radius + Bj.radius > this.fine_contact_check * Math.sqrt(dx * dx + dy * dy))) continue;
                B.docontact = true;
                Bj.docontact = true;
                boolean contact = Bj.contact(B.XX[k], B.YY[k], B.x0, B.y0);
                if (!contact) continue;
                this.contacts[i][k] = j;
                B.fix(k);
                boolean contain = Bj.contain(B.XX[k], B.YY[k], B.x0, B.y0);
                if (contain) {
                    B.encastre(k);
                }
                B.encastre(k);
                continue block0;
            }
        }
    }

    private boolean contains(Point Pi, Point Pj, Point Pk, Point Pa) {
        double a;
        double xi = Pi.getX();
        double yi = Pi.getY();
        double xj = Pj.getX();
        double yj = Pj.getY();
        double xk = Pk.getX();
        double yk = Pk.getY();
        double xa = Pa.getX();
        double ya = Pa.getY();
        if (yi == yj) {
            double b = (xj - xk) / (yi - yk) / 2.0;
            a = -((yj - yk) / 2.0 - b * (xk - xi)) / (xj - xi);
        } else if (yi == yk) {
            a = -(yj - yk) / 2.0 / (yi - yj);
            double b = -((yi - yk) / 2.0 - (xk - xi)) / (xj - xi);
        } else {
            a = (yj - yk) / 2.0 - (xk - xi) * (xj - xk) / (yi - yk) / 2.0;
            double b = (xj - xk) / 2.0 / (yi - yk) - (a /= -(xj - xi) + (yi - yj) * (xk - xi) / (yi - yk)) * (yi - yj) / (yi - yk);
        }
        double xc = (xi + xj) / 2.0 + a * (yi - yj);
        double yc = (yi + yj) / 2.0 + a * (xj - xi);
        double ri = Math.sqrt((xi - xc) * (xi - xc) + (yi - yc) * (yi - yc));
        double rj = Math.sqrt((xj - xc) * (xj - xc) + (yj - yc) * (yj - yc));
        double rk = Math.sqrt((xk - xc) * (xk - xc) + (yk - yc) * (yk - yc));
        double ra = Math.sqrt((xa - xc) * (xa - xc) + (ya - yc) * (ya - yc));
        double dr = Math.abs(ri - rj) + Math.abs(ri - rk) + Math.abs(rj - rk);
        double lij = Math.sqrt((xi - xj) * (xi - xj) + (yi - yj) * (yi - yj));
        double lik = Math.sqrt((xi - xk) * (xi - xk) + (yi - yk) * (yi - yk));
        double ljk = Math.sqrt((xj - xk) * (xj - xk) + (yj - yk) * (yj - yk));
        double n1x = (xi - xj) / lij;
        double n1y = (yi - yj) / lij;
        double n2x = (xi - xk) / lik;
        double n2y = (yi - yk) / lik;
        double n3x = (xj - xk) / ljk;
        double n3y = (yj - yk) / ljk;
        double det1 = Math.abs(n1x * n2y - n2x * n1y);
        double det2 = Math.abs(n1x * n3y - n3x * n1y);
        double det3 = Math.abs(n2x * n3y - n3x * n2y);
        double det = Math.min(Math.min(det1, det2), det3);
        double size_indic = Math.sqrt(this.area / this.N) * this.triangle_size_factor;
        boolean size_crit = true;
        double max_l = Math.max(ljk, Math.max(lij, lik));
        if (size_indic >= max_l | this.area == 0) {
            size_crit = false;
        }
        return ra < ri * this.crit_inclusion || dr > 0.1 || det < this.min_triangle_angle || size_crit;
    }

    private boolean isEdge(int ix, int iy) {
        int h;
        int w;
        if (ix < 2 | (w = this.ipb.getWidth()) - 2 < ix | iy < 2 | (h = this.ipb.getHeight()) - 2 < iy) {
            return true;
        }
        return 50 < this.IMB[ix][iy][2];
    }

    public void set_boundaries(int[][][] B) {
        this.IMB = B;
        this.calc_area();
    }

    public void modify_boundaries(int[] XXi, int[] YYi) {
        PolygonRoi Proi = new PolygonRoi(XXi, YYi, XXi.length, 2);
        int sx = this.IMB.length;
        int sy = this.IMB[0].length;
        int sz = this.IMB[0][0].length;
        for (int i = 0; i < sx; ++i) {
            for (int j = 0; j < sy; ++j) {
                this.IMB[i][j][2] = Proi.contains(i, j) ? 0 : 255;
            }
        }
        this.calc_area();
    }

    public void calc_area() {
        this.area = 0;
        int sx = this.IMB.length;
        int sy = this.IMB[0].length;
        for (int i = 0; i < sx; ++i) {
            for (int j = 0; j < sy; ++j) {
                if (this.IMB[i][j][2] >= 5) continue;
                ++this.area;
            }
        }
    }

    public void mass_Geometry() {
        for (int i = 0; i < this.N; ++i) {
            Balloon B = this.BallList.get(i);
            B.mass_geometry();
        }
    }

    public ColorProcessor Draw_kinematics() {
        int w = this.ipb.getWidth();
        int h = this.ipb.getHeight();
        ColorProcessor cp = new ColorProcessor(w, h);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pix;
                int red = pix = this.ipb.getPixel(x, y);
                int green = pix;
                int blue = pix;
                cp.putPixel(x, y, ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF));
            }
        }
        ImagePlus imp = new ImagePlus("Kinematics", (ImageProcessor)cp);
        for (int i = 0; i < this.BallList.size(); ++i) {
            Balloon bal = this.BallList.get(i);
            bal.Fill_balloon(imp);
        }
        cp = (ColorProcessor)imp.getProcessor();
        return cp;
    }

    public ColorProcessor Draw_lineage(int seq) {
        int w = this.ipb.getWidth();
        int h = this.ipb.getHeight();
        ColorProcessor cp = new ColorProcessor(w, h);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pix;
                int red = pix = this.ipb.getPixel(x, y);
                int green = pix;
                int blue = pix;
                cp.putPixel(x, y, ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF));
            }
        }
        ImagePlus imp = new ImagePlus("Generation", (ImageProcessor)cp);
        for (int i = 0; i < this.BallList.size(); ++i) {
            Balloon bal = this.BallList.get(i);
            if (bal.id_line == 2) {
                bal.Fill_balloon(imp, Math.min((int)(Math.pow(bal.n_generation, 2.0) * 10.0), 255));
                continue;
            }
            bal.Fill_balloon(imp, Math.min(0, 255));
        }
        cp = (ColorProcessor)imp.getProcessor();
        return cp;
    }

    public int[][] CenterList() {
        int[][] LIST = new int[this.N][2];
        for (int i = 0; i < this.N; ++i) {
            Balloon B = this.BallList.get(i);
            LIST[i][0] = B.x0;
            LIST[i][1] = B.y0;
        }
        return LIST;
    }
}

