/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.ResourceFilter;
import com.sun.javafx.tools.resource.ResourceTraversal;
import java.io.File;

public class PackagerResource {
    private static final ResourceFilter ACCEPT_ALL_FILTER = new ResourceFilter(){

        @Override
        public boolean descent(File file, String string) {
            return true;
        }

        @Override
        public boolean accept(File file, String string) {
            return true;
        }
    };
    private final File baseDir;
    private final File file;
    private final String relativePath;

    public PackagerResource(File file, String string) {
        this(file, PackagerResource.createFile(file, string));
    }

    public PackagerResource(File file, File file2) {
        File file3;
        File file4 = PackagerResource.normalizeFile(file2);
        if (file4 == null) {
            throw new IllegalArgumentException("Invalid file specified");
        }
        if (file != null) {
            file3 = PackagerResource.normalizeFile(file);
            if (file3 == null) {
                throw new IllegalArgumentException("Invalid basedir specified");
            }
            if (file4.equals(file3)) {
                this.file = file4;
                this.baseDir = file4;
                this.relativePath = "";
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(file4.getName());
            for (File file5 = file4.getParentFile(); file5 != null; file5 = file5.getParentFile()) {
                if (file5.equals(file3)) {
                    this.file = file4;
                    this.baseDir = file3;
                    this.relativePath = stringBuilder.toString();
                    return;
                }
                stringBuilder.insert(0, '/');
                stringBuilder.insert(0, file5.getName());
            }
        }
        file3 = file4.getParentFile();
        this.file = file4;
        this.baseDir = file3 != null ? file3 : file4;
        this.relativePath = file4.getName();
    }

    public final File getBaseDir() {
        return this.baseDir;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getRelativePath() {
        return this.relativePath;
    }

    public final boolean traverse(ResourceTraversal resourceTraversal) {
        return this.traverse(resourceTraversal, null);
    }

    public final boolean traverse(ResourceTraversal resourceTraversal, ResourceFilter resourceFilter) {
        return new TraversalOperation(resourceFilter != null ? resourceFilter : ACCEPT_ALL_FILTER, resourceTraversal, this).execute();
    }

    private static File normalizeFile(File file) {
        return PackagerResource.normalizeFileImpl(file.getAbsoluteFile());
    }

    private static File normalizeFileImpl(File file) {
        if (file.getParentFile() == null) {
            return file;
        }
        File file2 = PackagerResource.normalizeFileImpl(file.getParentFile());
        if (file2 == null) {
            return null;
        }
        String string = file.getName();
        if (string.equals(".")) {
            return file2;
        }
        if (string.equals("..")) {
            return file2.getParentFile();
        }
        return new File(file2, string);
    }

    private static File createFile(File file, String string) {
        File file2 = new File(string);
        return file2.isAbsolute() ? file2 : new File(file == null ? null : file.getAbsolutePath(), string);
    }

    private static final class TraversalOperation {
        private final ResourceFilter resourceFilter;
        private final ResourceTraversal resourceTraversal;
        private final PackagerResource rootResource;
        private final StringBuilder relativePathBuilder;

        public TraversalOperation(ResourceFilter resourceFilter, ResourceTraversal resourceTraversal, PackagerResource packagerResource) {
            this.resourceFilter = resourceFilter;
            this.resourceTraversal = resourceTraversal;
            this.rootResource = packagerResource;
            this.relativePathBuilder = new StringBuilder(packagerResource.relativePath);
        }

        public boolean execute() {
            return this.traverse(this.rootResource.file);
        }

        private boolean traverse(File file) {
            String string = this.relativePathBuilder.toString();
            if (this.resourceFilter.accept(file, string) && !this.resourceTraversal.traverse(this.rootResource, file, string)) {
                return false;
            }
            if (!file.isDirectory() || !this.resourceFilter.descent(file, string)) {
                return true;
            }
            int n = this.relativePathBuilder.length();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (n > 0) {
                        this.relativePathBuilder.append('/');
                    }
                    this.relativePathBuilder.append(file2.getName());
                    if (!this.traverse(file2)) {
                        return false;
                    }
                    this.relativePathBuilder.setLength(n);
                }
            }
            return true;
        }
    }
}

