/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractAttributedDecoratedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.handle.BoundsOutlineHandle;
import org.jhotdraw.draw.handle.FontSizeHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.locator.RelativeLocator;
import org.jhotdraw.draw.tool.TextEditingTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class TextFigure
extends AbstractAttributedDecoratedFigure
implements TextHolderFigure {
    protected Point2D.Double origin = new Point2D.Double();
    protected boolean editable = true;
    @Nullable
    protected transient TextLayout textLayout;

    public TextFigure() {
        this(ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("TextFigure.defaultText"));
    }

    public TextFigure(String text) {
        this.setText(text);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
    }

    @Override
    protected void drawFill(Graphics2D g) {
    }

    @Override
    protected void drawText(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            TextLayout layout = this.getTextLayout();
            layout.draw(g, (float)this.origin.x, (float)(this.origin.y + (double)layout.getAscent()));
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        tx.transform(this.origin, this.origin);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.origin = new Point2D.Double(anchor.x, anchor.y);
    }

    @Override
    public boolean figureContains(Point2D.Double p) {
        return this.getBounds().contains(p);
    }

    protected TextLayout getTextLayout() {
        if (this.textLayout == null) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (this.get(AttributeKeys.FONT_UNDERLINE).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            this.textLayout = new TextLayout(text, textAttributes, frc);
        }
        return this.textLayout;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        TextLayout layout = this.getTextLayout();
        Rectangle2D.Double r = new Rectangle2D.Double(this.origin.x, this.origin.y, layout.getAdvance(), layout.getAscent() + layout.getDescent());
        return r;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double b = this.getBounds();
        return new Dimension2DDouble(b.width, b.height);
    }

    @Override
    public double getBaseline() {
        TextLayout layout = this.getTextLayout();
        return this.origin.y + (double)layout.getAscent() - this.getBounds().y;
    }

    @Override
    protected Rectangle2D.Double getFigureDrawingArea() {
        if (this.getText() == null) {
            return this.getBounds();
        }
        TextLayout layout = this.getTextLayout();
        Rectangle2D.Double r = new Rectangle2D.Double(this.origin.x, this.origin.y, layout.getAdvance(), layout.getAscent());
        Rectangle2D lBounds = layout.getBounds();
        if (!lBounds.isEmpty() && !Double.isNaN(lBounds.getX())) {
            r.add(new Rectangle2D.Double(lBounds.getX() + this.origin.x, lBounds.getY() + this.origin.y + (double)layout.getAscent(), lBounds.getWidth(), lBounds.getHeight()));
        }
        Geom.grow(r, 2.0, 2.0);
        return r;
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Point2D.Double p = (Point2D.Double)geometry;
        this.origin.x = p.x;
        this.origin.y = p.y;
    }

    @Override
    public Object getTransformRestoreData() {
        return this.origin.clone();
    }

    @Override
    public String getText() {
        return this.get(AttributeKeys.TEXT);
    }

    @Override
    public void setText(String newText) {
        this.set(AttributeKeys.TEXT, newText);
    }

    @Override
    public int getTextColumns() {
        return 4;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return this.get(AttributeKeys.TEXT_COLOR);
    }

    @Override
    public Color getFillColor() {
        return this.get(AttributeKeys.FILL_COLOR);
    }

    @Override
    public void setFontSize(float size) {
        this.set(AttributeKeys.FONT_SIZE, new Double(size));
    }

    @Override
    public float getFontSize() {
        return this.get(AttributeKeys.FONT_SIZE).floatValue();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                handles.add(new BoundsOutlineHandle(this));
                handles.add(new MoveHandle(this, RelativeLocator.northWest()));
                handles.add(new MoveHandle(this, RelativeLocator.northEast()));
                handles.add(new MoveHandle(this, RelativeLocator.southWest()));
                handles.add(new MoveHandle(this, RelativeLocator.southEast()));
                handles.add(new FontSizeHandle(this));
            }
        }
        return handles;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            TextEditingTool t = new TextEditingTool(this);
            return t;
        }
        return null;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    @Override
    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.setBounds(new Point2D.Double(in.getAttribute("x", 0.0), in.getAttribute("y", 0.0)), new Point2D.Double(0.0, 0.0));
        this.readAttributes(in);
        this.readDecorator(in);
        this.invalidate();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double b = this.getBounds();
        out.addAttribute("x", b.x);
        out.addAttribute("y", b.y);
        this.writeAttributes(out);
        this.writeDecorator(out);
    }

    @Override
    public TextFigure clone() {
        TextFigure that = (TextFigure)super.clone();
        that.origin = (Point2D.Double)this.origin.clone();
        that.textLayout = null;
        return that;
    }

    @Override
    public boolean isTextOverflow() {
        return false;
    }
}

