/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.text.StyledEditorKit;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.app.action.edit.CopyAction;
import org.jhotdraw.app.action.edit.CutAction;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.app.action.edit.PasteAction;
import org.jhotdraw.color.HSBColorSpace;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.AlignAction;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.AttributeAction;
import org.jhotdraw.draw.action.AttributeToggler;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ColorIcon;
import org.jhotdraw.draw.action.DefaultAttributeAction;
import org.jhotdraw.draw.action.DrawingAttributeAction;
import org.jhotdraw.draw.action.DrawingColorChooserAction;
import org.jhotdraw.draw.action.DrawingColorChooserHandler;
import org.jhotdraw.draw.action.DrawingColorIcon;
import org.jhotdraw.draw.action.EditorColorChooserAction;
import org.jhotdraw.draw.action.EditorColorIcon;
import org.jhotdraw.draw.action.FontChooserHandler;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.LineDecorationIcon;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SelectionColorChooserAction;
import org.jhotdraw.draw.action.SelectionColorChooserHandler;
import org.jhotdraw.draw.action.SelectionColorIcon;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.StrokeIcon;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.draw.action.ZoomEditorAction;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.decoration.LineDecoration;
import org.jhotdraw.draw.event.SelectionComponentRepainter;
import org.jhotdraw.draw.event.ToolAdapter;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.tool.DelegationSelectionTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.gui.JComponentPopup;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;

public class ButtonFactory {
    public static final List<ColorIcon> DEFAULT_COLORS;
    public static final int DEFAULT_COLORS_COLUMN_COUNT = 8;
    public static final List<ColorIcon> WEBSAVE_COLORS;
    public static final int WEBSAVE_COLORS_COLUMN_COUNT = 19;
    public static final List<ColorIcon> HSB_COLORS;
    public static final int HSB_COLORS_COLUMN_COUNT = 12;
    public static final List<ColorIcon> HSB_COLORS_AS_RGB;
    public static final int HSB_COLORS_AS_RGB_COLUMN_COUNT = 12;

    private ButtonFactory() {
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor) {
        return ButtonFactory.createDrawingActions(editor, new LinkedList<Disposable>());
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor, List<Disposable> dsp) {
        LinkedList<Action> list = new LinkedList<Action>();
        list.add(new CutAction());
        list.add(new CopyAction());
        list.add(new PasteAction());
        SelectSameAction a = new SelectSameAction(editor);
        list.add(a);
        dsp.add(a);
        return list;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor));
        a.add(new UngroupAction(editor));
        a.add(null);
        a.add(new BringToFrontAction(editor));
        a.add(new SendToBackAction(editor));
        return a;
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor) {
        return ButtonFactory.addSelectionToolTo(tb, editor, ButtonFactory.createDrawingActions(editor), ButtonFactory.createSelectionActions(editor));
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor, Collection<Action> drawingActions, Collection<Action> selectionActions) {
        DelegationSelectionTool selectionTool = new DelegationSelectionTool(drawingActions, selectionActions);
        return ButtonFactory.addSelectionToolTo(tb, editor, selectionTool);
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor, Tool selectionTool) {
        JToggleButton t;
        ButtonGroup group;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        if (tb.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            group = (ButtonGroup)tb.getClientProperty("toolButtonGroup");
        } else {
            group = new ButtonGroup();
            tb.putClientProperty("toolButtonGroup", group);
        }
        editor.setTool(selectionTool);
        final JToggleButton defaultToolButton = t = new JToggleButton();
        if (!(tb.getClientProperty("toolHandler") instanceof ToolListener)) {
            ToolAdapter toolHandler = new ToolAdapter(){

                @Override
                public void toolDone(ToolEvent event) {
                    defaultToolButton.setSelected(true);
                }
            };
            tb.putClientProperty("toolHandler", toolHandler);
        }
        labels.configureToolBarButton(t, "selectionTool");
        t.setSelected(true);
        t.addItemListener(new ToolButtonListener(selectionTool, editor));
        t.setFocusable(false);
        group.add(t);
        tb.add(t);
        return t;
    }

    public static JToggleButton addToolTo(JToolBar tb, DrawingEditor editor, Tool tool, String labelKey, ResourceBundleUtil labels) {
        ButtonGroup group = (ButtonGroup)tb.getClientProperty("toolButtonGroup");
        ToolListener toolHandler = (ToolListener)tb.getClientProperty("toolHandler");
        JToggleButton t = new JToggleButton();
        labels.configureToolBarButton(t, labelKey);
        t.addItemListener(new ToolButtonListener(tool, editor));
        t.setFocusable(false);
        tool.addToolListener(toolHandler);
        group.add(t);
        tb.add(t);
        return t;
    }

    public static void addZoomButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createZoomButton(editor));
    }

    public static AbstractButton createZoomButton(final DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        final JPopupButton zoomPopupButton = new JPopupButton();
        labels.configureToolBarButton(zoomPopupButton, "view.zoomFactor");
        zoomPopupButton.setFocusable(false);
        if (editor.getDrawingViews().size() == 0) {
            zoomPopupButton.setText("100 %");
        } else {
            zoomPopupButton.setText((int)(editor.getDrawingViews().iterator().next().getScaleFactor() * 100.0) + " %");
        }
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "activeView") {
                    if (evt.getNewValue() == null) {
                        zoomPopupButton.setText("100 %");
                    } else {
                        zoomPopupButton.setText((int)(editor.getActiveView().getScaleFactor() * 100.0) + " %");
                    }
                }
            }
        });
        double[] factors = new double[]{16.0, 8.0, 5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
        for (int i = 0; i < factors.length; ++i) {
            zoomPopupButton.add(new ZoomEditorAction(editor, factors[i], (AbstractButton)zoomPopupButton){

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    zoomPopupButton.setText((int)(this.editor.getActiveView().getScaleFactor() * 100.0) + " %");
                }
            });
        }
        zoomPopupButton.setFocusable(false);
        return zoomPopupButton;
    }

    public static AbstractButton createZoomButton(DrawingView view) {
        return ButtonFactory.createZoomButton(view, new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1});
    }

    public static AbstractButton createZoomButton(final DrawingView view, double[] factors) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        final JPopupButton zoomPopupButton = new JPopupButton();
        labels.configureToolBarButton(zoomPopupButton, "view.zoomFactor");
        zoomPopupButton.setFocusable(false);
        zoomPopupButton.setText((int)(view.getScaleFactor() * 100.0) + " %");
        view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "scaleFactor") {
                    zoomPopupButton.setText((int)(view.getScaleFactor() * 100.0) + " %");
                }
            }
        });
        for (int i = 0; i < factors.length; ++i) {
            zoomPopupButton.add(new ZoomAction(view, factors[i], zoomPopupButton){

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    zoomPopupButton.setText((int)(view.getScaleFactor() * 100.0) + " %");
                }
            });
        }
        zoomPopupButton.setFocusable(false);
        return zoomPopupButton;
    }

    public static void addAttributesButtonsTo(JToolBar bar, DrawingEditor editor) {
        JButton b = bar.add(new PickAttributesAction(editor));
        b.setFocusable(false);
        b = bar.add(new ApplyAttributesAction(editor));
        b.setFocusable(false);
        bar.addSeparator();
        ButtonFactory.addColorButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addStrokeButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addFontButtonsTo(bar, editor);
    }

    public static void addColorButtonsTo(JToolBar bar, DrawingEditor editor) {
        ButtonFactory.addColorButtonsTo(bar, editor, DEFAULT_COLORS, 8);
    }

    public static void addColorButtonsTo(JToolBar bar, DrawingEditor editor, List<ColorIcon> colors, int columnCount) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.STROKE_COLOR, colors, columnCount, "attribute.strokeColor", labels, new HashMap<AttributeKey, Object>()));
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.FILL_COLOR, colors, columnCount, "attribute.fillColor", labels, new HashMap<AttributeKey, Object>()));
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.TEXT_COLOR, colors, columnCount, "attribute.textColor", labels, new HashMap<AttributeKey, Object>()));
    }

    public static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels) {
        return ButtonFactory.createEditorColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, null);
    }

    public static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes) {
        return ButtonFactory.createEditorColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, defaultAttributes, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape) {
        final JPopupButton popupButton = new JPopupButton();
        popupButton.setPopupAlpha(1.0f);
        if (defaultAttributes == null) {
            defaultAttributes = new HashMap<AttributeKey, Object>();
        }
        popupButton.setAction(new DefaultAttributeAction(editor, attributeKey, defaultAttributes), new Rectangle(0, 0, 22, 22));
        popupButton.setColumnCount(columnCount, false);
        boolean hasNullColor = false;
        for (ColorIcon swatch : swatches) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            Color swatchColor = swatch.getColor();
            attributes.put(attributeKey, swatchColor);
            if (swatchColor == null || swatchColor.getAlpha() == 0) {
                hasNullColor = true;
            }
            AttributeAction a = new AttributeAction(editor, attributes, labels.getToolTipTextProperty(labelKey), (Icon)swatch);
            popupButton.add(a);
            a.putValue("ShortDescription", swatch.getName());
            a.setUpdateEnabledState(false);
        }
        if (!hasNullColor) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            attributes.put(attributeKey, null);
            AttributeAction a = new AttributeAction(editor, attributes, labels.getToolTipTextProperty("attribute.color.noColor"), (Icon)new ColorIcon(null, labels.getToolTipTextProperty("attribute.color.noColor"), swatches.get(0).getIconWidth(), swatches.get(0).getIconHeight()));
            popupButton.add(a);
            a.putValue("ShortDescription", labels.getToolTipTextProperty("attribute.color.noColor"));
            a.setUpdateEnabledState(false);
        }
        ImageIcon chooserIcon = new ImageIcon(Images.createImage(ButtonFactory.class, "/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        EditorColorChooserAction a = new EditorColorChooserAction(editor, attributeKey, "color", chooserIcon, defaultAttributes);
        popupButton.add(a);
        labels.configureToolBarButton(popupButton, labelKey);
        a.putValue("ShortDescription", labels.getToolTipTextProperty("attribute.color.colorChooser"));
        EditorColorIcon icon = new EditorColorIcon(editor, attributeKey, labels.getIconProperty(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                popupButton.repaint();
            }
        });
        return popupButton;
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels) {
        return ButtonFactory.createSelectionColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, null);
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes) {
        return ButtonFactory.createSelectionColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, defaultAttributes, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape) {
        return ButtonFactory.createSelectionColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, defaultAttributes, colorShape, new LinkedList<Disposable>());
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape, List<Disposable> dsp) {
        JPopupButton popupButton = new JPopupButton();
        popupButton.setPopupAlpha(1.0f);
        if (defaultAttributes == null) {
            defaultAttributes = new HashMap<AttributeKey, Object>();
        }
        popupButton.setColumnCount(columnCount, false);
        boolean hasNullColor = false;
        for (ColorIcon swatch : swatches) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            if (swatch != null) {
                Color swatchColor = swatch.getColor();
                attributes.put(attributeKey, swatchColor);
                if (swatchColor == null || swatchColor.getAlpha() == 0) {
                    hasNullColor = true;
                }
                AttributeAction a = new AttributeAction(editor, attributes, labels.getToolTipTextProperty(labelKey), (Icon)swatch);
                popupButton.add(a);
                a.putValue("ShortDescription", swatch.getName());
                a.setUpdateEnabledState(false);
                dsp.add(a);
                continue;
            }
            popupButton.add(new JPanel());
        }
        if (!hasNullColor) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            attributes.put(attributeKey, null);
            AttributeAction a = new AttributeAction(editor, attributes, labels.getToolTipTextProperty("attribute.color.noColor"), (Icon)new ColorIcon(null, labels.getToolTipTextProperty("attribute.color.noColor")));
            popupButton.add(a);
            a.putValue("ShortDescription", labels.getToolTipTextProperty("attribute.color.noColor"));
            a.setUpdateEnabledState(false);
            dsp.add(a);
        }
        ImageIcon chooserIcon = new ImageIcon(Images.createImage(ButtonFactory.class, "/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        SelectionColorChooserAction a = new SelectionColorChooserAction(editor, attributeKey, labels.getToolTipTextProperty("attribute.color.colorChooser"), chooserIcon, defaultAttributes);
        popupButton.add(a);
        a.putValue("ShortDescription", labels.getToolTipTextProperty("attribute.color.colorChooser"));
        dsp.add(a);
        labels.configureToolBarButton(popupButton, labelKey);
        SelectionColorIcon icon = new SelectionColorIcon(editor, attributeKey, labels.getIconProperty(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        dsp.add(new SelectionComponentRepainter(editor, popupButton));
        return popupButton;
    }

    public static JPopupButton createSelectionColorChooserButton(DrawingEditor editor, AttributeKey<Color> attributeKey, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape, List<Disposable> dsp) {
        return ButtonFactory.createSelectionColorChooserButton(editor, attributeKey, labelKey, labels, defaultAttributes, colorShape, null, dsp);
    }

    public static JPopupButton createSelectionColorChooserButton(final DrawingEditor editor, final AttributeKey<Color> attributeKey, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape, final @Nullable Class uiclass, final @Nullable List<Disposable> dsp) {
        JPopupButton popupButton = new JPopupButton();
        labels.configureToolBarButton(popupButton, labelKey);
        popupButton.setFocusable(true);
        popupButton.setRequestFocusEnabled(false);
        JComponentPopup popupMenu = new JComponentPopup(){
            private JColorChooser colorChooser;

            @Override
            public void show(Component invoker, int x, int y) {
                if (this.colorChooser == null) {
                    this.initialize();
                }
                Color c = editor.getActiveView() != null && editor.getActiveView().getSelectionCount() > 0 ? (Color)editor.getActiveView().getSelectedFigures().iterator().next().get(attributeKey) : (Color)editor.getDefaultAttribute(attributeKey);
                this.colorChooser.setColor(c == null ? new Color(0, true) : c);
                super.show(invoker, x, y);
            }

            private void initialize() {
                this.colorChooser = new JColorChooser();
                this.colorChooser.setOpaque(true);
                this.colorChooser.setBackground(Color.WHITE);
                if (uiclass != null) {
                    try {
                        this.colorChooser.setUI((ColorChooserUI)Methods.invokeStatic(uiclass, "createUI", new Class[]{JComponent.class}, new Object[]{this.colorChooser}));
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                }
                dsp.add(new SelectionColorChooserHandler(editor, attributeKey, this.colorChooser, this));
                this.add(this.colorChooser);
            }
        };
        popupButton.setPopupMenu(popupMenu);
        popupButton.setPopupAlpha(1.0f);
        SelectionColorIcon icon = new SelectionColorIcon(editor, attributeKey, labels.getIconProperty(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        if (dsp != null) {
            dsp.add(new SelectionComponentRepainter(editor, popupButton));
        }
        return popupButton;
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels) {
        return ButtonFactory.createDrawingColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, null);
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes) {
        return ButtonFactory.createDrawingColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, defaultAttributes, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape) {
        return ButtonFactory.createDrawingColorButton(editor, attributeKey, swatches, columnCount, labelKey, labels, defaultAttributes, colorShape, new LinkedList<Disposable>());
    }

    public static JPopupButton createDrawingColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, List<ColorIcon> swatches, int columnCount, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape, List<Disposable> dsp) {
        JPopupButton popupButton = new JPopupButton();
        popupButton.setPopupAlpha(1.0f);
        if (defaultAttributes == null) {
            defaultAttributes = new HashMap<AttributeKey, Object>();
        }
        popupButton.setColumnCount(columnCount, false);
        boolean hasNullColor = false;
        for (ColorIcon swatch : swatches) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            if (swatch != null) {
                Color swatchColor = swatch.getColor();
                attributes.put(attributeKey, swatchColor);
                if (swatchColor == null || swatchColor.getAlpha() == 0) {
                    hasNullColor = true;
                }
                DrawingAttributeAction a = new DrawingAttributeAction(editor, attributes, labels.getToolTipTextProperty(labelKey), (Icon)swatch);
                popupButton.add(a);
                dsp.add(a);
                a.putValue("ShortDescription", swatch.getName());
                a.setUpdateEnabledState(false);
                continue;
            }
            popupButton.add(new JPanel());
        }
        if (!hasNullColor) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            attributes.put(attributeKey, null);
            DrawingAttributeAction a = new DrawingAttributeAction(editor, attributes, labels.getToolTipTextProperty("attribute.color.noColor"), (Icon)new ColorIcon(null, labels.getToolTipTextProperty("attribute.color.noColor")));
            popupButton.add(a);
            dsp.add(a);
            a.putValue("ShortDescription", labels.getToolTipTextProperty("attribute.color.noColor"));
            a.setUpdateEnabledState(false);
        }
        ImageIcon chooserIcon = new ImageIcon(Images.createImage(ButtonFactory.class, "/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        DrawingColorChooserAction a = new DrawingColorChooserAction(editor, attributeKey, "color", chooserIcon, defaultAttributes);
        popupButton.add(a);
        dsp.add(a);
        labels.configureToolBarButton(popupButton, labelKey);
        a.putValue("ShortDescription", labels.getToolTipTextProperty("attribute.color.colorChooser"));
        DrawingColorIcon icon = new DrawingColorIcon(editor, attributeKey, labels.getIconProperty(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        if (editor != null) {
            dsp.add(new SelectionComponentRepainter(editor, popupButton));
        }
        return popupButton;
    }

    public static JPopupButton createDrawingColorChooserButton(DrawingEditor editor, AttributeKey<Color> attributeKey, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape, @Nullable List<Disposable> dsp) {
        return ButtonFactory.createSelectionColorChooserButton(editor, attributeKey, labelKey, labels, defaultAttributes, colorShape, null, dsp);
    }

    public static JPopupButton createDrawingColorChooserButton(final DrawingEditor editor, final AttributeKey<Color> attributeKey, String labelKey, ResourceBundleUtil labels, @Nullable Map<AttributeKey, Object> defaultAttributes, Shape colorShape, final @Nullable Class uiclass, final @Nullable List<Disposable> dsp) {
        JPopupButton popupButton = new JPopupButton();
        labels.configureToolBarButton(popupButton, labelKey);
        popupButton.setFocusable(true);
        popupButton.setRequestFocusEnabled(false);
        JComponentPopup popupMenu = new JComponentPopup(){
            private JColorChooser colorChooser;

            @Override
            public void show(Component invoker, int x, int y) {
                if (this.colorChooser == null) {
                    this.initialize();
                }
                Color c = editor.getActiveView() != null ? (Color)editor.getActiveView().getDrawing().get(attributeKey) : (Color)editor.getDefaultAttribute(attributeKey);
                this.colorChooser.setColor(c == null ? new Color(0, true) : c);
                super.show(invoker, x, y);
            }

            private void initialize() {
                this.colorChooser = new JColorChooser();
                this.colorChooser.setOpaque(true);
                this.colorChooser.setBackground(Color.WHITE);
                if (uiclass != null) {
                    try {
                        this.colorChooser.setUI((ColorChooserUI)Methods.invokeStatic(uiclass, "createUI", new Class[]{JComponent.class}, new Object[]{this.colorChooser}));
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                }
                dsp.add(new DrawingColorChooserHandler(editor, attributeKey, this.colorChooser, this));
                this.add(this.colorChooser);
            }
        };
        popupButton.setPopupMenu(popupMenu);
        popupButton.setPopupAlpha(1.0f);
        DrawingColorIcon icon = new DrawingColorIcon(editor, attributeKey, labels.getIconProperty(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        if (dsp != null) {
            dsp.add(new SelectionComponentRepainter(editor, popupButton));
        }
        return popupButton;
    }

    public static void addStrokeButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createStrokeDecorationButton(editor));
        bar.add(ButtonFactory.createStrokeWidthButton(editor));
        bar.add(ButtonFactory.createStrokeDashesButton(editor));
        bar.add(ButtonFactory.createStrokeTypeButton(editor));
        bar.add(ButtonFactory.createStrokePlacementButton(editor));
        bar.add(ButtonFactory.createStrokeCapButton(editor));
        bar.add(ButtonFactory.createStrokeJoinButton(editor));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeWidthButton(editor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeWidthButton(editor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, labels);
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor, double[] widths) {
        return ButtonFactory.createStrokeWidthButton(editor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor, double[] widths, ResourceBundleUtil labels) {
        JPopupButton strokeWidthPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeWidthPopupButton, "attribute.strokeWidth");
        strokeWidthPopupButton.setFocusable(false);
        NumberFormat formatter = NumberFormat.getInstance();
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).setMaximumFractionDigits(1);
            ((DecimalFormat)formatter).setMinimumFractionDigits(0);
        }
        for (int i = 0; i < widths.length; ++i) {
            String label = Double.toString(widths[i]);
            StrokeIcon icon = new StrokeIcon(new BasicStroke((float)widths[i], 0, 2));
            AttributeAction a = new AttributeAction(editor, AttributeKeys.STROKE_WIDTH, new Double(widths[i]), label, icon);
            a.putValue("undoPresentationName", labels.getString("attribute.strokeWidth.text"));
            AbstractButton btn = strokeWidthPopupButton.add(a);
            btn.setDisabledIcon(icon);
        }
        return strokeWidthPopupButton;
    }

    public static JPopupButton createStrokeDecorationButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPopupButton strokeDecorationPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeDecorationPopupButton, "attribute.strokeDecoration");
        strokeDecorationPopupButton.setFocusable(false);
        strokeDecorationPopupButton.setColumnCount(2, false);
        LineDecoration[] decorations = new LineDecoration[]{new ArrowTip(0.35, 12.0, 11.3), new ArrowTip(0.35, 13.0, 7.0), new ArrowTip(0.6283185307179586, 12.0, 9.8, true, true, false), new ArrowTip(0.5235987755982988, 12.0, 0.0, false, true, false), new ArrowTip(0.28559933214452665, 13.0, 0.0, false, true, true), new ArrowTip(0.5235987755982988, 10.0, 18.0, false, true, false), new ArrowTip(0.5235987755982988, 10.0, 18.0, true, true, true), null};
        for (int i = 0; i < decorations.length; ++i) {
            strokeDecorationPopupButton.add(new AttributeAction(editor, AttributeKeys.START_DECORATION, decorations[i], null, new LineDecorationIcon(decorations[i], true)));
            strokeDecorationPopupButton.add(new AttributeAction(editor, AttributeKeys.END_DECORATION, decorations[i], null, new LineDecorationIcon(decorations[i], false)));
        }
        return strokeDecorationPopupButton;
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeDashesButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeDashesButton(editor, new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}}, labels);
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, double[][] dashes) {
        return ButtonFactory.createStrokeDashesButton(editor, dashes, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, double[][] dashes, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeDashesButton(editor, dashes, labels, new LinkedList<Disposable>());
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, double[][] dashes, ResourceBundleUtil labels, List<Disposable> dsp) {
        JPopupButton strokeDashesPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeDashesPopupButton, "attribute.strokeDashes");
        strokeDashesPopupButton.setFocusable(false);
        for (int i = 0; i < dashes.length; ++i) {
            float[] fdashes;
            if (dashes[i] == null) {
                fdashes = null;
            } else {
                fdashes = new float[dashes[i].length];
                for (int j = 0; j < dashes[i].length; ++j) {
                    fdashes[j] = (float)dashes[i][j];
                }
            }
            StrokeIcon icon = new StrokeIcon(new BasicStroke(2.0f, 0, 2, 10.0f, fdashes, 0.0f));
            AttributeAction a = new AttributeAction(editor, AttributeKeys.STROKE_DASHES, dashes[i], null, icon);
            AbstractButton btn = strokeDashesPopupButton.add(a);
            dsp.add(a);
            btn.setDisabledIcon(icon);
        }
        return strokeDashesPopupButton;
    }

    public static JPopupButton createStrokeTypeButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPopupButton strokeTypePopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeTypePopupButton, "attribute.strokeType");
        strokeTypePopupButton.setFocusable(false);
        strokeTypePopupButton.add(new AttributeAction(editor, AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.BASIC, labels.getString("attribute.strokeType.basic"), new StrokeIcon(new BasicStroke(1.0f, 0, 2))));
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        attr.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 2.0);
        strokeTypePopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokeType.double"), (Icon)new StrokeIcon(new DoubleStroke(2.0, 1.0))));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        attr.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 3.0);
        strokeTypePopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokeType.double"), (Icon)new StrokeIcon(new DoubleStroke(3.0, 1.0))));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        attr.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 4.0);
        strokeTypePopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokeType.double"), (Icon)new StrokeIcon(new DoubleStroke(4.0, 1.0))));
        return strokeTypePopupButton;
    }

    public static JPopupButton createStrokePlacementButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPopupButton strokePlacementPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokePlacementPopupButton, "attribute.strokePlacement");
        strokePlacementPopupButton.setFocusable(false);
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.center"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.inside"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.outside"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.centerFilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.insideFilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.outsideFilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.centerUnfilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.insideUnfilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attribute.strokePlacement.outsideUnfilled"), null));
        return strokePlacementPopupButton;
    }

    public static void addFontButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createFontButton(editor));
        bar.add(ButtonFactory.createFontStyleBoldButton(editor));
        bar.add(ButtonFactory.createFontStyleItalicButton(editor));
        bar.add(ButtonFactory.createFontStyleUnderlineButton(editor));
    }

    public static JPopupButton createFontButton(DrawingEditor editor) {
        return ButtonFactory.createFontButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createFontButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createFontButton(editor, AttributeKeys.FONT_FACE, labels);
    }

    public static JPopupButton createFontButton(DrawingEditor editor, AttributeKey<Font> key, ResourceBundleUtil labels) {
        return ButtonFactory.createFontButton(editor, key, labels, new LinkedList<Disposable>());
    }

    public static JPopupButton createFontButton(DrawingEditor editor, AttributeKey<Font> key, ResourceBundleUtil labels, List<Disposable> dsp) {
        JPopupButton fontPopupButton = new JPopupButton();
        labels.configureToolBarButton(fontPopupButton, "attribute.font");
        fontPopupButton.setFocusable(false);
        JComponentPopup popupMenu = new JComponentPopup();
        JFontChooser fontChooser = new JFontChooser();
        dsp.add(new FontChooserHandler(editor, key, fontChooser, popupMenu));
        popupMenu.add(fontChooser);
        fontPopupButton.setPopupMenu(popupMenu);
        fontPopupButton.setFocusable(false);
        return fontPopupButton;
    }

    public static JButton createFontStyleBoldButton(DrawingEditor editor) {
        return ButtonFactory.createFontStyleBoldButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleBoldButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createFontStyleBoldButton(editor, labels, new LinkedList<Disposable>());
    }

    public static JButton createFontStyleBoldButton(DrawingEditor editor, ResourceBundleUtil labels, List<Disposable> dsp) {
        JButton btn = new JButton();
        labels.configureToolBarButton(btn, "attribute.fontStyle.bold");
        btn.setFocusable(false);
        AttributeToggler<Boolean> a = new AttributeToggler<Boolean>(editor, AttributeKeys.FONT_BOLD, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        a.putValue("undoPresentationName", labels.getString("attribute.fontStyle.bold.text"));
        btn.addActionListener(a);
        return btn;
    }

    public static JButton createFontStyleItalicButton(DrawingEditor editor) {
        return ButtonFactory.createFontStyleItalicButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleItalicButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createFontStyleItalicButton(editor, labels, new LinkedList<Disposable>());
    }

    public static JButton createFontStyleItalicButton(DrawingEditor editor, ResourceBundleUtil labels, List<Disposable> dsp) {
        JButton btn = new JButton();
        labels.configureToolBarButton(btn, "attribute.fontStyle.italic");
        btn.setFocusable(false);
        AttributeToggler<Boolean> a = new AttributeToggler<Boolean>(editor, AttributeKeys.FONT_ITALIC, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        a.putValue("undoPresentationName", labels.getString("attribute.fontStyle.italic.text"));
        btn.addActionListener(a);
        return btn;
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor editor) {
        return ButtonFactory.createFontStyleUnderlineButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createFontStyleUnderlineButton(editor, labels, new LinkedList<Disposable>());
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor editor, ResourceBundleUtil labels, List<Disposable> dsp) {
        JButton btn = new JButton();
        labels.configureToolBarButton(btn, "attribute.fontStyle.underline");
        btn.setFocusable(false);
        AttributeToggler<Boolean> a = new AttributeToggler<Boolean>(editor, AttributeKeys.FONT_UNDERLINE, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        a.putValue("undoPresentationName", labels.getString("attribute.fontStyle.underline.text"));
        btn.addActionListener(a);
        return btn;
    }

    public static void addAlignmentButtonsTo(JToolBar bar, DrawingEditor editor) {
        ButtonFactory.addAlignmentButtonsTo(bar, editor, new LinkedList<Disposable>());
    }

    public static void addAlignmentButtonsTo(JToolBar bar, DrawingEditor editor, List<Disposable> dsp) {
        AbstractSelectedAction d = new AlignAction.West(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new AlignAction.East(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new AlignAction.Horizontal(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new AlignAction.North(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new AlignAction.South(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new AlignAction.Vertical(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        bar.addSeparator();
        d = new MoveAction.West(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new MoveAction.East(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new MoveAction.North(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        d = new MoveAction.South(editor);
        bar.add(d).setFocusable(false);
        dsp.add(d);
        bar.addSeparator();
        bar.add(new BringToFrontAction(editor)).setFocusable(false);
        dsp.add(d);
        bar.add(new SendToBackAction(editor)).setFocusable(false);
        dsp.add(d);
    }

    public static AbstractButton createToggleGridButton(final DrawingView view) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        final JToggleButton toggleButton = new JToggleButton();
        labels.configureToolBarButton(toggleButton, "view.toggleGrid");
        toggleButton.setFocusable(false);
        toggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                view.setConstrainerVisible(toggleButton.isSelected());
            }
        });
        view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "constrainerVisible") {
                    toggleButton.setSelected(view.isConstrainerVisible());
                }
            }
        });
        return toggleButton;
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeCapButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeCapButton(editor, labels, new LinkedList<Disposable>());
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor editor, ResourceBundleUtil labels, List<Disposable> dsp) {
        JPopupButton popupButton = new JPopupButton();
        labels.configureToolBarButton(popupButton, "attribute.strokeCap");
        popupButton.setFocusable(false);
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_CAP, 0);
        AttributeAction a = new AttributeAction(editor, attr, labels.getString("attribute.strokeCap.butt"), null);
        popupButton.add(a);
        dsp.add(a);
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_CAP, 1);
        a = new AttributeAction(editor, attr, labels.getString("attribute.strokeCap.round"), null);
        popupButton.add(a);
        dsp.add(a);
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_CAP, 2);
        a = new AttributeAction(editor, attr, labels.getString("attribute.strokeCap.square"), null);
        popupButton.add(a);
        dsp.add(a);
        return popupButton;
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeJoinButton(editor, ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeJoinButton(editor, labels, new LinkedList<Disposable>());
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor editor, ResourceBundleUtil labels, List<Disposable> dsp) {
        JPopupButton popupButton = new JPopupButton();
        labels.configureToolBarButton(popupButton, "attribute.strokeJoin");
        popupButton.setFocusable(false);
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_JOIN, 2);
        AttributeAction a = new AttributeAction(editor, attr, labels.getString("attribute.strokeJoin.bevel"), null);
        popupButton.add(a);
        dsp.add(a);
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_JOIN, 1);
        a = new AttributeAction(editor, attr, labels.getString("attribute.strokeJoin.round"), null);
        popupButton.add(a);
        dsp.add(a);
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_JOIN, 0);
        a = new AttributeAction(editor, attr, labels.getString("attribute.strokeJoin.miter"), null);
        popupButton.add(a);
        dsp.add(a);
        return popupButton;
    }

    public static JButton createPickAttributesButton(DrawingEditor editor) {
        return ButtonFactory.createPickAttributesButton(editor, new LinkedList<Disposable>());
    }

    public static JButton createPickAttributesButton(DrawingEditor editor, List<Disposable> dsp) {
        PickAttributesAction d = new PickAttributesAction(editor);
        JButton btn = new JButton(d);
        dsp.add(d);
        if (btn.getIcon() != null) {
            btn.putClientProperty("hideActionText", Boolean.TRUE);
        }
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(3);
        btn.setText(null);
        btn.setFocusable(false);
        return btn;
    }

    public static JButton createApplyAttributesButton(DrawingEditor editor) {
        return ButtonFactory.createApplyAttributesButton(editor, new LinkedList<Disposable>());
    }

    public static JButton createApplyAttributesButton(DrawingEditor editor, List<Disposable> dsp) {
        ApplyAttributesAction d = new ApplyAttributesAction(editor);
        JButton btn = new JButton(d);
        dsp.add(d);
        if (btn.getIcon() != null) {
            btn.putClientProperty("hideActionText", Boolean.TRUE);
        }
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(3);
        btn.setText(null);
        btn.setFocusable(false);
        return btn;
    }

    static {
        int b;
        LinkedList<ColorIcon> m = new LinkedList<ColorIcon>();
        m.add(new ColorIcon(0x800000, "Cayenne"));
        m.add(new ColorIcon(0x808000, "Asparagus"));
        m.add(new ColorIcon(32768, "Clover"));
        m.add(new ColorIcon(32896, "Teal"));
        m.add(new ColorIcon(128, "Midnight"));
        m.add(new ColorIcon(0x800080, "Plum"));
        m.add(new ColorIcon(0x7F7F7F, "Tin"));
        m.add(new ColorIcon(0x808080, "Nickel"));
        m.add(new ColorIcon(0xFF0000, "Maraschino"));
        m.add(new ColorIcon(0xFFFF00, "Lemon"));
        m.add(new ColorIcon(65280, "Spring"));
        m.add(new ColorIcon(65535, "Turquoise"));
        m.add(new ColorIcon(255, "Blueberry"));
        m.add(new ColorIcon(0xFF00FF, "Magenta"));
        m.add(new ColorIcon(0x666666, "Steel"));
        m.add(new ColorIcon(0x999999, "Aluminium"));
        m.add(new ColorIcon(0xFF6666, "Salmon"));
        m.add(new ColorIcon(0xFFFF66, "Banana"));
        m.add(new ColorIcon(0x66FF66, "Flora"));
        m.add(new ColorIcon(0x66FFFF, "Ice"));
        m.add(new ColorIcon(0x6666FF, "Orchid"));
        m.add(new ColorIcon(0xFF66FF, "Bubblegum"));
        m.add(new ColorIcon(0x4C4C4C, "Iron"));
        m.add(new ColorIcon(0xB3B3B3, "Magnesium"));
        m.add(new ColorIcon(0x804000, "Mocha"));
        m.add(new ColorIcon(0x408000, "Fern"));
        m.add(new ColorIcon(32832, "Moss"));
        m.add(new ColorIcon(16512, "Ocean"));
        m.add(new ColorIcon(0x400080, "Eggplant"));
        m.add(new ColorIcon(0x800040, "Maroon"));
        m.add(new ColorIcon(0x333333, "Tungsten"));
        m.add(new ColorIcon(0xCCCCCC, "Silver"));
        m.add(new ColorIcon(0xFF8000, "Tangerine"));
        m.add(new ColorIcon(0x80FF00, "Lime"));
        m.add(new ColorIcon(65408, "Sea Foam"));
        m.add(new ColorIcon(33023, "Aqua"));
        m.add(new ColorIcon(0x8000FF, "Grape"));
        m.add(new ColorIcon(0xFF0080, "Strawberry"));
        m.add(new ColorIcon(0x191919, "Lead"));
        m.add(new ColorIcon(0xE6E6E6, "Mercury"));
        m.add(new ColorIcon(0xFFCC66, "Cantaloupe"));
        m.add(new ColorIcon(0xCCFF66, "Honeydew"));
        m.add(new ColorIcon(0x66FFCC, "Spindrift"));
        m.add(new ColorIcon(0x66CCFF, "Sky"));
        m.add(new ColorIcon(0xCC66FF, "Lavender"));
        m.add(new ColorIcon(0xFF6FCF, "Carnation"));
        m.add(new ColorIcon(0, "Licorice"));
        m.add(new ColorIcon(0xFFFFFF, "Snow"));
        DEFAULT_COLORS = Collections.unmodifiableList(m);
        m = new LinkedList();
        for (int b2 = 0; b2 <= 255; b2 += 51) {
            int rgb = b2 << 16 | b2 << 8 | b2;
            m.add(new ColorIcon(rgb));
            for (int r = 0; r <= 102; r += 51) {
                for (int g = 0; g <= 255; g += 51) {
                    rgb = r << 16 | g << 8 | b2;
                    m.add(new ColorIcon(rgb));
                }
            }
        }
        int[] firstColumn = new int[]{0xFF0000, 65280, 255, 0xFF00FF, 65535, 0xFFFF00};
        int b3 = 0;
        int i = 0;
        while (b3 <= 255) {
            int rgb = b3 << 16 | b3 << 8 | b3;
            m.add(new ColorIcon(firstColumn[i]));
            for (int r = 153; r <= 255; r += 51) {
                for (int g = 0; g <= 255; g += 51) {
                    rgb = 0xFF000000 | r << 16 | g << 8 | b3;
                    m.add(new ColorIcon(rgb, "#" + Integer.toHexString(rgb).substring(2)));
                }
            }
            b3 += 51;
            ++i;
        }
        WEBSAVE_COLORS = Collections.unmodifiableList(m);
        ColorSpace grayCS = ColorSpace.getInstance(1003);
        HSBColorSpace hsbCS = HSBColorSpace.getInstance();
        LinkedList<ColorIcon> m2 = new LinkedList<ColorIcon>();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        m2.add(new ColorIcon(new Color(0, true), labels.getToolTipTextProperty("attribute.color.noColor")));
        for (b = 10; b >= 0; --b) {
            Color c = new Color(grayCS, new float[]{(float)b / 10.0f}, 1.0f);
            m2.add(new ColorIcon(c, labels.getFormatted("attribute.color.grayComponents.toolTipText", b * 10)));
        }
        for (int s = 2; s <= 8; s += 2) {
            for (int h = 0; h < 12; ++h) {
                Color c = new Color(hsbCS, new float[]{(float)h / 12.0f, (float)s * 0.1f, 1.0f}, 1.0f);
                m2.add(new ColorIcon(c, labels.getFormatted("attribute.color.hsbComponents.toolTipText", h * 360 / 12, s * 10, 100)));
            }
        }
        for (b = 10; b >= 2; b -= 2) {
            for (int h = 0; h < 12; ++h) {
                Color c = new Color(hsbCS, new float[]{(float)h / 12.0f, 1.0f, (float)b * 0.1f}, 1.0f);
                m2.add(new ColorIcon(new Color(hsbCS, new float[]{(float)h / 12.0f, 1.0f, (float)b * 0.1f}, 1.0f), labels.getFormatted("attribute.color.hsbComponents.toolTipText", h * 360 / 12, 100, b * 10)));
            }
        }
        HSB_COLORS = Collections.unmodifiableList(m2);
        m2 = new LinkedList();
        for (ColorIcon ci : HSB_COLORS) {
            if (ci.getColor() == null) {
                m2.add(new ColorIcon(new Color(0, true), labels.getToolTipTextProperty("attribute.color.noColor")));
                continue;
            }
            Color c = ci.getColor();
            c = c.getColorSpace() == grayCS ? new Color(c.getGreen(), c.getGreen(), c.getGreen(), c.getAlpha()) : new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            m2.add(new ColorIcon(c, labels.getFormatted("attribute.color.rgbComponents.toolTipText", c.getRed(), c.getGreen(), c.getBlue())));
        }
        HSB_COLORS_AS_RGB = Collections.unmodifiableList(m2);
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                this.editor.setTool(this.tool);
            }
        }
    }
}

