/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.gui.JLifeFormattedTextField;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class EditGridPanel
extends JPanel {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    private GridConstrainer constrainer;
    private JLifeFormattedTextField heightField;
    private JLabel heightLabel;
    private JLifeFormattedTextField thetaField;
    private JLabel thetaLabel;
    private JLifeFormattedTextField widthField;
    private JLabel widthLabel;

    public EditGridPanel() {
        this.initComponents();
        this.widthField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
        this.heightField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1000.0, 1.0));
        this.thetaField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 180.0, 1.0));
        this.constrainer = new GridConstrainer(10.0, 10.0);
        this.widthField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    EditGridPanel.this.constrainer.setWidth((Double)evt.getNewValue());
                }
            }
        });
        this.heightField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    EditGridPanel.this.constrainer.setHeight((Double)evt.getNewValue());
                }
            }
        });
        this.thetaField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    EditGridPanel.this.constrainer.setTheta((Double)evt.getNewValue() * Math.PI / 180.0);
                }
            }
        });
    }

    public void setConstrainer(GridConstrainer newValue) {
        this.constrainer = newValue;
        this.widthField.setValue(this.constrainer.getWidth());
        this.heightField.setValue(this.constrainer.getHeight());
        this.thetaField.setValue(this.constrainer.getTheta() * 180.0 / Math.PI);
    }

    public GridConstrainer getConstrainer() {
        return this.constrainer;
    }

    private void initComponents() {
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.widthField = new JLifeFormattedTextField();
        this.heightField = new JLifeFormattedTextField();
        this.thetaLabel = new JLabel();
        this.thetaField = new JLifeFormattedTextField();
        this.widthLabel.setText(this.labels.getString("view.grid.width.text"));
        this.heightLabel.setText(this.labels.getString("view.grid.height.text"));
        this.widthField.setColumns(5);
        this.heightField.setColumns(5);
        this.thetaLabel.setText(this.labels.getString("view.grid.theta.text"));
        this.thetaField.setColumns(5);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heightLabel, GroupLayout.Alignment.TRAILING).addComponent(this.widthLabel, GroupLayout.Alignment.TRAILING).addComponent(this.thetaLabel, GroupLayout.Alignment.TRAILING)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.thetaField, -2, -1, -2).addComponent(this.heightField, -2, -1, -2).addComponent(this.widthField, -2, -1, -2)).addContainerGap(67, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightLabel).addComponent(this.heightField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.thetaLabel).addComponent(this.thetaField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

