/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.export.ProgressWriter;
import bdv.ij.util.ProgressWriterIJ;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.BigWarpInit;
import java.io.File;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import org.janelia.utility.ui.RepeatingReleasedEventsFixer;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Big Warp XML/HDF5")
public class BigWarpBdvCommand
implements Command {
    @Parameter(label="Fixed image file [ xml/hdf5 ]")
    public File fixedImageXml;
    @Parameter(label="Moving image file [ xml/hdf5 ]")
    public File movingImageXml;
    public BigWarp bw;

    public void run() {
        try {
            SpimData fixedSpimData = (SpimData)new XmlIoSpimData().load(this.fixedImageXml.getAbsolutePath());
            SpimData movingSpimData = (SpimData)new XmlIoSpimData().load(this.movingImageXml.getAbsolutePath());
            new RepeatingReleasedEventsFixer().install();
            BigWarpData<?> bigWarpData = BigWarpInit.createBigWarpData(movingSpimData, fixedSpimData);
            this.bw = new BigWarp(bigWarpData, (ProgressWriter)new ProgressWriterIJ());
            this.bw.getViewerFrameP().getViewerPanel().requestRepaint();
            this.bw.getViewerFrameQ().getViewerPanel().requestRepaint();
            this.bw.getLandmarkFrame().repaint();
            this.bw.setMovingSpimData(movingSpimData, this.movingImageXml);
        }
        catch (SpimDataException e) {
            e.printStackTrace();
            return;
        }
    }
}

