/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.BigDataViewer;
import bdv.cache.SharedQueue;
import bdv.img.BwRandomAccessibleIntervalSource;
import bdv.img.RenamableSource;
import bdv.spimdata.SpimDataMinimal;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.RealARGBColorConverterSetup;
import bdv.util.BdvOptions;
import bdv.util.RandomAccessibleIntervalMipmapSource;
import bdv.util.RandomAccessibleIntervalSource;
import bdv.util.VolatileSource;
import bdv.util.volatiles.VolatileTypeMatcher;
import bdv.util.volatiles.VolatileViews;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpData;
import bigwarp.loader.ImagePlusLoader;
import bigwarp.loader.Loader;
import bigwarp.loader.XMLLoader;
import bigwarp.source.SourceInfo;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.plugin.FolderOpener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.display.ScaledARGBConverter;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRandomAccessible;
import net.imglib2.realtransform.Translation;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.util.ValuePair;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.bdv.N5Viewer;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.metadata.N5ViewerMultichannelMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusLegacyMetadataParser;
import org.janelia.saalfeldlab.n5.metadata.imagej.N5ImagePlusMetadata;
import org.janelia.saalfeldlab.n5.ui.DataSelection;
import org.janelia.saalfeldlab.n5.universe.N5DatasetDiscoverer;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMultiScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5GenericSingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5ViewerMultiscaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.canonical.CanonicalMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.OmeNgffMetadataParser;
import org.janelia.saalfeldlab.n5.zarr.N5ZarrReader;

public class BigWarpInit {
    public static final N5MetadataParser<?>[] PARSERS = new N5MetadataParser[]{new N5CosemMetadataParser(), new N5SingleScaleMetadataParser(), new CanonicalMetadataParser(), new ImagePlusLegacyMetadataParser(), new N5GenericSingleScaleMetadataParser()};
    public static final N5MetadataParser<?>[] GROUP_PARSERS = new N5MetadataParser[]{new OmeNgffMetadataParser(), new N5CosemMultiScaleMetadata.CosemMultiScaleParser(), new N5ViewerMultiscaleMetadataParser(), new CanonicalMetadataParser(), new N5ViewerMultichannelMetadata.N5ViewerMultichannelMetadataParser()};

    private static String createSetupName(BasicViewSetup setup) {
        Channel channel;
        if (setup.hasName()) {
            return setup.getName();
        }
        String name = "";
        Angle angle = (Angle)setup.getAttribute(Angle.class);
        if (angle != null) {
            name = name + (name.isEmpty() ? "" : " ") + "a " + angle.getName();
        }
        if ((channel = (Channel)setup.getAttribute(Channel.class)) != null) {
            name = name + (name.isEmpty() ? "" : " ") + "c " + channel.getName();
        }
        return name;
    }

    public static void initSetups(AbstractSpimData<?> spimData, List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources) {
        BigDataViewer.initSetups(spimData, converterSetups, sources);
    }

    public static void initSetup(Source<?> src, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources) {
        Object type = src.getType();
        if (RealType.class.isInstance(type)) {
            BigWarpInit.initSourceReal(src, setupId, converterSetups, sources);
        } else if (ARGBType.class.isInstance(type)) {
            BigWarpInit.initSourceARGB(src, setupId, converterSetups, sources);
        } else {
            throw new IllegalArgumentException("Source of type " + type.getClass() + " no supported.");
        }
    }

    public static void initSourceARGB(Source<ARGBType> src, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources) {
        SourceAndConverter soc = new SourceAndConverter(src, null);
        ValuePair<ScaledARGBConverter.ARGB, ScaledARGBConverter.VolatileARGB> converters = BigWarpInit.initColorConverterARGB();
        ScaledARGBConverter.ARGB converter = (ScaledARGBConverter.ARGB)converters.getA();
        ScaledARGBConverter.VolatileARGB vconverter = (ScaledARGBConverter.VolatileARGB)converters.getB();
        sources.add(soc);
        converterSetups.add((ConverterSetup)new RealARGBColorConverterSetup(setupId, new ColorConverter[]{converter, vconverter}));
    }

    public static <T extends RealType<T>> void initSourceReal(Source<T> src, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources) {
        RealType type = (RealType)src.getType();
        RealARGBColorConverter<RealType> converter = BigWarpInit.initColorConverterReal(type);
        SourceAndConverter soc = new SourceAndConverter(src, converter);
        sources.add(soc);
        converterSetups.add((ConverterSetup)new RealARGBColorConverterSetup(setupId, new ColorConverter[]{converter}));
    }

    private static <T extends RealType<T>> RealARGBColorConverter<T> initColorConverterReal(T type) {
        double typeMin = Math.max(0.0, Math.min(type.getMinValue(), 65535.0));
        double typeMax = Math.max(0.0, Math.min(type.getMaxValue(), 65535.0));
        RealARGBColorConverter converter = RealARGBColorConverter.create(type, (double)typeMin, (double)typeMax);
        converter.setColor(new ARGBType(-1));
        return converter;
    }

    private static ValuePair<ScaledARGBConverter.ARGB, ScaledARGBConverter.VolatileARGB> initColorConverterARGB() {
        ScaledARGBConverter.VolatileARGB vconverter = new ScaledARGBConverter.VolatileARGB(0.0, 255.0);
        ScaledARGBConverter.ARGB converter = new ScaledARGBConverter.ARGB(0.0, 255.0);
        return new ValuePair((Object)converter, (Object)vconverter);
    }

    public static BigWarpData<?> createBigWarpData(AbstractSpimData<?>[] spimDataPList, AbstractSpimData<?>[] spimDataQList) {
        return BigWarpInit.createBigWarpData(spimDataPList, spimDataQList, null);
    }

    public static <T> BigWarpData<?> createBigWarpData(Source<?>[] movingSourceList, Source<?>[] fixedSourceList, String[] names) {
        BigWarpData<T> data = BigWarpInit.initData();
        int setupId = 0;
        for (Source<?> mvgSource : movingSourceList) {
            BigWarpInit.add(data, BigWarpInit.createSources(data, mvgSource, setupId++, true));
        }
        for (Source<?> fxdSource : fixedSourceList) {
            BigWarpInit.add(data, BigWarpInit.createSources(data, fxdSource, setupId++, false));
        }
        ArrayList<SourceAndConverter<?>> wrappedSources = BigWarpInit.wrapSourcesAsRenamable(data.sources, names);
        AtomicInteger sourceInfoIdx = new AtomicInteger();
        data.sources = wrappedSources;
        BigWarpData<T> typedData = data;
        typedData.sourceInfos.forEach((id, info) -> info.setSourceAndConverter(typedData.sources.get(sourceInfoIdx.getAndIncrement())));
        return data;
    }

    @Deprecated
    public static <T> int add(BigWarpData<T> bwdata, ImagePlus ip, int setupId, int numTimepoints, boolean isMoving) {
        LinkedHashMap<Source<T>, SourceInfo> sources = BigWarpInit.createSources(bwdata, ip, setupId, numTimepoints, isMoving);
        BigWarpInit.add(bwdata, sources);
        return sources.size();
    }

    public static <T> LinkedHashMap<Source<T>, SourceInfo> createSources(BigWarpData<T> bwdata, ImagePlus ip, int setupId, int numTimepoints, boolean isMoving) {
        LinkedHashMap<Source<T>, SourceInfo> sourceInfoMap;
        block1: {
            ImagePlusLoader loader = new ImagePlusLoader(ip);
            SpimDataMinimal[] dataList = loader.loadAll(setupId);
            sourceInfoMap = new LinkedHashMap<Source<T>, SourceInfo>();
            for (SpimDataMinimal data : dataList) {
                LinkedHashMap<Source<T>, SourceInfo> map = BigWarpInit.createSources(bwdata, data, setupId, isMoving);
                sourceInfoMap.putAll(map);
                setupId += map.values().stream().map(SourceInfo::getId).max(Integer::compare).orElseGet(() -> 0).intValue();
            }
            sourceInfoMap.forEach((sac, state) -> {
                loader.update((SourceInfo)state);
                state.setUriSupplier(() -> {
                    FileInfo originalFileInfo = ip.getOriginalFileInfo();
                    if (originalFileInfo != null) {
                        String url = originalFileInfo.url;
                        if (url != null && !url.isEmpty()) {
                            return url;
                        }
                        return originalFileInfo.getFilePath();
                    }
                    return null;
                });
            });
            Iterator iterator = sourceInfoMap.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            Map.Entry sourceSourceInfoEntry = (Map.Entry)iterator.next();
            ((SourceInfo)sourceSourceInfoEntry.getValue()).setSerializable(true);
        }
        return sourceInfoMap;
    }

    @Deprecated
    public static <T> BigWarpData<T> add(BigWarpData<T> bwdata, Source<T> src, int setupId, int numTimepoints, boolean isMoving) {
        return BigWarpInit.add(bwdata, BigWarpInit.createSources(bwdata, src, setupId, isMoving));
    }

    public static <T> BigWarpData<T> add(BigWarpData<T> bwdata, Source<T> source, SourceInfo sourceInfo) {
        return BigWarpInit.add(bwdata, source, sourceInfo);
    }

    public static <T> BigWarpData<T> add(BigWarpData<T> bwdata, Source<T> source, SourceInfo sourceInfo, RealTransform transform, Supplier<String> transformUriSupplier) {
        LinkedHashMap<Source<T>, SourceInfo> sourceToInfo = new LinkedHashMap<Source<T>, SourceInfo>();
        sourceToInfo.put(source, sourceInfo);
        return BigWarpInit.add(bwdata, sourceToInfo, transform, transformUriSupplier);
    }

    public static <T> BigWarpData<T> add(BigWarpData<T> bwdata, LinkedHashMap<Source<T>, SourceInfo> sources) {
        BigWarpInit.add(bwdata, sources, null, null);
        return bwdata;
    }

    @Deprecated
    public static <T> BigWarpData<T> add(BigWarpData bwdata, Source<T> src, int setupId, int numTimepoints, boolean isMoving, RealTransform transform) {
        LinkedHashMap<Source<T>, SourceInfo> info = BigWarpInit.createSources(bwdata, src, numTimepoints, isMoving);
        BigWarpInit.add(bwdata, info, transform, null);
        return bwdata;
    }

    public static <T> BigWarpData<T> add(BigWarpData<T> bwdata, LinkedHashMap<Source<T>, SourceInfo> sources, RealTransform transform, Supplier<String> transformUriSupplier) {
        for (Map.Entry<Source<T>, SourceInfo> entry : sources.entrySet()) {
            Source<T> source = entry.getKey();
            SourceInfo info = entry.getValue();
            if (info.getSourceAndConverter() == null) {
                BigWarpInit.addSourceToListsGenericType(source, info.getId(), bwdata.converterSetups, bwdata.sources);
                SourceAndConverter addedSource = bwdata.sources.get(bwdata.sources.size() - 1);
                info.setSourceAndConverter(addedSource);
            }
            if (transform != null) {
                info.setTransform(transform, transformUriSupplier);
            }
            bwdata.sourceInfos.put(info.getId(), info);
        }
        return bwdata;
    }

    public static <T> LinkedHashMap<Source<T>, SourceInfo> createSources(BigWarpData bwdata, Dataset data, int baseId, boolean isMoving) {
        boolean first = true;
        LinkedHashMap<Source<T>, SourceInfo> sourceInfoMap = new LinkedHashMap<Source<T>, SourceInfo>();
        AffineTransform3D res = BigWarpInit.datasetResolution(data);
        long nc = data.getChannels();
        boolean hasZ = false;
        CalibratedAxis[] axes = new CalibratedAxis[data.numDimensions()];
        data.axes((Axis[])axes);
        for (int i = 0; i < data.numDimensions(); ++i) {
            if (!axes[i].type().equals(Axes.Z)) continue;
            hasZ = true;
            break;
        }
        if (nc > 1L) {
            int channelIdx = -1;
            for (int i = 0; i < data.numDimensions(); ++i) {
                if (!axes[i].type().equals(Axes.CHANNEL)) continue;
                channelIdx = i;
                break;
            }
            int c = 0;
            while ((long)c < nc) {
                IntervalView channelRaw = Views.hyperSlice((RandomAccessibleInterval)data, (int)channelIdx, (long)c);
                IntervalView channel = hasZ ? channelRaw : Views.addDimension((RandomAccessibleInterval)channelRaw, (long)0L, (long)0L);
                RandomAccessibleIntervalSource source = new RandomAccessibleIntervalSource((RandomAccessibleInterval)channel, (NumericType)data.getType(), res, data.getName());
                SourceInfo info = new SourceInfo(baseId + c, isMoving, data.getName(), () -> data.getSource());
                info.setSerializable(first);
                if (first) {
                    first = false;
                }
                sourceInfoMap.put((Source<T>)source, info);
                ++c;
            }
        } else {
            Dataset img = hasZ ? data : Views.addDimension((RandomAccessibleInterval)data, (long)0L, (long)0L);
            RandomAccessibleIntervalSource source = new RandomAccessibleIntervalSource((RandomAccessibleInterval)img, (NumericType)data.getType(), res, data.getName());
            SourceInfo info = new SourceInfo(baseId, isMoving, data.getName(), () -> data.getSource());
            info.setSerializable(true);
            sourceInfoMap.put((Source<T>)source, info);
        }
        return sourceInfoMap;
    }

    public static AffineTransform3D datasetResolution(Dataset data) {
        AffineTransform3D affine = new AffineTransform3D();
        CalibratedAxis[] axes = new CalibratedAxis[data.numDimensions()];
        data.axes((Axis[])axes);
        for (int d = 0; d < data.numDimensions(); ++d) {
            if (axes[d].type().equals(Axes.X)) {
                affine.set(axes[d].calibratedValue(1.0), 0, 0);
                continue;
            }
            if (axes[d].type().equals(Axes.Y)) {
                affine.set(axes[d].calibratedValue(1.0), 1, 1);
                continue;
            }
            if (!axes[d].type().equals(Axes.Z)) continue;
            affine.set(axes[d].calibratedValue(1.0), 2, 2);
        }
        return affine;
    }

    public static <T> LinkedHashMap<Source<T>, SourceInfo> createSources(BigWarpData bwdata, AbstractSpimData<?> data, int baseId, boolean isMoving) {
        ArrayList tmpSources = new ArrayList();
        ArrayList<ConverterSetup> tmpConverterSetups = new ArrayList<ConverterSetup>();
        BigWarpInit.initSetups(data, tmpConverterSetups, tmpSources);
        LinkedHashMap<Source<T>, SourceInfo> sourceInfoMap = new LinkedHashMap<Source<T>, SourceInfo>();
        int setupId = baseId;
        for (SourceAndConverter sourceAndConverter : tmpSources) {
            Source source = sourceAndConverter.getSpimSource();
            sourceInfoMap.put(source, new SourceInfo(setupId++, isMoving, source.getName()));
        }
        return sourceInfoMap;
    }

    public static <T> LinkedHashMap<Source<T>, SourceInfo> createSources(BigWarpData<?> bwdata, Source<T> src, int baseId, boolean isMoving) {
        LinkedHashMap<Source<T>, SourceInfo> sourceInfoMap = new LinkedHashMap<Source<T>, SourceInfo>();
        sourceInfoMap.put(src, new SourceInfo(baseId, isMoving, src.getName()));
        return sourceInfoMap;
    }

    private static String schemeSpecificPartWithoutQuery(URI uri) {
        return uri.getSchemeSpecificPart().replaceAll("\\?" + uri.getQuery(), "").replaceAll("//", "");
    }

    public static <T> LinkedHashMap<Source<T>, SourceInfo> createSources(BigWarpData<T> bwData, String uri, int setupId, boolean isMoving) throws URISyntaxException, IOException, SpimDataException {
        LinkedHashMap<Source<T>, SourceInfo> sourceStateMap;
        block21: {
            N5URI n5URL;
            SharedQueue sharedQueue = BigWarpData.getSharedQueue();
            URI encodedUri = N5URI.encodeAsUri((String)uri.trim());
            sourceStateMap = new LinkedHashMap<Source<T>, SourceInfo>();
            if (encodedUri.isOpaque()) {
                N5ZarrReader n5reader;
                n5URL = new N5URI(encodedUri.getSchemeSpecificPart());
                String firstScheme = encodedUri.getScheme().toLowerCase();
                switch (firstScheme.toLowerCase()) {
                    case "n5": {
                        n5reader = new N5Factory().openReader(n5URL.getContainerPath());
                        break;
                    }
                    case "zarr": {
                        n5reader = new N5ZarrReader(n5URL.getContainerPath());
                        break;
                    }
                    case "h5": 
                    case "hdf5": 
                    case "hdf": {
                        n5reader = new N5HDF5Reader(n5URL.getContainerPath(), new int[0]);
                        break;
                    }
                    default: {
                        throw new URISyntaxException(firstScheme, "Unsupported Top Level Protocol");
                    }
                }
                SourceInfo info = BigWarpInit.loadN5SourceInfo(bwData, (N5Reader)n5reader, n5URL.getGroupPath(), sharedQueue, setupId, isMoving);
                sourceStateMap.put(info.getSourceAndConverter().getSpimSource(), info);
            } else {
                n5URL = new N5URI(encodedUri);
                try {
                    String containerWithoutN5Scheme = n5URL.getContainerPath().replaceFirst("^n5://", "");
                    N5Reader n5reader = new N5Factory().openReader(containerWithoutN5Scheme);
                    SourceInfo info = BigWarpInit.loadN5SourceInfo(bwData, n5reader, n5URL.getGroupPath(), sharedQueue, setupId, isMoving);
                    sourceStateMap.put(info.getSourceAndConverter().getSpimSource(), info);
                }
                catch (Exception containerWithoutN5Scheme) {
                    // empty catch block
                }
                if (sourceStateMap.isEmpty()) {
                    String containerPath = n5URL.getContainerPath();
                    if (containerPath.trim().toLowerCase().endsWith(".xml")) {
                        sourceStateMap.putAll(BigWarpInit.createSources(bwData, isMoving, setupId, containerPath, n5URL.getGroupPath()));
                    } else {
                        ImagePlus ijp;
                        if (Objects.equals(encodedUri.getScheme(), "imagej")) {
                            String title = n5URL.getContainerPath().replaceAll("^imagej:(///|//)", "");
                            IJ.selectWindow((String)title);
                            ijp = IJ.getImage();
                        } else {
                            ijp = new File(uri).isDirectory() ? FolderOpener.open((String)uri) : IJ.openImage((String)uri.trim());
                        }
                        sourceStateMap.putAll(BigWarpInit.createSources(bwData, ijp, setupId, 0, isMoving));
                    }
                }
            }
            sourceStateMap.forEach((source, state) -> state.setUriSupplier(() -> uri));
            Iterator iterator = sourceStateMap.entrySet().iterator();
            if (!iterator.hasNext()) break block21;
            Map.Entry sourceSourceInfoEntry = iterator.next();
            ((SourceInfo)sourceSourceInfoEntry.getValue()).setSerializable(true);
        }
        return sourceStateMap;
    }

    @Deprecated
    public static <T> SpimData addToData(BigWarpData<T> bwdata, boolean isMoving, int setupId, String rootPath, String dataset) {
        AtomicReference<SpimData> returnMovingSpimData = new AtomicReference<SpimData>();
        LinkedHashMap<Source<T>, SourceInfo> sources = BigWarpInit.createSources(bwdata, isMoving, setupId, rootPath, dataset, returnMovingSpimData);
        BigWarpInit.add(bwdata, sources);
        return returnMovingSpimData.get();
    }

    public static <T> Map<Source<T>, SourceInfo> createSources(BigWarpData<T> bwdata, boolean isMoving, int setupId, String rootPath, String dataset) {
        return BigWarpInit.createSources(bwdata, isMoving, setupId, rootPath, dataset, null);
    }

    private static <T> LinkedHashMap<Source<T>, SourceInfo> createSources(BigWarpData<T> bwdata, boolean isMoving, int setupId, String rootPath, String dataset, AtomicReference<SpimData> returnMovingSpimData) {
        SharedQueue sharedQueue = new SharedQueue(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
        if (rootPath.endsWith("xml")) {
            try {
                SpimData spimData = (SpimData)new XmlIoSpimData().load(rootPath);
                if (returnMovingSpimData != null && isMoving) {
                    returnMovingSpimData.set(spimData);
                }
                LinkedHashMap<Source<T>, SourceInfo> sources = BigWarpInit.createSources(bwdata, spimData, setupId, isMoving);
                sources.forEach((source, state) -> state.setUriSupplier(() -> {
                    try {
                        return spimData.getBasePath().getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }));
                Iterator<Map.Entry<Source<T>, SourceInfo>> iterator = sources.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<Source<T>, SourceInfo> sourceSourceInfoEntry = iterator.next();
                    sourceSourceInfoEntry.getValue().setSerializable(true);
                }
                return sources;
            }
            catch (SpimDataException e) {
                e.printStackTrace();
                return null;
            }
        }
        return BigWarpInit.makeMap(BigWarpInit.loadN5SourceInfo(bwdata, rootPath, dataset, sharedQueue, setupId, isMoving));
    }

    private static <T> LinkedHashMap<Source<T>, SourceInfo> makeMap(SourceInfo info) {
        LinkedHashMap<Source<T>, SourceInfo> map = new LinkedHashMap<Source<T>, SourceInfo>();
        info.setSerializable(true);
        map.put(info.getSourceAndConverter().getSpimSource(), info);
        return map;
    }

    public static <T extends NativeType<T>> SourceInfo loadN5SourceInfo(BigWarpData<?> bwData, String n5Root, String n5Dataset, SharedQueue queue, int sourceId, boolean moving) {
        N5Reader n5;
        try {
            n5 = new N5Factory().openReader(n5Root);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
        return BigWarpInit.loadN5SourceInfo(bwData, n5, n5Dataset, queue, sourceId, moving);
    }

    public static <T extends NativeType<T>> SourceInfo loadN5SourceInfo(BigWarpData<?> bwData, N5Reader n5, String n5Dataset, SharedQueue queue, int sourceId, boolean moving) {
        N5Metadata meta = null;
        try {
            N5DatasetDiscoverer discoverer = new N5DatasetDiscoverer(n5, N5DatasetDiscoverer.fromParsers(PARSERS), N5DatasetDiscoverer.fromParsers(GROUP_PARSERS));
            N5TreeNode node = discoverer.discoverAndParseRecursive("");
            meta = node.getDescendant(n5Dataset).map(N5TreeNode::getMetadata).orElse(null);
        }
        catch (IOException discoverer) {
            // empty catch block
        }
        SourceAndConverter<T> sac = BigWarpInit.openN5VSourceAndConverter(bwData, n5, meta, queue);
        if (bwData != null) {
            bwData.sources.add(sac);
            bwData.converterSetups.add(BigDataViewer.createConverterSetup(sac, (int)sourceId));
        }
        String uri = n5.getURI().toString() + "$" + n5Dataset;
        SourceInfo info = new SourceInfo(sourceId, moving, sac.getSpimSource().getName(), () -> uri);
        info.setSourceAndConverter(sac);
        return info;
    }

    @Deprecated
    public static <T extends NativeType<T>> Source<T> loadN5Source(String n5Root, String n5Dataset, SharedQueue queue) {
        N5Reader n5;
        try {
            n5 = new N5Factory().openReader(n5Root);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
        return BigWarpInit.loadN5Source(n5, n5Dataset, queue);
    }

    @Deprecated
    public static <T extends NativeType<T>> Source<T> loadN5Source(N5Reader n5, String n5Dataset, SharedQueue queue) {
        N5Metadata meta = null;
        try {
            N5DatasetDiscoverer discoverer = new N5DatasetDiscoverer(n5, N5DatasetDiscoverer.fromParsers(PARSERS), N5DatasetDiscoverer.fromParsers(GROUP_PARSERS));
            N5TreeNode node = discoverer.discoverAndParseRecursive("");
            meta = node.getDescendant(n5Dataset).map(N5TreeNode::getMetadata).orElse(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (meta instanceof MultiscaleMetadata) {
            return BigWarpInit.openN5V(n5, (MultiscaleMetadata)meta, queue);
        }
        return BigWarpInit.openAsSource(n5, meta, queue, true);
    }

    public static <T extends NativeType<T>, M extends N5Metadata> Source<T> openAsSource(N5Reader n5, M meta, SharedQueue sharedQueue, boolean isVolatile) {
        if (meta == null) {
            return null;
        }
        try {
            RandomAccessibleInterval<?> imageRaw;
            if (isVolatile) {
                CachedCellImg rai = N5Utils.openVolatile((N5Reader)n5, (String)meta.getPath());
                imageRaw = BigWarpInit.to3d(rai);
            } else {
                imageRaw = BigWarpInit.to3d(N5Utils.open((N5Reader)n5, (String)meta.getPath()));
            }
            Object image = meta instanceof N5ImagePlusMetadata && ((N5ImagePlusMetadata)meta).getType() == 4 && imageRaw.getType() instanceof UnsignedIntType ? BigWarpInit.toColor(imageRaw) : imageRaw;
            if (meta instanceof SpatialMetadata) {
                String unit = ((SpatialMetadata)meta).unit();
                AffineTransform3D srcXfm = ((SpatialMetadata)meta).spatialTransform3d();
                FinalVoxelDimensions voxelDims = new FinalVoxelDimensions(unit, new double[]{srcXfm.get(0, 0), srcXfm.get(1, 1), srcXfm.get(2, 2)});
                return new BwRandomAccessibleIntervalSource<NumericType>((RandomAccessibleInterval<NumericType>)image, (NumericType)image.getType(), srcXfm, meta.getPath(), (VoxelDimensions)voxelDims);
            }
            return new BwRandomAccessibleIntervalSource<NumericType>((RandomAccessibleInterval<NumericType>)image, (NumericType)image.getType(), new AffineTransform3D(), meta.getPath());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static <T extends NativeType<T> & NumericType<T>> Source<T> openN5V(N5Reader n5, MultiscaleMetadata<?> multiMeta, SharedQueue sharedQueue) {
        return BigWarpInit.openN5VSourceAndConverter(null, n5, multiMeta, sharedQueue).getSpimSource();
    }

    public static <T extends NativeType<T> & NumericType<T>> SourceAndConverter<T> openN5VSourceAndConverter(BigWarpData<?> bwData, N5Reader n5, N5Metadata multiMeta, SharedQueue sharedQueue) {
        ArrayList sources = new ArrayList();
        ArrayList converterSetups = new ArrayList();
        try {
            N5Viewer.buildN5Sources((N5Reader)n5, (DataSelection)new DataSelection(n5, Collections.singletonList(multiMeta)), (SharedQueue)sharedQueue, converterSetups, sources, (BdvOptions)BdvOptions.options());
            if (sources.size() > 0) {
                return (SourceAndConverter)sources.get(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static <T extends NumericType<T> & NativeType<T>> Source<T> openAsSourceMulti(N5Reader n5, MultiscaleMetadata<?> multiMeta, SharedQueue sharedQueue, boolean isVolatile) {
        String[] paths = multiMeta.getPaths();
        AffineTransform3D[] transforms = multiMeta.spatialTransforms3d();
        String unit = multiMeta.units()[0];
        RandomAccessibleInterval[] images = new RandomAccessibleInterval[paths.length];
        double[][] mipmapScales = new double[images.length][3];
        CacheHints cacheHints = new CacheHints(LoadingStrategy.VOLATILE, 0, true);
        for (int s = 0; s < images.length; ++s) {
            try {
                if (isVolatile) {
                    CachedCellImg rai = N5Utils.openVolatile((N5Reader)n5, (String)paths[s]);
                    images[s] = BigWarpInit.to3d(VolatileViews.wrapAsVolatile((RandomAccessibleInterval)rai, (SharedQueue)sharedQueue, (CacheHints)cacheHints));
                } else {
                    images[s] = BigWarpInit.to3d(N5Utils.open((N5Reader)n5, (String)paths[s]));
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            mipmapScales[s][0] = transforms[s].get(0, 0);
            mipmapScales[s][1] = transforms[s].get(1, 1);
            mipmapScales[s][2] = transforms[s].get(2, 2);
        }
        return new RandomAccessibleIntervalMipmapSource(images, (NumericType)images[0].getType(), mipmapScales, (VoxelDimensions)new FinalVoxelDimensions(unit, mipmapScales[0]), new AffineTransform3D(), multiMeta.getPaths()[0] + "_group");
    }

    private static RandomAccessibleInterval<?> to3d(RandomAccessibleInterval<?> img) {
        if (img.numDimensions() == 2) {
            return Views.addDimension(img, (long)0L, (long)0L);
        }
        return img;
    }

    private static RandomAccessibleInterval<ARGBType> toColor(RandomAccessibleInterval<UnsignedIntType> img) {
        return Converters.convertRAI(img, (Converter)new Converter<UnsignedIntType, ARGBType>(){

            public void convert(UnsignedIntType input, ARGBType output) {
                output.set(input.getInt());
            }
        }, (Type)new ARGBType());
    }

    public static <T> BigWarpData<T> initData() {
        return new BigWarpData();
    }

    private static <T> void addSourceToListsGenericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        Object type = source.getType();
        if (!(type instanceof RealType || type instanceof ARGBType || type instanceof VolatileARGBType)) {
            throw new IllegalArgumentException("Unknown source type. Expected RealType, ARGBType, or VolatileARGBType");
        }
        BigWarpInit.addSourceToListsNumericType(source, setupId, converterSetups, sources);
    }

    private static <T extends NumericType<T>> void addSourceToListsNumericType(Source<T> source, int setupId, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        NumericType type = (NumericType)source.getType();
        SourceAndConverter soc = BigDataViewer.wrapWithTransformedSource((SourceAndConverter)new SourceAndConverter(source, BigDataViewer.createConverterToARGB((NumericType)type)));
        converterSetups.add(BigDataViewer.createConverterSetup((SourceAndConverter)soc, (int)setupId));
        sources.add(soc);
    }

    public static BigWarpData<?> createBigWarpData(AbstractSpimData<?>[] spimDataPList, AbstractSpimData<?>[] spimDataQList, String[] names) {
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        int numMovingSources = 0;
        for (AbstractSpimData<?> spimDataP : spimDataPList) {
            numMovingSources += spimDataP.getSequenceDescription().getViewSetups().size();
            BigDataViewer.initSetups(spimDataP, converterSetups, sources);
        }
        int numTargetSources = 0;
        for (AbstractSpimData<?> spimDataQ : spimDataQList) {
            numTargetSources += spimDataQ.getSequenceDescription().getViewSetups().size();
            BigDataViewer.initSetups(spimDataQ, converterSetups, sources);
        }
        int[] movingSourceIndices = ImagePlusLoader.range(0, numMovingSources);
        int[] targetSourceIndices = ImagePlusLoader.range(numMovingSources, numTargetSources);
        if (names != null && names.length == sources.size()) {
            return new BigWarpData(BigWarpInit.wrapSourcesAsRenamable(sources, names), converterSetups, null, movingSourceIndices, targetSourceIndices);
        }
        return new BigWarpData(sources, converterSetups, null, movingSourceIndices, targetSourceIndices);
    }

    public static ArrayList<SourceAndConverter<?>> wrapSourcesAsRenamable(List<SourceAndConverter<?>> sources, String[] names) {
        ArrayList wrappedSource = new ArrayList();
        int i = 0;
        for (SourceAndConverter<?> sac : sources) {
            SourceAndConverter<?> renamableSource = BigWarpInit.wrapSourceAsRenamable(sac);
            if (names != null) {
                ((RenamableSource)renamableSource.getSpimSource()).setName(names[i]);
            }
            wrappedSource.add(renamableSource);
            ++i;
        }
        return wrappedSource;
    }

    private static <T> SourceAndConverter<T> wrapSourceAsRenamable(SourceAndConverter<T> src) {
        if (src.asVolatile() == null) {
            return new SourceAndConverter(new RenamableSource(src.getSpimSource()), src.getConverter(), null);
        }
        return new SourceAndConverter(new RenamableSource(src.getSpimSource()), src.getConverter(), src.asVolatile());
    }

    public static <T extends NumericType<T> & NativeType<T>, V extends Volatile<T>> SourceAndConverter<T> cacheTransformedSource(BigWarpData data, int index, SourceAndConverter<T> sac, InvertibleRealTransform transform, SharedQueue sharedQueue) {
        SourceInfo info = data.getSourceInfo(sac);
        Source src = sac.getSpimSource();
        int setupId = info.getId();
        int nd = src.getSource(0, 0).numDimensions();
        int N = src.getNumMipmapLevels();
        NumericType type = (NumericType)src.getType();
        Volatile vtype = (Volatile)VolatileTypeMatcher.getVolatileTypeForType((NativeType)((NativeType)type));
        int[] defaultCellDimensions = new int[nd];
        Arrays.fill(defaultCellDimensions, 64);
        RandomAccessibleInterval[] mipmaps = new RandomAccessibleInterval[N];
        RandomAccessibleInterval[] vmipmaps = new RandomAccessibleInterval[N];
        AffineTransform3D[] sourceTransforms = new AffineTransform3D[N];
        for (int i = 0; i < src.getNumMipmapLevels(); ++i) {
            RandomAccessibleInterval img = src.getSource(0, i);
            AffineTransform3D origScaleTform = new AffineTransform3D();
            src.getSourceTransform(0, i, origScaleTform);
            InvertibleRealTransformSequence tformToPhysicalSpace = new InvertibleRealTransformSequence();
            tformToPhysicalSpace.add((RealTransform)origScaleTform);
            tformToPhysicalSpace.add((RealTransform)transform.copy());
            tformToPhysicalSpace.add((RealTransform)origScaleTform.inverse());
            BoundingBoxEstimation bbox = new BoundingBoxEstimation();
            RealInterval targetInterval = bbox.estimateInterval((RealTransform)tformToPhysicalSpace.inverse(), (RealInterval)img);
            FinalInterval pixelInterval = BoundingBoxEstimation.containingInterval(targetInterval);
            AffineTransform3D newSourceTform = origScaleTform.copy();
            Translation tlation = new Translation(targetInterval.minAsDoubleArray());
            newSourceTform.concatenate((AffineGet)tlation);
            sourceTransforms[i] = newSourceTform;
            InvertibleRealTransformSequence tformToPixelSpace = new InvertibleRealTransformSequence();
            tformToPixelSpace.add((RealTransform)newSourceTform);
            tformToPixelSpace.add((RealTransform)transform.copy());
            tformToPixelSpace.add((RealTransform)origScaleTform.inverse());
            final RandomAccessibleInterval<T> raiTform = BigWarpInit.transform(img, (Interval)pixelInterval, (RealTransform)tformToPixelSpace);
            ReadOnlyCachedCellImgFactory cacheFactory = new ReadOnlyCachedCellImgFactory((ReadOnlyCachedCellImgOptions)((ReadOnlyCachedCellImgOptions)new ReadOnlyCachedCellImgOptions().volatileAccesses(true)).cellDimensions(BigWarpInit.getCellDimensionsOrDefault(img, defaultCellDimensions)));
            CellLoader copier = new CellLoader<T>(){

                public void load(SingleCellArrayImg<T, ?> cell) throws Exception {
                    Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.pair((RandomAccessible)raiTform, cell), cell)).forEach(pair -> ((NumericType)pair.getB()).set((Type)pair.getA()));
                }
            };
            CachedCellImg cachedTransformedMipmap = cacheFactory.create(raiTform.dimensionsAsLongArray(), (NativeType)type.copy(), copier);
            mipmaps[i] = cachedTransformedMipmap;
            int priority = N - 1 - i;
            CacheHints cacheHints = new CacheHints(LoadingStrategy.BUDGETED, priority, false);
            vmipmaps[i] = VolatileViews.wrapAsVolatile((RandomAccessibleInterval)cachedTransformedMipmap, (SharedQueue)sharedQueue, (CacheHints)cacheHints);
        }
        RandomAccessibleIntervalMipmapSource cachedTransformedSource = new RandomAccessibleIntervalMipmapSource(mipmaps, type, sourceTransforms, src.getVoxelDimensions(), src.getName() + " (cached transform)", src.doBoundingBoxCulling());
        VolatileSource vsrc = new VolatileSource((Source)cachedTransformedSource, vtype, sharedQueue);
        SourceAndConverter vsac = new SourceAndConverter((Source)vsrc, BigDataViewer.createConverterToARGB((NumericType)((NumericType)vtype)));
        SourceAndConverter tsac = new SourceAndConverter((Source)cachedTransformedSource, BigDataViewer.createConverterToARGB((NumericType)type), vsac);
        ConverterSetup converterSetup = BigDataViewer.createConverterSetup((SourceAndConverter)tsac, (int)setupId);
        data.converterSetups.set(index, converterSetup);
        return tsac;
    }

    private static int[] getCellDimensionsOrDefault(RandomAccessibleInterval<?> img, int[] defaultDimensions) {
        if (img instanceof AbstractCellImg) {
            return ((AbstractCellImg)img).getCellGrid().getCellDimensions();
        }
        return defaultDimensions;
    }

    private static <T extends NumericType<T> & NativeType<T>> RandomAccessibleInterval<T> transform(RandomAccessibleInterval<T> img, Interval targetInterval, RealTransform transform) {
        NumericType background = (NumericType)((NumericType)img.getType()).copy();
        background.setZero();
        return Views.interval((RandomAccessible)new RealTransformRandomAccessible(Views.interpolate((EuclideanSpace)new ExtendedRandomAccessibleInterval(img, (OutOfBoundsFactory)new OutOfBoundsConstantValueFactory((Object)background)), (InterpolatorFactory)new ClampingNLinearInterpolatorFactory()), transform), (Interval)targetInterval);
    }

    public static BigWarpData<?> createBigWarpData(AbstractSpimData<?> spimDataP, AbstractSpimData<?> spimDataQ) {
        AbstractSequenceDescription seqP = spimDataP.getSequenceDescription();
        AbstractSequenceDescription seqQ = spimDataQ.getSequenceDescription();
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        BigWarpInit.initSetups(spimDataP, converterSetups, sources);
        int numMovingSources = seqP.getViewSetups().size();
        int numTargetSources = seqQ.getViewSetups().size();
        int[] movingSourceIndices = ImagePlusLoader.range(0, numMovingSources);
        int[] targetSourceIndices = ImagePlusLoader.range(numMovingSources, numTargetSources);
        BigWarpInit.initSetups(spimDataQ, converterSetups, sources);
        return new BigWarpData(sources, converterSetups, null, movingSourceIndices, targetSourceIndices);
    }

    public static BigWarpData<?> createBigWarpData(ImagePlusLoader loaderP, ImagePlusLoader loaderQ) {
        return BigWarpInit.createBigWarpData(loaderP, loaderQ, null);
    }

    public static BigWarpData<?> createBigWarpData(ImagePlusLoader loaderP, ImagePlusLoader loaderQ, String[] names) {
        SpimDataMinimal[] spimDataP = loaderP.loadAll(0);
        int numMovingChannels = loaderP.numChannels();
        SpimDataMinimal[] spimDataQ = loaderQ.loadAll(numMovingChannels);
        BigWarpData<?> data = BigWarpInit.createBigWarpData(spimDataP, spimDataQ, names);
        loaderP.update(data);
        loaderQ.update(data);
        return data;
    }

    public static BigWarpData<?> createBigWarpData(Loader loaderP, Loader loaderQ) {
        return BigWarpInit.createBigWarpData(loaderP, loaderQ, null);
    }

    public static BigWarpData<?> createBigWarpData(Loader loaderP, Loader loaderQ, String[] namesIn) {
        String[] names;
        AbstractSpimData<S>[] spimDataP = loaderP instanceof ImagePlusLoader ? loaderP.load() : loaderP.load();
        Object[] spimDataQ = loaderQ instanceof ImagePlusLoader ? ((ImagePlusLoader)loaderQ).loadAll(spimDataP.length) : loaderQ.load();
        int N = loaderP.numSources() + loaderQ.numSources();
        if (namesIn == null || namesIn.length != N) {
            int i;
            names = new String[N];
            int j = 0;
            for (i = 0; i < loaderP.numSources(); ++i) {
                names[j++] = loaderP.name(i);
            }
            for (i = 0; i < loaderQ.numSources(); ++i) {
                names[j++] = loaderQ.name(i);
            }
        } else {
            names = namesIn;
        }
        BigWarpData<?> data = BigWarpInit.createBigWarpData(spimDataP, spimDataQ, names);
        if (loaderP instanceof ImagePlusLoader) {
            ((ImagePlusLoader)loaderP).update(data);
        }
        if (loaderQ instanceof ImagePlusLoader) {
            ((ImagePlusLoader)loaderQ).update(data);
        }
        return data;
    }

    public static <T extends NativeType<T>> BigWarpData<T> createBigWarpDataFromXML(String xmlFilenameP, String xmlFilenameQ) {
        BigWarpData<T> bwdata = BigWarpInit.initData();
        try {
            int id = 0;
            LinkedHashMap<Source<T>, SourceInfo> mvgSrcs = BigWarpInit.createSources(bwdata, xmlFilenameP, id, true);
            BigWarpInit.add(bwdata, mvgSrcs);
            BigWarpInit.add(bwdata, BigWarpInit.createSources(bwdata, xmlFilenameQ, id += mvgSrcs.size(), false));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        return bwdata;
    }

    public static <T> BigWarpData<T> createBigWarpDataFromImages(ImagePlus impP, ImagePlus impQ) {
        int id = 0;
        BigWarpData<T> bwdata = BigWarpInit.initData();
        LinkedHashMap<Source<T>, SourceInfo> mvgSrcs = BigWarpInit.createSources(bwdata, impP, id, 0, true);
        id += mvgSrcs.size();
        BigWarpInit.add(bwdata, mvgSrcs);
        if (impQ != null) {
            BigWarpInit.add(bwdata, BigWarpInit.createSources(bwdata, impQ, id, 0, false));
        }
        return bwdata;
    }

    public static BigWarpData<?> createBigWarpDataFromImages(ImagePlus[] impP, ImagePlus[] impQ) {
        return BigWarpInit.createBigWarpData(new ImagePlusLoader(impP), new ImagePlusLoader(impQ));
    }

    public static BigWarpData<?> createBigWarpDataFromImages(ImagePlus impP, ImagePlus[] impQ) {
        return BigWarpInit.createBigWarpData(new ImagePlusLoader(impP), new ImagePlusLoader(impQ));
    }

    public static BigWarpData<?> createBigWarpDataFromImages(ImagePlus[] impP, ImagePlus impQ) {
        return BigWarpInit.createBigWarpData(new ImagePlusLoader(impP), new ImagePlusLoader(impQ));
    }

    public static <T extends NativeType<T>> BigWarpData<T> createBigWarpDataFromXMLImagePlus(String xmlFilenameP, ImagePlus impQ) {
        BigWarpData<T> bwdata = BigWarpInit.initData();
        try {
            int id = 0;
            LinkedHashMap<Source<T>, SourceInfo> mvgSrcs = BigWarpInit.createSources(bwdata, xmlFilenameP, id, true);
            BigWarpInit.add(bwdata, mvgSrcs);
            BigWarpInit.add(bwdata, BigWarpInit.createSources(bwdata, impQ, id += mvgSrcs.size(), 0, false));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        return bwdata;
    }

    public static BigWarpData<?> createBigWarpDataFromXMLImagePlus(String xmlFilenameP, ImagePlus[] impQ) {
        return BigWarpInit.createBigWarpData(new XMLLoader(xmlFilenameP), (Loader)new ImagePlusLoader(impQ));
    }

    public static <T extends NativeType<T>> BigWarpData<T> createBigWarpDataFromImagePlusXML(ImagePlus impP, String xmlFilenameQ) {
        BigWarpData<T> bwdata = BigWarpInit.initData();
        try {
            int id = 0;
            LinkedHashMap<Source<T>, SourceInfo> mvgSrcs = BigWarpInit.createSources(bwdata, impP, id, 0, true);
            BigWarpInit.add(bwdata, mvgSrcs);
            BigWarpInit.add(bwdata, BigWarpInit.createSources(bwdata, xmlFilenameQ, id += mvgSrcs.size(), false));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        return bwdata;
    }

    public static BigWarpData<?> createBigWarpDataFromImagePlusXML(ImagePlus[] impP, String xmlFilenameQ) {
        return BigWarpInit.createBigWarpData((Loader)new ImagePlusLoader(impP), new XMLLoader(xmlFilenameQ));
    }

    public static String[] namesFromImagePluses(ImagePlus impP, ImagePlus impQ) {
        String[] names = new String[impP.getNChannels() + impQ.getNChannels()];
        String[] impPnames = BigWarpInit.namesFromImagePlus(impP);
        String[] impQnames = BigWarpInit.namesFromImagePlus(impQ);
        int i = 0;
        for (String name : impPnames) {
            names[i++] = name;
        }
        for (String name : impQnames) {
            names[i++] = name;
        }
        return names;
    }

    public static String[] namesFromImagePlus(ImagePlus imp) {
        if (imp.getNChannels() == 1) {
            return new String[]{imp.getTitle()};
        }
        String[] names = new String[imp.getNChannels()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = imp.getTitle() + "-" + i;
        }
        return names;
    }
}

