/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.viewer.Source;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.RealTransform;

public class FieldOfView {
    public static RealInterval getPhysicaInterval(Source<?> source) {
        AffineTransform3D tform = new AffineTransform3D();
        return BoundingBoxEstimation.corners((RealTransform)tform, (Interval)source.getSource(0, 0));
    }

    public static RealInterval fromMinSize(double[] min, double[] size) {
        int nd = size.length;
        double[] max = new double[nd];
        for (int i = 0; i < nd; ++i) {
            max[i] = min[i] + size[i];
        }
        return new FinalRealInterval(min, max);
    }

    public static RealInterval fromPixelMinSize(double[] minPixel, double[] sizePixel, double[] resolution) {
        int nd = sizePixel.length;
        double[] min = new double[nd];
        double[] max = new double[nd];
        for (int i = 0; i < nd; ++i) {
            min[i] = resolution[i] * min[i];
            max[i] = resolution[i] * (min[i] + sizePixel[i]);
        }
        return new FinalRealInterval(min, max);
    }

    public static RealInterval computeInterval(double[] resolution, double[] offset, long[] dimensions) {
        int nd = resolution.length;
        double[] max = new double[resolution.length];
        for (int i = 0; i < nd; ++i) {
            max[i] = offset[i] + resolution[i] * (double)dimensions[i];
        }
        return new FinalRealInterval(offset, max);
    }

    public static RealInterval expand(RealInterval interval, double ... amounts) {
        int nd = interval.numDimensions();
        double[] min = new double[nd];
        double[] max = new double[nd];
        for (int i = 0; i < nd; ++i) {
            min[i] = interval.realMin(i) - amounts[i];
            max[i] = interval.realMax(i) + amounts[i];
        }
        return new FinalRealInterval(min, max);
    }
}

