/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import bdv.viewer.animate.AbstractTransformAnimator;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RotationTransformInterpolator;
import net.imglib2.realtransform.SimilarityTransformInterpolator;
import net.imglib2.type.numeric.RealType;

public class MaskedSimilarityTransform<T extends RealType<T>>
implements RealTransform {
    private final RealRandomAccessible<T> lambda;
    private RealRandomAccess<T> lambdaAccess;
    private final AffineTransform3D transform;
    private final AbstractTransformAnimator interpolator;
    private final double[] c;

    public MaskedSimilarityTransform(AffineTransform3D transform, RealRandomAccessible<T> lambda) {
        this(transform, lambda, new double[3], Interpolators.SIMILARITY);
    }

    public MaskedSimilarityTransform(AffineTransform3D transform, RealRandomAccessible<T> lambda, boolean flip) {
        this(transform, lambda, new double[3], Interpolators.SIMILARITY);
    }

    public MaskedSimilarityTransform(AffineTransform3D transform, RealRandomAccessible<T> lambda, double[] c) {
        this(transform, lambda, c, Interpolators.SIMILARITY);
    }

    public MaskedSimilarityTransform(AffineTransform3D transform, RealRandomAccessible<T> lambda, Interpolators interp) {
        this(transform, lambda, new double[3], interp);
    }

    public MaskedSimilarityTransform(AffineTransform3D transform, RealRandomAccessible<T> lambda, double[] c, Interpolators interp) {
        assert (transform.numSourceDimensions() == lambda.numDimensions());
        this.transform = transform;
        this.c = c;
        this.lambda = lambda;
        this.lambdaAccess = lambda.realRandomAccess();
        this.interpolator = interp == Interpolators.SIMILARITY ? new SimilarityTransformInterpolator(transform, c) : new RotationTransformInterpolator(transform, c);
    }

    public int numSourceDimensions() {
        return this.transform.numSourceDimensions();
    }

    public int numTargetDimensions() {
        return this.transform.numTargetDimensions();
    }

    public void apply(double[] source, double[] target) {
        this.lambdaAccess.setPosition(source);
        double lam = ((RealType)this.lambdaAccess.get()).getRealDouble();
        this.interpolator.get(lam).apply(source, target);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.lambdaAccess.setPosition(source);
        double lam = ((RealType)this.lambdaAccess.get()).getRealDouble();
        this.interpolator.get(lam).apply(source, target);
    }

    public RealTransform copy() {
        return new MaskedSimilarityTransform<T>(this.transform.copy(), this.lambda, this.c);
    }

    public static enum Interpolators {
        SIMILARITY,
        ROTATION;

    }
}

