/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.transform.CoordinateTransform;

public class MovingLeastSquaresTransform
extends mpicbg.models.MovingLeastSquaresTransform
implements CoordinateTransform {
    private static final long serialVersionUID = 969438449108820224L;
    private static final Comparator<PointMatch> SORTER = new Comparator<PointMatch>(){

        @Override
        public final int compare(PointMatch o1, PointMatch o2) {
            double[] p2;
            double[] p1 = o1.getP1().getW();
            double dx = p1[0] - (p2 = o1.getP2().getW())[0];
            if (dx < 0.0) {
                return -1;
            }
            if (0.0 == dx) {
                double dy = p1[1] - p2[1];
                if (dy < 0.0) {
                    return -1;
                }
                if (0.0 == dy) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void init(String data) throws NumberFormatException {
        this.matches.clear();
        String[] fields = data.split("\\s+");
        if (fields.length <= 3) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        int d = Integer.parseInt(fields[1]);
        if ((fields.length - 3) % (2 * d + 1) != 0) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        if (d == 2) {
            if (fields[0].equals("translation")) {
                this.model = new TranslationModel2D();
            } else if (fields[0].equals("rigid")) {
                this.model = new RigidModel2D();
            } else if (fields[0].equals("similarity")) {
                this.model = new SimilarityModel2D();
            } else {
                if (!fields[0].equals("affine")) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
                this.model = new AffineModel2D();
            }
        } else {
            if (d != 3) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
            if (!fields[0].equals("affine")) throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
            this.model = new AffineModel3D();
        }
        this.alpha = Double.parseDouble(fields[2]);
        int i = 2;
        while (i < fields.length - 1) {
            double[] p1 = new double[d];
            for (int k = 0; k < d; ++k) {
                p1[k] = Double.parseDouble(fields[++i]);
            }
            double[] p2 = new double[d];
            for (int k = 0; k < d; ++k) {
                p2[k] = Double.parseDouble(fields[++i]);
            }
            double weight = Double.parseDouble(fields[++i]);
            PointMatch m = new PointMatch(new Point(p1), new Point(p2), weight);
            this.matches.add(m);
        }
    }

    @Override
    public String toDataString() {
        StringBuilder data = new StringBuilder();
        this.toDataString(data);
        return data.toString();
    }

    private final void toDataString(StringBuilder data) {
        if (AffineModel2D.class.isInstance(this.model)) {
            data.append("affine 2");
        } else if (TranslationModel2D.class.isInstance(this.model)) {
            data.append("translation 2");
        } else if (RigidModel2D.class.isInstance(this.model)) {
            data.append("rigid 2");
        } else if (SimilarityModel2D.class.isInstance(this.model)) {
            data.append("similarity 2");
        } else if (AffineModel3D.class.isInstance(this.model)) {
            data.append("affine 3");
        } else {
            data.append("unknown");
        }
        data.append(' ').append(this.alpha);
        ArrayList pms = new ArrayList(this.matches);
        Collections.sort(pms, SORTER);
        for (PointMatch m : pms) {
            int k;
            double[] p1 = m.getP1().getL();
            double[] p2 = m.getP2().getW();
            for (k = 0; k < p1.length; ++k) {
                data.append(' ').append(p1[k]);
            }
            for (k = 0; k < p2.length; ++k) {
                data.append(' ').append(p2[k]);
            }
            data.append(' ').append(m.getWeight());
        }
    }

    @Override
    public final String toXML(String indent) {
        StringBuilder xml = new StringBuilder(128);
        xml.append(indent).append("<ict_transform class=\"").append(this.getClass().getCanonicalName()).append("\" data=\"");
        this.toDataString(xml);
        return xml.append("\"/>").toString();
    }

    @Override
    public final MovingLeastSquaresTransform copy() {
        MovingLeastSquaresTransform t = new MovingLeastSquaresTransform();
        t.init(this.toDataString());
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyInPlace(double[] location) {
        ArrayList<PointMatch> weightedMatches = new ArrayList<PointMatch>();
        for (PointMatch m : this.matches) {
            double[] l = m.getP1().getL();
            double s = 0.0;
            for (int i = 0; i < location.length; ++i) {
                double dx = l[i] - location[i];
                s += dx * dx;
            }
            if (s <= 0.0) {
                double[] w = m.getP2().getW();
                for (int i = 0; i < location.length; ++i) {
                    location[i] = w[i];
                }
                return;
            }
            double weight = m.getWeight() * this.weigh(s);
            PointMatch mw = new PointMatch(m.getP1(), m.getP2(), weight);
            weightedMatches.add(mw);
        }
        try {
            Model model = this.model;
            synchronized (model) {
                this.model.fit(weightedMatches);
                this.model.applyInPlace(location);
            }
        }
        catch (IllDefinedDataPointsException illDefinedDataPointsException) {
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            // empty catch block
        }
    }
}

