/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import mpicbg.trakem2.transform.CoordinateTransform;

public class NonLinearCoordinateTransform
implements CoordinateTransform {
    protected double[][] beta = null;
    protected double[] normMean = null;
    protected double[] normVar = null;
    protected int dimension = 0;
    protected int length = 0;
    protected int width = 0;
    protected int height = 0;

    @Override
    public void init(String data) throws NumberFormatException {
        String[] fields = data.split(" ");
        int c = 0;
        this.dimension = Integer.parseInt(fields[c]);
        this.length = Integer.parseInt(fields[++c]);
        ++c;
        this.beta = new double[this.length][2];
        this.normMean = new double[this.length];
        this.normVar = new double[this.length];
        if (fields.length == 4 + 4 * this.length) {
            int i;
            for (i = 0; i < this.length; ++i) {
                this.beta[i][0] = Double.parseDouble(fields[c]);
                this.beta[i][1] = Double.parseDouble(fields[++c]);
                ++c;
            }
            for (i = 0; i < this.length; ++i) {
                this.normMean[i] = Double.parseDouble(fields[c]);
                ++c;
            }
            for (i = 0; i < this.length; ++i) {
                this.normVar[i] = Double.parseDouble(fields[c]);
                ++c;
            }
            this.width = Integer.parseInt(fields[c]);
            this.height = Integer.parseInt(fields[++c]);
            ++c;
        } else {
            throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public String toXML(String indent) {
        return indent + "<ict_transform class=\"" + this.getClass().getCanonicalName() + "\" data=\"" + this.toDataString() + "\"/>";
    }

    @Override
    public String toDataString() {
        int i;
        String data = "";
        data = data + Integer.toString(this.dimension) + " ";
        data = data + Integer.toString(this.length) + " ";
        for (i = 0; i < this.length; ++i) {
            data = data + Double.toString(this.beta[i][0]) + " ";
            data = data + Double.toString(this.beta[i][1]) + " ";
        }
        for (i = 0; i < this.length; ++i) {
            data = data + Double.toString(this.normMean[i]) + " ";
        }
        for (i = 0; i < this.length; ++i) {
            data = data + Double.toString(this.normVar[i]) + " ";
        }
        data = data + Integer.toString(this.width) + " ";
        data = data + Integer.toString(this.height) + " ";
        return data;
    }

    public String toString() {
        return this.toDataString();
    }

    public double[] apply(double[] location) {
        double[] position = new double[]{location[0], location[1]};
        double[] featureVector = this.kernelExpand(position);
        return NonLinearCoordinateTransform.multiply(this.beta, featureVector);
    }

    public void applyInPlace(double[] location) {
        double[] position = new double[]{location[0], location[1]};
        double[] featureVector = this.kernelExpand(position);
        double[] newPosition = NonLinearCoordinateTransform.multiply(this.beta, featureVector);
        location[0] = newPosition[0];
        location[1] = newPosition[1];
    }

    protected static double[] multiply(double[][] beta, double[] featureVector) {
        double[] result = new double[]{0.0, 0.0};
        if (beta.length != featureVector.length) {
            return new double[2];
        }
        for (int i = 0; i < featureVector.length; ++i) {
            result[0] = result[0] + featureVector[i] * beta[i][0];
            result[1] = result[1] + featureVector[i] * beta[i][1];
        }
        return result;
    }

    public double[] kernelExpand(double[] position) {
        int i;
        double[] expanded = new double[this.length];
        int counter = 0;
        for (i = 1; i <= this.dimension; ++i) {
            for (double j = (double)i; j >= 0.0; j -= 1.0) {
                double val;
                expanded[counter] = val = Math.pow(position[0], j) * Math.pow(position[1], (double)i - j);
                ++counter;
            }
        }
        for (i = 0; i < this.length - 1; ++i) {
            expanded[i] = expanded[i] - this.normMean[i];
            expanded[i] = expanded[i] / this.normVar[i];
        }
        expanded[this.length - 1] = 100.0;
        return expanded;
    }

    @Override
    public NonLinearCoordinateTransform copy() {
        NonLinearCoordinateTransform t = new NonLinearCoordinateTransform();
        t.init(this.toDataString());
        return t;
    }
}

