/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching.fusion;

public class Interval {
    private int min;
    private int max;

    public Interval(int ... points) {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        for (int p : points) {
            this.min = Math.min(this.min, p);
            this.max = Math.max(this.max, p);
        }
    }

    public Interval(Interval interval) {
        this.min = interval.min();
        this.max = interval.max();
    }

    public boolean setMin(int min) {
        this.min = min;
        if (min > this.max) {
            this.max = min;
            return true;
        }
        return false;
    }

    public boolean setMax(int max) {
        this.max = max;
        if (max < this.min) {
            this.min = max;
            return true;
        }
        return false;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int contains(int point) {
        if (this.max < point) {
            return -1;
        }
        if (this.min > point) {
            return 1;
        }
        return 0;
    }

    public boolean intersects(Interval other) {
        boolean intersects = this.equalsInterval(other);
        return intersects || this.contains(other.min()) == 0 || other.contains(this.min()) == 0 || this.contains(other.max()) == 0 || other.contains(this.max()) == 0;
    }

    public boolean equalsInterval(Interval other) {
        return this.min() == other.min() && this.max() == other.max();
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

