/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import fiji.stacks.Hyperstack_rearranger;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import mpicbg.stitching.ComparePair;
import mpicbg.stitching.GlobalOptimization;
import mpicbg.stitching.ImagePlusTimePoint;
import mpicbg.stitching.PairWiseStitchingImgLib;
import mpicbg.stitching.PairWiseStitchingResult;
import mpicbg.stitching.StitchingParameters;
import mpicbg.stitching.fusion.Fusion;
import mpicbg.stitching.fusion.OverlayFusion;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import plugin.Stitching_Grid;
import stitching.CommonFunctions;
import stitching.utils.CompositeImageFixer;
import stitching.utils.Log;

public class Stitching_Pairwise
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/preibisch";
    private final String paperURL = "http://bioinformatics.oxfordjournals.org/cgi/content/abstract/btp184";
    public static int defaultImg1 = 0;
    public static int defaultImg2 = 1;
    public static int defaultChannel1 = 0;
    public static int defaultChannel2 = 0;
    public static int defaultTimeSelect = 1;
    public static boolean defaultFuseImages = true;
    public static int defaultFusionMethod = 0;
    public static boolean defaultIgnoreZeroValues = false;
    public static boolean defaultComputeOverlap = true;
    public static boolean defaultSubpixelAccuracy = false;
    public static int defaultCheckPeaks = 5;
    public static double defaultxOffset = 0.0;
    public static double defaultyOffset = 0.0;
    public static double defaultzOffset = 0.0;
    public static boolean[] defaultHandleChannel1 = null;
    public static boolean[] defaultHandleChannel2 = null;
    public static int defaultMemorySpeedChoice = 0;
    public static double defaultDisplacementThresholdRelative = 2.5;
    public static double defaultDisplacementThresholdAbsolute = 3.5;

    public void run(String arg0) {
        boolean simpleFusion;
        String[] fusionMethodList;
        int c;
        Log.info("Stitching internal version: 1.2");
        int[] idList = WindowManager.getIDList();
        if (idList == null || idList.length < 2) {
            IJ.error((String)"You need at least two open images.");
            return;
        }
        String[] imgList = new String[idList.length];
        for (int i = 0; i < idList.length; ++i) {
            imgList[i] = WindowManager.getImage((int)idList[i]).getTitle();
        }
        GenericDialog gd1 = new GenericDialog("Pairwise Stitching of Images");
        if (defaultImg1 >= imgList.length || defaultImg2 >= imgList.length) {
            defaultImg1 = 0;
            defaultImg2 = 1;
        }
        gd1.addChoice("First_image (reference)", imgList, imgList[defaultImg1]);
        gd1.addChoice("Second_image (to register)", imgList, imgList[defaultImg2]);
        gd1.addMessage("Please note that the Stitching is based on a publication.\nIf you use it successfully for your research please be so kind to cite our work:\nPreibisch et al., Bioinformatics (2009), 25(11):1463-1465\n");
        MultiLineLabel text = (MultiLineLabel)gd1.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://bioinformatics.oxfordjournals.org/cgi/content/abstract/btp184");
        gd1.showDialog();
        if (gd1.wasCanceled()) {
            return;
        }
        defaultImg1 = gd1.getNextChoiceIndex();
        ImagePlus imp1 = WindowManager.getImage((int)idList[defaultImg1]);
        defaultImg2 = gd1.getNextChoiceIndex();
        ImagePlus imp2 = WindowManager.getImage((int)idList[defaultImg2]);
        String error = Stitching_Pairwise.testRegistrationCompatibility(imp1 = Hyperstack_rearranger.convertToHyperStack((ImagePlus)imp1), imp2 = Hyperstack_rearranger.convertToHyperStack((ImagePlus)imp2));
        if (error != null) {
            IJ.error((String)error);
            return;
        }
        int dimensionality = imp1.getNSlices() > 1 || imp2.getNSlices() > 1 ? 3 : 2;
        int numChannels1 = imp1.getNChannels();
        int numChannels2 = imp2.getNChannels();
        String[] channels1 = new String[numChannels1 + 1];
        String[] channels2 = new String[numChannels2 + 1];
        channels1[0] = "Average all channels";
        for (c = 1; c < channels1.length; ++c) {
            channels1[c] = "Only channel " + c;
        }
        channels2[0] = "Average all channels";
        for (c = 1; c < channels2.length; ++c) {
            channels2[c] = "Only channel " + c;
        }
        if (defaultChannel1 >= channels1.length) {
            defaultChannel1 = 0;
        }
        if (defaultChannel2 >= channels2.length) {
            defaultChannel2 = 0;
        }
        if (imp1.getNChannels() != imp2.getNChannels()) {
            fusionMethodList = CommonFunctions.fusionMethodListSimple;
            simpleFusion = true;
        } else {
            fusionMethodList = CommonFunctions.fusionMethodList;
            simpleFusion = false;
        }
        if (defaultFusionMethod >= fusionMethodList.length) {
            defaultFusionMethod = 0;
        }
        GenericDialog gd2 = new GenericDialog("Pairwise Stitching");
        gd2.addChoice("Fusion_method", fusionMethodList, fusionMethodList[defaultFusionMethod]);
        gd2.addStringField("Fused_image name: ", imp1.getTitle() + "<->" + imp2.getTitle(), 20);
        gd2.addSlider("Check_peaks", 1.0, 100.0, (double)defaultCheckPeaks);
        gd2.addCheckbox("Ignore zero values when fusing", defaultIgnoreZeroValues);
        gd2.addCheckbox("Display_fusion", Stitching_Grid.defaultDisplayFusion);
        gd2.addCheckbox("Compute_overlap", defaultComputeOverlap);
        gd2.addCheckbox("Subpixel_accuracy", defaultSubpixelAccuracy);
        gd2.addNumericField("x", defaultxOffset, 4);
        gd2.addNumericField("y", defaultyOffset, 4);
        if (dimensionality == 3) {
            gd2.addNumericField("z", defaultzOffset, 4);
        }
        gd2.addChoice("Registration_channel_image_1 ", channels1, channels1[defaultChannel1]);
        gd2.addChoice("Registration_channel_image_2 ", channels2, channels2[defaultChannel2]);
        if (imp1.getNFrames() > 1) {
            gd2.addChoice("Time-lapse_registration", CommonFunctions.timeSelect, CommonFunctions.timeSelect[defaultTimeSelect]);
        }
        gd2.addMessage("");
        gd2.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        text = (MultiLineLabel)gd2.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return;
        }
        StitchingParameters params = new StitchingParameters();
        params.dimensionality = dimensionality;
        params.fusionMethod = simpleFusion ? (defaultFusionMethod = gd2.getNextChoiceIndex() + (CommonFunctions.fusionMethodList.length - CommonFunctions.fusionMethodListSimple.length)) : (defaultFusionMethod = gd2.getNextChoiceIndex());
        params.fusedName = gd2.getNextString();
        params.checkPeaks = defaultCheckPeaks = (int)Math.round(gd2.getNextNumber());
        params.ignoreZeroValuesFusion = defaultIgnoreZeroValues = gd2.getNextBoolean();
        params.displayFusion = Stitching_Grid.defaultDisplayFusion = gd2.getNextBoolean();
        params.computeOverlap = defaultComputeOverlap = gd2.getNextBoolean();
        params.subpixelAccuracy = defaultSubpixelAccuracy = gd2.getNextBoolean();
        params.xOffset = defaultxOffset = gd2.getNextNumber();
        params.yOffset = defaultyOffset = gd2.getNextNumber();
        params.zOffset = dimensionality == 3 ? (defaultzOffset = gd2.getNextNumber()) : 0.0;
        params.channel1 = defaultChannel1 = gd2.getNextChoiceIndex();
        params.channel2 = defaultChannel2 = gd2.getNextChoiceIndex();
        if (channels1.length == 2) {
            params.channel1 = 1;
        }
        if (channels2.length == 2) {
            params.channel2 = 1;
        }
        params.timeSelect = imp1.getNFrames() > 1 ? (defaultTimeSelect = gd2.getNextChoiceIndex()) : 0;
        if (!params.computeOverlap && params.timeSelect > 0) {
            Log.warn("You chose to not compute overlap, ignoring the option '" + CommonFunctions.timeSelect[params.timeSelect] + "'!");
            defaultTimeSelect = 0;
            params.timeSelect = 0;
            Log.warn("Instead we will '" + CommonFunctions.timeSelect[params.timeSelect] + "'");
        }
        if (params.timeSelect > 0) {
            GenericDialog gd3 = new GenericDialog("Details for timelapse stitching");
            gd3.addChoice("Computation parameters", CommonFunctions.cpuMemSelect, CommonFunctions.cpuMemSelect[defaultMemorySpeedChoice]);
            gd3.addNumericField("Max/Avg Displacement Threshold", defaultDisplacementThresholdRelative, 2);
            gd3.addNumericField("Absolute Avg Displacement Threshold", defaultDisplacementThresholdAbsolute, 2);
            gd3.showDialog();
            if (gd3.wasCanceled()) {
                return;
            }
            params.cpuMemChoice = defaultMemorySpeedChoice = gd3.getNextChoiceIndex();
            params.relativeThreshold = defaultDisplacementThresholdRelative = gd3.getNextNumber();
            params.absoluteThreshold = defaultDisplacementThresholdAbsolute = gd3.getNextNumber();
        }
        Stitching_Pairwise.performPairWiseStitching(imp1, imp2, params);
    }

    public static void performPairWiseStitching(ImagePlus imp1, ImagePlus imp2, final StitchingParameters params) {
        ArrayList<InvertibleBoundable> models = new ArrayList<InvertibleBoundable>();
        if (imp1.getNFrames() == 1 || params.timeSelect == 0) {
            PairWiseStitchingResult result;
            long start = System.currentTimeMillis();
            if (params.computeOverlap) {
                result = PairWiseStitchingImgLib.stitchPairwise(imp1, imp2, imp1.getRoi(), imp2.getRoi(), 1, 1, params);
                Log.info("shift (second relative to first): " + Util.printCoordinates((float[])result.getOffset()) + " correlation (R)=" + result.getCrossCorrelation() + " (" + (System.currentTimeMillis() - start) + " ms)");
                defaultxOffset = result.getOffset(0);
                defaultyOffset = result.getOffset(1);
                if (params.dimensionality == 3) {
                    defaultzOffset = result.getOffset(2);
                }
            } else {
                float[] offset = params.dimensionality == 2 ? (params.subpixelAccuracy ? new float[]{(float)params.xOffset, (float)params.yOffset} : new float[]{Math.round((float)params.xOffset), Math.round((float)params.yOffset)}) : (params.subpixelAccuracy ? new float[]{(float)params.xOffset, (float)params.yOffset, (float)params.zOffset} : new float[]{Math.round((float)params.xOffset), Math.round((float)params.yOffset), Math.round((float)params.zOffset)});
                result = new PairWiseStitchingResult(offset, 0.0f, 0.0f);
                Log.info("shift (second relative to first): " + Util.printCoordinates((float[])result.getOffset()) + " (from dialog)");
            }
            if (GlobalOptimization.ignoreZ && params.dimensionality == 3) {
                result.getOffset()[2] = 0.0f;
                defaultzOffset = 0.0f;
                Log.info("Ignoring z-shift because mpicbg.stitching.GlobalOptimization.ignoreZ = true");
            }
            for (int f = 1; f <= imp1.getNFrames(); ++f) {
                TranslationModel2D model2;
                TranslationModel2D model1;
                if (params.dimensionality == 2) {
                    model1 = new TranslationModel2D();
                    model2 = new TranslationModel2D();
                    model2.set((double)result.getOffset(0), (double)result.getOffset(1));
                    models.add((InvertibleBoundable)model1);
                    models.add((InvertibleBoundable)model2);
                    continue;
                }
                model1 = new TranslationModel3D();
                model2 = new TranslationModel3D();
                model2.set((double)result.getOffset(0), (double)result.getOffset(1), (double)result.getOffset(2));
                models.add((InvertibleBoundable)model1);
                models.add((InvertibleBoundable)model2);
            }
        } else {
            final Vector<ComparePair> pairs = Stitching_Pairwise.getComparePairs(imp1, imp2, params.dimensionality, params.timeSelect);
            final AtomicInteger ai = new AtomicInteger(0);
            final int numThreads = params.cpuMemChoice == 0 ? 1 : Runtime.getRuntime().availableProcessors();
            Thread[] threads = SimpleMultiThreading.newThreads((int)numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        for (int i = 0; i < pairs.size(); ++i) {
                            if (i % numThreads != myNumber) continue;
                            ComparePair pair = (ComparePair)pairs.get(i);
                            long start = System.currentTimeMillis();
                            PairWiseStitchingResult result = PairWiseStitchingImgLib.stitchPairwise(pair.getImagePlus1(), pair.getImagePlus2(), pair.getImagePlus1().getRoi(), pair.getImagePlus2().getRoi(), pair.getTimePoint1(), pair.getTimePoint2(), params);
                            if (params.dimensionality == 2) {
                                pair.setRelativeShift(new float[]{result.getOffset(0), result.getOffset(1)});
                            } else {
                                pair.setRelativeShift(new float[]{result.getOffset(0), result.getOffset(1), result.getOffset(2)});
                            }
                            pair.setCrossCorrelation(result.getCrossCorrelation());
                            Log.info(pair.getImagePlus1().getTitle() + "[" + pair.getTimePoint1() + "] <- " + pair.getImagePlus2().getTitle() + "[" + pair.getTimePoint2() + "]: " + Util.printCoordinates((float[])result.getOffset()) + " correlation (R)=" + result.getCrossCorrelation() + " (" + (System.currentTimeMillis() - start) + " ms)");
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
            ArrayList<ImagePlusTimePoint> optimized = GlobalOptimization.optimize(pairs, pairs.get(0).getTile1(), params);
            for (int f = 0; f < imp1.getNFrames(); ++f) {
                Log.info(optimized.get(f * 2).getImagePlus().getTitle() + "[" + optimized.get(f * 2).getImpId() + "," + optimized.get(f * 2).getTimePoint() + "]: " + optimized.get(f * 2).getModel());
                Log.info(optimized.get(f * 2 + 1).getImagePlus().getTitle() + "[" + optimized.get(f * 2 + 1).getImpId() + "," + optimized.get(f * 2 + 1).getTimePoint() + "]: " + optimized.get(f * 2 + 1).getModel());
                models.add((InvertibleBoundable)optimized.get(f * 2).getModel());
                models.add((InvertibleBoundable)optimized.get(f * 2 + 1).getModel());
            }
        }
        Log.info("Fusing ...");
        long start = System.currentTimeMillis();
        ImagePlus ci = imp1.getType() == 2 || imp2.getType() == 2 ? Stitching_Pairwise.fuse(new FloatType(), imp1, imp2, models, params) : (imp1.getType() == 1 || imp2.getType() == 1 ? Stitching_Pairwise.fuse(new UnsignedShortType(), imp1, imp2, models, params) : Stitching_Pairwise.fuse(new UnsignedByteType(), imp1, imp2, models, params));
        if (ci != null) {
            ci.setTitle(params.fusedName);
            ci.show();
        }
        Log.info("Finished ... (" + (System.currentTimeMillis() - start) + " ms)");
    }

    protected static <T extends RealType<T> & NativeType<T>> ImagePlus fuse(T targetType, ImagePlus imp1, ImagePlus imp2, ArrayList<InvertibleBoundable> models, StitchingParameters params) {
        ArrayList<ImagePlus> images = new ArrayList<ImagePlus>();
        images.add(imp1);
        images.add(imp2);
        if (params.fusionMethod < 6) {
            ImagePlus imp = Fusion.fuse(targetType, images, models, params.dimensionality, params.subpixelAccuracy, params.fusionMethod, null, false, params.ignoreZeroValuesFusion, params.displayFusion);
            return imp;
        }
        if (params.fusionMethod == 6) {
            Object factory = params.subpixelAccuracy ? new NLinearInterpolatorFactory() : new NearestNeighborInterpolatorFactory();
            CompositeImage timepoint0 = OverlayFusion.createOverlay(targetType, images, models, params.dimensionality, 1, (InterpolatorFactory<FloatType, RandomAccessible<FloatType>>)factory);
            if (imp1.getNFrames() > 1) {
                ImageStack stack = new ImageStack(timepoint0.getWidth(), timepoint0.getHeight());
                for (int c = 1; c <= timepoint0.getStackSize(); ++c) {
                    stack.addSlice("", timepoint0.getStack().getProcessor(c));
                }
                for (int f = 2; f <= imp1.getNFrames(); ++f) {
                    CompositeImage tmp = OverlayFusion.createOverlay(targetType, images, models, params.dimensionality, f, (InterpolatorFactory<FloatType, RandomAccessible<FloatType>>)factory);
                    for (int c = 1; c <= tmp.getStackSize(); ++c) {
                        stack.addSlice("", tmp.getStack().getProcessor(c));
                    }
                }
                ImagePlus result = new ImagePlus(params.fusedName, stack);
                result.setDimensions(timepoint0.getNChannels(), timepoint0.getNSlices(), imp1.getNFrames());
                return CompositeImageFixer.makeComposite(result, 1);
            }
            timepoint0.setTitle(params.fusedName);
            return timepoint0;
        }
        return null;
    }

    protected static Vector<ComparePair> getComparePairs(ImagePlus imp1, ImagePlus imp2, int dimensionality, int timeSelect) {
        int timePointA;
        Object model = dimensionality == 2 ? new TranslationModel2D() : new TranslationModel3D();
        ArrayList<ImagePlusTimePoint> listImp1 = new ArrayList<ImagePlusTimePoint>();
        ArrayList<ImagePlusTimePoint> listImp2 = new ArrayList<ImagePlusTimePoint>();
        for (int timePoint1 = 1; timePoint1 <= imp1.getNFrames(); ++timePoint1) {
            listImp1.add(new ImagePlusTimePoint(imp1, 1, timePoint1, model.copy(), null));
        }
        for (int timePoint2 = 1; timePoint2 <= imp2.getNFrames(); ++timePoint2) {
            listImp2.add(new ImagePlusTimePoint(imp2, 2, timePoint2, model.copy(), null));
        }
        Vector<ComparePair> pairs = new Vector<ComparePair>();
        for (timePointA = 1; timePointA <= Math.min(imp1.getNFrames(), imp2.getNFrames()); ++timePointA) {
            ImagePlusTimePoint a = (ImagePlusTimePoint)listImp1.get(timePointA - 1);
            ImagePlusTimePoint b = (ImagePlusTimePoint)listImp2.get(timePointA - 1);
            pairs.add(new ComparePair(a, b));
        }
        if (timeSelect == 1) {
            for (timePointA = 1; timePointA <= imp1.getNFrames() - 1; ++timePointA) {
                pairs.add(new ComparePair((ImagePlusTimePoint)listImp1.get(timePointA - 1), (ImagePlusTimePoint)listImp1.get(timePointA + 1 - 1)));
            }
            for (int timePointB = 1; timePointB <= imp2.getNFrames() - 1; ++timePointB) {
                pairs.add(new ComparePair((ImagePlusTimePoint)listImp2.get(timePointB - 1), (ImagePlusTimePoint)listImp2.get(timePointB + 1 - 1)));
            }
        } else {
            for (timePointA = 1; timePointA <= imp1.getNFrames() - 1; ++timePointA) {
                for (int timePointB = timePointA + 1; timePointB <= imp1.getNFrames(); ++timePointB) {
                    pairs.add(new ComparePair((ImagePlusTimePoint)listImp1.get(timePointA - 1), (ImagePlusTimePoint)listImp1.get(timePointB - 1)));
                }
            }
            for (timePointA = 1; timePointA <= imp2.getNFrames() - 1; ++timePointA) {
                for (int timePointB = timePointA + 1; timePointB <= imp2.getNFrames(); ++timePointB) {
                    pairs.add(new ComparePair((ImagePlusTimePoint)listImp2.get(timePointA - 1), (ImagePlusTimePoint)listImp2.get(timePointB - 1)));
                }
            }
        }
        return pairs;
    }

    public static String testRegistrationCompatibility(ImagePlus imp1, ImagePlus imp2) {
        int numFrames2;
        int numFrames1 = imp1.getNFrames();
        if (numFrames1 != (numFrames2 = imp2.getNFrames())) {
            return "Images have a different number of time points, cannot proceed...";
        }
        int numSlices1 = imp1.getNSlices();
        int numSlices2 = imp2.getNSlices();
        if (numSlices1 == 1 && numSlices2 != 1 || numSlices1 != 1 && numSlices2 == 1) {
            return "One image is 2d and the other one is 3d, cannot proceed...";
        }
        return null;
    }
}

