/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import stitching.model.InvertibleCoordinateTransform;
import stitching.model.NoninvertibleModelException;
import stitching.utils.Log;

public class PaintInvertibleCoordinateTransformThread
extends Thread {
    protected final ImagePlus imp;
    protected final ImageProcessor source;
    protected final ImageProcessor target;
    protected final AtomicBoolean pleaseRepaint;
    protected final InvertibleCoordinateTransform transform;

    public PaintInvertibleCoordinateTransformThread(ImagePlus imp, ImageProcessor source, ImageProcessor target, AtomicBoolean pleaseRepaint, InvertibleCoordinateTransform transform) {
        this.imp = imp;
        this.source = source;
        this.target = target;
        this.pleaseRepaint = pleaseRepaint;
        this.transform = transform;
        this.setName("PaintInvertibleCoordinateTransformThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                if (this.pleaseRepaint.compareAndSet(true, false)) {
                    for (int y = 0; y < this.target.getHeight(); ++y) {
                        for (int x = 0; x < this.target.getWidth(); ++x) {
                            float[] t = new float[]{x, y};
                            try {
                                this.transform.applyInverseInPlace(t);
                                this.target.putPixel(x, y, this.source.getPixel((int)t[0], (int)t[1]));
                                continue;
                            }
                            catch (NoninvertibleModelException e) {
                                Log.error(e);
                            }
                        }
                        this.imp.updateAndDraw();
                    }
                    continue;
                }
                PaintInvertibleCoordinateTransformThread y = this;
                synchronized (y) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

