/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import stitching.model.InvertibleModel;
import stitching.model.Model;
import stitching.model.NoninvertibleModelException;

public class Point {
    private final float[] w;
    private final float[] l;

    public final float[] getW() {
        return this.w;
    }

    public final float[] getL() {
        return this.l;
    }

    public Point(float[] l) {
        this.l = l;
        this.w = (float[])l.clone();
    }

    public final void apply(Model model) {
        System.arraycopy(this.l, 0, this.w, 0, this.l.length);
        model.applyInPlace(this.w);
    }

    public final void apply(Model model, float amount) {
        float[] a = model.apply(this.l);
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            this.w[n] = this.w[n] + amount * (a[i] - this.w[i]);
        }
    }

    public final void applyInverse(InvertibleModel model) throws NoninvertibleModelException {
        System.arraycopy(this.l, 0, this.w, 0, this.l.length);
        model.applyInverseInPlace(this.w);
    }

    public static final float squareDistance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same dimensionality.";
        double sum = 0.0;
        for (int i = 0; i < p1.w.length; ++i) {
            double d = p1.w[i] - p2.w[i];
            sum += d * d;
        }
        return (float)sum;
    }

    public static final float distance(Point p1, Point p2) {
        assert (p1.l.length == p2.l.length) : "Both points have to have the same dimensionality.";
        return (float)Math.sqrt(Point.squareDistance(p1, p2));
    }

    public Point clone() {
        Point p = new Point((float[])this.l.clone());
        for (int i = 0; i < this.w.length; ++i) {
            p.w[i] = this.w[i];
        }
        return p;
    }
}

