/*
 * Decompiled with CFR 0.152.
 */
package lineage;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ini.trakem2.Project;
import ini.trakem2.display.Line3D;
import ini.trakem2.plugin.TPlugIn;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.FieldMapView;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Identify
implements TPlugIn {
    private static Params PARAMS;
    private Params params = PARAMS.clone();

    public static Object identify(Object ... args) {
        return Identify.invokeClojureFunction("lineage.identify", "identify", args);
    }

    public static Object invokeClojureFunction(String namespace, String fnName, Object ... args) {
        try {
            Class<?> RT = Class.forName("clojure.lang.RT");
            Method var = RT.getDeclaredMethod("var", String.class, String.class);
            Object fn = var.invoke(null, namespace, fnName);
            Class[] cc = new Class[args.length];
            for (int i = 0; i < cc.length; ++i) {
                cc[i] = Object.class;
            }
            Method invoke = Class.forName("clojure.lang.Var").getDeclaredMethod("invoke", cc);
            return invoke.invoke(fn, args);
        }
        catch (Throwable e) {
            IJError.print((Throwable)e);
            return null;
        }
    }

    public Bureaucrat identify(final Line3D pipe) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Identifying " + pipe){

            public void exec() {
                if (null == pipe) {
                    return;
                }
                Params p = Identify.this.params.clone();
                Identify.identify(pipe, p.libs.get(p.lib_index), p.delta, p.direct, p.substring);
            }
        }, (Project)pipe.getProject());
    }

    public boolean setup(Object ... args) {
        if (this.params.isOutOfDate()) {
            this.params = new Params(this.params);
        }
        return this.params.setup();
    }

    public Object invoke(Object ... args) {
        if (null == args || args.length < 1 || null == args[0] || !(args[0] instanceof Line3D)) {
            return null;
        }
        Line3D pipe = (Line3D)args[0];
        Params p = this.params.clone();
        return Identify.identify(pipe, p.libs.get(p.lib_index), p.delta, p.direct, p.substring);
    }

    public boolean applies(Object ob) {
        return null != ob && ob instanceof Line3D;
    }

    static {
        try {
            Thread.currentThread().setContextClassLoader(IJ.getClassLoader());
            Class<?> c = Class.forName("clojure.lang.Compiler");
            Method load = c.getDeclaredMethod("load", Reader.class);
            load.invoke(null, new InputStreamReader(Identify.class.getResourceAsStream("/lineage/identify.clj")));
        }
        catch (Throwable t) {
            IJError.print((Throwable)t);
        }
        PARAMS = new Params();
    }

    private static class Params {
        private final List<Library> libs;
        private final long modificationTime;
        private double delta = 1.0;
        private int lib_index = 0;
        private boolean direct = true;
        private boolean substring = false;

        private Params() {
            Tuple b = this.init();
            this.libs = b.libraries;
            this.modificationTime = b.lastModified;
        }

        private final File fileNITLibraries() {
            String pluginsDir = Utils.fixDir((String)Prefs.get((String)"plugins.dir", (String)Utils.fixDir((String)(System.getProperty("user.dir") + "/plugins"))));
            File libsList = new File(pluginsDir + "NIT-libraries.txt");
            if (!libsList.exists()) {
                throw new RuntimeException("Could not find file " + libsList.getAbsolutePath());
            }
            if (!libsList.canRead()) {
                throw new RuntimeException("Could not read file " + libsList.getAbsolutePath());
            }
            return libsList;
        }

        private final Tuple init() {
            ArrayList<Library> l = new ArrayList<Library>();
            File libsList = this.fileNITLibraries();
            long lastModified = libsList.lastModified();
            String[] lines = Utils.openTextFileLines((String)libsList.getAbsolutePath());
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                if (0 == line.length() || line.startsWith("#")) continue;
                int comment = line.indexOf(35);
                if (-1 != comment) {
                    line = line.substring(0, comment).trim();
                }
                if (0 == line.length()) continue;
                String[] t = line.split("\\t+");
                if (t.length < 3) {
                    throw new RuntimeException("Errors in Library file: improper entry at line " + (i + 1) + ": '" + lines[i] + "'");
                }
                for (int k = 0; k < t.length; ++k) {
                    t[k] = t[k].trim();
                }
                File f = new File(t[1]);
                if (!f.exists()) {
                    f = new File(Utils.fixDir((String)libsList.getParent()) + t[1]);
                    Utils.logAll((String)("File f is " + f.getAbsolutePath() + " and t[1]: " + t[1]));
                    if (!f.exists()) {
                        Utils.logAll((String)("Could not find file for NIT library: " + t[1]));
                        continue;
                    }
                }
                if (!f.canRead()) {
                    Utils.logAll((String)("Incorrect permissions, cannot read file for NIT library at " + t[1]));
                    continue;
                }
                l.add(new Library(t[0], f.getAbsolutePath(), t[2]));
                Utils.log((String)("Library: " + t[0] + " | " + f.getAbsolutePath() + " | " + t[2]));
            }
            Utils.logAll((String)("T2-NIT: loaded " + l.size() + " librar" + (0 == l.size() ? "y" : "ies")));
            return new Tuple(lastModified, Collections.unmodifiableList(l));
        }

        private Params(Params p) {
            File libsList = this.fileNITLibraries();
            if (libsList.lastModified() > p.modificationTime) {
                Utils.logAll((String)"NIT-libraries.txt has been modified: libraries will be reloaded");
                Identify.invokeClojureFunction("lineage.identify", "forget-libs", new Object[0]);
                Tuple b = this.init();
                this.libs = b.libraries;
                this.modificationTime = b.lastModified;
            } else {
                this.libs = p.libs;
                this.delta = p.delta;
                this.lib_index = p.lib_index;
                this.direct = p.direct;
                this.substring = p.substring;
                this.modificationTime = p.modificationTime;
            }
        }

        public synchronized Params clone() {
            return new Params(this);
        }

        private synchronized boolean setup() {
            GenericDialog gd = new GenericDialog("Setup NIT");
            gd.addNumericField("delta:", this.delta, 2);
            gd.addCheckbox("direct", this.direct);
            gd.addCheckbox("substring", this.substring);
            String[] libNames = new String[this.libs.size()];
            for (int i = 0; i < this.libs.size(); ++i) {
                libNames[i] = this.libs.get(i).title;
            }
            gd.addChoice("Library: ", libNames, libNames[this.lib_index]);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            double d = gd.getNextNumber();
            if (Double.isNaN(d)) {
                Utils.log((String)"Invalid delta value!");
                return false;
            }
            if (d < 0.0) {
                d = 1.0;
            }
            this.delta = d;
            this.lib_index = gd.getNextChoiceIndex();
            this.direct = gd.getNextBoolean();
            this.substring = gd.getNextBoolean();
            return true;
        }

        private boolean isOutOfDate() {
            File f = this.fileNITLibraries();
            return f.lastModified() > this.modificationTime;
        }

        private final class Tuple {
            private final long lastModified;
            private final List<Library> libraries;

            Tuple(long modificationTime, List<Library> libs) {
                this.lastModified = modificationTime;
                this.libraries = libs;
            }
        }
    }

    private static class Library
    extends FieldMapView {
        private String title;
        private String filepath;
        private String reference;

        private Library(String title, String filepath, String reference) {
            this.title = title;
            this.filepath = filepath;
            this.reference = reference;
        }
    }
}

