/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.algorithm.math.ImageStatistics;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class ColocImgLibGadgets<T extends RealType<T> & NativeType<T>>
implements PlugIn {
    protected Img<T> img1;
    protected Img<T> img2;

    public void run(String arg) {
        ImagePlus imp1 = IJ.openImage((String)"/Users/dan/Documents/Dresden/ipf/colocPluginDesign/red.tif");
        this.img1 = ImagePlusAdapter.wrap((ImagePlus)imp1);
        ImagePlus imp2 = IJ.openImage((String)"/Users/dan/Documents/Dresden/ipf/colocPluginDesign/green.tif");
        this.img2 = ImagePlusAdapter.wrap((ImagePlus)imp2);
        double pearson = this.calculatePearson();
        Img<T> ranImg = this.generateRandomImageStack(this.img1, new int[]{2, 2, 1});
    }

    protected Img<T> generateRandomImageStack(Img<T> img, int[] blockDimensions) {
        int numberOfDimensions = Math.min(img.numDimensions(), blockDimensions.length);
        int numberOfBlocks = 0;
        long[] numberOfBlocksPerDimension = new long[numberOfDimensions];
        for (int i = 0; i < numberOfDimensions; ++i) {
            if (img.dimension(i) % (long)blockDimensions[i] != 0L) {
                System.out.println("sorry, for now image dims must be divisable by block size");
                return null;
            }
            numberOfBlocksPerDimension[i] = img.dimension(i) / (long)blockDimensions[i];
            numberOfBlocks = (int)((long)numberOfBlocks * numberOfBlocksPerDimension[i]);
        }
        ArrayList<Integer> allTheBlocks = new ArrayList<Integer>(numberOfBlocks);
        for (int i = 0; i < numberOfBlocks; ++i) {
            allTheBlocks.add(new Integer(i));
        }
        Collections.shuffle(allTheBlocks, new Random());
        Cursor cursor = img.cursor();
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        long[] dim = new long[img.numDimensions()];
        img.dimensions(dim);
        Img randomStack = imgFactory.create(dim, (Object)((RealType)img.firstElement()).createVariable());
        while (cursor.hasNext()) {
            cursor.fwd();
            RealType realType = (RealType)cursor.get();
        }
        return randomStack;
    }

    protected double calculatePearson() {
        Cursor cursor1 = this.img1.cursor();
        Cursor cursor2 = this.img2.cursor();
        double mean1 = this.getImageMean(this.img1);
        double mean2 = this.getImageMean(this.img2);
        long startTime = System.currentTimeMillis();
        double pearson = this.calculatePearson(cursor1, mean1, cursor2, mean2);
        long finishTime = System.currentTimeMillis();
        long elapsed = finishTime - startTime;
        IJ.log((String)("mean of ch1: " + mean1 + " mean of ch2: " + mean2));
        IJ.log((String)("Pearson's Coefficient " + pearson));
        IJ.log((String)("That took: " + elapsed + " ms"));
        return pearson;
    }

    protected double calculatePearson(Cursor<T> cursor1, double mean1, Cursor<T> cursor2, double mean2) {
        double pearsonDenominator = 0.0;
        double ch1diffSquaredSum = 0.0;
        double ch2diffSquaredSum = 0.0;
        while (cursor1.hasNext() && cursor2.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            RealType type1 = (RealType)cursor1.get();
            double ch1diff = type1.getRealDouble() - mean1;
            RealType type2 = (RealType)cursor2.get();
            double ch2diff = type2.getRealDouble() - mean2;
            pearsonDenominator += ch1diff * ch2diff;
            ch1diffSquaredSum += ch1diff * ch1diff;
            ch2diffSquaredSum += ch2diff * ch2diff;
        }
        double pearsonNumerator = Math.sqrt(ch1diffSquaredSum * ch2diffSquaredSum);
        return pearsonDenominator / pearsonNumerator;
    }

    protected double getImageMean(Img<T> img) {
        double sum = 0.0;
        Cursor cursor = img.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            RealType type = (RealType)cursor.get();
            sum += type.getRealDouble();
        }
        return sum / (double)ImageStatistics.getNumPixels(img);
    }
}

