/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss.Gauss;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.roi.RectangleRegionOfInterest;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.algorithms.PearsonsCorrelation;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.gadgets.Statistics;
import sc.fiji.coloc.results.ResultHandler;

public class CostesSignificanceTest<T extends RealType<T> & NativeType<T>>
extends Algorithm<T> {
    protected double[] psfRadius = new double[3];
    boolean showShuffledImages = false;
    int nrRandomizations;
    Img<T> smoothedShuffledImage;
    PearsonsCorrelation<T> pearsonsCorrelation;
    List<Double> shuffledPearsonsResults;
    int shuffledPearsonsNotLessOriginal = 0;
    double shuffledMean = 0.0;
    double shuffledStdDerivation = 0.0;
    double costesPValue;
    protected final int maxErrorRetries = 3;

    public CostesSignificanceTest(PearsonsCorrelation<T> pc, int psfRadiusInPixels, int nrRandomizations, boolean showShuffledImages) {
        super("Costes significance test");
        this.pearsonsCorrelation = pc;
        Arrays.fill(this.psfRadius, (double)psfRadiusInPixels);
        this.nrRandomizations = nrRandomizations;
        this.showShuffledImages = showShuffledImages;
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        long[] dimensions = container.getMaskBBSize();
        int nrDimensions = dimensions.length;
        int nrBlocksPerImage = 1;
        long[] nrBlocksPerDimension = new long[3];
        for (int i = 0; i < nrDimensions; ++i) {
            nrBlocksPerDimension[i] = (long)((double)dimensions[i] / this.psfRadius[i]);
            if ((double)dimensions[i] % this.psfRadius[i] != 0.0) {
                int n = i;
                nrBlocksPerDimension[n] = nrBlocksPerDimension[n] + 1L;
            }
            nrBlocksPerImage = (int)((long)nrBlocksPerImage * nrBlocksPerDimension[i]);
        }
        double[] floatOffset = new double[img1.numDimensions()];
        long[] longOffset = container.getMaskBBOffset();
        for (int i = 0; i < longOffset.length; ++i) {
            floatOffset[i] = longOffset[i];
        }
        double[] floatDimensions = new double[nrDimensions];
        for (int i = 0; i < nrDimensions; ++i) {
            floatDimensions[i] = dimensions[i];
        }
        ArrayList<IterableInterval<T>> blockIntervals = new ArrayList<IterableInterval<T>>(nrBlocksPerImage);
        ExtendedRandomAccessibleInterval infiniteImg = Views.extendMirrorSingle(img1);
        this.generateBlocks((RandomAccessible<T>)infiniteImg, (List<IterableInterval<T>>)blockIntervals, floatOffset, floatDimensions);
        ArrayList<Cursor> inputBlocks = new ArrayList<Cursor>(nrBlocksPerImage);
        ArrayList<Cursor> outputBlocks = new ArrayList<Cursor>(nrBlocksPerImage);
        for (IterableInterval iterableInterval : blockIntervals) {
            inputBlocks.add(iterableInterval.localizingCursor());
            outputBlocks.add(iterableInterval.localizingCursor());
        }
        RealType zero = (RealType)((RealType)img1.randomAccess().get()).createVariable();
        zero.setZero();
        long[] lArray = new long[img1.numDimensions()];
        img1.dimensions(lArray);
        ArrayImgFactory factory = new ArrayImgFactory();
        Img shuffledImage = factory.create(lArray, (Object)((RealType)img1.randomAccess().get()).createVariable());
        ExtendedRandomAccessibleInterval infiniteShuffledImage = Views.extendValue((RandomAccessibleInterval)shuffledImage, (Type)zero);
        double[] smoothingPsfRadius = new double[nrDimensions];
        for (int i = 0; i < nrDimensions; ++i) {
            smoothingPsfRadius[i] = this.psfRadius[i];
        }
        int retries = 0;
        this.shuffledPearsonsResults = new ArrayList<Double>();
        for (int i = 0; i < this.nrRandomizations; ++i) {
            Collections.shuffle(inputBlocks);
            RandomAccess output = infiniteShuffledImage.randomAccess();
            if (container.getMaskType() == DataContainer.MaskType.Irregular) {
                Cursor siCursor = shuffledImage.cursor();
                while (siCursor.hasNext()) {
                    siCursor.fwd();
                    output.setPosition((Localizable)siCursor);
                    ((RealType)output.get()).setZero();
                }
            }
            for (int j = 0; j < inputBlocks.size(); ++j) {
                Cursor inputCursor = (Cursor)inputBlocks.get(j);
                Cursor outputCursor = (Cursor)outputBlocks.get(j);
                while (inputCursor.hasNext() && outputCursor.hasNext()) {
                    inputCursor.fwd();
                    outputCursor.fwd();
                    output.setPosition((Localizable)outputCursor);
                    ((RealType)output.get()).set((Type)inputCursor.get());
                }
                inputCursor.reset();
                outputCursor.reset();
            }
            this.smoothedShuffledImage = Gauss.inFloat((double[])smoothingPsfRadius, (Img)shuffledImage);
            try {
                double pValue = this.pearsonsCorrelation.calculatePearsons(this.smoothedShuffledImage, img2, mask);
                this.shuffledPearsonsResults.add(pValue);
                continue;
            }
            catch (MissingPreconditionException e) {
                if (retries < 3) {
                    ++retries;
                    ++this.nrRandomizations;
                    continue;
                }
                throw new MissingPreconditionException("Maximum retries have been made (" + retries + "), but errors keep on coming: " + e.getMessage(), e);
            }
        }
        double originalVal = this.pearsonsCorrelation.getPearsonsCorrelationValue();
        this.calculateStatistics(this.shuffledPearsonsResults, originalVal);
    }

    protected void generateBlocks(RandomAccessible<T> img, List<IterableInterval<T>> blockList, double[] offset, double[] size) throws MissingPreconditionException {
        int nrDimensions = img.numDimensions();
        if (nrDimensions == 2) {
            this.generateBlocksXY(img, blockList, offset, size);
        } else if (nrDimensions == 3) {
            double z;
            double depth = size[2];
            double originalZ = offset[2];
            for (z = this.psfRadius[2]; z <= depth; z += this.psfRadius[2]) {
                offset[2] = originalZ + z - this.psfRadius[2];
                this.generateBlocksXY(img, blockList, offset, size);
            }
            if (z > depth) {
                offset[2] = originalZ + z - this.psfRadius[2];
                this.generateBlocksXY(img, blockList, offset, size);
            }
            offset[2] = originalZ;
        } else {
            throw new MissingPreconditionException("Currently only 2D and 3D images are supported.");
        }
    }

    protected void generateBlocksXY(RandomAccessible<T> img, List<IterableInterval<T>> blockList, double[] offset, double[] size) {
        double y;
        double height = size[1];
        double originalY = offset[1];
        for (y = this.psfRadius[1]; y <= height; y += this.psfRadius[1]) {
            offset[1] = originalY + y - this.psfRadius[1];
            this.generateBlocksX(img, blockList, offset, size);
        }
        if (y > height) {
            offset[1] = originalY + y - this.psfRadius[1];
            this.generateBlocksX(img, blockList, offset, size);
        }
        offset[1] = originalY;
    }

    protected void generateBlocksX(RandomAccessible<T> img, List<IterableInterval<T>> blockList, double[] offset, double[] size) {
        IterableInterval roiInterval;
        RectangleRegionOfInterest roi;
        double x;
        double width = size[0];
        double originalX = offset[0];
        for (x = this.psfRadius[0]; x <= width; x += this.psfRadius[0]) {
            offset[0] = originalX + x - this.psfRadius[0];
            roi = new RectangleRegionOfInterest((double[])offset.clone(), (double[])this.psfRadius.clone());
            roiInterval = roi.getIterableIntervalOverROI(img);
            blockList.add(roiInterval);
        }
        if (x > width) {
            offset[0] = originalX + x - this.psfRadius[0];
            roi = new RectangleRegionOfInterest((double[])offset.clone(), (double[])this.psfRadius.clone());
            roiInterval = roi.getIterableIntervalOverROI(img);
            blockList.add(roiInterval);
        }
        offset[0] = originalX;
    }

    protected void calculateStatistics(List<Double> compareValues, double originalVal) {
        this.shuffledPearsonsNotLessOriginal = 0;
        int iterations = this.shuffledPearsonsResults.size();
        double compareSum = 0.0;
        for (Double shuffledVal : this.shuffledPearsonsResults) {
            double diff = shuffledVal - originalVal;
            if (diff > -1.0E-5) {
                ++this.shuffledPearsonsNotLessOriginal;
            }
            compareSum += shuffledVal.doubleValue();
        }
        this.shuffledMean = compareSum / (double)iterations;
        this.shuffledStdDerivation = Statistics.stdDeviation(compareValues);
        this.costesPValue = Statistics.phi(originalVal, this.shuffledMean, this.shuffledStdDerivation);
        if (this.costesPValue > 1.0) {
            this.costesPValue = 1.0;
        } else if (this.costesPValue < 0.0) {
            this.costesPValue = 0.0;
        }
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        if (this.showShuffledImages) {
            handler.handleImage((RandomAccessibleInterval<T>)this.smoothedShuffledImage, "Smoothed & shuffled channel 1");
        }
        handler.handleValue("Costes P-Value", this.costesPValue, 2);
        handler.handleValue("Costes Shuffled Mean", this.shuffledMean, 2);
        handler.handleValue("Costes Shuffled Std.D.", this.shuffledStdDerivation, 2);
        double ratio = 0.0;
        if (this.shuffledPearsonsNotLessOriginal > 0) {
            ratio = (double)this.shuffledPearsonsResults.size() / (double)this.shuffledPearsonsNotLessOriginal;
        }
        handler.handleValue("Ratio of rand. Pearsons >= actual Pearsons value ", ratio, 2);
    }

    public double getCostesPValue() {
        return this.costesPValue;
    }

    public double getShuffledMean() {
        return this.shuffledMean;
    }

    public double getShuffledStdDerivation() {
        return this.shuffledStdDerivation;
    }

    public double getShuffledPearsonsNotLessOriginal() {
        return this.shuffledPearsonsNotLessOriginal;
    }
}

