/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.CaptureOverlayPanel;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.ViewUtils;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.scijava.plugin.Plugin;

public class CaptureOverlayAction
extends AbstractTMAction {
    public static final String NAME = "Capture overlay";
    public static final String KEY = "CAPTURE_OVERLAY";
    public static final String INFO_TEXT = "<html>If the current displayer is the HyperstackDisplayer, this action <br>will capture the TrackMate overlay with current display settings. <br>That is: a new RGB stack will be created (careful with large data) where <br>each frame contains a RGB snapshot of the TrackMate display. <p>It can take long since we pause between each frame to ensure the whole <br>overlay is redrawn. The current zoom is taken into account. <br>Also, make sure nothing is moved over the image while capturing. </html>";
    private static int firstFrame = -1;
    private static int lastFrame = -1;
    private static boolean hideImage = false;
    private static boolean whiteBackground = false;

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame gui) {
        ImagePlus imp = trackmate.getSettings().imp;
        if (firstFrame < 0) {
            firstFrame = 1;
        }
        firstFrame = Math.max(firstFrame, 1);
        if (lastFrame < 0) {
            lastFrame = imp.getNFrames();
        }
        lastFrame = Math.min(lastFrame, imp.getNFrames());
        if (gui != null) {
            CaptureOverlayPanel panel = new CaptureOverlayPanel(firstFrame, lastFrame, hideImage, whiteBackground);
            int userInput = JOptionPane.showConfirmDialog(gui, panel, "Capture TrackMate overlay", 2, 3, Icons.TRACKMATE_ICON);
            if (userInput != 0) {
                return;
            }
            int first = panel.getFirstFrame();
            int last = panel.getLastFrame();
            firstFrame = Math.min(last, first);
            lastFrame = Math.max(last, first);
            firstFrame = Math.max(1, firstFrame);
            lastFrame = Math.min(imp.getNFrames(), lastFrame);
            hideImage = panel.isHideImage();
            whiteBackground = panel.isWhiteBackground();
        }
        if (hideImage) {
            ImagePlus imp2 = ViewUtils.makeEmptyImagePlus(imp.getWidth(), imp.getHeight(), imp.getNSlices(), imp.getNFrames(), TMUtils.getSpatialCalibration(imp));
            if (whiteBackground) {
                ImageProcessor ip = imp2.getProcessor();
                ip.invertLut();
                if (imp2.getStackSize() > 1) {
                    imp2.getStack().setColorModel(ip.getColorModel());
                }
                imp2.updateAndRepaintWindow();
            }
            HyperStackDisplayer displayer = new HyperStackDisplayer(trackmate.getModel(), new SelectionModel(trackmate.getModel()), imp2, displaySettings);
            displayer.render();
            ImagePlus capture = CaptureOverlayAction.capture(imp2, firstFrame, lastFrame, this.logger);
            imp2.close();
            capture.show();
        } else {
            ImagePlus capture = CaptureOverlayAction.capture(trackmate, firstFrame, lastFrame, this.logger);
            capture.show();
        }
    }

    public static ImagePlus capture(TrackMate trackmate, int first, int last, Logger logger) {
        ImagePlus imp = trackmate.getSettings().imp;
        return CaptureOverlayAction.capture(imp, first, last, logger);
    }

    public static ImagePlus capture(ImagePlus imp, int first, int last, Logger log) {
        Logger logger = null == log ? Logger.VOID_LOGGER : log;
        int firstFrame = Math.max(1, Math.min(last, first));
        int lastFrame = Math.min(imp.getNFrames(), Math.max(last, first));
        logger.log("Capturing TrackMate overlay from frame " + firstFrame + " to " + lastFrame + ".\n");
        Rectangle bounds = imp.getCanvas().getBounds();
        int width = bounds.width;
        int height = bounds.height;
        int nCaptures = lastFrame - firstFrame + 1;
        ImageStack stack = new ImageStack(width, height);
        int channel = imp.getChannel();
        int slice = imp.getSlice();
        imp.getCanvas().hideZoomIndicator(true);
        for (int frame = firstFrame; frame <= lastFrame; ++frame) {
            logger.setProgress((float)(frame - firstFrame) / (float)nCaptures);
            imp.setPositionWithoutUpdate(channel, slice, frame);
            BufferedImage bi = new BufferedImage(width, height, 2);
            imp.getCanvas().paint(bi.getGraphics());
            ColorProcessor cp = new ColorProcessor((Image)bi);
            int index = imp.getStackIndex(channel, slice, frame);
            stack.addSlice(imp.getImageStack().getSliceLabel(index), (ImageProcessor)cp);
        }
        imp.getCanvas().hideZoomIndicator(false);
        ImagePlus capture = new ImagePlus("TrackMate capture of " + imp.getShortTitle(), stack);
        CaptureOverlayAction.transferCalibration(imp, capture);
        logger.log(" done.\n");
        logger.setProgress(0.0);
        return capture;
    }

    private static final void transferCalibration(ImagePlus from, ImagePlus to) {
        Calibration fc = from.getCalibration();
        Calibration tc = to.getCalibration();
        tc.setUnit(fc.getUnit());
        tc.setTimeUnit(fc.getTimeUnit());
        tc.frameInterval = fc.frameInterval;
        double mag = from.getCanvas().getMagnification();
        tc.pixelWidth = fc.pixelWidth / mag;
        tc.pixelHeight = fc.pixelHeight / mag;
        tc.pixelDepth = fc.pixelDepth;
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return CaptureOverlayAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return CaptureOverlayAction.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new CaptureOverlayAction();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.CAMERA_ICON;
        }

        @Override
        public String getName() {
            return CaptureOverlayAction.NAME;
        }
    }
}

