/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.autonaming;

import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.action.autonaming.AutoNamingController;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Frame;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class AutoNamingAction
extends AbstractTMAction {
    public static final String INFO_TEXT = "<html>Rename individual spots based on auto-naming rules. All spot names are changed. There is no undo.</html>";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        AutoNamingController controller = new AutoNamingController(trackmate, this.logger);
        controller.show();
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        public static final String NAME = "Spot auto-naming";
        public static final String KEY = "AUTO_NAMING";

        @Override
        public String getInfoText() {
            return AutoNamingAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return KEY;
        }

        @Override
        public TrackMateAction create() {
            return new AutoNamingAction();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.PENCIL_ICON;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

