/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.fit;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.action.fit.AbstractSpotFitter;
import fiji.plugin.trackmate.detection.DetectionUtils;
import ij.ImagePlus;
import net.imglib2.Point;
import net.imglib2.util.Util;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.Pair;

public class SpotGaussianFitter2DFixedRadius
extends AbstractSpotFitter {
    public SpotGaussianFitter2DFixedRadius(ImagePlus imp, int channel) {
        super(imp, channel);
        assert (DetectionUtils.is2D(imp));
    }

    @Override
    public void process(Iterable<Spot> spots, Logger logger) {
        super.process(spots, logger);
    }

    @Override
    public void fit(Spot spot) {
        int frame = spot.getFeature("FRAME").intValue();
        double sigma = spot.getFeature("RADIUS") / Math.sqrt(2.0);
        double pixelSigma = sigma / this.calibration[0];
        double x0 = spot.getDoublePosition(0) / this.calibration[0];
        double y0 = spot.getDoublePosition(1) / this.calibration[1];
        long span = (long)Math.ceil(2.0 * pixelSigma) + 1L;
        AbstractSpotFitter.Observation obs = this.gatherObservationData(new Point(new long[]{Math.round(x0), Math.round(y0)}), new long[]{span, span}, frame);
        SpotGaussianFitter2DFixedRadius.clipBackground(obs);
        double b = 1.0 / (2.0 * pixelSigma * pixelSigma);
        MyGaussian2D gauss = new MyGaussian2D(obs.pos, b);
        double ampstart = Util.max((double[])obs.values);
        LeastSquaresProblem lsq = new LeastSquaresBuilder().start(new double[]{x0, y0, ampstart}).model((MultivariateJacobianFunction)gauss).parameterValidator((ParameterValidator)gauss).target(obs.values).lazyEvaluation(false).maxEvaluations(1000).maxIterations(1000).build();
        try {
            LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(lsq);
            RealVector fit = optimum.getPoint();
            double fitX = fit.getEntry(0) * this.calibration[0];
            double fitY = fit.getEntry(1) * this.calibration[1];
            spot.putFeature("POSITION_X", fitX);
            spot.putFeature("POSITION_Y", fitY);
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    private static class MyGaussian2D
    implements MultivariateJacobianFunction,
    ParameterValidator {
        private final long[][] pos;
        private final double b;

        public MyGaussian2D(long[][] pos, double b) {
            this.pos = pos;
            this.b = b;
        }

        public Pair<RealVector, RealMatrix> value(RealVector point) {
            double x0 = point.getEntry(0);
            double y0 = point.getEntry(1);
            double A = point.getEntry(2);
            double[] vals = new double[this.pos[0].length];
            double[][] grad = new double[this.pos[0].length][3];
            for (int i = 0; i < vals.length; ++i) {
                long x = this.pos[0][i];
                long y = this.pos[1][i];
                double dx = (double)x - x0;
                double dy = (double)y - y0;
                double sumSq = dx * dx + dy * dy;
                double E = Math.exp(-this.b * sumSq);
                vals[i] = A * E;
                grad[i][0] = A * this.b * E * 2.0 * dx;
                grad[i][1] = A * this.b * E * 2.0 * dy;
                grad[i][2] = E;
            }
            ArrayRealVector out = new ArrayRealVector(vals);
            Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(grad, false);
            return new Pair((Object)out, (Object)jacobian);
        }

        public RealVector validate(RealVector params) {
            params.setEntry(2, Math.abs(params.getEntry(2)));
            return params;
        }
    }
}

