/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.HessianDetector;
import fiji.plugin.trackmate.detection.LogDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.HessianDetectorConfigurationPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.Map;
import net.imagej.ImgPlusMetadata;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class HessianDetectorFactory<T extends RealType<T> & NativeType<T>>
extends LogDetectorFactory<T> {
    public static final String DETECTOR_KEY = "HESSIAN_DETECTOR";
    public static final String NAME = "Hessian detector";
    public static final String INFO_TEXT = "<html>This detector is based on computing the determinant of the <br>Hessian matrix of the image to detector bright blobs.  <p>It can be configured with a different spots size in XY and Z. <br>It can also return a normalized quality value, scaled from 0 <br>to 1 for the spots of each time-point.<p>As discussed in Mikolajczyk et al.(2005), this detector has <br>a better edge response elimination than the LoG detector and is <br>suitable for detect spots in images with many strong edges.</html>";

    @Override
    public SpotDetector<T> getDetector(Interval interval, int frame) {
        double radiusXY = (Double)this.settings.get("RADIUS");
        double radiusZ = (Double)this.settings.get("RADIUS_Z");
        double thresholdQuality = (Double)this.settings.get("THRESHOLD");
        boolean doSubpixel = (Boolean)this.settings.get("DO_SUBPIXEL_LOCALIZATION");
        boolean normalize = (Boolean)this.settings.get("NORMALIZE");
        double[] calibration = TMUtils.getSpatialCalibration((ImgPlusMetadata)this.img);
        RandomAccessibleInterval imFrame = this.prepareFrameImg(frame);
        HessianDetector detector = new HessianDetector(Views.extendMirrorDouble(imFrame), interval, calibration, radiusXY, radiusZ, thresholdQuality, normalize, doSubpixel);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public boolean forbidMultithreading() {
        return true;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public boolean checkSettings(Map<String, Object> lSettings) {
        boolean ok = true;
        StringBuilder errorHolder = new StringBuilder();
        ok &= TMUtils.checkParameter(lSettings, "TARGET_CHANNEL", Integer.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "RADIUS", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "RADIUS_Z", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "THRESHOLD", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "DO_SUBPIXEL_LOCALIZATION", Boolean.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "NORMALIZE", Boolean.class, errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("TARGET_CHANNEL");
        mandatoryKeys.add("RADIUS");
        mandatoryKeys.add("RADIUS_Z");
        mandatoryKeys.add("THRESHOLD");
        mandatoryKeys.add("DO_SUBPIXEL_LOCALIZATION");
        mandatoryKeys.add("NORMALIZE");
        if (!(ok &= TMUtils.checkMapKeys(lSettings, mandatoryKeys, null, errorHolder))) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean marshall(Map<String, Object> lSettings, Element element) {
        boolean ok;
        StringBuilder errorHolder = new StringBuilder();
        boolean bl = ok = IOUtils.writeTargetChannel(lSettings, element, errorHolder) && IOUtils.writeRadius(lSettings, element, errorHolder) && IOUtils.writeAttribute(lSettings, element, "RADIUS_Z", Double.class, errorHolder) && IOUtils.writeThreshold(lSettings, element, errorHolder) && IOUtils.writeAttribute(lSettings, element, "NORMALIZE", Boolean.class, errorHolder) && IOUtils.writeDoSubPixel(lSettings, element, errorHolder);
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> lSettings) {
        lSettings.clear();
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = true;
        ok &= IOUtils.readDoubleAttribute(element, lSettings, "RADIUS", errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, lSettings, "RADIUS_Z", errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, lSettings, "THRESHOLD", errorHolder);
        ok &= IOUtils.readBooleanAttribute(element, lSettings, "DO_SUBPIXEL_LOCALIZATION", errorHolder);
        ok &= IOUtils.readBooleanAttribute(element, lSettings, "NORMALIZE", errorHolder);
        if (!(ok &= IOUtils.readIntegerAttribute(element, lSettings, "TARGET_CHANNEL", errorHolder))) {
            this.errorMessage = errorHolder.toString();
            return false;
        }
        return this.checkSettings(lSettings);
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new HessianDetectorConfigurationPanel(lSettings, model, INFO_TEXT, NAME);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        Map<String, Object> lSettings = super.getDefaultSettings();
        lSettings.remove("DO_MEDIAN_FILTERING");
        lSettings.put("RADIUS_Z", 8.0);
        lSettings.put("NORMALIZE", false);
        return lSettings;
    }

    @Override
    public HessianDetectorFactory<T> copy() {
        return new HessianDetectorFactory<T>();
    }
}

