/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.BasicStroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.xy.XYDataset;

public abstract class ModelDataset
extends AbstractDataset
implements XYDataset,
Iterable<DataItem> {
    private static final long serialVersionUID = 1L;
    protected final Model model;
    protected final List<String> yFeatures;
    protected final String xFeature;
    protected final DisplaySettings ds;
    protected final SelectionModel selectionModel;
    protected final BasicStroke stroke;
    protected final BasicStroke selectionStroke;
    private final Map<String, Integer> featureNameMap;

    public ModelDataset(Model model, SelectionModel selectionModel, DisplaySettings ds, String xFeature, List<String> yFeatures) {
        this.model = model;
        this.selectionModel = selectionModel;
        this.xFeature = xFeature;
        this.yFeatures = yFeatures;
        this.ds = ds;
        this.stroke = new BasicStroke((float)ds.getLineThickness(), 1, 1);
        this.selectionStroke = new BasicStroke((float)ds.getSelectionLineThickness(), 1, 1);
        this.featureNameMap = new HashMap<String, Integer>();
        for (int i = 0; i < yFeatures.size(); ++i) {
            this.featureNameMap.put(this.getSeriesKey(i).toString(), i);
        }
        if (selectionModel != null) {
            selectionModel.addSelectionChangeListener(l -> this.fireDatasetChanged());
        }
        if (ds != null) {
            ds.listeners().add(() -> this.fireDatasetChanged());
        }
    }

    public String getXFeature() {
        return this.xFeature;
    }

    public int getSeriesCount() {
        return this.yFeatures.size();
    }

    public int indexOf(Comparable seriesKey) {
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (!this.getSeriesKey(i).equals(seriesKey)) continue;
            return i;
        }
        return -1;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public double getXValue(int series, int item) {
        Number val = this.getX(series, item);
        if (val == null) {
            return Double.NaN;
        }
        return val.doubleValue();
    }

    public double getYValue(int series, int item) {
        Number val = this.getY(series, item);
        if (val == null) {
            return Double.NaN;
        }
        return val.doubleValue();
    }

    public abstract String getItemLabel(int var1);

    public abstract void setItemLabel(int var1, String var2);

    public abstract XYItemRenderer getRenderer();

    @Override
    public Iterator<DataItem> iterator() {
        return new Iterator<DataItem>(){
            int item = 0;

            @Override
            public boolean hasNext() {
                return this.item < ModelDataset.this.getItemCount(0);
            }

            @Override
            public DataItem next() {
                return new DataItem(this.item++);
            }
        };
    }

    public final class DataItem {
        public final int item;

        private DataItem(int item) {
            this.item = item;
        }

        public Double get(String feature) {
            if (ModelDataset.this.xFeature.equals(feature)) {
                return (Double)ModelDataset.this.getX(0, this.item);
            }
            Integer series = (Integer)ModelDataset.this.featureNameMap.get(feature);
            if (series == null) {
                return null;
            }
            return (Double)ModelDataset.this.getY(series, this.item);
        }
    }
}

