/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.CategoryJComboBox;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FeatureDisplaySelector {
    private static final List<String> FEATURES_WITHOUT_MIN_MAX = Arrays.asList("UNIFORM_COLOR", "RANDOM_COLOR", "TRACK_INDEX", "MANUAL_EDGE_COLOR", "MANUAL_SPOT_COLOR");
    private final Model model;
    private final Settings settings;
    private final DisplaySettings ds;

    public FeatureDisplaySelector(Model model, Settings settings, DisplaySettings displaySettings) {
        this.model = model;
        this.settings = settings;
        this.ds = displaySettings;
    }

    public JPanel createSelectorForSpots() {
        return this.createSelectorFor(DisplaySettings.TrackMateObject.SPOTS);
    }

    public JPanel createSelectorForTracks() {
        return this.createSelectorFor(DisplaySettings.TrackMateObject.TRACKS);
    }

    public JPanel createSelectorFor(DisplaySettings.TrackMateObject target) {
        return new FeatureSelectorPanel(target);
    }

    private DisplaySettings.TrackMateObject getColorByType(DisplaySettings.TrackMateObject target) {
        return target == DisplaySettings.TrackMateObject.SPOTS ? this.ds.getSpotColorByType() : this.ds.getTrackColorByType();
    }

    private String getColorByFeature(DisplaySettings.TrackMateObject target) {
        return target == DisplaySettings.TrackMateObject.SPOTS ? this.ds.getSpotColorByFeature() : this.ds.getTrackColorByFeature();
    }

    private double getMin(DisplaySettings.TrackMateObject target) {
        return target == DisplaySettings.TrackMateObject.SPOTS ? this.ds.getSpotMin() : this.ds.getTrackMin();
    }

    private double getMax(DisplaySettings.TrackMateObject target) {
        return target == DisplaySettings.TrackMateObject.SPOTS ? this.ds.getSpotMax() : this.ds.getTrackMax();
    }

    private double[] autoMinMax(DisplaySettings.TrackMateObject target) {
        DisplaySettings.TrackMateObject type = this.getColorByType(target);
        String feature = this.getColorByFeature(target);
        return FeatureUtils.autoMinMax(this.model, type, feature);
    }

    public static final CategoryJComboBox<DisplaySettings.TrackMateObject, String> createComboBoxSelector(Model model, Settings settings) {
        List<DisplaySettings.TrackMateObject> categoriesIn = Arrays.asList(DisplaySettings.TrackMateObject.values());
        LinkedHashMap<DisplaySettings.TrackMateObject, Set<String>> features = new LinkedHashMap<DisplaySettings.TrackMateObject, Set<String>>(categoriesIn.size());
        HashMap<DisplaySettings.TrackMateObject, String> categoryNames = new HashMap<DisplaySettings.TrackMateObject, String>(categoriesIn.size());
        HashMap<String, String> featureNames = new HashMap<String, String>();
        block6: for (DisplaySettings.TrackMateObject category : categoriesIn) {
            Map<String, String> featureKeys = FeatureUtils.collectFeatureKeys(category, model, settings);
            features.put(category, featureKeys.keySet());
            featureNames.putAll(featureKeys);
            switch (category) {
                case SPOTS: {
                    categoryNames.put(DisplaySettings.TrackMateObject.SPOTS, "Spot features:");
                    continue block6;
                }
                case EDGES: {
                    categoryNames.put(DisplaySettings.TrackMateObject.EDGES, "Edge features:");
                    continue block6;
                }
                case TRACKS: {
                    categoryNames.put(DisplaySettings.TrackMateObject.TRACKS, "Track features:");
                    continue block6;
                }
                case DEFAULT: {
                    categoryNames.put(DisplaySettings.TrackMateObject.DEFAULT, "Default:");
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown object type: " + (Object)((Object)category));
        }
        CategoryJComboBox<DisplaySettings.TrackMateObject, String> cb = new CategoryJComboBox<DisplaySettings.TrackMateObject, String>(features, featureNames, categoryNames);
        if (null != model) {
            model.addModelChangeListener(event -> {
                if (event.getEventID() == 9) {
                    LinkedHashMap<DisplaySettings.TrackMateObject, Set<String>> features2 = new LinkedHashMap<DisplaySettings.TrackMateObject, Set<String>>(categoriesIn.size());
                    HashMap<DisplaySettings.TrackMateObject, String> categoryNames2 = new HashMap<DisplaySettings.TrackMateObject, String>(categoriesIn.size());
                    HashMap<String, String> featureNames2 = new HashMap<String, String>();
                    block6: for (DisplaySettings.TrackMateObject category : categoriesIn) {
                        Map<String, String> featureKeys = FeatureUtils.collectFeatureKeys(category, model, settings);
                        features2.put(category, featureKeys.keySet());
                        featureNames2.putAll(featureKeys);
                        switch (category) {
                            case SPOTS: {
                                categoryNames2.put(DisplaySettings.TrackMateObject.SPOTS, "Spot features:");
                                continue block6;
                            }
                            case EDGES: {
                                categoryNames2.put(DisplaySettings.TrackMateObject.EDGES, "Edge features:");
                                continue block6;
                            }
                            case TRACKS: {
                                categoryNames2.put(DisplaySettings.TrackMateObject.TRACKS, "Track features:");
                                continue block6;
                            }
                            case DEFAULT: {
                                categoryNames2.put(DisplaySettings.TrackMateObject.DEFAULT, "Default:");
                                continue block6;
                            }
                        }
                        throw new IllegalArgumentException("Unknown object type: " + (Object)((Object)category));
                    }
                    cb.setItems(features2, featureNames2, categoryNames2);
                }
            });
        }
        return cb;
    }

    public static void main(String[] args) {
        GuiUtils.setSystemLookAndFeel();
        DisplaySettings ds = DisplaySettings.defaultStyle().copy();
        FeatureDisplaySelector featureSelector = new FeatureDisplaySelector(FeatureUtils.DUMMY_MODEL, null, ds);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(featureSelector.createSelectorForSpots());
        frame.pack();
        frame.setVisible(true);
    }

    private final class CanvasColor
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final DisplaySettings.TrackMateObject target;

        public CanvasColor(DisplaySettings.TrackMateObject target) {
            this.target = target;
        }

        @Override
        public void paint(Graphics g) {
            String maxStr;
            String minStr;
            String dataMaxStr;
            String dataMinStr;
            boolean isInt;
            String feature = FeatureDisplaySelector.this.getColorByFeature(this.target);
            if (!this.isEnabled() || FEATURES_WITHOUT_MIN_MAX.contains(feature)) {
                g.setColor(this.getParent().getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                return;
            }
            double[] autoMinMax = FeatureDisplaySelector.this.autoMinMax(this.target);
            double min = FeatureDisplaySelector.this.getMin(this.target);
            double max = FeatureDisplaySelector.this.getMax(this.target);
            double dataMin = autoMinMax[0];
            double dataMax = autoMinMax[1];
            Colormap colormap = FeatureDisplaySelector.this.ds.getColormap();
            double alphaMin = (min - dataMin) / (dataMax - dataMin);
            double alphaMax = (max - dataMin) / (dataMax - dataMin);
            int width = this.getWidth();
            int height = this.getHeight();
            for (int i = 0; i < width; ++i) {
                double alpha = (double)i / (double)(width - 1);
                double beta = (alpha - alphaMin) / (alphaMax - alphaMin);
                g.setColor(colormap.getPaint(beta));
                g.drawLine(i, 0, i, height);
            }
            g.setColor(Color.WHITE);
            g.setFont(Fonts.SMALL_FONT.deriveFont(1));
            FontMetrics fm = g.getFontMetrics();
            switch (FeatureDisplaySelector.this.getColorByType(this.target)) {
                case TRACKS: {
                    isInt = FeatureDisplaySelector.this.model.getFeatureModel().getTrackFeatureIsInt().get(feature);
                    break;
                }
                case EDGES: {
                    isInt = FeatureDisplaySelector.this.model.getFeatureModel().getEdgeFeatureIsInt().get(feature);
                    break;
                }
                case SPOTS: {
                    isInt = FeatureDisplaySelector.this.model.getFeatureModel().getSpotFeatureIsInt().get(feature);
                    break;
                }
                default: {
                    isInt = false;
                }
            }
            if (isInt) {
                dataMinStr = String.format("%d", (int)dataMin);
                dataMaxStr = String.format("%d", (int)dataMax);
                minStr = String.format("%d", (int)min);
                maxStr = String.format("%d", (int)max);
            } else {
                dataMinStr = String.format("%.1f", dataMin);
                dataMaxStr = String.format("%.1f", dataMax);
                minStr = String.format("%.1f", min);
                maxStr = String.format("%.1f", max);
            }
            int dataMinStrWidth = fm.stringWidth(dataMinStr);
            int dataMaxStrWidth = fm.stringWidth(dataMaxStr);
            int minStrWidth = fm.stringWidth(minStr);
            int maxStrWidth = fm.stringWidth(maxStr);
            g.setColor(GuiUtils.textColorForBackground(colormap.getPaint(-alphaMin / (alphaMax - alphaMin))));
            g.drawString(dataMinStr, 1, height / 2 + fm.getHeight() / 2);
            g.setColor(GuiUtils.textColorForBackground(colormap.getPaint((1.0 - alphaMin) / (alphaMax - alphaMin))));
            g.drawString(dataMaxStr, width - dataMaxStrWidth - 1, height / 2 + fm.getHeight() / 2);
            int iMin = (int)((double)(width - 1) * (min - dataMin) / (dataMax - dataMin));
            int iMax = (int)((double)(width - 1) * (max - dataMin) / (dataMax - dataMin));
            if (iMin - minStrWidth > dataMinStrWidth + 2 && iMin < width - dataMaxStrWidth - 2) {
                g.setColor(GuiUtils.textColorForBackground(colormap.getPaint(0.0)));
                g.drawString(minStr, iMin - minStrWidth, height / 2);
            }
            if (iMax + maxStrWidth < width - dataMaxStrWidth - 2 && iMax > dataMinStrWidth + 2) {
                g.setColor(GuiUtils.textColorForBackground(colormap.getPaint(1.0)));
                g.drawString(maxStr, iMax, height / 2);
            }
        }
    }

    private class FeatureSelectorPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public FeatureSelectorPanel(DisplaySettings.TrackMateObject target) {
            GridBagLayout layout = new GridBagLayout();
            layout.rowHeights = new int[]{0, 0, 20};
            layout.columnWeights = new double[]{0.0, 1.0};
            layout.rowWeights = new double[]{0.0, 0.0, 0.0};
            this.setLayout(layout);
            JLabel lblColorBy = new JLabel("Color " + target.toString() + " by:");
            lblColorBy.setFont(Fonts.SMALL_FONT);
            GridBagConstraints gbcLblColorBy = new GridBagConstraints();
            gbcLblColorBy.anchor = 13;
            gbcLblColorBy.fill = 3;
            gbcLblColorBy.insets = new Insets(0, 0, 5, 5);
            gbcLblColorBy.gridx = 0;
            gbcLblColorBy.gridy = 0;
            this.add((Component)lblColorBy, gbcLblColorBy);
            CategoryJComboBox<DisplaySettings.TrackMateObject, String> cmbboxColor = FeatureDisplaySelector.createComboBoxSelector(FeatureDisplaySelector.this.model, FeatureDisplaySelector.this.settings);
            GridBagConstraints gbcCmbboxColor = new GridBagConstraints();
            gbcCmbboxColor.fill = 2;
            gbcCmbboxColor.gridx = 1;
            gbcCmbboxColor.gridy = 0;
            this.add(cmbboxColor, gbcCmbboxColor);
            JPanel panelColorMap = new JPanel();
            GridBagConstraints gbcPanelColorMap = new GridBagConstraints();
            gbcPanelColorMap.gridwidth = 2;
            gbcPanelColorMap.fill = 1;
            gbcPanelColorMap.gridx = 0;
            gbcPanelColorMap.gridy = 2;
            this.add((Component)panelColorMap, gbcPanelColorMap);
            final CanvasColor canvasColor = new CanvasColor(target);
            panelColorMap.setLayout(new BorderLayout());
            panelColorMap.add((Component)canvasColor, "Center");
            JPanel panelMinMax = new JPanel();
            GridBagConstraints gbcPanelMinMax = new GridBagConstraints();
            gbcPanelMinMax.gridwidth = 2;
            gbcPanelMinMax.fill = 1;
            gbcPanelMinMax.gridx = 0;
            gbcPanelMinMax.gridy = 1;
            gbcPanelMinMax.insets = new Insets(2, 0, 0, 0);
            this.add((Component)panelMinMax, gbcPanelMinMax);
            panelMinMax.setLayout(new BoxLayout(panelMinMax, 0));
            JButton btnAutoMinMax = new JButton("auto");
            btnAutoMinMax.setFont(Fonts.SMALL_FONT);
            panelMinMax.add(btnAutoMinMax);
            panelMinMax.add(Box.createHorizontalGlue());
            JLabel lblMin = new JLabel("min");
            lblMin.setFont(Fonts.SMALL_FONT);
            panelMinMax.add(lblMin);
            JFormattedTextField ftfMin = new JFormattedTextField(FeatureDisplaySelector.this.getMin(target));
            ftfMin.setMaximumSize(new Dimension(180, Integer.MAX_VALUE));
            GuiUtils.selectAllOnFocus(ftfMin);
            ftfMin.setHorizontalAlignment(0);
            ftfMin.setFont(Fonts.SMALL_FONT);
            ftfMin.setColumns(7);
            panelMinMax.add(ftfMin);
            panelMinMax.add(Box.createHorizontalGlue());
            JLabel lblMax = new JLabel("max");
            lblMax.setFont(Fonts.SMALL_FONT);
            panelMinMax.add(lblMax);
            JFormattedTextField ftfMax = new JFormattedTextField(FeatureDisplaySelector.this.getMax(target));
            ftfMax.setMaximumSize(new Dimension(180, Integer.MAX_VALUE));
            GuiUtils.selectAllOnFocus(ftfMax);
            ftfMax.setHorizontalAlignment(0);
            ftfMax.setFont(Fonts.SMALL_FONT);
            ftfMax.setColumns(7);
            panelMinMax.add(ftfMax);
            final JPopupMenu colormapMenu = new JPopupMenu();
            List<Colormap> cmaps = Colormap.getAvailableLUTs();
            Iterator<Colormap> iterator = cmaps.iterator();
            while (iterator.hasNext()) {
                Colormap cmap;
                final Colormap lut = cmap = iterator.next();
                JMenuItem item = new JMenuItem();
                item.setPreferredSize(new Dimension(100, 20));
                BoxLayout itemlayout = new BoxLayout(item, 2);
                item.setLayout(itemlayout);
                item.add(new JLabel(lut.getName()));
                item.add(Box.createHorizontalGlue());
                item.add(new JComponent(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void paint(Graphics g) {
                        int width = this.getWidth();
                        int height = this.getHeight();
                        for (int i = 0; i < width; ++i) {
                            double beta = (double)i / (double)(width - 1);
                            g.setColor(lut.getPaint(beta));
                            g.drawLine(i, 0, i, height);
                        }
                        g.setColor(this.getParent().getBackground());
                        g.drawRect(0, 0, width, height);
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        return new Dimension(50, 20);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.getMaximumSize();
                    }
                });
                item.addActionListener(e -> FeatureDisplaySelector.this.ds.setColormap(cmap));
                colormapMenu.add(item);
            }
            canvasColor.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    colormapMenu.show(canvasColor, e.getX(), e.getY());
                }
            });
            switch (target) {
                case SPOTS: {
                    cmbboxColor.addActionListener(e -> {
                        FeatureDisplaySelector.this.ds.setSpotColorBy((DisplaySettings.TrackMateObject)((Object)((Object)cmbboxColor.getSelectedCategory())), (String)cmbboxColor.getSelectedItem());
                        boolean hasMinMax = !FEATURES_WITHOUT_MIN_MAX.contains(FeatureDisplaySelector.this.getColorByFeature(target));
                        ftfMin.setEnabled(hasMinMax);
                        ftfMax.setEnabled(hasMinMax);
                        btnAutoMinMax.setEnabled(hasMinMax);
                        if (hasMinMax && !((String)cmbboxColor.getSelectedItem()).equals(FeatureDisplaySelector.this.getColorByFeature(target))) {
                            double[] minmax = FeatureDisplaySelector.this.autoMinMax(target);
                            ftfMin.setValue(minmax[0]);
                            ftfMax.setValue(minmax[1]);
                        }
                    });
                    PropertyChangeListener pcl = e -> {
                        double v1 = ((Number)ftfMin.getValue()).doubleValue();
                        double v2 = ((Number)ftfMax.getValue()).doubleValue();
                        FeatureDisplaySelector.this.ds.setSpotMinMax(v1, v2);
                    };
                    ftfMin.addPropertyChangeListener("value", pcl);
                    ftfMax.addPropertyChangeListener("value", pcl);
                    break;
                }
                case TRACKS: {
                    cmbboxColor.addActionListener(e -> {
                        FeatureDisplaySelector.this.ds.setTrackColorBy((DisplaySettings.TrackMateObject)((Object)((Object)cmbboxColor.getSelectedCategory())), (String)cmbboxColor.getSelectedItem());
                        boolean hasMinMax = !FEATURES_WITHOUT_MIN_MAX.contains(FeatureDisplaySelector.this.getColorByFeature(target));
                        ftfMin.setEnabled(hasMinMax);
                        ftfMax.setEnabled(hasMinMax);
                        btnAutoMinMax.setEnabled(hasMinMax);
                        if (hasMinMax && !((String)cmbboxColor.getSelectedItem()).equals(FeatureDisplaySelector.this.getColorByFeature(target))) {
                            double[] minmax = FeatureDisplaySelector.this.autoMinMax(target);
                            ftfMin.setValue(minmax[0]);
                            ftfMax.setValue(minmax[1]);
                        }
                    });
                    PropertyChangeListener pcl = e -> {
                        double v1 = ((Number)ftfMin.getValue()).doubleValue();
                        double v2 = ((Number)ftfMax.getValue()).doubleValue();
                        FeatureDisplaySelector.this.ds.setTrackMinMax(v1, v2);
                    };
                    ftfMin.addPropertyChangeListener("value", pcl);
                    ftfMax.addPropertyChangeListener("value", pcl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected selector target: " + (Object)((Object)target));
                }
            }
            btnAutoMinMax.addActionListener(e -> {
                double[] minmax = FeatureDisplaySelector.this.autoMinMax(target);
                ftfMin.setValue(minmax[0]);
                ftfMax.setValue(minmax[1]);
            });
            FeatureDisplaySelector.this.ds.listeners().add(() -> {
                ftfMin.setValue(FeatureDisplaySelector.this.getMin(target));
                ftfMax.setValue(FeatureDisplaySelector.this.getMax(target));
                String feature = FeatureDisplaySelector.this.getColorByFeature(target);
                if (feature != cmbboxColor.getSelectedItem()) {
                    cmbboxColor.setSelectedItem(feature);
                }
                canvasColor.repaint();
            });
            cmbboxColor.setSelectedItem(FeatureDisplaySelector.this.getColorByFeature(target));
        }
    }
}

