/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.tracking.TrackerKeys;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class LAPUtils {
    private static final Border RED_BORDER = new LineBorder(Color.RED);
    public static final String XML_ELEMENT_NAME_LINKING = "Linking";
    public static final String XML_ELEMENT_NAME_GAP_CLOSING = "GapClosing";
    public static final String XML_ELEMENT_NAME_MERGING = "TrackMerging";
    public static final String XML_ELEMENT_NAME_SPLITTING = "TrackSplitting";
    public static final String XML_ELEMENT_NAME_FEATURE_PENALTIES = "FeaturePenalties";

    public static final boolean addFeaturePenaltyToSettings(Map<?, ?> motherMap, Object motherKey, Object childKey, Object childValue, StringBuilder errorHolder) {
        Object childObj = motherMap.get(motherKey);
        if (null == childObj) {
            errorHolder.append("Mother map has no value for key " + motherKey + ".\n");
            return false;
        }
        if (!(childObj instanceof Map)) {
            errorHolder.append("Value for key " + motherKey + " is not a map.\n");
            return false;
        }
        Map childMap = (Map)childObj;
        childMap.put(childKey, childValue);
        return true;
    }

    public static final Map<String, Object> getDefaultSegmentSettingsMap() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("ALLOW_GAP_CLOSING", true);
        settings.put("MAX_FRAME_GAP", 2);
        settings.put("GAP_CLOSING_MAX_DISTANCE", 15.0);
        settings.put("GAP_CLOSING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_GAP_CLOSING_FEATURE_PENALTIES));
        settings.put("ALLOW_TRACK_SPLITTING", false);
        settings.put("SPLITTING_MAX_DISTANCE", 15.0);
        settings.put("SPLITTING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_SPLITTING_FEATURE_PENALTIES));
        settings.put("ALLOW_TRACK_MERGING", false);
        settings.put("MERGING_MAX_DISTANCE", 15.0);
        settings.put("MERGING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_MERGING_FEATURE_PENALTIES));
        settings.put("BLOCKING_VALUE", Double.POSITIVE_INFINITY);
        settings.put("ALTERNATIVE_LINKING_COST_FACTOR", 1.05);
        settings.put("CUTOFF_PERCENTILE", 0.9);
        return settings;
    }

    public static String echoFeaturePenalties(Map<String, Double> featurePenalties) {
        String str = "";
        if (featurePenalties.isEmpty()) {
            str = str + "    - no feature penalties\n";
        } else {
            str = str + "    - with feature penalties:\n";
            for (String feature : featurePenalties.keySet()) {
                str = str + "      - " + feature.toString() + ": weight = " + String.format("%.1f", featurePenalties.get(feature)) + '\n';
            }
        }
        return str;
    }

    public static final double computeLinkingCostFor(Spot s0, Spot s1, double distanceCutOff, double blockingValue, Map<String, Double> featurePenalties) {
        double d2 = s0.squareDistanceTo(s1);
        if (d2 > distanceCutOff * distanceCutOff) {
            return blockingValue;
        }
        double penalty = 1.0;
        for (String feature : featurePenalties.keySet()) {
            double ndiff = s0.normalizeDiffTo(s1, feature);
            if (Double.isNaN(ndiff)) continue;
            double factor = featurePenalties.get(feature);
            penalty += factor * 1.5 * ndiff;
        }
        return d2 * penalty * penalty;
    }

    public static final boolean checkSettingsValidity(Map<String, Object> settings, StringBuilder errorHolder, boolean linking) {
        if (null == settings) {
            errorHolder.append("Settings map is null.\n");
            return false;
        }
        boolean ok = true;
        if (linking) {
            ok &= TMUtils.checkParameter(settings, "LINKING_MAX_DISTANCE", Double.class, errorHolder);
            ok &= LAPUtils.checkFeatureMap(settings, "LINKING_FEATURE_PENALTIES", errorHolder);
        }
        ok &= TMUtils.checkParameter(settings, "ALLOW_GAP_CLOSING", Boolean.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "GAP_CLOSING_MAX_DISTANCE", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "MAX_FRAME_GAP", Integer.class, errorHolder);
        ok &= LAPUtils.checkFeatureMap(settings, "GAP_CLOSING_FEATURE_PENALTIES", errorHolder);
        ok &= TMUtils.checkParameter(settings, "ALLOW_TRACK_SPLITTING", Boolean.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "SPLITTING_MAX_DISTANCE", Double.class, errorHolder);
        ok &= LAPUtils.checkFeatureMap(settings, "SPLITTING_FEATURE_PENALTIES", errorHolder);
        ok &= TMUtils.checkParameter(settings, "ALLOW_TRACK_MERGING", Boolean.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "MERGING_MAX_DISTANCE", Double.class, errorHolder);
        ok &= LAPUtils.checkFeatureMap(settings, "MERGING_FEATURE_PENALTIES", errorHolder);
        ok &= TMUtils.checkParameter(settings, "CUTOFF_PERCENTILE", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "ALTERNATIVE_LINKING_COST_FACTOR", Double.class, errorHolder);
        ok &= TMUtils.checkParameter(settings, "BLOCKING_VALUE", Double.class, errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        if (linking) {
            mandatoryKeys.add("LINKING_MAX_DISTANCE");
        }
        mandatoryKeys.add("ALLOW_GAP_CLOSING");
        mandatoryKeys.add("GAP_CLOSING_MAX_DISTANCE");
        mandatoryKeys.add("MAX_FRAME_GAP");
        mandatoryKeys.add("ALLOW_TRACK_SPLITTING");
        mandatoryKeys.add("SPLITTING_MAX_DISTANCE");
        mandatoryKeys.add("ALLOW_TRACK_MERGING");
        mandatoryKeys.add("MERGING_MAX_DISTANCE");
        mandatoryKeys.add("ALTERNATIVE_LINKING_COST_FACTOR");
        mandatoryKeys.add("CUTOFF_PERCENTILE");
        mandatoryKeys.add("BLOCKING_VALUE");
        ArrayList<String> optionalKeys = new ArrayList<String>();
        if (linking) {
            optionalKeys.add("LINKING_FEATURE_PENALTIES");
        }
        optionalKeys.add("GAP_CLOSING_FEATURE_PENALTIES");
        optionalKeys.add("SPLITTING_FEATURE_PENALTIES");
        optionalKeys.add("MERGING_FEATURE_PENALTIES");
        optionalKeys.add("KALMAN_SEARCH_RADIUS");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, optionalKeys, errorHolder);
    }

    public static final boolean checkFeatureMap(Map<String, Object> map, String featurePenaltiesKey, StringBuilder errorHolder) {
        Object obj = map.get(featurePenaltiesKey);
        if (null == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            errorHolder.append("Feature penalty map is not of the right class. Expected a Map, got a " + obj.getClass().getName() + ".\n");
            return false;
        }
        boolean ok = true;
        Map fpMap = (Map)obj;
        Set fpKeys = fpMap.keySet();
        for (Object fpKey : fpKeys) {
            Object fpVal;
            if (!(fpKey instanceof String)) {
                ok = false;
                errorHolder.append("One key (" + fpKey.toString() + ") in the map is not of the right class.\nExpected String, got " + fpKey.getClass().getName() + ".\n");
            }
            if ((fpVal = fpMap.get(fpKey)) instanceof Double) continue;
            ok = false;
            errorHolder.append("The value for key " + fpVal.toString() + " in the map is not of the right class.\nExpected Double, got " + fpVal.getClass().getName() + ".\n");
        }
        return ok;
    }

    public static final void echoMatrix(double[][] m) {
        int nlines = m.length;
        if (nlines == 0) {
            System.out.println("0x0 empty matrix");
            return;
        }
        int nrows = m[0].length;
        System.out.print("L\\C\t");
        for (int j = 0; j < nrows; ++j) {
            System.out.print(String.format("%7d: ", j));
        }
        System.out.println();
        for (int i = 0; i < nlines; ++i) {
            System.out.print(i + ":\t");
            for (int j = 0; j < nrows; ++j) {
                double val = m[i][j];
                if (val > 8.988465674311579E307) {
                    System.out.print("     B   ");
                    continue;
                }
                System.out.print(String.format("%7.1f  ", val));
            }
            System.out.println();
        }
    }

    public static final void displayCostMatrix(double[][] costs, final int nSegments, final int nSpots, double blockingValue, final int[][] solutions) {
        int width = costs.length;
        int height = costs[0].length;
        System.out.println(String.format("Displaying table with: Width = %d, Height = %d", width, height));
        DefaultTableModel model = new DefaultTableModel(height, width){
            private static final long serialVersionUID = 1L;

            @Override
            public String getColumnName(int i) {
                if (i < nSegments) {
                    return "Ts " + i;
                }
                if (i < nSegments + nSpots) {
                    return "Sp " + (i - nSegments);
                }
                return "\u00f8";
            }
        };
        JTable debugTable = new JTable(model){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JLabel label = (JLabel)super.prepareRenderer(renderer, row, col);
                if (col < nSegments) {
                    if (row < nSegments) {
                        label.setForeground(Color.BLUE);
                    } else if (row < nSegments + nSpots) {
                        label.setForeground(Color.GREEN.darker());
                    } else {
                        label.setForeground(Color.BLACK);
                    }
                } else if (col < nSegments + nSpots) {
                    if (row < nSegments) {
                        label.setForeground(Color.CYAN.darker());
                    } else if (row < nSegments + nSpots) {
                        label.setForeground(Color.RED.darker());
                    } else {
                        label.setForeground(Color.BLACK);
                    }
                } else if (row < nSegments + nSpots) {
                    label.setForeground(Color.BLACK);
                } else {
                    label.setForeground(Color.GRAY);
                }
                label.setHorizontalAlignment(0);
                label.setBorder(null);
                for (int i = 0; i < solutions.length; ++i) {
                    int srow = solutions[i][0];
                    int scol = solutions[i][1];
                    if (row != srow || col != scol) continue;
                    label.setBorder(RED_BORDER);
                }
                return label;
            }
        };
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                double val = costs[row][col];
                String txt = val == blockingValue ? "B" : String.format("%.1f", val);
                model.setValueAt(txt, row, col);
            }
        }
        AbstractTableModel rhm = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;
            String[] headers;
            {
                int i;
                this.headers = new String[2 * (nSegments + nSpots)];
                for (i = 0; i < nSegments; ++i) {
                    this.headers[i] = "Te " + i;
                }
                for (i = nSegments; i < nSegments + nSpots; ++i) {
                    this.headers[i] = "Sp " + (i - nSegments);
                }
                for (i = nSegments + nSpots; i < this.headers.length; ++i) {
                    this.headers[i] = "\u00f8";
                }
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return this.headers.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return this.headers[rowIndex];
            }
        };
        JTable rowHeader = new JTable(rhm);
        Dimension d = rowHeader.getPreferredScrollableViewportSize();
        d.width = rowHeader.getPreferredSize().width;
        rowHeader.setPreferredScrollableViewportSize(d);
        debugTable.setAutoResizeMode(0);
        for (int i = 0; i < debugTable.getColumnCount(); ++i) {
            debugTable.getColumnModel().getColumn(i).setPreferredWidth(50);
        }
        JScrollPane scrollPane = new JScrollPane(debugTable);
        debugTable.setFillsViewportHeight(true);
        scrollPane.setRowHeaderView(rowHeader);
        JFrame frame = new JFrame("Segment cost matrix");
        frame.getContentPane().add(scrollPane);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public static void echoSolutions(int[][] solutions) {
        for (int i = 0; i < solutions.length; ++i) {
            System.out.println(String.format("%3d: %3d -> %3d", i, solutions[i][0], solutions[i][1]));
        }
    }

    public static void displayLAPresults(int[][] array) {
        int i;
        Object[][] data = new Object[array.length][array[0].length];
        Object[] headers = new Object[array[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = "" + array[i][j];
            }
        }
        for (i = 0; i < headers.length; ++i) {
            headers[i] = "" + i;
        }
        JTable table = new JTable(data, headers);
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        JFrame frame = new JFrame("Hungarian solution");
        frame.getContentPane().add(scrollPane);
        frame.setVisible(true);
    }
}

