/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.util.SpotNeighborhood;
import net.imglib2.Cursor;
import net.imglib2.type.numeric.RealType;

public class SpotNeighborhoodCursor<T extends RealType<T>>
implements Cursor<T> {
    protected final Cursor<T> cursor;
    protected final double[] calibration;
    protected final long[] center;
    private final long[] pos;

    public SpotNeighborhoodCursor(SpotNeighborhood<T> sn) {
        this.cursor = sn.neighborhood.cursor();
        this.calibration = sn.calibration;
        this.center = sn.center;
        this.pos = new long[this.cursor.numDimensions()];
        this.reset();
    }

    public void getRelativePosition(double[] position) {
        this.cursor.localize(this.pos);
        for (int d = 0; d < this.center.length; ++d) {
            position[d] = this.calibration[d] * (double)(this.pos[d] - this.center[d]);
        }
    }

    public double getDistanceSquared() {
        this.cursor.localize(this.pos);
        double sum = 0.0;
        double dx = 0.0;
        for (int d = 0; d < this.pos.length; ++d) {
            dx = this.calibration[d] * (double)(this.pos[d] - this.center[d]);
            sum += dx * dx;
        }
        return sum;
    }

    public double getTheta() {
        if (this.numDimensions() < 2) {
            return 0.0;
        }
        double dx = this.calibration[2] * (this.cursor.getDoublePosition(2) - (double)this.center[2]);
        return Math.acos(dx / Math.sqrt(this.getDistanceSquared()));
    }

    public double getPhi() {
        double dx = this.calibration[0] * (this.cursor.getDoublePosition(0) - (double)this.center[0]);
        double dy = this.calibration[1] * (this.cursor.getDoublePosition(1) - (double)this.center[1]);
        return Math.atan2(dy, dx);
    }

    public void localize(float[] position) {
        this.cursor.localize(position);
    }

    public void localize(double[] position) {
        this.cursor.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.cursor.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.cursor.getDoublePosition(d);
    }

    public int numDimensions() {
        return this.cursor.numDimensions();
    }

    public T get() {
        return (T)((RealType)this.cursor.get());
    }

    public Cursor<T> copy() {
        return this.cursor.copy();
    }

    public void jumpFwd(long steps) {
        this.cursor.jumpFwd(steps);
    }

    public void fwd() {
        this.cursor.fwd();
    }

    public void reset() {
        this.cursor.reset();
    }

    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    public T next() {
        return (T)((RealType)this.cursor.next());
    }

    public void remove() {
        this.cursor.remove();
    }

    public void localize(int[] position) {
        this.cursor.localize(position);
    }

    public void localize(long[] position) {
        this.cursor.localize(position);
    }

    public int getIntPosition(int d) {
        return this.cursor.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.cursor.getLongPosition(d);
    }
}

