/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.FastMatrixN;
import math3d.Point3d;

public class Bookstein {
    protected Point3d[] points;
    protected Bookstein1d bx;
    protected Bookstein1d by;
    protected Bookstein1d bz;
    public double x;
    public double y;
    public double z;

    public Bookstein(Point3d[] orig, Point3d[] trans) {
        int j;
        int i;
        if (orig.length != trans.length) {
            throw new RuntimeException("orig has " + orig.length + " points, but trans has " + trans.length + "???");
        }
        this.points = orig;
        int N = orig.length + 4;
        double[][] matrix = new double[N][N];
        for (i = 0; i < orig.length; ++i) {
            for (j = i + 1; j < orig.length; ++j) {
                matrix[i][j] = Bookstein.U(orig[i].distanceTo(orig[j]));
            }
            matrix[i][orig.length] = 1.0;
            matrix[i][orig.length + 1] = orig[i].x;
            matrix[i][orig.length + 2] = orig[i].y;
            matrix[i][orig.length + 3] = orig[i].z;
            for (j = i + 1; j < N; ++j) {
                matrix[j][i] = matrix[i][j];
            }
        }
        FastMatrixN.invert(matrix);
        this.bx = new Bookstein1d();
        this.by = new Bookstein1d();
        this.bz = new Bookstein1d();
        this.bx.w = new double[orig.length];
        this.by.w = new double[orig.length];
        this.bz.w = new double[orig.length];
        for (i = 0; i < orig.length; ++i) {
            for (j = 0; j < orig.length; ++j) {
                int n = i;
                this.bx.w[n] = this.bx.w[n] + trans[j].x * matrix[i][j];
                int n2 = i;
                this.by.w[n2] = this.by.w[n2] + trans[j].y * matrix[i][j];
                int n3 = i;
                this.bz.w[n3] = this.bz.w[n3] + trans[j].z * matrix[i][j];
            }
        }
        for (int j2 = 0; j2 < orig.length; ++j2) {
            this.bx.a1 += trans[j2].x * matrix[orig.length][j2];
            this.bx.ax += trans[j2].x * matrix[orig.length + 1][j2];
            this.bx.ay += trans[j2].x * matrix[orig.length + 2][j2];
            this.bx.az += trans[j2].x * matrix[orig.length + 3][j2];
            this.by.a1 += trans[j2].y * matrix[orig.length][j2];
            this.by.ax += trans[j2].y * matrix[orig.length + 1][j2];
            this.by.ay += trans[j2].y * matrix[orig.length + 2][j2];
            this.by.az += trans[j2].y * matrix[orig.length + 3][j2];
            this.bz.a1 += trans[j2].z * matrix[orig.length][j2];
            this.bz.ax += trans[j2].z * matrix[orig.length + 1][j2];
            this.bz.ay += trans[j2].z * matrix[orig.length + 2][j2];
            this.bz.az += trans[j2].z * matrix[orig.length + 3][j2];
        }
    }

    public void apply(Point3d p) {
        this.x = this.bx.evalInit(p);
        this.y = this.by.evalInit(p);
        this.z = this.bz.evalInit(p);
        for (int i = 0; i < this.points.length; ++i) {
            double u = Bookstein.U(p.distanceTo(this.points[i]));
            this.x += this.bx.w[i] * u;
            this.y += this.by.w[i] * u;
            this.z += this.bz.w[i] * u;
        }
    }

    public static double U(double r) {
        if (r <= 0.0) {
            return 0.0;
        }
        return r * r * Math.log(r);
    }

    public class Bookstein1d {
        double a1;
        double ax;
        double ay;
        double az;
        public double[] w;

        public double evalInit(Point3d p) {
            return this.a1 + this.ax * p.x + this.ay * p.y + this.az * p.z;
        }

        public double eval(Point3d p) {
            double res = this.evalInit(p);
            for (int i = 0; i < Bookstein.this.points.length; ++i) {
                res += this.w[i] * Bookstein.U(p.distanceTo(Bookstein.this.points[i]));
            }
            return res;
        }
    }
}

