/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import java.util.Iterator;
import java.util.Vector;
import vib.app.gui.Console;
import vib.app.module.ModuleListener;
import vib.app.module.State;

public abstract class Module {
    protected Console console;
    protected static Vector listeners = new Vector();
    private static boolean exception = false;

    public abstract String getName();

    protected abstract String getMessage();

    protected abstract void run(State var1, int var2);

    protected boolean runsOnce() {
        return false;
    }

    public void runOnOneImage(State state, int index) {
        this.console = Console.instance();
        try {
            this.run(state, index);
        }
        catch (Exception e) {
            if (!exception) {
                exception = true;
                this.exceptionOccurred(index);
            }
            throw new RuntimeException("Exception in " + this.getName(), e);
        }
        this.finished(index);
    }

    public void runOnAllImages(State state) {
        for (int i = 0; i < state.getImageCount(); ++i) {
            this.runOnOneImage(state, i);
        }
    }

    public void runOnAllImagesAndTemplate(State state) {
        for (int i = -1; i < state.getImageCount(); ++i) {
            this.runOnOneImage(state, i);
        }
    }

    public void prereqsDone(State state, int index) {
        String message = this.getMessage();
        if (!this.runsOnce()) {
            message = message + ": " + state.getBaseName(index) + " (" + (index + 1) + "/" + state.getImageCount() + ")";
        }
        this.console.append(message);
    }

    public void finished(int index) {
        Iterator it = Module.listeners();
        while (it.hasNext()) {
            ((ModuleListener)it.next()).moduleFinished(this, index);
        }
    }

    public void exceptionOccurred(int index) {
        Iterator it = Module.listeners();
        while (it.hasNext()) {
            ((ModuleListener)it.next()).exceptionOccurred(this, index);
        }
    }

    public static void addModuleListener(ModuleListener l) {
        listeners.add(l);
    }

    public static Iterator listeners() {
        return listeners.iterator();
    }
}

