/*
 * Decompiled with CFR 0.152.
 */
package vib.transforms;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import math3d.Point3d;
import vib.transforms.BoundsInclusive;
import vib.transforms.Threshold;
import vib.transforms.Transform;

public class OrderedTransformations {
    private ArrayList<Transform> listOfTransforms = new ArrayList();

    public Object clone() {
        ArrayList clonedList;
        OrderedTransformations result = new OrderedTransformations();
        result.listOfTransforms = clonedList = (ArrayList)this.listOfTransforms.clone();
        return result;
    }

    public void addFirst(Transform t) {
        this.listOfTransforms.add(0, t);
    }

    public void addLast(Transform t) {
        this.listOfTransforms.add(t);
    }

    public void addFirst(OrderedTransformations o) {
        int j = 0;
        for (Transform f : o.listOfTransforms) {
            this.listOfTransforms.add(j, f);
            ++j;
        }
    }

    public void addLast(OrderedTransformations o) {
        for (Transform f : o.listOfTransforms) {
            this.addLast(f);
        }
    }

    public int number() {
        return this.listOfTransforms.size();
    }

    public Transform getComponentTransform(int i) {
        return this.listOfTransforms.get(i);
    }

    public String toString() {
        String result = "";
        int j = 0;
        for (Transform f : this.listOfTransforms) {
            result = result + "Transformation " + j + " is:\n";
            result = result + f.toStringIndented("   ");
            ++j;
        }
        return result;
    }

    public void reduce() {
        Iterator<Transform> i = this.listOfTransforms.iterator();
        while (i.hasNext()) {
            Transform f = i.next();
            if (!f.isIdentity()) continue;
            i.remove();
        }
        ArrayList<Transform> newList = new ArrayList<Transform>();
        Transform last = null;
        i = this.listOfTransforms.iterator();
        while (i.hasNext()) {
            if (last == null) {
                last = i.next();
            }
            while (i.hasNext()) {
                Transform next = i.next();
                Transform compositionResult = last.composeWith(next);
                if (compositionResult == null) {
                    newList.add(last);
                    last = next;
                    break;
                }
                last = compositionResult;
            }
            if (i.hasNext() || last == null) continue;
            newList.add(last);
        }
        this.listOfTransforms = newList;
    }

    public OrderedTransformations inverse() {
        ArrayList<Transform> newList = new ArrayList<Transform>();
        ListIterator<Transform> i = this.listOfTransforms.listIterator();
        while (i.hasNext()) {
            i.next();
        }
        while (i.hasPrevious()) {
            Transform f = i.previous();
            Transform f_inverted = f.inverse();
            newList.add(f_inverted);
        }
        OrderedTransformations result = new OrderedTransformations();
        result.listOfTransforms = newList;
        return result;
    }

    public void apply(double x, double y, double z, double[] result) {
        for (Transform f : this.listOfTransforms) {
            f.apply(x, y, z, result);
            x = result[0];
            y = result[1];
            z = result[2];
        }
    }

    public double[] apply(double x, double y, double z) {
        double[] result = new double[3];
        for (Transform f : this.listOfTransforms) {
            f.apply(x, y, z, result);
            x = result[0];
            y = result[1];
            z = result[2];
        }
        return result;
    }

    public Point3d apply(Point3d p) {
        double[] result = this.apply(p.x, p.y, p.z);
        return new Point3d(result[0], result[1], result[2]);
    }

    public double scoreTransformation(ImagePlus image0, ImagePlus image1, int skipPixelsInTemplate) {
        return this.scoreTransformationReal(image0, image1, skipPixelsInTemplate, null);
    }

    public double scoreTransformation(ImagePlus image0, ImagePlus image1, BoundsInclusive boundsInclusive) {
        return this.scoreTransformationReal(image0, image1, 0, boundsInclusive);
    }

    public double scoreTransformation(ImagePlus image0, ImagePlus image1, int skipPixelsInTemplate, BoundsInclusive boundsInclusive) {
        return this.scoreTransformationReal(image0, image1, skipPixelsInTemplate, boundsInclusive);
    }

    public double scoreTransformationReal(ImagePlus image0, ImagePlus image1, int skipPixelsInTemplate, BoundsInclusive boundsInclusive) {
        OrderedTransformations invertedTransform = this.inverse();
        ImageStack stack0 = image0.getStack();
        ImageStack stack1 = image1.getStack();
        int d0 = stack0.getSize();
        int h0 = stack0.getHeight();
        int w0 = stack0.getWidth();
        int d1 = stack1.getSize();
        int h1 = stack1.getHeight();
        int w1 = stack1.getWidth();
        int xmin = 0;
        int ymin = 0;
        int zmin = 0;
        int xmax = w0 - 1;
        int ymax = h0 - 1;
        int zmax = d0 - 1;
        if (boundsInclusive != null) {
            xmin = boundsInclusive.xmin;
            ymin = boundsInclusive.ymin;
            zmin = boundsInclusive.zmin;
            xmax = boundsInclusive.xmax;
            ymax = boundsInclusive.ymax;
            zmax = boundsInclusive.zmax;
        }
        double[] transformedPoint = new double[3];
        long numberOfPixelsConsidered = 0L;
        long sumSquaredDifferences = 0L;
        for (int z = zmin; z <= zmax; z += 1 + skipPixelsInTemplate) {
            byte[] templatePixels = (byte[])stack0.getPixels(z + 1);
            for (int y = ymin; y <= ymax; y += 1 + skipPixelsInTemplate) {
                for (int x = xmin; x <= xmax; x += 1 + skipPixelsInTemplate) {
                    invertedTransform.apply(x, y, z, transformedPoint);
                    int x_in_domain = (int)transformedPoint[0];
                    int y_in_domain = (int)transformedPoint[1];
                    int z_in_domain = (int)transformedPoint[2];
                    int value_in_template = 0xFF & templatePixels[x + y * w0];
                    if (x_in_domain < 0 || x_in_domain >= w1 || y_in_domain < 0 || y_in_domain >= h1 || z_in_domain < 0 || z_in_domain >= d1) continue;
                    byte[] domainPixels = (byte[])stack1.getPixels(z_in_domain + 1);
                    int value_in_domain = 0xFF & domainPixels[x_in_domain + y_in_domain * w1];
                    int difference = value_in_domain - value_in_template;
                    sumSquaredDifferences += (long)(difference * difference);
                    ++numberOfPixelsConsidered;
                }
            }
        }
        return Math.sqrt((double)sumSquaredDifferences / (double)numberOfPixelsConsidered);
    }

    public double scoreTransformationThresholdedReal(ImagePlus image0, ImagePlus image1, Threshold threshold0, Threshold threshold1, int skipPixelsInTemplate, BoundsInclusive boundsInclusive) {
        OrderedTransformations invertedTransform = this.inverse();
        ImageStack stack0 = image0.getStack();
        ImageStack stack1 = image1.getStack();
        int d0 = stack0.getSize();
        int h0 = stack0.getHeight();
        int w0 = stack0.getWidth();
        int d1 = stack1.getSize();
        int h1 = stack1.getHeight();
        int w1 = stack1.getWidth();
        int xmin = 0;
        int ymin = 0;
        int zmin = 0;
        int xmax = w0 - 1;
        int ymax = h0 - 1;
        int zmax = d0 - 1;
        if (boundsInclusive != null) {
            xmin = boundsInclusive.xmin;
            ymin = boundsInclusive.ymin;
            zmin = boundsInclusive.zmin;
            xmax = boundsInclusive.xmax;
            ymax = boundsInclusive.ymax;
            zmax = boundsInclusive.zmax;
        }
        double[] transformedPoint = new double[3];
        long numberOfPixelsConsidered = 0L;
        long sumSquaredDifferences = 0L;
        for (int z = zmin; z <= zmax; z += 1 + skipPixelsInTemplate) {
            byte[] templatePixels = (byte[])stack0.getPixels(z + 1);
            for (int y = ymin; y <= ymax; y += 1 + skipPixelsInTemplate) {
                for (int x = xmin; x <= xmax; x += 1 + skipPixelsInTemplate) {
                    int value_in_domain;
                    invertedTransform.apply(x, y, z, transformedPoint);
                    int x_in_domain = (int)transformedPoint[0];
                    int y_in_domain = (int)transformedPoint[1];
                    int z_in_domain = (int)transformedPoint[2];
                    int value_in_template = 0xFF & templatePixels[x + y * w0];
                    if (value_in_template < threshold0.value) {
                        value_in_template = 0;
                    }
                    if (x_in_domain >= 0 && x_in_domain < w1 && y_in_domain >= 0 && y_in_domain < h1 && z_in_domain >= 0 && z_in_domain < d1) {
                        byte[] domainPixels = (byte[])stack1.getPixels(z_in_domain + 1);
                        value_in_domain = 0xFF & domainPixels[x_in_domain + y_in_domain * w1];
                        if (value_in_domain < threshold1.value) {
                            value_in_domain = 0;
                        }
                    } else {
                        value_in_domain = 0;
                    }
                    int difference = value_in_domain - value_in_template;
                    sumSquaredDifferences += (long)(difference * difference);
                    ++numberOfPixelsConsidered;
                }
            }
        }
        return Math.sqrt((double)sumSquaredDifferences / (double)numberOfPixelsConsidered);
    }

    public double scoreTransformationThresholded(ImagePlus image0, ImagePlus image1, Threshold threshold0, Threshold threshold1, BoundsInclusive boundsInclusive) {
        return this.scoreTransformationThresholdedReal(image0, image1, threshold0, threshold1, 0, boundsInclusive);
    }

    public double scoreTransformationThresholded(ImagePlus image0, ImagePlus image1, Threshold threshold0, Threshold threshold1) {
        return this.scoreTransformationThresholdedReal(image0, image1, threshold0, threshold1, 0, null);
    }

    public double scoreTransformationThresholded(ImagePlus image0, ImagePlus image1, Threshold threshold0, Threshold threshold1, int skipPixelsInTemplate) {
        return this.scoreTransformationThresholdedReal(image0, image1, threshold0, threshold1, skipPixelsInTemplate, null);
    }

    public ImagePlus createNewImageReal(ImagePlus image0, ImagePlus image1, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, boolean overlay) {
        int z;
        System.out.println("      createNewImageReal called with overlay: " + overlay);
        System.out.println("                                      image0: " + image0);
        System.out.println("                                      image1: " + image1);
        System.out.println("                                        xmin: " + xmin);
        System.out.println("                                        xmax: " + xmax);
        System.out.println("                                        ymin: " + ymin);
        System.out.println("                                        ymax: " + ymax);
        System.out.println("                                        zmin: " + zmin);
        System.out.println("                                        zmax: " + zmax);
        int widthNew = xmax - xmin + 1;
        int heightNew = ymax - ymin + 1;
        int depthNew = zmax - zmin + 1;
        assert (xmax >= xmin);
        assert (ymax >= ymin);
        assert (zmax >= zmin);
        assert (image1 != null);
        int width0 = -1;
        int height0 = -1;
        int depth0 = -1;
        ImageStack stack0 = null;
        if (image0 != null) {
            width0 = image0.getWidth();
            height0 = image0.getHeight();
            stack0 = image0.getStack();
            depth0 = stack0.getSize();
        }
        ImageStack stack1 = image1.getStack();
        int width1 = stack1.getWidth();
        int height1 = stack1.getHeight();
        int depth1 = stack1.getSize();
        assert (image0 != null || !overlay);
        if (image0 != null && image0.getType() != 0) {
            IJ.error((String)"OrderedTransformations.createNewImageReal() can onlybe used on 8 bit image, at the moment.");
            return null;
        }
        if (image1.getType() != 0) {
            IJ.error((String)"OrderedTransformations.createNewImageReal() can onlybe used on 8 bit image, at the moment.");
            return null;
        }
        ImageStack newStack = new ImageStack(widthNew, heightNew);
        boolean cacheImage = true;
        Object image1_data = null;
        if (cacheImage) {
            image1_data = new byte[depth1][];
            for (z = 0; z < depth1; ++z) {
                image1_data[z] = (byte[])stack1.getPixels(z + 1);
            }
        }
        OrderedTransformations invertedTransform = this.inverse();
        for (z = 0; z < depthNew; ++z) {
            int z_in_template = z + zmin;
            byte[] greenPixels = new byte[widthNew * heightNew];
            byte[] magentaPixels = null;
            byte[] magentaPixelsExpanded = null;
            if (overlay) {
                magentaPixelsExpanded = new byte[widthNew * heightNew];
                magentaPixels = z_in_template >= 0 && z_in_template < stack0.getSize() ? (byte[])stack0.getPixels(z_in_template + 1) : new byte[image0.getWidth() * image0.getHeight()];
            }
            double[] transformedPoint = new double[3];
            for (int y = 0; y < heightNew; ++y) {
                for (int x = 0; x < widthNew; ++x) {
                    int y_in_template = y + ymin;
                    int x_in_template = x + xmin;
                    invertedTransform.apply(x_in_template, y_in_template, z_in_template, transformedPoint);
                    int x_in_domain = (int)transformedPoint[0];
                    int y_in_domain = (int)transformedPoint[1];
                    int z_in_domain = (int)transformedPoint[2];
                    if (x_in_domain >= 0 && x_in_domain < width1 && y_in_domain >= 0 && y_in_domain < height1 && z_in_domain >= 0 && z_in_domain < depth1) {
                        if (cacheImage) {
                            greenPixels[x + y * widthNew] = image1_data[z_in_domain][x_in_domain + y_in_domain * width1];
                        } else {
                            byte[] pixels = (byte[])stack1.getPixels(z_in_domain + 1);
                            greenPixels[x + y * widthNew] = pixels[x_in_domain + y_in_domain * width1];
                        }
                    }
                    if (z_in_template >= 0 && z_in_template < depth0 && x_in_template >= 0 && x_in_template < width0 && y_in_template >= 0 && y_in_template < height0) {
                        magentaPixelsExpanded[x + y * widthNew] = magentaPixels[x_in_template + y_in_template * width0];
                    }
                    IJ.showProgress((double)((double)(z + 1) / (double)depthNew));
                }
            }
            if (overlay) {
                ColorProcessor cp = new ColorProcessor(widthNew, heightNew);
                cp.setRGB(magentaPixelsExpanded, greenPixels, magentaPixelsExpanded);
                newStack.addSlice(null, (ImageProcessor)cp);
                continue;
            }
            ByteProcessor bp = new ByteProcessor(widthNew, heightNew);
            bp.setPixels((Object)greenPixels);
            newStack.addSlice(null, (ImageProcessor)bp);
        }
        IJ.showProgress((double)1.0);
        ImagePlus impNew = overlay ? new ImagePlus("overlay of " + image0.getShortTitle() + " and transformed " + image1.getShortTitle(), newStack) : new ImagePlus("transformation of " + image1.getShortTitle(), newStack);
        if (image0 != null) {
            impNew.setCalibration(image0.getCalibration());
        }
        return impNew;
    }

    public ImagePlus createNewImage(ImagePlus image0, ImagePlus image1, boolean cropToTemplate) {
        int width0 = image0.getWidth();
        int width1 = image1.getWidth();
        int height0 = image0.getHeight();
        int height1 = image1.getHeight();
        int depth0 = image0.getStack().getSize();
        int depth1 = image1.getStack().getSize();
        if (cropToTemplate) {
            return this.createNewImageReal(image0, image1, 0, width0 - 1, 0, height0 - 1, 0, depth0 - 1, true);
        }
        Point3d corner0 = new Point3d(0.0, 0.0, 0.0);
        Point3d corner1 = new Point3d(0.0, 0.0, depth1 - 1);
        Point3d corner2 = new Point3d(0.0, height1 - 1, 0.0);
        Point3d corner3 = new Point3d(0.0, height1 - 1, depth1 - 1);
        Point3d corner4 = new Point3d(width1 - 1, 0.0, 0.0);
        Point3d corner5 = new Point3d(width1 - 1, 0.0, depth1 - 1);
        Point3d corner6 = new Point3d(width1 - 1, height1 - 1, 0.0);
        Point3d corner7 = new Point3d(width1 - 1, height1 - 1, depth1 - 1);
        Point3d corner0_transformed = this.apply(corner0);
        Point3d corner1_transformed = this.apply(corner1);
        Point3d corner2_transformed = this.apply(corner2);
        Point3d corner3_transformed = this.apply(corner3);
        Point3d corner4_transformed = this.apply(corner4);
        Point3d corner5_transformed = this.apply(corner5);
        Point3d corner6_transformed = this.apply(corner6);
        Point3d corner7_transformed = this.apply(corner7);
        double[] corner_xs = new double[]{corner0_transformed.x, corner1_transformed.x, corner2_transformed.x, corner3_transformed.x, corner4_transformed.x, corner5_transformed.x, corner6_transformed.x, corner7_transformed.x};
        double[] corner_ys = new double[]{corner0_transformed.y, corner1_transformed.y, corner2_transformed.y, corner3_transformed.y, corner4_transformed.y, corner5_transformed.y, corner6_transformed.y, corner7_transformed.y};
        double[] corner_zs = new double[]{corner0_transformed.z, corner1_transformed.z, corner2_transformed.z, corner3_transformed.z, corner4_transformed.z, corner5_transformed.z, corner6_transformed.z, corner7_transformed.z};
        Arrays.sort(corner_xs);
        Arrays.sort(corner_ys);
        Arrays.sort(corner_zs);
        double min_trans_corner_x = corner_xs[0];
        double min_trans_corner_y = corner_ys[0];
        double min_trans_corner_z = corner_zs[0];
        double max_trans_corner_x = corner_xs[7];
        double max_trans_corner_y = corner_ys[7];
        double max_trans_corner_z = corner_zs[7];
        int new_min_x_1 = (int)Math.floor(min_trans_corner_x);
        int new_min_y_1 = (int)Math.floor(min_trans_corner_y);
        int new_min_z_1 = (int)Math.floor(min_trans_corner_z);
        int new_max_x_1 = (int)Math.ceil(max_trans_corner_x);
        int new_max_y_1 = (int)Math.ceil(max_trans_corner_y);
        int new_max_z_1 = (int)Math.ceil(max_trans_corner_z);
        int width_mapped2 = new_max_x_1 - new_min_x_1 + 1;
        int height_mapped2 = new_max_y_1 - new_min_y_1 + 1;
        int depth_mapped2 = new_max_z_1 - new_min_z_1 + 1;
        int target_offset_x = 0;
        int target_offset_y = 0;
        int target_offset_z = 0;
        if (new_min_x_1 < 0) {
            target_offset_x = -new_min_x_1;
        }
        if (new_min_y_1 < 0) {
            target_offset_y = -new_min_y_1;
        }
        if (new_min_z_1 < 0) {
            target_offset_z = -new_min_z_1;
        }
        int widthNew = Math.max(width0, new_max_x_1 + 1) - Math.min(0, new_min_x_1);
        int heightNew = Math.max(height0, new_max_y_1 + 1) - Math.min(0, new_min_y_1);
        int depthNew = Math.max(depth0, new_max_z_1 + 1) - Math.min(0, new_min_z_1);
        return this.createNewImageReal(image0, image1, -target_offset_x, widthNew - target_offset_x, -target_offset_y, heightNew - target_offset_y, -target_offset_z, depthNew - target_offset_z, true);
    }

    public ImagePlus createNewImageSingle(ImagePlus image, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        return this.createNewImageReal(null, image, xmin, xmax, ymin, ymax, zmin, zmax, false);
    }

    public ImagePlus createNewImageSingle(ImagePlus image0, ImagePlus image1, boolean cropToTemplate) {
        int width0 = image0.getWidth();
        int width1 = image1.getWidth();
        int height0 = image0.getHeight();
        int height1 = image1.getHeight();
        int depth0 = image0.getStack().getSize();
        int depth1 = image1.getStack().getSize();
        boolean xmin = false;
        boolean xmax = false;
        boolean ymin = false;
        boolean ymax = false;
        boolean zmin = false;
        boolean zmax = false;
        if (cropToTemplate) {
            return this.createNewImageReal(null, image1, 0, width0 - 1, 0, height0 - 1, 0, depth0 - 1, false);
        }
        Point3d corner0 = new Point3d(0.0, 0.0, 0.0);
        Point3d corner1 = new Point3d(0.0, 0.0, depth1 - 1);
        Point3d corner2 = new Point3d(0.0, height1 - 1, 0.0);
        Point3d corner3 = new Point3d(0.0, height1 - 1, depth1 - 1);
        Point3d corner4 = new Point3d(width1 - 1, 0.0, 0.0);
        Point3d corner5 = new Point3d(width1 - 1, 0.0, depth1 - 1);
        Point3d corner6 = new Point3d(width1 - 1, height1 - 1, 0.0);
        Point3d corner7 = new Point3d(width1 - 1, height1 - 1, depth1 - 1);
        Point3d corner0_transformed = this.apply(corner0);
        Point3d corner1_transformed = this.apply(corner1);
        Point3d corner2_transformed = this.apply(corner2);
        Point3d corner3_transformed = this.apply(corner3);
        Point3d corner4_transformed = this.apply(corner4);
        Point3d corner5_transformed = this.apply(corner5);
        Point3d corner6_transformed = this.apply(corner6);
        Point3d corner7_transformed = this.apply(corner7);
        double[] corner_xs = new double[]{corner0_transformed.x, corner1_transformed.x, corner2_transformed.x, corner3_transformed.x, corner4_transformed.x, corner5_transformed.x, corner6_transformed.x, corner7_transformed.x};
        double[] corner_ys = new double[]{corner0_transformed.y, corner1_transformed.y, corner2_transformed.y, corner3_transformed.y, corner4_transformed.y, corner5_transformed.y, corner6_transformed.y, corner7_transformed.y};
        double[] corner_zs = new double[]{corner0_transformed.z, corner1_transformed.z, corner2_transformed.z, corner3_transformed.z, corner4_transformed.z, corner5_transformed.z, corner6_transformed.z, corner7_transformed.z};
        Arrays.sort(corner_xs);
        Arrays.sort(corner_ys);
        Arrays.sort(corner_zs);
        double min_trans_corner_x = corner_xs[0];
        double min_trans_corner_y = corner_ys[0];
        double min_trans_corner_z = corner_zs[0];
        double max_trans_corner_x = corner_xs[7];
        double max_trans_corner_y = corner_ys[7];
        double max_trans_corner_z = corner_zs[7];
        int new_min_x_1 = (int)Math.floor(min_trans_corner_x);
        int new_min_y_1 = (int)Math.floor(min_trans_corner_y);
        int new_min_z_1 = (int)Math.floor(min_trans_corner_z);
        int new_max_x_1 = (int)Math.ceil(max_trans_corner_x);
        int new_max_y_1 = (int)Math.ceil(max_trans_corner_y);
        int new_max_z_1 = (int)Math.ceil(max_trans_corner_z);
        int width_mapped2 = new_max_x_1 - new_min_x_1 + 1;
        int height_mapped2 = new_max_y_1 - new_min_y_1 + 1;
        int depth_mapped2 = new_max_z_1 - new_min_z_1 + 1;
        int target_offset_x = 0;
        int target_offset_y = 0;
        int target_offset_z = 0;
        if (new_min_x_1 < 0) {
            target_offset_x = -new_min_x_1;
        }
        if (new_min_y_1 < 0) {
            target_offset_y = -new_min_y_1;
        }
        if (new_min_z_1 < 0) {
            target_offset_z = -new_min_z_1;
        }
        int widthNew = new_max_x_1 - new_min_x_1;
        int heightNew = new_max_y_1 - new_min_y_1;
        int depthNew = new_max_z_1 - new_min_z_1;
        return this.createNewImageReal(null, image1, -target_offset_x, widthNew - target_offset_x, -target_offset_y, heightNew - target_offset_y, -target_offset_z, depthNew - target_offset_z, false);
    }
}

