/*
 * Decompiled with CFR 0.152.
 */
package io.scif.cli;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.cli.AbstractSCIFIOToolCommand;
import io.scif.cli.LongArrayOptionHandler;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.ChannelFiller;
import io.scif.filters.FileStitcher;
import io.scif.filters.MinMaxFilter;
import io.scif.filters.PlaneSeparator;
import io.scif.filters.ReaderFilter;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.scijava.plugin.Parameter;
import org.scijava.util.ArrayUtils;

public abstract class AbstractReaderCommand
extends AbstractSCIFIOToolCommand {
    private SCIFIOConfig config;
    @Parameter
    private InitializeService initializeService;
    @Option(name="-t", aliases={"--stitch"}, usage="stitch input files with similar names")
    private boolean stitch;
    @Option(name="-s", aliases={"--separate"}, usage="separate non-XY planar axes")
    private boolean separate;
    @Option(name="-e", aliases={"--expand"}, usage="expand indexed color to RGB")
    private boolean expand;
    @Option(name="-g", aliases={"--nogroup"}, usage="force multi-file datasets to be read as individual files")
    private boolean nogroup;
    @Option(name="-a", aliases={"--autoscale"}, usage="automatically adjust brightness and contrast before converting")
    private boolean autoscale;
    @Option(name="-M", aliases={"--map"}, metaVar="FILE_NAME", usage="specify file on disk to which name should be mapped")
    private String map;
    @Option(name="-r", aliases={"--range"}, handler=LongArrayOptionHandler.class, usage="specify a range for non-planar indices. Values are read as [min, max] pairs in axis order")
    private final long[] npRange = new long[0];
    @Option(name="-C", aliases={"--crop"}, handler=LongArrayOptionHandler.class, usage="specify a range for planar axis cropping. Values are read as [offset, length] pairs in axis order")
    private long[] crop = new long[0];

    protected String getMap() {
        return this.map;
    }

    protected void setMap(String map) {
        this.map = map;
    }

    protected long[] getCrop() {
        return this.crop;
    }

    protected void setCrop(long[] crop) {
        this.crop = crop;
    }

    protected ReaderFilter makeReader(String path) throws CmdLineException {
        ReaderFilter reader;
        try {
            reader = this.initializeService.initializeReader(this.location(path), this.getConfig());
        }
        catch (FormatException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        catch (IOException e) {
            throw new CmdLineException(null, e.getMessage());
        }
        if (this.stitch) {
            reader.enable(FileStitcher.class);
        }
        if (this.separate) {
            reader.enable(PlaneSeparator.class);
        }
        if (this.expand) {
            reader.enable(ChannelFiller.class);
        }
        if (this.autoscale) {
            reader.enable(MinMaxFilter.class);
        }
        return reader;
    }

    protected void makeRange(long[] values, long[] offsets, long[] lengths, ImageMetadata meta, List<CalibratedAxis> axes) {
        for (int i = 0; i < offsets.length * 2; ++i) {
            if (i % 2 == 0) {
                if (i >= values.length) continue;
                offsets[i / 2] = values[i];
                continue;
            }
            lengths[i / 2] = i < values.length ? values[i] : meta.getAxisLength(axes.get(i / 2));
        }
    }

    protected void read(Reader reader) throws CmdLineException {
        Metadata m = reader.getMetadata();
        ImageMetadata iMeta = m.get(0);
        long[] planeOffsets = new long[iMeta.getAxesPlanar().size()];
        long[] planeLengths = new long[planeOffsets.length];
        this.makeRange(this.getCrop(), planeOffsets, planeLengths, iMeta, iMeta.getAxesPlanar());
        long[] npOffsets = new long[iMeta.getAxesNonPlanar().size()];
        long[] npLengths = new long[npOffsets.length];
        this.makeRange(this.npRange, npOffsets, npLengths, iMeta, iMeta.getAxesNonPlanar());
        long[] position = Arrays.copyOf(npOffsets, npOffsets.length);
        long[] planeCounts = new long[npOffsets.length];
        for (int i = 0; i < planeCounts.length; ++i) {
            planeCounts[i] = npLengths[i] - npOffsets[i];
        }
        long planeCount = planeCounts.length > 0 ? ArrayUtils.safeMultiply64((long[])planeCounts) : 1L;
        long planeIndex = FormatTools.positionToRaster((int)0, (Metadata)m, (long[])position);
        Plane plane = null;
        long planeNo = 0L;
        do {
            long[] planeMax = new long[planeLengths.length];
            for (int d = 0; d < planeMax.length; ++d) {
                planeMax[d] = planeOffsets[d] + planeLengths[d] - 1L;
            }
            FinalInterval bounds = new FinalInterval(planeOffsets, planeMax);
            plane = this.processPlane(reader, plane, 0, planeIndex, planeNo++, (Interval)bounds);
            this.info("Processed: " + planeNo + "/" + planeCount + " planes.");
        } while ((planeIndex = FormatTools.nextPlaneIndex((int)0, (Metadata)m, (long[])position, (long[])npOffsets, (long[])npLengths)) != -1L);
    }

    protected abstract Plane processPlane(Reader var1, Plane var2, int var3, long var4, long var6, Interval var8) throws CmdLineException;

    protected SCIFIOConfig getConfig() {
        if (this.config == null) {
            this.config = new SCIFIOConfig().groupableSetGroupFiles(!this.nogroup).writerSetSequential(true);
        }
        return this.config;
    }
}

