/*
 * Decompiled with CFR 0.152.
 */
package customnode.u3d;

public class ContextManager {
    private final int[][] symbolCount = new int[1024][];
    private final int[][] cumulativeCount = new int[1024][];
    private final long Elephant = 8191L;
    private final long MaximumSymbolInHistogram = 65535L;
    private final long ArraySizeIncr = 32L;

    public void AddSymbol(long context, long symbol) {
        if (context < 1024L && context != 0L && symbol < 65535L) {
            int[] cumulativeCount = this.cumulativeCount[(int)context];
            int[] symbolCount = this.symbolCount[(int)context];
            if (cumulativeCount == null || (long)cumulativeCount.length <= symbol) {
                cumulativeCount = new int[(int)(symbol + 32L)];
                symbolCount = new int[(int)(symbol + 32L)];
                if (cumulativeCount != null && symbolCount != null) {
                    if (this.cumulativeCount[(int)context] == null) {
                        this.cumulativeCount[(int)context] = cumulativeCount;
                        this.cumulativeCount[(int)context][0] = 1;
                        this.symbolCount[(int)context] = symbolCount;
                        this.symbolCount[(int)context][0] = 1;
                    } else {
                        System.arraycopy(this.cumulativeCount[(int)context], 0, cumulativeCount, 0, this.cumulativeCount[(int)context].length);
                        System.arraycopy(this.symbolCount[(int)context], 0, symbolCount, 0, this.symbolCount[(int)context].length);
                    }
                }
                this.cumulativeCount[(int)context] = cumulativeCount;
                this.symbolCount[(int)context] = symbolCount;
            }
            if ((long)cumulativeCount[0] >= 8191L) {
                int len = cumulativeCount.length;
                int tempAccum = 0;
                for (int i = len - 1; i >= 0; --i) {
                    int n = i;
                    symbolCount[n] = symbolCount[n] >> 1;
                    cumulativeCount[i] = tempAccum += symbolCount[i];
                }
                symbolCount[0] = symbolCount[0] + 1;
                cumulativeCount[0] = cumulativeCount[0] + 1;
            }
            int n = (int)symbol;
            symbolCount[n] = symbolCount[n] + 1;
            int i = 0;
            while ((long)i <= symbol) {
                int n2 = i++;
                cumulativeCount[n2] = cumulativeCount[n2] + 1;
            }
        }
    }

    public long GetSymbolFrequency(long context, long symbol) {
        long rValue = 1L;
        if (context < 1024L && context != 0L) {
            rValue = 0L;
            if (this.symbolCount[(int)context] != null && symbol < (long)this.symbolCount[(int)context].length) {
                rValue = this.symbolCount[(int)context][(int)symbol];
            } else if (symbol == 0L) {
                rValue = 1L;
            }
        }
        return rValue;
    }

    public long GetCumulativeSymbolFrequency(long context, long symbol) {
        long rValue = symbol - 1L;
        if (context < 1024L && context != 0L) {
            rValue = 0L;
            if (this.cumulativeCount[(int)context] != null) {
                rValue = symbol < (long)this.cumulativeCount[(int)context].length ? (long)(this.cumulativeCount[(int)context][0] - this.cumulativeCount[(int)context][(int)symbol]) : (long)this.cumulativeCount[(int)context][0];
            }
        }
        return rValue;
    }

    public long GetTotalSymbolFrequency(long context) {
        if (context < 1024L && context != 0L) {
            long rValue = 1L;
            if (this.cumulativeCount[(int)context] != null) {
                rValue = this.cumulativeCount[(int)context][0];
            }
            return rValue;
        }
        if (context == 0L) {
            return 256L;
        }
        return context - 1024L;
    }

    public long GetSymbolFromFrequency(long context, long symbolFrequency) {
        long rValue = 0L;
        if (context < 1024L && context != 0L) {
            rValue = 0L;
            if (this.cumulativeCount[(int)context] != null && symbolFrequency != 0L && (long)this.cumulativeCount[(int)context][0] >= symbolFrequency) {
                long i = 0L;
                i = 0L;
                while (i < (long)this.cumulativeCount[(int)context].length && this.GetCumulativeSymbolFrequency(context, i) <= symbolFrequency) {
                    rValue = i++;
                }
            }
        } else {
            rValue = symbolFrequency + 1L;
        }
        return rValue;
    }
}

