/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import java.awt.Frame;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Node;

public class ScenegraphDebugger {
    public static void displayTree(Node root) {
        ScenegraphDebugger.displayTree(root, "");
    }

    private static void displayTree(Node node, String indent) {
        System.out.println(indent + node);
        if (node instanceof Group) {
            Iterator ch = ((Group)node).getAllChildren();
            while (ch.hasNext()) {
                ScenegraphDebugger.displayTree((Node)ch.next(), indent + "   ");
            }
        }
    }

    public static void showTree(Node root) {
        JTree tree = new JTree(new J3DNode(root, null));
        Frame parent = null;
        JDialog dialog = new JDialog(parent, "Scenegraph");
        JScrollPane scroll = new JScrollPane(tree);
        dialog.getContentPane().add(scroll);
        dialog.pack();
        dialog.setVisible(true);
    }

    private static class J3DNode
    implements TreeNode {
        private final Node node;
        private final J3DNode parent;
        private J3DNode[] children = null;

        public J3DNode(Node n, J3DNode parent) {
            this.node = n;
            this.parent = parent;
            if (this.node instanceof Group) {
                Group g = (Group)this.node;
                this.children = new J3DNode[g.numChildren()];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = new J3DNode(g.getChild(i), this);
                }
            }
        }

        public Enumeration children() {
            if (this.children != null) {
                return Collections.enumeration(Arrays.asList(this.children));
            }
            return null;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.node instanceof Group;
        }

        @Override
        public TreeNode getChildAt(int arg0) {
            if (!(this.node instanceof Group)) {
                return null;
            }
            return this.children[arg0];
        }

        @Override
        public int getChildCount() {
            return this.children.length;
        }

        @Override
        public int getIndex(TreeNode arg0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].equals(arg0)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return !(this.node instanceof Group);
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

