/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij3d.DefaultUniverse;
import ij3d.behaviors.BehaviorCallback;
import ij3d.behaviors.ViewPlatformTransformer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class InteractiveViewPlatformTransformer
extends ViewPlatformTransformer {
    private static final double ONE_RAD = Math.PI / 180;
    private int xLast;
    private int yLast;

    public InteractiveViewPlatformTransformer(DefaultUniverse univ, BehaviorCallback callback) {
        super(univ, callback);
    }

    public void init(MouseEvent e) {
        this.xLast = e.getX();
        this.yLast = e.getY();
    }

    public void translate(MouseEvent e) {
        int dx = this.xLast - e.getX();
        int dy = this.yLast - e.getY();
        this.translateXY(-dx, dy);
        this.xLast = e.getX();
        this.yLast = e.getY();
    }

    public void rotate(MouseEvent e) {
        int dx = this.xLast - e.getX();
        int dy = this.yLast - e.getY();
        this.rotateXY((double)dy * (Math.PI / 180), (double)dx * (Math.PI / 180));
        this.xLast = e.getX();
        this.yLast = e.getY();
    }

    public void wheel_zoom(MouseEvent e) {
        MouseWheelEvent we = (MouseWheelEvent)e;
        int units = 0;
        if (we.getScrollType() == 0) {
            units = we.getUnitsToScroll();
        }
        this.zoom(units);
    }

    public void zoom(MouseEvent e) {
        int y = e.getY();
        int dy = y - this.yLast;
        this.zoom(dy);
        this.xLast = e.getX();
        this.yLast = y;
    }
}

