/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomTriangleMesh;
import ij.IJ;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.Utils;
import isosurface.Triangulator;
import java.awt.Color;
import java.util.List;
import marchingcubes.MCTriangulator;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;

public class MeshGroup
extends ContentNode {
    private final CustomTriangleMesh mesh;
    private final Triangulator triangulator = new MCTriangulator();
    private final ContentInstant c;
    private Point3f min;
    private Point3f max;
    private Point3f center;

    public MeshGroup(Content c) {
        this(c.getCurrent());
    }

    public MeshGroup(ContentInstant c) {
        this.c = c;
        Color3f color = c.getColor();
        List tri = this.triangulator.getTriangles(c.getImage(), c.getThreshold(), c.getChannels(), c.getResamplingFactor());
        if (color == null) {
            int value = c.getImage().getProcessor().getColorModel().getRGB(c.getThreshold());
            color = Utils.toColor3f(new Color(value));
        }
        this.mesh = new CustomTriangleMesh(tri, color, c.getTransparency());
        this.calculateMinMaxCenterPoint();
        this.addChild((Node)this.mesh);
    }

    public CustomTriangleMesh getMesh() {
        return this.mesh;
    }

    @Override
    public void getMin(Tuple3d min) {
        min.set((Tuple3f)this.min);
    }

    @Override
    public void getMax(Tuple3d max) {
        max.set((Tuple3f)this.max);
    }

    @Override
    public void getCenter(Tuple3d center) {
        center.set((Tuple3f)this.center);
    }

    @Override
    public void eyePtChanged(View view) {
    }

    @Override
    public void thresholdUpdated(int threshold) {
        if (this.c.getImage() == null) {
            IJ.error((String)"Mesh was not calculated of a grayscale image. Can't change threshold");
            return;
        }
        List tri = this.triangulator.getTriangles(this.c.getImage(), this.c.getThreshold(), this.c.getChannels(), this.c.getResamplingFactor());
        this.mesh.setMesh(tri);
    }

    @Override
    public void lutUpdated(int[] r, int[] g, int[] b, int[] a) {
    }

    @Override
    public void channelsUpdated(boolean[] channels) {
        if (this.c.getImage() == null) {
            IJ.error((String)"Mesh was not calculated of a grayscale image. Can't change channels");
            return;
        }
        List tri = this.triangulator.getTriangles(this.c.getImage(), this.c.getThreshold(), this.c.getChannels(), this.c.getResamplingFactor());
        this.mesh.setMesh(tri);
    }

    public void calculateMinMaxCenterPoint() {
        this.min = new Point3f();
        this.max = new Point3f();
        this.center = new Point3f();
        if (this.mesh != null) {
            this.mesh.calculateMinMaxCenterPoint(this.min, this.max, this.center);
        }
    }

    @Override
    public float getVolume() {
        if (this.mesh == null) {
            return -1.0f;
        }
        return this.mesh.getVolume();
    }

    @Override
    public void shadeUpdated(boolean shaded) {
        this.mesh.setShaded(shaded);
    }

    @Override
    public void colorUpdated(Color3f newColor) {
        if (newColor == null) {
            int val = this.c.getImage().getProcessor().getColorModel().getRGB(this.c.getThreshold());
            newColor = Utils.toColor3f(new Color(val));
        }
        this.mesh.setColor(newColor);
    }

    @Override
    public void transparencyUpdated(float transparency) {
        this.mesh.setTransparency(transparency);
    }

    @Override
    public void restoreDisplayedData(String path, String name) {
        this.mesh.restoreDisplayedData(path, name);
    }

    @Override
    public void clearDisplayedData() {
        this.mesh.clearDisplayedData();
    }

    @Override
    public void swapDisplayedData(String path, String name) {
        this.mesh.swapDisplayedData(path, name);
    }
}

