/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.ij.steger;

import de.biomedical_imaging.ij.steger.GenericDialogPlus;
import de.biomedical_imaging.ij.steger.Junction;
import de.biomedical_imaging.ij.steger.Junctions;
import de.biomedical_imaging.ij.steger.Line;
import de.biomedical_imaging.ij.steger.LineDetector;
import de.biomedical_imaging.ij.steger.Lines;
import de.biomedical_imaging.ij.steger.Options;
import de.biomedical_imaging.ij.steger.OverlapOption;
import de.biomedical_imaging.ij.steger.ResetToDefaultListener;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.RoiManager;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.TextField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Lines_
implements ExtendedPlugInFilter,
DialogListener {
    static final double lineWidthDefault = 3.5;
    double lineWidth = 3.5;
    static final double contrastHighDefault = 230.0;
    double contrastHigh = 230.0;
    static final double contrastLowDefault = 87.0;
    double contrastLow = 87.0;
    static final double sigmaDefault = 1.51;
    double sigma = 1.51;
    static final double lowerThreshDefault = 3.06;
    double lowerThresh = 3.06;
    static final double upperThreshDefault = 7.99;
    double upperThresh = 7.99;
    static final double minLengthDefault = 0.0;
    double minLength = 0.0;
    static final double maxLengthDefault = 0.0;
    double maxLength = 0.0;
    static final boolean isDarkLineDefault = false;
    boolean isDarkLine = false;
    static final boolean doCorrectPositionDefault = false;
    boolean doCorrectPosition = false;
    static final boolean doEstimateWidthDefault = false;
    boolean doEstimateWidth = false;
    static final boolean doExtendLineDefault = true;
    boolean doExtendLine = true;
    static final boolean showJunctionPointsDefault = false;
    boolean showJunctionPoints = false;
    static final boolean displayResultsDefault = true;
    boolean displayResults = true;
    static final boolean addToRoiManagerDefault = true;
    boolean addToRoiManager = true;
    static final boolean makeBinaryDefault = false;
    boolean makeBinary = false;
    OverlapOption overlapOption = OverlapOption.NONE;
    static final boolean showIDsDefault = false;
    boolean showIDs = false;
    static final boolean verboseDefault = false;
    boolean verbose = false;
    boolean isPreview = false;
    boolean contrastOrLineWidthChangedOnce = false;
    boolean doStack = false;
    private Options usedOptions = null;
    private static Lines_ instance = null;
    ArrayList<Lines> result;
    ArrayList<Junctions> resultJunction;
    ImagePlus imp;

    public Lines_() {
        instance = this;
    }

    public static Lines_ getInstance() {
        return instance;
    }

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("final")) {
            this.sortLists();
            this.displayContours();
            if (this.displayResults) {
                this.createResultsTable(true);
            }
            if (this.addToRoiManager) {
                this.addToRoiManager();
            }
            if (this.makeBinary) {
                this.makeBinary();
            }
            return 4096;
        }
        try {
            Class.forName("org.apache.commons.lang3.mutable.MutableLong");
        }
        catch (ClassNotFoundException exception) {
            IJ.error((String)"Please install apache-commons-lang 3", (String)"It seems that the apache-commons-lang 3 library is not installed on your system. \n Download the jar file under https://commons.apache.org/proper/commons-lang/ and copy it to plugins/jars");
            return 4096;
        }
        if (imp == null) {
            IJ.error((String)"No image open");
            return 4096;
        }
        if (imp.isInvertedLut()) {
            IJ.showMessage((String)"LUT reset", (String)"The LUT of your image is inverted and will now reset for better parameter selection");
            IJ.run((ImagePlus)imp, (String)"Invert LUT", (String)"");
        }
        Line.resetCounter();
        this.imp = imp;
        this.result = new ArrayList();
        this.resultJunction = new ArrayList();
        this.readSettings();
        return 98337;
    }

    private void sortLists() {
        Collections.sort(this.result, new Comparator<Lines>(){

            @Override
            public int compare(Lines o1, Lines o2) {
                if (o1.getFrame() < o2.getFrame()) {
                    return -1;
                }
                if (o1.getFrame() > o2.getFrame()) {
                    return 1;
                }
                return 0;
            }
        });
        Collections.sort(this.resultJunction, new Comparator<Junctions>(){

            @Override
            public int compare(Junctions o1, Junctions o2) {
                if (o1.getFrame() < o2.getFrame()) {
                    return -1;
                }
                if (o1.getFrame() > o2.getFrame()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        GenericDialogPlus gd = new GenericDialogPlus("Ridge Detection");
        gd.addMessage("Optional_parameters:");
        gd.addNumericField("Line_width", this.lineWidth, 1);
        gd.addNumericField("High_Contrast", this.contrastHigh, 0);
        gd.addNumericField("Low_Contrast", this.contrastLow, 0);
        gd.addMessage("Mandatory_parameters:");
        gd.addNumericField("Sigma", this.sigma, 2);
        gd.addNumericField("Lower_Threshold", this.lowerThresh, 2);
        gd.addNumericField("Upper_Threshold", this.upperThresh, 2);
        gd.addNumericField("Minimum_Line_Length", this.minLength, 2);
        gd.addNumericField("Maximum Line Length", this.maxLength, 2);
        gd.addCheckbox("Darkline", this.isDarkLine);
        gd.addCheckbox("Correct_position", this.doCorrectPosition);
        gd.addCheckbox("Estimate_width", this.doEstimateWidth);
        gd.addCheckbox("Extend_line", this.doExtendLine);
        gd.addCheckbox("Show_junction_points", this.showJunctionPoints);
        gd.addCheckbox("Show_IDs", this.showIDs);
        gd.addCheckbox("Verbose mode", this.verbose);
        gd.addCheckbox("DisplayResults", this.displayResults);
        gd.addCheckbox("Add_to_Manager", this.addToRoiManager);
        gd.addCheckbox("Make_Binary", this.makeBinary);
        String[] overlap = new String[OverlapOption.values().length];
        for (int i = 0; i < overlap.length; ++i) {
            overlap[i] = OverlapOption.values()[i].name();
        }
        gd.addChoice("Method_for_overlap_resolution", overlap, this.overlapOption.name());
        gd.addHelp("http://fiji.sc/Ridge_Detection");
        gd.addDialogListener(this);
        gd.addPreviewCheckbox(pfr, "Preview");
        gd.addButton("Reset settings to default", new ResetToDefaultListener(gd));
        gd.showDialog();
        if (gd.wasCanceled()) {
            imp.setOverlay(null);
            return 4096;
        }
        this.isPreview = false;
        this.lineWidth = gd.getNextNumber();
        this.contrastHigh = gd.getNextNumber();
        this.contrastLow = gd.getNextNumber();
        this.sigma = gd.getNextNumber();
        this.lowerThresh = gd.getNextNumber();
        this.upperThresh = gd.getNextNumber();
        this.minLength = gd.getNextNumber();
        this.maxLength = gd.getNextNumber();
        this.isDarkLine = gd.getNextBoolean();
        this.doCorrectPosition = gd.getNextBoolean();
        this.doEstimateWidth = gd.getNextBoolean();
        this.doExtendLine = gd.getNextBoolean();
        this.showJunctionPoints = gd.getNextBoolean();
        this.showIDs = gd.getNextBoolean();
        this.verbose = gd.getNextBoolean();
        this.displayResults = gd.getNextBoolean();
        this.addToRoiManager = gd.getNextBoolean();
        this.makeBinary = gd.getNextBoolean();
        this.overlapOption = OverlapOption.valueOf(gd.getNextChoice());
        this.saveSettings();
        this.result = new ArrayList();
        this.resultJunction = new ArrayList();
        int labels = IJ.setupDialog((ImagePlus)imp, (int)98305);
        this.doStack = labels != 98305;
        return labels;
    }

    private void readSettings() {
        this.lineWidth = Prefs.get((String)"RidgeDetection.lineWidth", (double)3.5);
        this.contrastHigh = Prefs.get((String)"RidgeDetection.contrastHigh", (double)230.0);
        this.contrastLow = Prefs.get((String)"RidgeDetection.contrastLow", (double)87.0);
        this.sigma = Prefs.get((String)"RidgeDetection.sigma", (double)1.51);
        this.lowerThresh = Prefs.get((String)"RidgeDetection.lowerThresh", (double)3.06);
        this.upperThresh = Prefs.get((String)"RidgeDetection.upperThresh", (double)7.99);
        this.minLength = Prefs.get((String)"RidgeDetection.minLength", (double)0.0);
        this.maxLength = Prefs.get((String)"RidgeDetection.maxLength", (double)0.0);
        this.isDarkLine = Prefs.get((String)"RidgeDetection.isDarkLine", (boolean)false);
        this.doCorrectPosition = Prefs.get((String)"RidgeDetection.doCorrectPosition", (boolean)false);
        this.doEstimateWidth = Prefs.get((String)"RidgeDetection.doEstimateWidth", (boolean)false);
        this.doExtendLine = Prefs.get((String)"RidgeDetection.doExtendLine", (boolean)true);
        this.showJunctionPoints = Prefs.get((String)"RidgeDetection.showJunctionPoints", (boolean)false);
        this.showIDs = Prefs.get((String)"RidgeDetection.showIDs", (boolean)false);
        this.verbose = Prefs.get((String)"RidgeDetection.verbose", (boolean)false);
        this.displayResults = Prefs.get((String)"RidgeDetection.displayResults", (boolean)true);
        this.addToRoiManager = Prefs.get((String)"RidgeDetection.addToRoiManager", (boolean)true);
        this.makeBinary = Prefs.get((String)"RidgeDetection.makeBinary", (boolean)false);
        String overlapOptionString = Prefs.get((String)"RidgeDetection.overlapOption", (String)OverlapOption.NONE.name());
        this.overlapOption = OverlapOption.valueOf(overlapOptionString);
    }

    private void saveSettings() {
        Prefs.set((String)"RidgeDetection.lineWidth", (double)this.lineWidth);
        Prefs.set((String)"RidgeDetection.contrastHigh", (double)this.contrastHigh);
        Prefs.set((String)"RidgeDetection.contrastLow", (double)this.contrastLow);
        Prefs.set((String)"RidgeDetection.sigma", (double)this.sigma);
        Prefs.set((String)"RidgeDetection.lowerThresh", (double)this.lowerThresh);
        Prefs.set((String)"RidgeDetection.upperThresh", (double)this.upperThresh);
        Prefs.set((String)"RidgeDetection.minLength", (double)this.minLength);
        Prefs.set((String)"RidgeDetection.maxLength", (double)this.maxLength);
        Prefs.set((String)"RidgeDetection.isDarkLine", (boolean)this.isDarkLine);
        Prefs.set((String)"RidgeDetection.doCorrectPosition", (boolean)this.doCorrectPosition);
        Prefs.set((String)"RidgeDetection.doEstimateWidth", (boolean)this.doEstimateWidth);
        Prefs.set((String)"RidgeDetection.doExtendLine", (boolean)this.doExtendLine);
        Prefs.set((String)"RidgeDetection.showJunctionPoints", (boolean)this.showJunctionPoints);
        Prefs.set((String)"RidgeDetection.showIDs", (boolean)this.showIDs);
        Prefs.set((String)"RidgeDetection.verbose", (boolean)this.verbose);
        Prefs.set((String)"RidgeDetection.displayResults", (boolean)this.displayResults);
        Prefs.set((String)"RidgeDetection.addToRoiManager", (boolean)this.addToRoiManager);
        Prefs.set((String)"RidgeDetection.makeBinary", (boolean)this.makeBinary);
        Prefs.set((String)"RidgeDetection.overlapOption", (String)this.overlapOption.name());
    }

    public void addToRoiManager() {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            rm = new RoiManager();
        }
        for (Lines contours : this.result) {
            for (Line c : contours) {
                float[] x = c.getXCoordinates();
                for (int j = 0; j < x.length; ++j) {
                    x[j] = (float)((double)x[j] + 0.5);
                }
                float[] y = c.getYCoordinates();
                for (int j = 0; j < y.length; ++j) {
                    y[j] = (float)((double)y[j] + 0.5);
                }
                FloatPolygon p = new FloatPolygon(x, y, c.getNumber());
                PolygonRoi r = new PolygonRoi(p, 7);
                r.setPosition(c.getFrame());
                r.setName("C" + c.getID());
                rm.addRoi((Roi)r);
            }
        }
        for (Junctions junctions : this.resultJunction) {
            for (Junction j : junctions) {
                PointRoi pr = new PointRoi((double)j.x + 0.5, (double)j.y + 0.5);
                pr.setName("JP-C" + j.getLine1().getID() + "-C" + j.getLine2().getID());
                pr.setPosition(j.getLine1().getFrame());
                rm.addRoi((Roi)pr);
            }
        }
        rm.setVisible(true);
        rm.runCommand("UseNames", "true");
    }

    private void createResultsTable(boolean showJunctions) {
        ResultsTable rt = ResultsTable.getResultsTable();
        ResultsTable rtSum = new ResultsTable();
        rt.setPrecision(3);
        Calibration cal = this.imp.getCalibration();
        for (Lines contours : this.result) {
            for (Line c : contours) {
                double meanWidth = 0.0;
                for (int i = 0; i < c.num; ++i) {
                    rt.incrementCounter();
                    rt.addValue("Frame", (double)contours.getFrame());
                    rt.addValue("Contour ID", (double)c.getID());
                    rt.addValue("Pos.", (double)(i + 1));
                    rt.addValue("X", (double)c.col[i] * cal.pixelWidth);
                    rt.addValue("Y", (double)c.row[i] * cal.pixelHeight);
                    rt.addValue("Length", c.estimateLength() * cal.pixelHeight);
                    if (this.doCorrectPosition && this.doEstimateWidth) {
                        rt.addValue("Contrast", (double)Math.abs(c.intensity[i]));
                        rt.addValue("Asymmetry", (double)Math.abs(c.asymmetry[i]));
                    }
                    if (this.doEstimateWidth) {
                        rt.addValue("Line width", (double)(c.width_l[i] + c.width_r[i]) * cal.pixelWidth);
                        meanWidth += (double)(c.width_l[i] + c.width_r[i]);
                        rt.addValue("Angle of normal", (double)c.angle[i]);
                    }
                    rt.addValue("Class", c.getContourClass().toString().substring(5));
                }
                rtSum.incrementCounter();
                rtSum.addValue("Frame", (double)contours.getFrame());
                rtSum.addValue("Contour ID", (double)c.getID());
                rtSum.addValue("Length", c.estimateLength() * cal.pixelWidth);
                if (!this.doEstimateWidth) continue;
                rtSum.addValue("Mean line width", meanWidth / (double)c.num * cal.pixelWidth);
            }
        }
        rt.show("Results");
        rtSum.show("Summary");
        if (showJunctions) {
            ResultsTable rt2 = new ResultsTable();
            rt2.setPrecision(0);
            for (Junctions junctions : this.resultJunction) {
                for (Junction j : junctions) {
                    rt2.incrementCounter();
                    rt2.addValue("Frame", (double)junctions.getFrame());
                    rt2.addValue("Contour ID 1", (double)j.getLine1().getID());
                    rt2.addValue("Contour ID 2", (double)j.getLine2().getID());
                    rt2.addValue("X", (double)j.x * cal.pixelWidth);
                    rt2.addValue("Y", (double)j.y * cal.pixelHeight);
                }
            }
            rt2.show("Junctions");
        }
    }

    public void makeBinary() {
        ImagePlus binary = IJ.createHyperStack((String)(this.imp.getTitle() + " Detected segments"), (int)this.imp.getWidth(), (int)this.imp.getHeight(), (int)this.imp.getNChannels(), (int)(this.imp.getStackSize() / this.imp.getNChannels()), (int)1, (int)8);
        binary.copyScale(this.imp);
        ImageProcessor binaryProcessor = binary.getProcessor();
        binaryProcessor.invertLut();
        if (this.imp.getCompositeMode() > 0) {
            ((CompositeImage)binary).setLuts(this.imp.getLuts());
        }
        ImageStack is = binary.getImageStack();
        ImageProcessor ip = binary.getProcessor();
        for (Lines contours : this.result) {
            for (Line c : contours) {
                int j;
                float[] x = c.getXCoordinates();
                float[] y = c.getYCoordinates();
                int[] x_poly_r = new int[x.length];
                int[] y_poly_r = new int[x.length];
                Polygon LineSurface = new Polygon();
                ip = is.getProcessor(c.getFrame());
                ip.setLineWidth(1);
                ip.setColor(255);
                for (j = 0; j < x.length; ++j) {
                    if (j > 0) {
                        ip.drawLine(Math.round(x[j - 1]), Math.round(y[j - 1]), Math.round(x[j]), Math.round(y[j]));
                    }
                    if (!this.doEstimateWidth) continue;
                    double nx = Math.sin(c.angle[j]);
                    double ny = Math.cos(c.angle[j]);
                    LineSurface.addPoint((int)Math.round((double)x[j] - (double)c.width_l[j] * nx), (int)Math.round((double)y[j] - (double)c.width_l[j] * ny));
                    x_poly_r[j] = (int)Math.round((double)x[j] + (double)c.width_r[j] * nx);
                    y_poly_r[j] = (int)Math.round((double)y[j] + (double)c.width_r[j] * ny);
                }
                if (!this.doEstimateWidth) continue;
                for (j = 0; j < x.length; ++j) {
                    if (j >= x.length) continue;
                    LineSurface.addPoint(x_poly_r[x.length - 1 - j], y_poly_r[x.length - 1 - j]);
                }
                ip.fillPolygon(LineSurface);
            }
        }
        binary.show();
        binary.updateAndDraw();
    }

    private void displayContours() {
        int k;
        this.imp.setOverlay(null);
        Overlay ovpoly = new Overlay();
        double px_r = 0.0;
        double py_r = 0.0;
        double px_l = 0.0;
        double py_l = 0.0;
        for (k = 0; k < this.result.size(); ++k) {
            for (int i = 0; i < this.result.get(k).size(); ++i) {
                FloatPolygon polyMitte = new FloatPolygon();
                FloatPolygon polyR = new FloatPolygon();
                FloatPolygon polyL = new FloatPolygon();
                Line cont = (Line)this.result.get(k).get(i);
                int num_points = cont.num;
                double last_w_r = 0.0;
                double last_w_l = 0.0;
                for (int j = 0; j < num_points; ++j) {
                    double px = cont.col[j];
                    double py = cont.row[j];
                    double nx = Math.sin(cont.angle[j]);
                    double ny = Math.cos(cont.angle[j]);
                    if (this.doEstimateWidth) {
                        px_r = px + (double)cont.width_r[j] * nx;
                        py_r = py + (double)cont.width_r[j] * ny;
                        px_l = px - (double)cont.width_l[j] * nx;
                        py_l = py - (double)cont.width_l[j] * ny;
                    }
                    polyMitte.addPoint(px + 0.5, py + 0.5);
                    if (this.doEstimateWidth) {
                        if (last_w_r > 0.0 && cont.width_r[j] > 0.0f) {
                            polyR.addPoint(px_r + 0.5, py_r + 0.5);
                        }
                        if (last_w_l > 0.0 && cont.width_l[j] > 0.0f) {
                            polyL.addPoint(px_l + 0.5, py_l + 0.5);
                        }
                    }
                    if (!this.doEstimateWidth) continue;
                    last_w_r = cont.width_r[j];
                    last_w_l = cont.width_l[j];
                }
                PolygonRoi polyRoiMitte = new PolygonRoi(polyMitte, 6);
                polyRoiMitte.setStrokeColor(Color.red);
                int position = this.result.get(k).getFrame();
                if (!this.doStack || this.isPreview) {
                    position = this.imp.getCurrentSlice();
                }
                polyRoiMitte.setPosition(position);
                ovpoly.add((Roi)polyRoiMitte);
                if (this.doEstimateWidth && polyL.npoints > 1) {
                    PolygonRoi polyRoiRand1 = new PolygonRoi(polyL, 6);
                    polyRoiRand1.setStrokeColor(Color.green);
                    position = this.result.get(k).getFrame();
                    if (!this.doStack || this.isPreview) {
                        position = this.imp.getCurrentSlice();
                    }
                    polyRoiRand1.setPosition(position);
                    ovpoly.add((Roi)polyRoiRand1);
                    PolygonRoi polyRoiRand2 = new PolygonRoi(polyR, 6);
                    polyRoiRand2.setStrokeColor(Color.green);
                    polyRoiRand2.setPosition(position);
                    ovpoly.add((Roi)polyRoiRand2);
                }
                if (!this.showIDs) continue;
                int posx = (int)polyMitte.xpoints[polyMitte.npoints / 2];
                int posy = (int)polyMitte.ypoints[polyMitte.npoints / 2];
                TextRoi tr = new TextRoi(posx, posy, "" + cont.getID());
                tr.setCurrentFont(new Font("SansSerif", 0, 9));
                tr.setIgnoreClipRect(true);
                tr.setStrokeColor(Color.orange);
                tr.setPosition(this.resultJunction.get(k).getFrame());
                ovpoly.add((Roi)tr);
            }
        }
        if (this.showJunctionPoints) {
            for (k = 0; k < this.resultJunction.size(); ++k) {
                FloatPolygon pointpoly = new FloatPolygon();
                for (int i = 0; i < this.resultJunction.get(k).size(); ++i) {
                    pointpoly.addPoint((double)((Junction)this.resultJunction.get((int)k).get((int)i)).x + 0.5, (double)((Junction)this.resultJunction.get((int)k).get((int)i)).y + 0.5);
                }
                PointRoi pointroi = new PointRoi(pointpoly);
                pointroi.setShowLabels(false);
                int position = this.resultJunction.get(k).getFrame();
                if (!this.doStack || this.isPreview) {
                    position = this.imp.getCurrentSlice();
                }
                pointroi.setPosition(position);
                ovpoly.add((Roi)pointroi);
            }
        }
        if (ovpoly.size() > 0) {
            this.imp.setOverlay(ovpoly);
        }
    }

    public void setNPasses(int nPasses) {
        IJ.showProgress((int)nPasses, (int)this.imp.getNSlices());
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        boolean darklineCand;
        double conCand;
        this.imp.setOverlay(null);
        boolean lwChanged = false;
        boolean contHighChanged = false;
        boolean contLowChanged = false;
        boolean darklineChanged = false;
        double lwCand = gd.getNextNumber();
        double diff = Math.abs(lwCand - this.lineWidth);
        if (diff > 1.0E-4) {
            this.lineWidth = lwCand;
            lwChanged = true;
        }
        if ((diff = Math.abs((conCand = gd.getNextNumber()) - this.contrastHigh)) > 1.0E-4) {
            this.contrastHigh = conCand;
            contHighChanged = true;
        }
        if ((diff = Math.abs((conCand = gd.getNextNumber()) - this.contrastLow)) > 1.0E-4) {
            this.contrastLow = conCand;
            contLowChanged = true;
        }
        if ((darklineCand = gd.getNextBoolean()) != this.isDarkLine) {
            this.isDarkLine = darklineCand;
            darklineChanged = true;
        }
        this.doCorrectPosition = gd.getNextBoolean();
        this.doEstimateWidth = gd.getNextBoolean();
        this.doExtendLine = gd.getNextBoolean();
        this.showJunctionPoints = gd.getNextBoolean();
        this.showIDs = gd.getNextBoolean();
        this.verbose = gd.getNextBoolean();
        this.displayResults = gd.getNextBoolean();
        this.addToRoiManager = gd.getNextBoolean();
        this.makeBinary = gd.getNextBoolean();
        this.overlapOption = OverlapOption.valueOf(gd.getNextChoice());
        if (lwChanged || contHighChanged || contLowChanged) {
            this.contrastOrLineWidthChangedOnce = true;
        }
        if (lwChanged || contHighChanged || contLowChanged || darklineChanged && this.contrastOrLineWidthChangedOnce) {
            double estimatedSigma = this.lineWidth / (2.0 * Math.sqrt(3.0)) + 0.5;
            TextField textSigma = (TextField)gd.getNumericFields().get(3);
            textSigma.setText("" + IJ.d2s((double)estimatedSigma, (int)2));
            textSigma.setEditable(true);
            double clow = this.contrastLow;
            if (this.isDarkLine) {
                clow = 255.0 - this.contrastHigh;
            }
            double estimatedLowerThresh = Math.floor(Math.abs(-2.0 * clow * (this.lineWidth / 2.0) / (Math.sqrt(Math.PI * 2) * estimatedSigma * estimatedSigma * estimatedSigma) * Math.exp(-(this.lineWidth / 2.0 * (this.lineWidth / 2.0)) / (2.0 * estimatedSigma * estimatedSigma))));
            TextField textLowThresh = (TextField)gd.getNumericFields().get(4);
            textLowThresh.setText("" + IJ.d2s((double)(estimatedLowerThresh * 0.17), (int)2));
            textLowThresh.setEditable(true);
            double chigh = this.contrastHigh;
            if (this.isDarkLine) {
                chigh = 255.0 - this.contrastLow;
            }
            double estimatedUpperThresh = Math.floor(Math.abs(-2.0 * chigh * (this.lineWidth / 2.0) / (Math.sqrt(Math.PI * 2) * estimatedSigma * estimatedSigma * estimatedSigma) * Math.exp(-(this.lineWidth / 2.0 * (this.lineWidth / 2.0)) / (2.0 * estimatedSigma * estimatedSigma))));
            TextField textUppThresh = (TextField)gd.getNumericFields().get(5);
            textUppThresh.setText("" + IJ.d2s((double)(estimatedUpperThresh * 0.17), (int)2));
            textUppThresh.setEditable(true);
        }
        this.sigma = gd.getNextNumber();
        this.lowerThresh = gd.getNextNumber();
        this.upperThresh = gd.getNextNumber();
        if (this.lowerThresh >= this.upperThresh || this.sigma < 0.4 || Double.isNaN(this.sigma + this.lowerThresh + this.upperThresh)) {
            return false;
        }
        this.minLength = gd.getNextNumber();
        this.maxLength = gd.getNextNumber();
        this.isPreview = gd.isPreviewActive();
        return true;
    }

    public void run(ImageProcessor ip) {
        if (this.isPreview) {
            Line.resetCounter();
            this.result = new ArrayList();
            this.resultJunction = new ArrayList();
        }
        LineDetector detect = new LineDetector();
        detect.bechatty = this.verbose;
        this.result.add(detect.detectLines(ip, this.sigma, this.upperThresh, this.lowerThresh, this.minLength, this.maxLength, this.isDarkLine, this.doCorrectPosition, this.doEstimateWidth, this.doExtendLine, this.overlapOption));
        this.usedOptions = detect.getUsedParamters();
        this.resultJunction.add(detect.getJunctions());
        if (this.isPreview) {
            this.displayContours();
            Line.resetCounter();
            this.result = new ArrayList();
            this.resultJunction = new ArrayList();
        }
    }

    public ArrayList<Lines> getDetectedLines() {
        return this.result;
    }

    public ArrayList<Junctions> getDetectedJunctions() {
        return this.resultJunction;
    }

    public Options getParameters() {
        return this.usedOptions;
    }
}

