/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve;

import java.util.ArrayList;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.deconvolve.NonCirculantFirstGuess;
import net.imagej.ops.deconvolve.NonCirculantNormalizationFactor;
import net.imagej.ops.deconvolve.RichardsonLucyC;
import net.imagej.ops.deconvolve.RichardsonLucyUpdate;
import net.imagej.ops.deconvolve.accelerate.VectorAccelerator;
import net.imagej.ops.filter.AbstractPadAndFFTFilter;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.inplace.Inplaces;
import net.imagej.ops.special.inplace.UnaryInplaceOp;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.RichardsonLucy.class, priority=100.0)
public class PadAndRichardsonLucy<I extends RealType<I> & NativeType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K> & NativeType<K>, C extends ComplexType<C> & NativeType<C>>
extends AbstractPadAndFFTFilter<I, O, K, C>
implements Ops.Deconvolve.RichardsonLucy {
    @Parameter
    private OpService ops;
    @Parameter
    private int maxIterations;
    @Parameter(required=false)
    private boolean nonCirculant = false;
    @Parameter(required=false)
    private boolean accelerate = false;
    private UnaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> computeEstimateOp;
    private UnaryInplaceOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> normalizer;

    @Override
    public void initialize() {
        if (this.getOBFInput() == null) {
            if (!this.nonCirculant) {
                this.setOBFInput(new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
            } else if (this.nonCirculant) {
                this.setOBFInput(new OutOfBoundsConstantValueFactory((Object)((RealType)Util.getTypeFromInterval((Interval)((Interval)this.in()))).createVariable()));
            }
        }
        this.computeEstimateOp = this.getComputeEstimateOp();
        super.initialize();
    }

    @Override
    public BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> createFilterComputer(RandomAccessibleInterval<I> paddedInput, RandomAccessibleInterval<K> paddedKernel, RandomAccessibleInterval<C> fftImg, RandomAccessibleInterval<C> fftKernel, RandomAccessibleInterval<O> output) {
        UnaryInplaceOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> accelerator = null;
        if (this.accelerate) {
            accelerator = Inplaces.unary(this.ops(), VectorAccelerator.class, output, new Object[0]);
        }
        if (this.nonCirculant) {
            this.normalizer = Inplaces.unary(this.ops(), NonCirculantNormalizationFactor.class, output, this.in(), this.in2(), fftImg, fftKernel);
            ArrayList<UnaryInplaceOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>>> list = new ArrayList<UnaryInplaceOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>>>();
            list.add(this.normalizer);
            UnaryFunctionOp<Class<RandomAccessibleInterval>, RandomAccessibleInterval> fg = Functions.unary(this.ops(), NonCirculantFirstGuess.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{Util.getTypeFromInterval(output), this.in()});
            return Computers.binary(this.ops(), RichardsonLucyC.class, output, paddedInput, paddedKernel, fftImg, fftKernel, true, true, this.maxIterations, accelerator, this.computeEstimateOp, fg.calculate((Class<RandomAccessibleInterval>)paddedInput), list);
        }
        return Computers.binary(this.ops(), RichardsonLucyC.class, output, paddedInput, paddedKernel, fftImg, fftKernel, true, true, this.maxIterations, accelerator, this.computeEstimateOp);
    }

    protected UnaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> getComputeEstimateOp() {
        return Computers.unary(this.ops(), RichardsonLucyUpdate.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[0]);
    }
}

