/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.derivativeGauss;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.AbstractOutOfBoundsMirror;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.DerivativeGauss.class)
public class DefaultDerivativeGauss<T extends RealType<T>>
extends AbstractBinaryComputerOp<RandomAccessibleInterval<T>, int[], RandomAccessibleInterval<DoubleType>>
implements Ops.Filter.DerivativeGauss,
Contingent {
    @Parameter
    private double[] sigma;
    double SQRT2PI = Math.sqrt(Math.PI * 2);

    private double phi0(double x, double sigma) {
        double t = x / sigma;
        return -sigma * Math.exp(-0.5 * t * t) / (this.SQRT2PI * x);
    }

    private double phi1(double x, double sigma) {
        double t = x / sigma;
        return Math.exp(-0.5 * t * t) / (this.SQRT2PI * sigma);
    }

    private double phi2(double x, double sigma) {
        double t = x / sigma;
        return -x * Math.exp(-0.5 * t * t) / (this.SQRT2PI * Math.pow(sigma, 3.0));
    }

    private double[] get_mask_0(double sigma) {
        int x = (int)Math.ceil(4.0 * sigma);
        double[] h = new double[2 * x + 1];
        for (int i = -x + 1; i < x; ++i) {
            h[i + x] = Math.abs(this.phi0((double)i + 0.5, sigma) - this.phi0((double)i - 0.5, sigma));
        }
        h[0] = this.phi0((double)(-x) + 0.5, sigma);
        h[h.length - 1] = this.phi0((double)(-x) + 0.5, sigma);
        return h;
    }

    private double[] get_mask_1(double sigma) {
        int x = (int)Math.ceil(4.0 * sigma);
        double[] h = new double[2 * x + 1];
        for (int i = -x + 1; i < x; ++i) {
            h[i + x] = this.phi1((double)(-i) + 0.5, sigma) - this.phi1((double)(-i) - 0.5, sigma);
        }
        h[0] = -this.phi1((double)x - 0.5, sigma);
        h[h.length - 1] = this.phi1((double)(-x) + 0.5, sigma);
        return h;
    }

    private double[] get_mask_2(double sigma) {
        int x = (int)Math.ceil(4.0 * sigma);
        double[] h = new double[2 * x + 1];
        for (int i = -x + 1; i < x; ++i) {
            h[i + x] = this.phi2((double)(-i) + 0.5, sigma) - this.phi2((double)(-i) - 0.5, sigma);
        }
        h[0] = -this.phi2((double)(-x) + 0.5, sigma);
        h[h.length - 1] = this.phi2((double)x - 0.5, sigma);
        return h;
    }

    private double[] get_mask_general(int n, double sigma) {
        double[] h;
        switch (n) {
            case 0: {
                h = this.get_mask_0(sigma);
                break;
            }
            case 1: {
                h = this.get_mask_1(sigma);
                break;
            }
            case 2: {
                h = this.get_mask_2(sigma);
                break;
            }
            default: {
                h = this.get_mask_0(sigma);
            }
        }
        return h;
    }

    private <T extends RealType<T>> void convolve_x(RandomAccessibleInterval<T> input, RandomAccessibleInterval<DoubleType> output, double[] mask) {
        Cursor cursor = Views.iterable(input).localizingCursor();
        OutOfBoundsMirrorFactory osmf = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        AbstractOutOfBoundsMirror inputRA = osmf.create(input);
        RandomAccess outputRA = output.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            inputRA.setPosition((Localizable)cursor);
            outputRA.setPosition((Localizable)cursor);
            double sum = 0.0;
            int halfWidth = mask.length / 2;
            for (int i = -halfWidth; i <= halfWidth; ++i) {
                inputRA.setPosition(cursor.getLongPosition(0) + (long)i, 0);
                inputRA.setPosition(cursor.getLongPosition(1), 1);
                sum += ((RealType)inputRA.get()).getRealDouble() * mask[i + halfWidth];
            }
            ((DoubleType)outputRA.get()).setReal(sum);
        }
    }

    private <T extends RealType<T>> void convolve_n(RandomAccessibleInterval<T> input, RandomAccessibleInterval<DoubleType> output, double[] mask, int n) {
        Cursor cursor = Views.iterable(input).localizingCursor();
        OutOfBoundsMirrorFactory osmf = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        AbstractOutOfBoundsMirror inputRA = osmf.create(input);
        RandomAccess outputRA = output.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            inputRA.setPosition((Localizable)cursor);
            outputRA.setPosition((Localizable)cursor);
            double sum = 0.0;
            int halfWidth = mask.length / 2;
            for (int i = -halfWidth; i <= halfWidth; ++i) {
                for (int dim = 0; dim < input.numDimensions(); ++dim) {
                    long position = cursor.getLongPosition(dim);
                    if (dim == n) {
                        position += (long)i;
                    }
                    inputRA.setPosition(position, dim);
                }
                sum += ((RealType)inputRA.get()).getRealDouble() * mask[i + halfWidth];
            }
            ((DoubleType)outputRA.get()).setReal(sum);
        }
    }

    @Override
    public void compute(RandomAccessibleInterval<T> input, int[] derivatives, RandomAccessibleInterval<DoubleType> output) {
        if (input.numDimensions() != derivatives.length) {
            throw new IllegalArgumentException("derivatives array must include values for each dimension!");
        }
        for (int derivative : derivatives) {
            if (derivative >= 0 && derivative <= 2) continue;
            throw new IllegalArgumentException("derivatives greater than second-order or less than zeroth order cannot be performed!");
        }
        Img<DoubleType> intermediate = this.ops().create().img((Dimensions)output, new DoubleType());
        UnaryComputerOp<RandomAccessibleInterval<DoubleType>, RandomAccessibleInterval<DoubleType>> copyOp = Computers.unary(this.ops(), Ops.Copy.RAI.class, output, output, new Object[0]);
        this.convolve_n(input, (RandomAccessibleInterval<DoubleType>)intermediate, this.get_mask_general(derivatives[0], this.sigma[0]), 0);
        for (int n = 1; n < input.numDimensions(); ++n) {
            this.convolve_n((RandomAccessibleInterval<T>)intermediate, output, this.get_mask_general(derivatives[n], this.sigma[n]), n);
            if (n + 1 == input.numDimensions()) continue;
            copyOp.compute(output, (RandomAccessibleInterval<DoubleType>)intermediate);
        }
    }

    @Override
    public boolean conforms() {
        if (((RandomAccessibleInterval)this.in1()).numDimensions() < 1) {
            return false;
        }
        return ((RandomAccessibleInterval)this.out()).numDimensions() == ((RandomAccessibleInterval)this.in1()).numDimensions();
    }
}

