/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.mesh.Mesh;
import net.imagej.mesh.Triangle;
import net.imagej.mesh.Vertices;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.img.Img;
import net.imglib2.type.logic.BitType;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Voxelization.class)
public class DefaultVoxelization3D
extends AbstractUnaryFunctionOp<Mesh, RandomAccessibleInterval<BitType>>
implements Ops.Geometric.Voxelization {
    @Parameter(type=ItemIO.INPUT, required=false)
    private int width = 10;
    @Parameter(type=ItemIO.INPUT, required=false)
    private int height = 10;
    @Parameter(type=ItemIO.INPUT, required=false)
    private int depth = 10;
    @Parameter
    private OpService ops;

    @Override
    public RandomAccessibleInterval<BitType> calculate(Mesh input) {
        Img<BitType> outImg = this.ops.create().img((Dimensions)new FinalInterval(new long[]{this.width, this.height, this.depth}), new BitType());
        Vertices verts = input.vertices();
        RealPoint minPoint = new RealPoint((RealLocalizable)verts.iterator().next());
        RealPoint maxPoint = new RealPoint((RealLocalizable)verts.iterator().next());
        for (RealLocalizable v : verts) {
            if (v.getDoublePosition(0) < minPoint.getDoublePosition(0)) {
                minPoint.setPosition(v.getDoublePosition(0), 0);
            }
            if (v.getDoublePosition(1) < minPoint.getDoublePosition(1)) {
                minPoint.setPosition(v.getDoublePosition(1), 1);
            }
            if (v.getDoublePosition(2) < minPoint.getDoublePosition(2)) {
                minPoint.setPosition(v.getDoublePosition(2), 2);
            }
            if (v.getDoublePosition(0) > maxPoint.getDoublePosition(0)) {
                maxPoint.setPosition(v.getDoublePosition(0), 0);
            }
            if (v.getDoublePosition(1) > maxPoint.getDoublePosition(1)) {
                maxPoint.setPosition(v.getDoublePosition(1), 1);
            }
            if (!(v.getDoublePosition(2) > maxPoint.getDoublePosition(2))) continue;
            maxPoint.setPosition(v.getDoublePosition(2), 2);
        }
        RealPoint dimPoint = new RealPoint(new double[]{maxPoint.getDoublePosition(0) - minPoint.getDoublePosition(0), maxPoint.getDoublePosition(1) - minPoint.getDoublePosition(1), maxPoint.getDoublePosition(2) - minPoint.getDoublePosition(2)});
        double[] stepSizes = new double[]{dimPoint.getDoublePosition(0) / (double)this.width, dimPoint.getDoublePosition(1) / (double)this.height, dimPoint.getDoublePosition(2) / (double)this.depth};
        double[] voxelHalfsize = new double[3];
        for (int k = 0; k < stepSizes.length; ++k) {
            voxelHalfsize[k] = stepSizes[k] / 2.0;
        }
        for (Triangle tri : input.triangles()) {
            Vector3D v1 = new Vector3D(tri.v0x(), tri.v0y(), tri.v0z());
            Vector3D v2 = new Vector3D(tri.v1x(), tri.v1y(), tri.v1z());
            Vector3D v3 = new Vector3D(tri.v2x(), tri.v2y(), tri.v2z());
            double[] minSubBoundary = new double[]{Math.min(Math.min(v1.getX(), v2.getX()), v3.getX()) - minPoint.getDoublePosition(0), Math.min(Math.min(v1.getY(), v2.getY()), v3.getY()) - minPoint.getDoublePosition(1), Math.min(Math.min(v1.getZ(), v2.getZ()), v3.getZ()) - minPoint.getDoublePosition(2)};
            double[] maxSubBoundary = new double[]{Math.max(Math.max(v1.getX(), v2.getX()), v3.getX()) - minPoint.getDoublePosition(0), Math.max(Math.max(v1.getY(), v2.getY()), v3.getY()) - minPoint.getDoublePosition(1), Math.max(Math.max(v1.getZ(), v2.getZ()), v3.getZ()) - minPoint.getDoublePosition(2)};
            RandomAccess ra = outImg.randomAccess();
            long[] indices = new long[3];
            indices[0] = (long)Math.floor(minSubBoundary[0] / stepSizes[0]);
            while ((double)indices[0] < Math.floor(maxSubBoundary[0] / stepSizes[0])) {
                indices[1] = (long)Math.floor(minSubBoundary[1] / stepSizes[1]);
                while ((double)indices[1] < Math.floor(maxSubBoundary[1] / stepSizes[1])) {
                    indices[2] = (long)Math.floor(minSubBoundary[2] / stepSizes[2]);
                    while ((double)indices[2] < Math.floor(maxSubBoundary[2] / stepSizes[2])) {
                        ra.setPosition(indices);
                        if (!((BitType)ra.get()).get()) {
                            double[] voxelCenter = new double[3];
                            for (int k = 0; k < 3; ++k) {
                                voxelCenter[k] = (double)indices[k] * stepSizes[k] + voxelHalfsize[k];
                            }
                            if (this.triBoxOverlap(voxelCenter, voxelHalfsize, v1, v2, v3) == 1) {
                                ((BitType)ra.get()).set(true);
                            }
                        }
                        indices[2] = indices[2] + 1L;
                    }
                    indices[1] = indices[1] + 1L;
                }
                indices[0] = indices[0] + 1L;
            }
        }
        return outImg;
    }

    private double findMin(double x0, double x1, double x2) {
        return Math.min(Math.min(x0, x1), x2);
    }

    private double findMax(double x0, double x1, double x2) {
        return Math.max(Math.max(x0, x1), x2);
    }

    private double dotArray(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    private int planeBoxOverlap(double[] normalArray, double[] vertArray, double[] maxboxArray) {
        double[] vminArray = new double[3];
        double[] vmaxArray = new double[3];
        for (int q = 0; q <= 2; ++q) {
            double v = vertArray[q];
            if (normalArray[q] > 0.0) {
                vminArray[q] = -maxboxArray[q] - v;
                int n = q;
                maxboxArray[n] = maxboxArray[n] - v;
                continue;
            }
            int n = q;
            maxboxArray[n] = maxboxArray[n] - v;
            vmaxArray[q] = -maxboxArray[q] - v;
        }
        if (this.dotArray(normalArray, vminArray) > 0.0) {
            return 0;
        }
        if (this.dotArray(normalArray, vmaxArray) >= 0.0) {
            return 1;
        }
        return 0;
    }

    private int axisTest_x01(double e0, double e02, double fez, double fey, double[] v0, double[] v1, double[] v2, double[] boxhalfsize) {
        double max;
        double min;
        double p0 = e0 * v0[1] - e02 * v0[2];
        double p2 = e0 * v2[1] - e02 * v2[2];
        if (p0 < p2) {
            min = p0;
            max = p2;
        } else {
            min = p2;
            max = p0;
        }
        double rad = fez * boxhalfsize[1] + fey * boxhalfsize[2];
        if (min > rad || max < -rad) {
            return 0;
        }
        return 1;
    }

    private int axisTest_x2(double a, double b, double fa, double fb, double[] v0, double[] v1, double[] v2, double[] boxhalfsize) {
        double max;
        double min;
        double p0 = a * v0[1] - b * v0[2];
        double p1 = a * v1[1] - b * v1[2];
        if (p0 < p1) {
            min = p0;
            max = p1;
        } else {
            min = p1;
            max = p0;
        }
        double rad = fa * boxhalfsize[1] + fb * boxhalfsize[2];
        if (min > rad || max < -rad) {
            return 0;
        }
        return 1;
    }

    private int axisTest_y02(double a, double b, double fa, double fb, double[] v0, double[] v1, double[] v2, double[] boxhalfsize) {
        double max;
        double min;
        double p0 = -a * v0[0] + b * v0[2];
        double p2 = -a * v2[0] + b * v2[2];
        if (p0 < p2) {
            min = p0;
            max = p2;
        } else {
            min = p2;
            max = p0;
        }
        double rad = fa * boxhalfsize[0] + fb * boxhalfsize[2];
        if (min > rad || max < -rad) {
            return 0;
        }
        return 1;
    }

    private int axisTest_y1(double a, double b, double fa, double fb, double[] v0, double[] v1, double[] v2, double[] boxhalfsize) {
        double max;
        double min;
        double p0 = -a * v0[0] + b * v0[2];
        double p1 = -a * v1[0] + b * v1[2];
        if (p0 < p1) {
            min = p0;
            max = p1;
        } else {
            min = p1;
            max = p0;
        }
        double rad = fa * boxhalfsize[0] + fb * boxhalfsize[2];
        if (min > rad || max < -rad) {
            return 0;
        }
        return 1;
    }

    private int axisTest_z12(double a, double b, double fa, double fb, double[] v0, double[] v1, double[] v2, double[] boxhalfsize) {
        double max;
        double min;
        double p2 = a * v2[0] - b * v2[1];
        double p1 = a * v1[0] - b * v1[1];
        if (p2 < p1) {
            min = p2;
            max = p1;
        } else {
            min = p1;
            max = p2;
        }
        double rad = fa * boxhalfsize[0] + fb * boxhalfsize[1];
        if (min > rad || max < -rad) {
            return 0;
        }
        return 1;
    }

    private int axisTest_z0(double a, double b, double fa, double fb, double[] v0, double[] v1, double[] v2, double[] boxhalfsize) {
        double max;
        double min;
        double p0 = a * v0[0] - b * v0[1];
        double p1 = a * v1[0] - b * v1[1];
        if (p0 < p1) {
            min = p0;
            max = p1;
        } else {
            min = p1;
            max = p0;
        }
        double rad = fa * boxhalfsize[0] + fb * boxhalfsize[1];
        if (min > rad || max < -rad) {
            return 0;
        }
        return 1;
    }

    private void sub(double[] v0, double[] vert1, double[] boxcenter) {
        vert1[0] = vert1[0] - boxcenter[0];
        vert1[1] = vert1[1] - boxcenter[1];
        vert1[2] = vert1[2] - boxcenter[2];
    }

    private void cross(double[] dest, double[] v1, double[] v2) {
        dest[0] = v1[1] * v2[2] - v1[2] * v2[1];
        dest[1] = v1[2] * v2[0] - v1[0] * v2[2];
        dest[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    private int triBoxOverlap(double[] boxcenter, double[] boxhalfsize, Vector3D pf1, Vector3D pf2, Vector3D pf3) {
        double[] vert1 = pf1.toArray();
        double[] vert2 = pf2.toArray();
        double[] vert3 = pf3.toArray();
        double[] v0 = new double[3];
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] normal = new double[3];
        double[] e0 = new double[3];
        double[] e1 = new double[3];
        double[] e2 = new double[3];
        this.sub(v0, vert1, boxcenter);
        this.sub(v1, vert2, boxcenter);
        this.sub(v2, vert3, boxcenter);
        this.sub(e0, v1, v0);
        this.sub(e1, v2, v1);
        this.sub(e2, v0, v2);
        double fex = Math.abs(e0[0]);
        double fey = Math.abs(e0[1]);
        double fez = Math.abs(e0[2]);
        this.axisTest_x01(e0[2], e0[1], fez, fey, v0, v1, v2, boxhalfsize);
        this.axisTest_y02(e0[2], e0[0], fez, fex, v0, v1, v2, boxhalfsize);
        this.axisTest_z12(e0[1], e0[0], fey, fex, v0, v1, v2, boxhalfsize);
        fex = Math.abs(e1[0]);
        fey = Math.abs(e1[1]);
        fez = Math.abs(e1[2]);
        this.axisTest_x01(e1[2], e1[1], fez, fey, v0, v1, v2, boxhalfsize);
        this.axisTest_y02(e1[2], e1[0], fez, fex, v0, v1, v2, boxhalfsize);
        this.axisTest_z0(e1[1], e1[0], fey, fex, v0, v1, v2, boxhalfsize);
        fex = Math.abs(e2[0]);
        fey = Math.abs(e2[1]);
        fez = Math.abs(e2[2]);
        this.axisTest_x2(e2[2], e2[1], fez, fey, v0, v1, v2, boxhalfsize);
        this.axisTest_y1(e2[2], e2[0], fez, fex, v0, v1, v2, boxhalfsize);
        this.axisTest_z12(e2[1], e2[0], fey, fex, v0, v1, v2, boxhalfsize);
        double min = this.findMin(v0[0], v1[0], v2[0]);
        double max = this.findMax(v0[0], v1[0], v2[0]);
        if (min > boxhalfsize[0] || max < -boxhalfsize[0]) {
            return 0;
        }
        min = this.findMin(v0[1], v1[1], v2[1]);
        max = this.findMax(v0[1], v1[1], v2[1]);
        if (min > boxhalfsize[1] || max < -boxhalfsize[1]) {
            return 0;
        }
        min = this.findMin(v0[2], v1[2], v2[2]);
        max = this.findMax(v0[2], v1[2], v2[2]);
        if (min > boxhalfsize[2] || max < -boxhalfsize[2]) {
            return 0;
        }
        this.cross(normal, e0, e1);
        if (this.planeBoxOverlap(normal, v0, boxhalfsize) != 1) {
            return 0;
        }
        return 1;
    }
}

