/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.erode;

import java.util.List;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.map.Maps;
import net.imagej.ops.morphology.Morphologies;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCF;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Morphology.Erode.class, priority=-100.0)
public class ListErode<T extends RealType<T>>
extends AbstractBinaryHybridCF<RandomAccessibleInterval<T>, List<Shape>, IterableInterval<T>>
implements Ops.Morphology.Erode,
Contingent {
    @Parameter(required=false)
    private boolean isFull;
    private T maxVal;
    private UnaryFunctionOp<Interval, Img<T>> imgCreator;
    private UnaryComputerOp<IterableInterval<T>, IterableInterval<T>> copyImg;
    private BinaryComputerOp<RandomAccessibleInterval<T>, Shape, IterableInterval<T>> erodeComputer;

    @Override
    public boolean conforms() {
        return this.in1() == null || this.in2() == null || this.out() == null || Maps.compatible((RandomAccessibleInterval)this.in1(), (IterableInterval)this.out());
    }

    @Override
    public void initialize() {
        this.maxVal = (RealType)((RealType)Util.getTypeFromInterval((Interval)((Interval)this.in()))).createVariable();
        this.maxVal.setReal(this.maxVal.getMaxValue());
        this.imgCreator = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, this.in(), this.maxVal.createVariable());
        this.copyImg = Computers.unary(this.ops(), Ops.Copy.IterableInterval.class, IterableInterval.class, Views.iterable((RandomAccessibleInterval)((RandomAccessibleInterval)this.in1())), new Object[0]);
        this.erodeComputer = (BinaryComputerOp)Computers.unary(this.ops(), Ops.Morphology.Erode.class, IterableInterval.class, this.in1(), new Object[]{((List)this.in2()).get(0), false});
    }

    @Override
    public IterableInterval<T> createOutput(RandomAccessibleInterval<T> in1, List<Shape> in2) {
        if (this.isFull) {
            long[][] maxSize = Morphologies.computeMinSize(in1, in2);
            return (IterableInterval)this.imgCreator.calculate((Interval)new FinalInterval(maxSize[1]));
        }
        return (IterableInterval)this.imgCreator.calculate((Interval)in1);
    }

    @Override
    public void compute(RandomAccessibleInterval<T> in1, List<Shape> in2, IterableInterval<T> out) {
        long[][] minSize = Morphologies.computeMinSize(in1, in2);
        FinalInterval interval = new FinalInterval(minSize[1]);
        Img<T> upstream = this.imgCreator.calculate((Interval)interval);
        Img<T> downstream = this.imgCreator.calculate((Interval)interval);
        this.erodeComputer.compute(in1, in2.get(0), (IterableInterval<T>)Views.translate(downstream, (long[])minSize[0]));
        for (int i = 1; i < in2.size(); ++i) {
            Img<T> tmp = downstream;
            downstream = upstream;
            upstream = tmp;
            this.erodeComputer.compute((RandomAccessibleInterval<T>)Views.interval((RandomAccessible)Views.extendValue(upstream, this.maxVal), (Interval)interval), in2.get(i), (IterableInterval<T>)downstream);
        }
        if (this.isFull) {
            this.copyImg.compute((IterableInterval<T>)downstream, out);
        } else {
            this.copyImg.compute((IterableInterval<T>)Views.interval((RandomAccessible)Views.translate(downstream, (long[])minSize[0]), out), out);
        }
    }
}

