/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.img.list.AbstractListImg;
import net.imglib2.img.list.ListCursor;
import net.imglib2.type.Type;

public class ListImg<T>
extends AbstractListImg<T> {
    private final List<T> pixels;
    private final T type;

    public ListImg(long[] dim, T type) {
        super(dim);
        this.type = type;
        this.pixels = new ArrayList<T>((int)this.numPixels);
        if (type instanceof Type) {
            Type t = (Type)type;
            ArrayList tpixels = (ArrayList)this.pixels;
            int i = 0;
            while ((long)i < this.numPixels) {
                tpixels.add(t.createVariable());
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.numPixels) {
                this.pixels.add(null);
                ++i;
            }
        }
    }

    public ListImg(T type, Collection<T> collection, long ... dim) {
        super(dim);
        this.type = type;
        assert (this.numPixels == (long)collection.size()) : "Dimensions do not match number of pixels.";
        this.pixels = new ArrayList<T>(collection);
    }

    public ListImg(Collection<T> collection, long ... dim) {
        this(collection.iterator().next(), collection, dim);
    }

    @Override
    protected T get(int index) {
        return this.pixels.get(index);
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    protected void set(int index, T value) {
        this.pixels.set(index, value);
    }

    private static <A extends Type<A>> ListImg<A> copyWithType(ListImg<A> img) {
        ListImg copy = new ListImg(img.dimension, img.type);
        Cursor source = img.cursor();
        Cursor target = copy.cursor();
        while (((ListCursor)source).hasNext()) {
            ((Type)target.next()).set((Type)source.next());
        }
        return copy;
    }

    @Override
    public ListImg<T> copy() {
        if (this.type instanceof Type) {
            ListImg copy = ListImg.copyWithType(this);
            return copy;
        }
        return new ListImg<T>(this.type, this.pixels, this.dimension);
    }

    private ListImg(List<T> pixels, boolean dummy, long ... dim) {
        super(dim);
        this.type = pixels.isEmpty() ? null : pixels.get(0);
        Object v0 = this.type;
        assert (this.numPixels == (long)pixels.size()) : "Dimensions do not match number of pixels.";
        this.pixels = pixels;
    }

    public static <T> ListImg<T> wrap(List<T> pixels, long ... dim) {
        return new ListImg<T>(pixels, false, dim);
    }
}

