/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;

public class IntervalChunks {
    public static List<Interval> chunkInterval(Interval interval, int numberOfChunks) {
        long[] chunkDimensions = IntervalChunks.suggestChunkSize(Intervals.dimensionsAsLongArray(interval), numberOfChunks);
        return IntervalChunks.generateGrid(interval, chunkDimensions);
    }

    static long[] suggestChunkSize(long[] dimensions, long numberOfChunks) {
        long[] chunkSize = new long[dimensions.length];
        for (int i = dimensions.length - 1; i >= 0; --i) {
            chunkSize[i] = Math.max(1L, dimensions[i] / numberOfChunks);
            long divisions = IntervalChunks.divideAndRoundUp(dimensions[i], chunkSize[i]);
            numberOfChunks = IntervalChunks.divideAndRoundUp(numberOfChunks, divisions);
        }
        return chunkSize;
    }

    static List<Interval> generateGrid(Interval interval, long[] cellDimensions) {
        int n = interval.numDimensions();
        long[] totalMin = Intervals.minAsLongArray(interval);
        long[] totalMax = Intervals.maxAsLongArray(interval);
        long[] dimensions = Intervals.dimensionsAsLongArray(interval);
        long[] cellNumbers = new long[dimensions.length];
        Arrays.setAll(cellNumbers, d -> IntervalChunks.divideAndRoundUp(dimensions[d], cellDimensions[d]));
        long elements = Intervals.numElements(cellNumbers);
        long[] cellIndicies = new long[n];
        long[] min = new long[n];
        long[] max = new long[n];
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (long cell = 0L; cell < elements; ++cell) {
            IntervalIndexer.indexToPosition(cell, cellNumbers, cellIndicies);
            for (int d2 = 0; d2 < n; ++d2) {
                min[d2] = totalMin[d2] + cellIndicies[d2] * cellDimensions[d2];
                max[d2] = Math.min(totalMax[d2], min[d2] + cellDimensions[d2] - 1L);
            }
            result.add(new FinalInterval(min, max));
        }
        return result;
    }

    static long divideAndRoundUp(long a, long b) {
        if (a < 0L || b < 0L) {
            throw new UnsupportedOperationException();
        }
        return (a + b - 1L) / b;
    }
}

