/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.OutOfBounds;

public abstract class AbstractOutOfBoundsValue<T>
extends AbstractLocalizable
implements OutOfBounds<T> {
    protected final RandomAccess<T> sampler;
    protected final long[] dimension;
    protected final long[] min;
    protected final long[] max;
    protected final boolean[] dimIsOutOfBounds;
    protected boolean isOutOfBounds = false;

    protected AbstractOutOfBoundsValue(AbstractOutOfBoundsValue<T> outOfBounds) {
        super(outOfBounds.numDimensions());
        this.sampler = outOfBounds.sampler.copy();
        this.dimension = new long[this.n];
        this.min = new long[this.n];
        this.max = new long[this.n];
        this.dimIsOutOfBounds = new boolean[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.dimension[d] = outOfBounds.dimension[d];
            this.min[d] = outOfBounds.min[d];
            this.max[d] = outOfBounds.max[d];
            this.position[d] = outOfBounds.position[d];
            this.dimIsOutOfBounds[d] = outOfBounds.dimIsOutOfBounds[d];
        }
    }

    public <F extends Interval & RandomAccessible<T>> AbstractOutOfBoundsValue(F f) {
        super(f.numDimensions());
        this.sampler = ((RandomAccessible<T>)f).randomAccess();
        this.dimension = new long[this.n];
        f.dimensions(this.dimension);
        this.min = new long[this.n];
        f.min(this.min);
        this.max = new long[this.n];
        f.max(this.max);
        this.dimIsOutOfBounds = new boolean[this.n];
    }

    @Override
    public T getType() {
        return this.sampler.getType();
    }

    private final void checkOutOfBounds() {
        for (int d = 0; d < this.n; ++d) {
            if (!this.dimIsOutOfBounds[d]) continue;
            this.isOutOfBounds = true;
            return;
        }
        this.isOutOfBounds = false;
    }

    @Override
    public boolean isOutOfBounds() {
        this.checkOutOfBounds();
        return this.isOutOfBounds;
    }

    @Override
    public void fwd(int dim) {
        boolean wasOutOfBounds = this.isOutOfBounds;
        int n = dim;
        this.position[n] = this.position[n] + 1L;
        long p = this.position[n];
        if (p == this.min[dim]) {
            this.dimIsOutOfBounds[dim] = false;
            this.checkOutOfBounds();
        } else if (p == this.max[dim] + 1L) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[dim] = true;
            return;
        }
        if (this.isOutOfBounds) {
            return;
        }
        if (wasOutOfBounds) {
            this.sampler.setPosition(this.position);
        } else {
            this.sampler.fwd(dim);
        }
    }

    @Override
    public void bck(int dim) {
        boolean wasOutOfBounds = this.isOutOfBounds;
        int n = dim;
        long l = this.position[n];
        this.position[n] = l - 1L;
        long p = l;
        if (p == this.min[dim]) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[dim] = true;
        } else if (p == this.max[dim] + 1L) {
            this.dimIsOutOfBounds[dim] = false;
            this.checkOutOfBounds();
        }
        if (this.isOutOfBounds) {
            return;
        }
        if (wasOutOfBounds) {
            this.sampler.setPosition(this.position);
        } else {
            this.sampler.bck(dim);
        }
    }

    @Override
    public void move(long distance, int dim) {
        this.setPosition(this.position[dim] + distance, dim);
    }

    @Override
    public void move(int distance, int dim) {
        this.move((long)distance, dim);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.move(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    @Override
    public void setPosition(long position, int dim) {
        this.position[dim] = position;
        if (position < this.min[dim] || position > this.max[dim]) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[dim] = true;
        } else if (this.isOutOfBounds) {
            this.dimIsOutOfBounds[dim] = false;
            this.checkOutOfBounds();
            if (!this.isOutOfBounds) {
                this.sampler.setPosition(this.position);
            }
        } else {
            this.sampler.setPosition(position, dim);
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        this.setPosition((long)position, dim);
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(localizable.getLongPosition(d), d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }
}

